/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.dataflow;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.inspections.JSInspectionUiService;
import com.intellij.lang.javascript.inspections.JSUnusedLocalSymbolsInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.VariableAccessUtil;
import com.intellij.openapi.util.IntRef;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryLocalVariableJSInspectionBase
extends JavaScriptInspection {
    public boolean m_ignoreImmediatelyReturnedVariables = false;
    public boolean m_ignoreAnnotatedVariables = false;

    public JComponent createOptionsPanel() {
        return JSInspectionUiService.getInstance().createSingleCheckboxOptionsPanel(InspectionJSBundle.message("redundant.local.variable.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreImmediatelyReturnedVariables");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    @InspectionMessage
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("unnecessary.local.variable.problem.descriptor", ((PsiElement)args[0]).getText());
        if (string == null) {
            UnnecessaryLocalVariableJSInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryLocalVariableVisitor();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/dataflow/UnnecessaryLocalVariableJSInspectionBase", "buildErrorString"));
    }

    private class UnnecessaryLocalVariableVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryLocalVariableVisitor() {
        }

        @Override
        public void visitJSVarStatement(@NotNull JSVarStatement varStatement) {
            JSVariable[] variables;
            if (varStatement == null) {
                UnnecessaryLocalVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSVarStatement(varStatement);
            for (JSVariable variable : variables = varStatement.getVariables()) {
                if (JSDestructuringUtil.isDestructuring(variable.getParent())) continue;
                if (this.isCopyVariable(variable) && this.validateTypeAndInitializer(variable)) {
                    this.registerVariableError(variable);
                    continue;
                }
                if (!UnnecessaryLocalVariableJSInspectionBase.this.m_ignoreImmediatelyReturnedVariables && this.isImmediatelyReturned(variable)) {
                    JSFunction scope = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)variable, JSFunction.class, (boolean)true);
                    if (scope != null && scope.getReturnTypeElement() == null && !this.validateTypeAndInitializer(variable)) continue;
                    this.registerVariableError(variable);
                    continue;
                }
                if (!UnnecessaryLocalVariableJSInspectionBase.this.m_ignoreImmediatelyReturnedVariables && this.isImmediatelyThrown(variable)) {
                    this.registerVariableError(variable);
                    continue;
                }
                if (this.isImmediatelyAssigned(variable)) {
                    this.registerVariableError(variable);
                    continue;
                }
                if (!this.isImmediatelyAssignedAsDeclaration(variable) || !this.validateTypeAndInitializer(variable)) continue;
                this.registerVariableError(variable);
            }
        }

        private boolean validateTypeAndInitializer(@NotNull JSVariable variable) {
            PsiElement typeElement;
            if (variable == null) {
                UnnecessaryLocalVariableVisitor.$$$reportNull$$$0(1);
            }
            if ((typeElement = variable.getTypeElement()) == null) {
                return true;
            }
            JSType explicitType = variable.getJSType();
            if (explicitType == null) {
                return true;
            }
            JSExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return false;
            }
            JSType type = JSTypeUtils.widenLiteralTypes(JSResolveUtil.getExpressionJSType(initializer));
            if (type == null) {
                return false;
            }
            return explicitType.isEquivalentTo(type, null);
        }

        private boolean isCopyVariable(final JSVariable variable) {
            JSExpression initializer = variable.getInitializer();
            if (!(initializer instanceof JSReferenceExpression)) {
                return false;
            }
            final PsiElement referent = ((JSReferenceExpression)initializer).resolve();
            if (!(referent instanceof JSVariable) || JSResolveUtil.findParent(referent) instanceof JSClass) {
                return false;
            }
            JSVarStatement declarationStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSVarStatement.class);
            if (declarationStatement == null) {
                return false;
            }
            final JSStatement nextStatement = this.getNextStatement(declarationStatement);
            if (nextStatement == null) {
                return false;
            }
            PsiElement containingScope = variable.getDeclarationScope();
            if (containingScope instanceof JSFunction) {
                JSBlockStatement body = ((JSFunction)containingScope).getBlock();
                if (body == null) {
                    return false;
                }
                containingScope = body;
            }
            if (containingScope == null) {
                return false;
            }
            final Flags flags = new Flags();
            containingScope.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){
                private boolean withinNextStatement = false;
                private boolean withinClosure = false;

                @Override
                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (flags.isUnsatisfiable()) {
                        return;
                    }
                    super.visitElement(element);
                }

                @Override
                public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    boolean _withinClosure = this.withinClosure;
                    this.withinClosure = true;
                    super.visitJSFunctionDeclaration(node);
                    this.withinClosure = _withinClosure;
                }

                @Override
                public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    boolean _withinClosure = this.withinClosure;
                    this.withinClosure = true;
                    super.visitJSFunctionExpression(node);
                    this.withinClosure = _withinClosure;
                }

                @Override
                public void visitJSStatement(JSStatement node) {
                    if (nextStatement == node) {
                        this.withinNextStatement = true;
                    }
                    super.visitJSStatement(node);
                    if (nextStatement == node) {
                        this.withinNextStatement = false;
                    }
                }

                @Override
                public void visitJSReferenceExpression(JSReferenceExpression node) {
                    boolean isReferenceToLocalVar = UnnecessaryLocalVariableVisitor.this.isReferenceTo(node, variable);
                    if (isReferenceToLocalVar) {
                        PsiElement parent;
                        if (this.isReadUsage(node)) {
                            if (flags.usedAnywhere) {
                                flags.canBeCopy = false;
                            }
                            flags.usedAnywhere = true;
                            if (!this.withinNextStatement) {
                                flags.canBeCopy = false;
                            }
                            if (this.withinClosure) {
                                flags.usedWithinClosure = true;
                            }
                        } else {
                            flags.canBeCopy = false;
                        }
                        if ((parent = node.getParent()) instanceof ES6Property && ((ES6Property)parent).isShorthanded()) {
                            flags.hasShorthandPropertyUsages = true;
                        }
                    } else if (UnnecessaryLocalVariableVisitor.this.isReferenceTo(node, (JSVariable)referent) && !this.isReadUsage(node)) {
                        flags.hasReferentWrites = true;
                    }
                    super.visitJSReferenceExpression(node);
                }

                private boolean isReadUsage(JSReferenceExpression node) {
                    return JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node) == ReadWriteAccessDetector.Access.Read;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                    }
                    objectArray2[1] = "com/sixrr/inspectjs/dataflow/UnnecessaryLocalVariableJSInspectionBase$UnnecessaryLocalVariableVisitor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSFunctionDeclaration";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSFunctionExpression";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            return flags.usedAnywhere && !flags.isUnsatisfiable();
        }

        private boolean isReferenceTo(JSReferenceExpression node, JSVariable varr) {
            return node.getQualifier() == null && Objects.equals(node.getReferenceName(), varr.getName()) && node.resolve() == varr;
        }

        private boolean isImmediateReturnExpression(JSExpression returnValue, JSVariable variable) {
            return returnValue instanceof JSReferenceExpression && this.isReferenceTo((JSReferenceExpression)returnValue, variable);
        }

        private boolean isImmediatelyReturned(JSVariable variable) {
            JSStatement nextStatement = this.getNextStatement(variable);
            if (!(nextStatement instanceof JSReturnStatement)) {
                return false;
            }
            JSReturnStatement returnStatement = (JSReturnStatement)nextStatement;
            if (this.isImmediateReturnExpression(returnStatement.getExpression(), variable)) {
                PsiElement originalScope = JSUseScopeProvider.getLexicalScopeOrFile((PsiElement)returnStatement);
                if (!(originalScope instanceof JSFunction)) {
                    return false;
                }
                PsiElement scopeNode = JSUnusedLocalSymbolsInspection.getInjectedScopeOrCurrent(variable, originalScope);
                if (scopeNode == null) {
                    return false;
                }
                IntRef count = new IntRef(0);
                Processor hasTwoUsagesProcessor = reference -> {
                    int newValue = count.get() + 1;
                    count.set(newValue);
                    return newValue == 1;
                };
                JSUnusedLocalSymbolsInspection.checkUsages(variable, scopeNode, originalScope, (Processor<? super PsiReference>)hasTwoUsagesProcessor);
                return count.get() <= 1;
            }
            return false;
        }

        @Nullable
        private JSStatement getNextStatement(JSVariable variable) {
            JSVarStatement declarationStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSVarStatement.class);
            return this.getNextStatement(declarationStatement);
        }

        private JSStatement getNextStatement(JSStatement statement) {
            return (JSStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, JSStatement.class);
        }

        private boolean isImmediatelyThrown(JSVariable variable) {
            JSStatement nextStatement = this.getNextStatement(variable);
            if (!(nextStatement instanceof JSThrowStatement)) {
                return false;
            }
            JSThrowStatement throwStatement = (JSThrowStatement)nextStatement;
            return this.isImmediateReturnExpression(throwStatement.getExpression(), variable);
        }

        private boolean isImmediatelyAssigned(JSVariable variable) {
            JSVarStatement declarationStatement;
            JSBlockStatement containingScope = (JSBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSBlockStatement.class);
            if (containingScope == null) {
                return false;
            }
            PsiElement parent = variable.getParent();
            JSVarStatement jSVarStatement = declarationStatement = parent instanceof JSVarStatement ? (JSVarStatement)parent : null;
            if (declarationStatement == null) {
                return false;
            }
            JSSourceElement nextStatement = null;
            int followingStatementNumber = 0;
            JSSourceElement[] statements = containingScope.getStatementListItems();
            for (int i2 = 0; i2 < statements.length - 1; ++i2) {
                if (!statements[i2].equals(declarationStatement)) continue;
                nextStatement = statements[i2 + 1];
                followingStatementNumber = i2 + 2;
            }
            if (nextStatement == null) {
                return false;
            }
            if (!(nextStatement instanceof JSExpressionStatement)) {
                return false;
            }
            JSExpressionStatement expressionStatement = (JSExpressionStatement)nextStatement;
            JSExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof JSAssignmentExpression) || ((JSAssignmentExpression)expression).getOperationSign() != JSTokenTypes.EQ) {
                return false;
            }
            JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)expression;
            JSExpression rhs = assignmentExpression.getROperand();
            if (rhs == null) {
                return false;
            }
            if (!(rhs instanceof JSReferenceExpression)) {
                return false;
            }
            JSReferenceExpression reference = (JSReferenceExpression)rhs;
            PsiElement referent = reference.resolve();
            if (referent == null || !referent.equals(variable)) {
                return false;
            }
            JSExpression lhs = assignmentExpression.getLOperand();
            if (VariableAccessUtil.isLocalVariableUsed(variable, (PsiElement)lhs)) {
                return false;
            }
            for (int i3 = followingStatementNumber; i3 < statements.length; ++i3) {
                if (!VariableAccessUtil.isLocalVariableUsed(variable, (PsiElement)statements[i3])) continue;
                return false;
            }
            return !VariableAccessUtil.isLocalVariableUsed(variable, (PsiElement)statements[followingStatementNumber - 2]);
        }

        private boolean isImmediatelyAssignedAsDeclaration(JSVariable variable) {
            JSBlockStatement containingScope = (JSBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSBlockStatement.class);
            if (containingScope == null) {
                return false;
            }
            JSVarStatement declarationStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSVarStatement.class);
            if (declarationStatement == null) {
                return false;
            }
            JSSourceElement nextStatement = null;
            int followingStatementNumber = 0;
            JSSourceElement[] statements = containingScope.getStatementListItems();
            for (int i2 = 0; i2 < statements.length - 1; ++i2) {
                if (!statements[i2].equals(declarationStatement)) continue;
                nextStatement = statements[i2 + 1];
                followingStatementNumber = i2 + 2;
            }
            if (nextStatement == null) {
                return false;
            }
            if (!(nextStatement instanceof JSVarStatement)) {
                return false;
            }
            JSVarStatement declaration = (JSVarStatement)nextStatement;
            JSVariable[] declarations = declaration.getVariables();
            if (declarations.length != 1) {
                return false;
            }
            JSExpression rhs = declarations[0].getInitializer();
            if (rhs == null) {
                return false;
            }
            if (!(rhs instanceof JSReferenceExpression)) {
                return false;
            }
            PsiElement referent = ((PsiReference)rhs).resolve();
            if (referent == null || !referent.equals(variable)) {
                return false;
            }
            for (int i3 = followingStatementNumber; i3 < statements.length; ++i3) {
                if (!VariableAccessUtil.isLocalVariableUsed(variable, (PsiElement)statements[i3])) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "varStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/sixrr/inspectjs/dataflow/UnnecessaryLocalVariableJSInspectionBase$UnnecessaryLocalVariableVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSVarStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "validateTypeAndInitializer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class Flags {
            boolean usedAnywhere = false;
            boolean usedWithinClosure = false;
            boolean hasReferentWrites = false;
            boolean canBeCopy = true;
            boolean hasShorthandPropertyUsages = false;

            private Flags() {
            }

            private boolean isUnsatisfiable() {
                return !this.canBeCopy || this.usedWithinClosure || this.hasReferentWrites || this.hasShorthandPropertyUsages;
            }
        }
    }
}

