/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.functionmetrics.NegationCountVisitor;
import org.jetbrains.annotations.NotNull;

public class ThreeNegationsPerFunctionJSInspection
extends JavaScriptInspection {
    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        JSFunction function2 = (JSFunction)((PsiElement)args[0]).getParent();
        assert (function2 != null);
        PsiElement lastChild = function2.getLastChild();
        NegationCountVisitor visitor = new NegationCountVisitor();
        assert (lastChild != null);
        lastChild.accept((PsiElementVisitor)visitor);
        int negationCount = visitor.getNegationCount();
        if (ThreeNegationsPerFunctionJSInspection.functionHasIdentifier(function2)) {
            String string = InspectionJSBundle.message("function.contains.too.many.negation.error.string", negationCount);
            if (string == null) {
                ThreeNegationsPerFunctionJSInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionJSBundle.message("anonymous.function.contains.too.many.negation.error.string", negationCount);
        if (string == null) {
            ThreeNegationsPerFunctionJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/functionmetrics/ThreeNegationsPerFunctionJSInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitJSFunctionDeclaration(@NotNull JSFunction function2) {
            if (function2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            NegationCountVisitor visitor = new NegationCountVisitor();
            PsiElement lastChild = function2.getLastChild();
            if (!(lastChild instanceof JSBlockStatement)) {
                return;
            }
            lastChild.accept((PsiElementVisitor)visitor);
            int negationCount = visitor.getNegationCount();
            if (negationCount <= 3) {
                return;
            }
            this.registerFunctionError(function2);
        }

        @Override
        public void visitJSFunctionExpression(JSFunctionExpression node) {
            this.visitJSFunctionDeclaration(node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/functionmetrics/ThreeNegationsPerFunctionJSInspection$Visitor", "visitJSFunctionDeclaration"));
        }
    }
}

