/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.jetbrains.cidr.EarlyProjectDirListener;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectOpenHelper<T> {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ProjectOpenHelper.class);
    private final Key<T> myOpenDataKey;
    private final SupportedFileChecker mySupportedFileChecker;

    public ProjectOpenHelper(@NotNull Key<T> openDataKey, @NotNull SupportedFileChecker supportedFileChecker) {
        if (openDataKey == null) {
            ProjectOpenHelper.$$$reportNull$$$0(0);
        }
        if (supportedFileChecker == null) {
            ProjectOpenHelper.$$$reportNull$$$0(1);
        }
        this.myOpenDataKey = openDataKey;
        this.mySupportedFileChecker = supportedFileChecker;
    }

    public boolean isSupportedFile(@Nullable VirtualFile file) {
        return file != null && this.mySupportedFileChecker.isSupportedFile(file);
    }

    public boolean isSupportedFile(@Nullable String fileName) {
        return fileName != null && this.mySupportedFileChecker.isSupportedFile(fileName);
    }

    @Nullable
    public VirtualFile findSupportedSubFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectOpenHelper.$$$reportNull$$$0(2);
        }
        if (!file.isDirectory() && this.isSupportedFile(file)) {
            return file;
        }
        for (VirtualFile child : file.getChildren()) {
            if (child == null || child.isDirectory() || !this.isSupportedFile(child)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getValidProjectPath(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectOpenHelper.$$$reportNull$$$0(3);
        }
        if (!file.isDirectory()) {
            file = file.getParent();
        }
        if (ProjectUtil.isValidProjectPath((Path)file.toNioPath())) {
            return file;
        }
        return null;
    }

    @Nullable
    private static Pair<Path, OpenProjectTask> createTaskToOpenExistingProjectInDirectory(@NotNull VirtualFile file, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        VirtualFile projectDir;
        if (file == null) {
            ProjectOpenHelper.$$$reportNull$$$0(4);
        }
        if ((projectDir = ProjectOpenHelper.getValidProjectPath(file)) == null) {
            return null;
        }
        LOG.info("Opening existing project in directory " + projectDir + " Requested file " + file);
        Path projectPath = projectDir.toNioPath();
        OpenProjectTask openProjectTask = PlatformProjectOpenProcessor.createOptionsToOpenDotIdeaOrCreateNewIfNotExists((Path)projectPath, (Project)projectToClose).withForceOpenInNewFrame(forceOpenInNewFrame);
        return new Pair((Object)projectPath, (Object)openProjectTask);
    }

    @Nullable
    public Project openExistingProjectInDirectory(@NotNull VirtualFile file, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Pair<Path, OpenProjectTask> task;
        if (file == null) {
            ProjectOpenHelper.$$$reportNull$$$0(5);
        }
        if ((task = ProjectOpenHelper.createTaskToOpenExistingProjectInDirectory(file, projectToClose, forceOpenInNewFrame)) == null) {
            return null;
        }
        return ProjectManagerEx.getInstanceEx().openProject((Path)task.first, (OpenProjectTask)task.second);
    }

    @Nullable
    public @Nullable CompletableFuture<@Nullable Project> openExistingProjectInDirectoryAsync(@NotNull VirtualFile file, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Pair<Path, OpenProjectTask> task;
        if (file == null) {
            ProjectOpenHelper.$$$reportNull$$$0(6);
        }
        if ((task = ProjectOpenHelper.createTaskToOpenExistingProjectInDirectory(file, projectToClose, forceOpenInNewFrame)) == null) {
            return null;
        }
        return ProjectManagerEx.getInstanceEx().openProjectAsync((Path)task.first, (OpenProjectTask)task.second);
    }

    @Nullable
    public Project openProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, T data) {
        if (virtualFile == null) {
            ProjectOpenHelper.$$$reportNull$$$0(7);
        }
        return this.openProject(virtualFile, projectToClose, forceOpenInNewFrame, data, project -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Project openProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, T data, Predicate<Project> callback) {
        if (virtualFile == null) {
            ProjectOpenHelper.$$$reportNull$$$0(8);
        }
        if (!this.isSupportedFile(virtualFile)) {
            return null;
        }
        this.markFileToOpen(virtualFile, data);
        VirtualFile baseDir = virtualFile.getParent();
        OpenProjectTask options = PlatformProjectOpenProcessor.createOptionsToOpenDotIdeaOrCreateNewIfNotExists((Path)baseDir.toNioPath(), (Project)projectToClose).withForceOpenInNewFrame(forceOpenInNewFrame).withBeforeOpenCallback(callback);
        EarlyProjectDirListener dirListener = (EarlyProjectDirListener)ApplicationManager.getApplication().getService(EarlyProjectDirListener.class);
        if (dirListener != null) {
            dirListener.setBaseDir(baseDir.getCanonicalPath());
        }
        try {
            Project project = ProjectManagerEx.getInstanceEx().openProject(baseDir.toNioPath(), options);
            return project;
        }
        finally {
            if (dirListener != null) {
                dirListener.setBaseDir(null);
            }
        }
    }

    public @NotNull CompletableFuture<@Nullable Project> openProjectAsync(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, T data) {
        if (virtualFile == null) {
            ProjectOpenHelper.$$$reportNull$$$0(9);
        }
        CompletableFuture<Project> completableFuture = this.openProjectAsync(virtualFile, projectToClose, forceOpenInNewFrame, data, null);
        if (completableFuture == null) {
            ProjectOpenHelper.$$$reportNull$$$0(10);
        }
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NotNull CompletableFuture<@Nullable Project> openProjectAsync(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, T data, @Nullable Predicate<Project> runBeforeOpenCallback) {
        EarlyProjectDirListener dirListener;
        if (virtualFile == null) {
            ProjectOpenHelper.$$$reportNull$$$0(11);
        }
        if (!this.isSupportedFile(virtualFile)) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                ProjectOpenHelper.$$$reportNull$$$0(12);
            }
            return completableFuture;
        }
        this.markFileToOpen(virtualFile, data);
        VirtualFile baseDir = virtualFile.getParent();
        OpenProjectTask options = OpenProjectTask.withProjectToClose((Project)projectToClose, (boolean)forceOpenInNewFrame).withRunConfigurators();
        if (runBeforeOpenCallback != null) {
            options = options.withBeforeOpenCallback(runBeforeOpenCallback);
        }
        if ((dirListener = (EarlyProjectDirListener)ApplicationManager.getApplication().getService(EarlyProjectDirListener.class)) != null) {
            dirListener.setBaseDir(baseDir.getCanonicalPath());
        }
        CompletableFuture completableFuture = ProjectManagerEx.getInstanceEx().openProjectAsync(baseDir.toNioPath(), options);
        CompletableFuture completableFuture2 = completableFuture;
        if (completableFuture2 == null) {
            ProjectOpenHelper.$$$reportNull$$$0(13);
        }
        return completableFuture2;
        finally {
            if (dirListener != null) {
                dirListener.setBaseDir(null);
            }
        }
    }

    public void markFileToOpen(@NotNull VirtualFile virtualFile, @NotNull T data) {
        if (virtualFile == null) {
            ProjectOpenHelper.$$$reportNull$$$0(14);
        }
        if (data == null) {
            ProjectOpenHelper.$$$reportNull$$$0(15);
        }
        VirtualFile baseDir = virtualFile.getParent();
        baseDir.putUserData(this.myOpenDataKey, data);
    }

    @Nullable
    public T getAndClearFileToOpenData(@NotNull Project project) {
        VirtualFile baseDir;
        if (project == null) {
            ProjectOpenHelper.$$$reportNull$$$0(16);
        }
        if ((baseDir = project.getBaseDir()) == null) {
            return null;
        }
        Object data = baseDir.getUserData(this.myOpenDataKey);
        baseDir.putUserData(this.myOpenDataKey, null);
        return (T)data;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openDataKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedFileChecker";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/ProjectOpenHelper";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/ProjectOpenHelper";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "openProjectAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSupportedSubFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValidProjectPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTaskToOpenExistingProjectInDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "openExistingProjectInDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "openExistingProjectInDirectoryAsync";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "openProject";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "openProjectAsync";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "markFileToOpen";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAndClearFileToOpenData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface SupportedFileChecker {
        public boolean isSupportedFile(@NotNull VirtualFile var1);

        public boolean isSupportedFile(@NotNull String var1);
    }
}

