/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.Function;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.execution.testing.CidrOutputToGeneralTestEventsConverter;
import com.jetbrains.cidr.execution.testing.CidrOutputToGeneralTestEventsConverterBase;
import com.jetbrains.cidr.execution.testing.CidrTestEventProcessor;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrFromTagInLineToGeneralTestEventsConverter
extends CidrOutputToGeneralTestEventsConverterBase {
    protected final CidrTestEventProcessor myEventProcessor;
    protected volatile String myProcessFinishedMessage;
    protected volatile String myFinalTestReport;
    protected final ExecutionConsole myConsole;
    protected final Stack<String> myTestNameStack;
    protected final Stack<TestResult> myTestResultStack;
    public static final String NAME_SPLITTER = "/";
    public static final String EMPTY_STR = "";
    protected static final String ROOT_NODE_ID = "0";
    protected volatile ServiceMessageVisitor myVisitor;

    public CidrFromTagInLineToGeneralTestEventsConverter(@NonNls @NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull CidrTestEventProcessor processor, @NotNull ExecutionConsole console) {
        if (testFrameworkName == null) {
            CidrFromTagInLineToGeneralTestEventsConverter.$$$reportNull$$$0(0);
        }
        if (consoleProperties == null) {
            CidrFromTagInLineToGeneralTestEventsConverter.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            CidrFromTagInLineToGeneralTestEventsConverter.$$$reportNull$$$0(2);
        }
        if (console == null) {
            CidrFromTagInLineToGeneralTestEventsConverter.$$$reportNull$$$0(3);
        }
        super(testFrameworkName, consoleProperties);
        this.myTestNameStack = new Stack();
        this.myTestResultStack = new Stack();
        this.myEventProcessor = processor;
        this.myConsole = console;
    }

    protected void process(@NotNull List<ServiceMessageBuilder> messages) {
        if (messages == null) {
            CidrFromTagInLineToGeneralTestEventsConverter.$$$reportNull$$$0(4);
        }
        try {
            for (ServiceMessageBuilder each : messages) {
                super.processServiceMessages(each.toString(), ProcessOutputTypes.STDOUT, this.myVisitor);
            }
        }
        catch (Exception e) {
            CidrTestLog.LOG.error(e.getMessage());
        }
    }

    protected boolean processServiceMessages(@NlsSafe @NotNull String text, @Nullable Key outputType, @NotNull ServiceMessageVisitor visitor) {
        if (text == null) {
            CidrFromTagInLineToGeneralTestEventsConverter.$$$reportNull$$$0(5);
        }
        if (visitor == null) {
            CidrFromTagInLineToGeneralTestEventsConverter.$$$reportNull$$$0(6);
        }
        CidrOutputToGeneralTestEventsConverter.logOutput(text, outputType);
        this.myVisitor = visitor;
        if (outputType != null && (ProcessOutputType.isStdout((Key)outputType) || ProcessOutputType.isStderr((Key)outputType))) {
            this.processLine(outputType, text);
            return true;
        }
        if (CidrOutputToGeneralTestEventsConverter.PROCESS_FINISHED_PATTERN.matcher(text).matches()) {
            this.myProcessFinishedMessage = text;
            return true;
        }
        return text.equals("\n");
    }

    protected abstract void processLine(@NotNull Key var1, @NotNull @NlsSafe String var2);

    @NotNull
    @NonNls
    protected String getCurrentNodeId() {
        StringBuilder path = new StringBuilder();
        path.append(ROOT_NODE_ID);
        this.myTestNameStack.forEach(testName -> path.append(NAME_SPLITTER).append((String)testName));
        String string = path.toString();
        if (string == null) {
            CidrFromTagInLineToGeneralTestEventsConverter.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NonNls
    protected String getLocationFromId() {
        String nodeId = this.getCurrentNodeId();
        return nodeId.equals(ROOT_NODE_ID) ? EMPTY_STR : nodeId.substring(ROOT_NODE_ID.length() + 1);
    }

    public static long getTimeInMs(@NlsSafe @Nullable String timeStringWithSplittersAndSuffix) {
        if (timeStringWithSplittersAndSuffix != null) {
            try {
                int length = timeStringWithSplittersAndSuffix.length() - 2;
                if (length > 0) {
                    String numbersWithSeps = timeStringWithSplittersAndSuffix.substring(0, length).trim();
                    length = numbersWithSeps.length();
                    StringBuilder sb = new StringBuilder(length);
                    for (int i = 0; i < length; ++i) {
                        char ch = numbersWithSeps.charAt(i);
                        if ("0123456789".indexOf(ch) < 0) continue;
                        sb.append(ch);
                    }
                    long parseLong = Long.parseLong(sb.toString());
                    if (timeStringWithSplittersAndSuffix.endsWith("us")) {
                        return Math.round((double)parseLong / 1000.0);
                    }
                    if (timeStringWithSplittersAndSuffix.endsWith("ms")) {
                        return parseLong;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public void flushBufferOnProcessTermination(int exitCode) {
        GeneralTestEventsProcessor processor = this.getProcessor();
        if (processor != null) {
            if (this.myFinalTestReport != null) {
                processor.onUncapturedOutput(this.myFinalTestReport, ProcessOutputTypes.STDERR);
            }
            if (this.myProcessFinishedMessage != null) {
                processor.onUncapturedOutput(this.myProcessFinishedMessage, ProcessOutputTypes.SYSTEM);
            }
        }
        this.transferTextToConsoleViewInTest();
        super.flushBufferOnProcessTermination(exitCode);
    }

    protected void transferTextToConsoleViewInTest() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ((ConsoleViewImpl)((SMTRunnerConsoleView)this.myConsole).getConsole()).waitAllRequests());
        }
    }

    protected static boolean fixIgnoredState(@NotNull GeneralTestEventsProcessor processor, @NotNull SMTestProxy node, @NotNull Predicate<SMTestProxy> isDisabledByFramework, @NotNull Function<? super SMTestProxy, String> getNodeId, boolean markIgnored) {
        String nodeId;
        if (processor == null) {
            CidrFromTagInLineToGeneralTestEventsConverter.$$$reportNull$$$0(8);
        }
        if (node == null) {
            CidrFromTagInLineToGeneralTestEventsConverter.$$$reportNull$$$0(9);
        }
        if (isDisabledByFramework == null) {
            CidrFromTagInLineToGeneralTestEventsConverter.$$$reportNull$$$0(10);
        }
        if (getNodeId == null) {
            CidrFromTagInLineToGeneralTestEventsConverter.$$$reportNull$$$0(11);
        }
        markIgnored |= node.isIgnored() || isDisabledByFramework.test(node);
        if (!node.isLeaf()) {
            boolean allChildrenIgnored = true;
            for (SMTestProxy ch : node.getChildren()) {
                if (CidrFromTagInLineToGeneralTestEventsConverter.fixIgnoredState(processor, ch, isDisabledByFramework, getNodeId, markIgnored)) continue;
                allChildrenIgnored = false;
            }
            markIgnored |= allChildrenIgnored;
        }
        if (markIgnored && !node.isIgnored() && (nodeId = (String)getNodeId.fun((Object)node)) != null) {
            processor.onTestIgnored(new TestIgnoredEvent(node.getName(), nodeId, " ", null));
        }
        return markIgnored;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrFromTagInLineToGeneralTestEventsConverter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isDisabledByFramework";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getNodeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrFromTagInLineToGeneralTestEventsConverter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentNodeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processServiceMessages";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fixIgnoredState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static final class TestResult {
        public boolean success = true;
        public int durationInMs = 0;

        private TestResult() {
        }

        public void update(boolean succeed, long durationInMs) {
            this.success &= succeed;
            this.durationInMs = (int)((long)this.durationInMs + durationInMs);
        }

        public static TestResult create(boolean success, int durationInMs) {
            TestResult result = new TestResult();
            result.success = success;
            result.durationInMs = durationInMs;
            return result;
        }
    }

    protected static class TagWithAttr<TAG> {
        private final Map<Attr, String> myAttrs;
        private final TAG myTag;

        public TagWithAttr(@NotNull TAG tag, @NotNull Map<Attr, String> attrs) {
            if (tag == null) {
                TagWithAttr.$$$reportNull$$$0(0);
            }
            if (attrs == null) {
                TagWithAttr.$$$reportNull$$$0(1);
            }
            this.myAttrs = attrs;
            this.myTag = tag;
        }

        @Nullable
        public String getAttr(Attr attrId) {
            return this.myAttrs.get((Object)attrId);
        }

        @NotNull
        public TAG getTag() {
            TAG TAG = this.myTag;
            if (TAG == null) {
                TagWithAttr.$$$reportNull$$$0(2);
            }
            return TAG;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attrs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrFromTagInLineToGeneralTestEventsConverter$TagWithAttr";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrFromTagInLineToGeneralTestEventsConverter$TagWithAttr";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Attr {
        SOURCE_PATH,
        LINE_NUM,
        NAME,
        MESSAGE,
        TIME,
        SUCCEEDED,
        TEST_ID;

    }
}

