/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.application.options.CodeStyle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.InplaceButton;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandlerProvider;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.settings.OCFileExtensionsSettingsProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCNewFileWithSelectedExtensionAction<T extends CreateFileDialog>
extends OCNewFileActionBase<T> {
    private static final String NEW_CPP_HELP_TOPIC_ID = "New_CPP_File_Dialog";

    protected OCNewFileWithSelectedExtensionAction(@Nullable FileType type, @NlsActions.ActionText String text, @NlsActions.ActionDescription String description2, Icon icon) {
        super(type, text, description2, icon);
    }

    @NotNull
    protected List<FileExtensionPair> getExtensions(@NotNull Project project) {
        if (project == null) {
            OCNewFileWithSelectedExtensionAction.$$$reportNull$$$0(0);
        }
        List<FileExtensionPair> list = OCNewFileLangBackendHandlerProvider.getHandler().getExtensions(CodeStyle.getSettings((Project)project));
        if (list == null) {
            OCNewFileWithSelectedExtensionAction.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    protected Couple<String> determineExtensions(@NotNull PsiFile sampleFile, @Nullable String preferredSourceExt, @Nullable String preferredHeaderExt) {
        if (sampleFile == null) {
            OCNewFileWithSelectedExtensionAction.$$$reportNull$$$0(2);
        }
        Couple<String> couple = OCNewFileLangBackendHandlerProvider.getHandler().determineExtensions(sampleFile, preferredSourceExt, preferredHeaderExt);
        if (couple == null) {
            OCNewFileWithSelectedExtensionAction.$$$reportNull$$$0(3);
        }
        return couple;
    }

    @NotNull
    protected Pair<String, FileExtensionPair> determineNameAndExtension(@NotNull String fileName, boolean isHeader) {
        if (fileName == null) {
            OCNewFileWithSelectedExtensionAction.$$$reportNull$$$0(4);
        }
        String selectedExt = FileUtilRt.getExtension((String)fileName);
        FileExtensionPair extensionPair = null;
        if (selectedExt.length() > 0 && (isHeader ? OCFileTypeHelpers.isHeaderFile(fileName) : OCFileTypeHelpers.isSourceFile(fileName))) {
            fileName = FileUtilRt.getNameWithoutExtension((String)fileName);
            List<FileExtensionPair> es = this.getExtensions(this.getState().project);
            for (FileExtensionPair e : es) {
                String referenceExt = isHeader ? e.myHeaderExt : e.mySourceExt;
                if (!referenceExt.equals(selectedExt)) continue;
                extensionPair = e;
                break;
            }
            if (extensionPair == null) {
                String srcExt = isHeader ? "cpp" : selectedExt;
                String headerExt = isHeader ? selectedExt : "h";
                extensionPair = new FileExtensionPair(srcExt, headerExt, NamingConventionStyle.NONE);
            }
        } else {
            extensionPair = ((CreateFileDialog)((Object)this.getState().dialogPeer)).myFileExtensionPair;
            if (extensionPair == null) {
                extensionPair = new FileExtensionPair("cpp", "h", NamingConventionStyle.NONE);
            }
        }
        Pair.NonNull nonNull = Pair.createNonNull((Object)fileName, (Object)extensionPair);
        if (nonNull == null) {
            OCNewFileWithSelectedExtensionAction.$$$reportNull$$$0(5);
        }
        return nonNull;
    }

    @Override
    protected boolean isValidName(@NotNull String selectedName) {
        if (selectedName == null) {
            OCNewFileWithSelectedExtensionAction.$$$reportNull$$$0(6);
        }
        return StandardFileSystems.local().isValidName(selectedName);
    }

    @Override
    @NotNull
    protected T createDialog(@NotNull @NlsContexts.Label String defaultName) {
        if (defaultName == null) {
            OCNewFileWithSelectedExtensionAction.$$$reportNull$$$0(7);
        }
        return (T)((Object)new CreateFileDialog(defaultName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "determineExtensions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "determineNameAndExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "determineExtensions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "determineNameAndExtension";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class CreateFileDialog
    extends OCNewFileActionBase.CreateFileDialogBase {
        @Nullable
        protected FileExtensionPair myFileExtensionPair;
        protected TemplateKindCombo myKindCombo;
        @NotNull
        protected ImmutableList<FileExtensionPair> pairs;

        public CreateFileDialog(String defaultName) {
            this(CidrLangBundle.message("action.create.new.file", this$0.getTemplatePresentation().getText()), defaultName);
        }

        public CreateFileDialog(@NlsContexts.Label String title, String defaultName) {
            super(title, defaultName, PlatformUtils.isCLion() ? OCNewFileWithSelectedExtensionAction.NEW_CPP_HELP_TOPIC_ID : null);
            this.pairs = ContainerUtil.immutableList((Object[])new FileExtensionPair[0]);
        }

        @Override
        protected void addNameField(FormBuilder formBuilder) {
            this.addNameField(formBuilder, true);
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            this.createFileTypesCombo(formBuilder);
        }

        protected void createFileTypesCombo(FormBuilder formBuilder) {
            JPanel panel = new JPanel(new BorderLayout(5, 0));
            this.myKindCombo = new TemplateKindCombo();
            panel.add((Component)this.myKindCombo, "Center");
            panel.add((Component)this.createPreferencesButton(), "East");
            formBuilder.addLabeledComponent(CidrLangBundle.message("create.field.type", new Object[0]), (JComponent)panel);
            this.reloadExtensions();
            ((JComboBox)this.myKindCombo.getChildComponent()).addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    int selectedIndex;
                    if (event.getStateChange() == 1 && (selectedIndex = CreateFileDialog.this.myKindCombo.getComboBox().getSelectedIndex()) < CreateFileDialog.this.pairs.size()) {
                        CreateFileDialog.this.myFileExtensionPair = (FileExtensionPair)CreateFileDialog.this.pairs.get(selectedIndex);
                    }
                    CreateFileDialog.this.validateOkAction();
                }
            });
            this.myKindCombo.registerUpDownHint((JComponent)this.myNameField);
        }

        protected void reloadExtensions() {
            String prevPairName = this.myFileExtensionPair == null ? null : this.getPresentableName(this.myFileExtensionPair);
            FileExtensionPair currentPair = null;
            this.myKindCombo.clear();
            HashSet<String> processedNames = new HashSet<String>();
            ArrayList<FileExtensionPair> filteredPairs = new ArrayList<FileExtensionPair>();
            for (FileExtensionPair pair : OCNewFileWithSelectedExtensionAction.this.getExtensions(OCNewFileWithSelectedExtensionAction.this.getState().project)) {
                String presentableName = this.getPresentableName(pair);
                if (!processedNames.add(presentableName)) continue;
                this.myKindCombo.addItem(presentableName, null, presentableName);
                filteredPairs.add(pair);
                if (!presentableName.equals(prevPairName)) continue;
                currentPair = pair;
            }
            if (!filteredPairs.isEmpty()) {
                this.pairs = ContainerUtil.immutableList(filteredPairs);
                this.myFileExtensionPair = currentPair == null ? (FileExtensionPair)this.pairs.get(0) : currentPair;
                this.myKindCombo.setSelectedName(this.getPresentableName(this.myFileExtensionPair));
            }
        }

        @Override
        @Nullable
        protected String collectOkActionErrors() {
            if (this.myKindCombo.getComboBox().getItemCount() == 0) {
                return CidrLangBundle.message("fileExtensions.noCompatibleTypes", new Object[0]);
            }
            return super.collectOkActionErrors();
        }

        @NotNull
        @NlsSafe
        protected String getPresentableName(@NotNull FileExtensionPair pair) {
            if (pair == null) {
                CreateFileDialog.$$$reportNull$$$0(0);
            }
            String string = "." + pair.mySourceExt + " / ." + pair.myHeaderExt;
            if (string == null) {
                CreateFileDialog.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        private InplaceButton createPreferencesButton() {
            return new InplaceButton(CidrLangBundle.message("fileExtensions.editFileTypesTooltip", new Object[0]), AllIcons.General.Settings, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CodeStyleSettings settings = CodeStyle.getSettings((Project)OCNewFileWithSelectedExtensionAction.this.getState().project);
                    OCFileExtensionsSettingsProvider.MyMasterDetailsComponent configurable = OCFileExtensionsSettingsProvider.createConfigurable(settings);
                    boolean ok = ShowSettingsUtil.getInstance().editConfigurable(OCNewFileWithSelectedExtensionAction.this.getState().project, (Configurable)configurable);
                    if (ok) {
                        CreateFileDialog.this.reloadExtensions();
                    }
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pair";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction$CreateFileDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction$CreateFileDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentableName";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

