/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSettingsKey;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoots;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCCompilerSettings {
    @Nullable
    public OCCompilerKind getCompilerKind();

    @Nullable
    public File getCompilerExecutable();

    @Nullable
    public File getCompilerWorkingDir();

    @Nullable
    public CidrCompilerSwitches getCompilerSwitches();

    @NotNull
    public HeadersSearchRoots getHeadersSearchRoots();

    @NotNull
    public List<HeadersSearchPath> getHeadersSearchPaths();

    @NotNull
    public List<VirtualFile> getImplicitIncludes();

    @NotNull
    public List<String> getImplicitIncludeUrls();

    @Nullable
    public VirtualFile getMappedInclude(@NotNull String var1);

    @Nullable
    public String getMappedIncludeUrl(@NotNull String var1);

    @NotNull
    public List<String> getPreprocessorDefines();

    @NotNull
    public Map<OCCompilerFeatures.Type<?>, ?> getCompilerFeatures();

    @Nullable
    public CompilerSettingsKey getCachingKey();

    @Nullable
    public Object getIndexingCluster();

    public static interface ModifiableModel {
        public void setCompiler(@Nullable OCCompilerKind var1, @Nullable File var2, @Nullable File var3);

        public void setCompilerSwitches(@Nullable CidrCompilerSwitches var1);

        public void setHeadersSearchPaths(@Nullable List<HeadersSearchPath> var1);

        public void setImplicitIncludes(@Nullable List<? extends VirtualFile> var1);

        public void setImplicitIncludeUrls(@Nullable List<String> var1);

        public void setMappedIncludes(@Nullable Map<String, ? extends VirtualFile> var1);

        public void setMappedIncludeUrls(@Nullable Map<String, String> var1);

        default public void setPreprocessorDefines(@Nullable String defines) {
            if (defines == null || defines.isBlank()) {
                this.setPreprocessorDefines((List<String>)null);
                return;
            }
            this.setPreprocessorDefines(Arrays.asList(StringUtil.splitByLines((String)defines)));
        }

        public void setPreprocessorDefines(@Nullable List<String> var1);

        public void setCompilerFeatures(@Nullable Map<OCCompilerFeatures.Type<?>, ?> var1);

        public void clear();
    }
}

