/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesProvider;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class OCCompilerFeatures {
    public static final Type<OCLanguageStandard> LANGUAGE_STANDARD = new Type<OCLanguageStandard>(){

        public String toString() {
            return "LANGUAGE_STANDARD";
        }

        @Override
        @NotNull
        public OCLanguageStandard getDefault() {
            OCLanguageStandard oCLanguageStandard = OCLanguageStandard.CPP98;
            if (oCLanguageStandard == null) {
                1.$$$reportNull$$$0(0);
            }
            return oCLanguageStandard;
        }

        @Override
        @NotNull
        public OCLanguageStandard compute(@NotNull OCCompilerFeaturesProvider provider) {
            if (provider == null) {
                1.$$$reportNull$$$0(1);
            }
            OCLanguageStandard oCLanguageStandard = provider.getLanguageStandard();
            if (oCLanguageStandard == null) {
                1.$$$reportNull$$$0(2);
            }
            return oCLanguageStandard;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final short BIT_8 = 1;
    public static final short BIT_16 = 2;
    public static final short BIT_32 = 4;
    public static final short BIT_64 = 8;
    public static final short BIT_128 = 16;
    @TestOnly
    private static final Key<Map<Type, Object>> ENABLED_FEATURES = Key.create((String)"ENABLED_FEATURES");

    @Nullable
    public static <T> T getForTests(@NotNull Project project, @NotNull Type<T> type) {
        Map features;
        if (project == null) {
            OCCompilerFeatures.$$$reportNull$$$0(0);
        }
        if (type == null) {
            OCCompilerFeatures.$$$reportNull$$$0(1);
        }
        return (features = (Map)ENABLED_FEATURES.get((UserDataHolder)project)) == null ? null : (T)features.get(type);
    }

    @TestOnly
    public static <T> void set(@NotNull Project project, Type<T> feature, T value) {
        ConcurrentHashMap<Type<T>, T> enabledFeatures;
        if (project == null) {
            OCCompilerFeatures.$$$reportNull$$$0(2);
        }
        if ((enabledFeatures = (ConcurrentHashMap<Type<T>, T>)ENABLED_FEATURES.get((UserDataHolder)project)) == null) {
            enabledFeatures = new ConcurrentHashMap<Type<T>, T>();
            project.putUserData(ENABLED_FEATURES, enabledFeatures);
        }
        enabledFeatures.put(feature, value);
    }

    @TestOnly
    public static void resetFeatures(@NotNull Project project) {
        if (project == null) {
            OCCompilerFeatures.$$$reportNull$$$0(3);
        }
        project.putUserData(ENABLED_FEATURES, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getForTests";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resetFeatures";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Diagnostic implements Type<DiagnosticLevel>
    {
        MISSING_RETURN_FROM_NON_VOID(DiagnosticLevel.WARNING),
        FOLDING_CONSTANT(DiagnosticLevel.ERROR);

        @NotNull
        private final DiagnosticLevel myDefault;

        private Diagnostic(DiagnosticLevel def) {
            if (def == null) {
                Diagnostic.$$$reportNull$$$0(0);
            }
            this.myDefault = def;
        }

        @Override
        @NotNull
        public DiagnosticLevel getDefault() {
            DiagnosticLevel diagnosticLevel = this.myDefault;
            if (diagnosticLevel == null) {
                Diagnostic.$$$reportNull$$$0(1);
            }
            return diagnosticLevel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "def";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Diagnostic";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Diagnostic";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum DiagnosticLevel {
        DISABLED,
        WARNING,
        ERROR;


        public boolean isEnabled() {
            return this != DISABLED;
        }
    }

    public static enum TypeSize implements Type<Short>
    {
        BOOL(1),
        CHAR(1),
        CHAR8_T(1),
        CHAR16_T(2),
        CHAR32_T(4),
        WCHAR_T(4),
        SHORT(2),
        INT(4),
        LONG(4),
        SIZE_T(INT),
        PTRDIFF_T(SIZE_T),
        POINTER(SIZE_T),
        LONG_LONG(8),
        INT128_T(16),
        FLOAT(4),
        DOUBLE(8),
        LONG_DOUBLE(8);

        @Nullable
        private final TypeSize myBaseType;
        private final short myDefault;

        private TypeSize(short def) {
            this.myBaseType = null;
            this.myDefault = def;
        }

        private TypeSize(TypeSize baseType) {
            if (baseType == null) {
                TypeSize.$$$reportNull$$$0(0);
            }
            this.myBaseType = baseType;
            this.myDefault = this.myBaseType.getDefault();
        }

        @Override
        @NotNull
        public Short getDefault() {
            Short s = this.myDefault;
            if (s == null) {
                TypeSize.$$$reportNull$$$0(1);
            }
            return s;
        }

        @Override
        @Nullable
        public Short compute(@NotNull OCCompilerFeaturesProvider provider) {
            if (provider == null) {
                TypeSize.$$$reportNull$$$0(2);
            }
            if (this.myBaseType != null) {
                return provider.getCompilerFeature(this.myBaseType);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$TypeSize";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$TypeSize";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Feature implements Type<Boolean>
    {
        C_STATIC_ASSERT(OCLanguageStandard.C11),
        CXX_EXCEPTIONS(OCLanguageStandard.CPP98),
        CXX_AUTO_TYPE(OCLanguageStandard.CPP11),
        CXX_OVERRIDE_CONTROL(OCLanguageStandard.CPP11),
        CXX_GENERALIZED_INITIALIZERS(OCLanguageStandard.CPP11),
        CXX_NULLPTR(OCLanguageStandard.CPP11),
        CXX_NONSTATIC_MEMBER_INIT(OCLanguageStandard.CPP11),
        CXX_CONSTEXPR(OCLanguageStandard.CPP11),
        CXX_RAW_STRING_LITERALS(OCLanguageStandard.CPP11),
        CXX_USER_LITERALS(OCLanguageStandard.CPP11),
        CXX_ATTRIBUTES(OCLanguageStandard.CPP11),
        CXX_BINARY_LITERALS(OCLanguageStandard.CPP14),
        CXX_RETURN_TYPE_DEDUCTION(OCLanguageStandard.CPP14),
        CXX_LAMBDAS(OCLanguageStandard.CPP11),
        CXX_GENERIC_LAMBDAS(OCLanguageStandard.CPP14),
        CXX_CONCEPTS(OCLanguageStandard.CPP20),
        OBJC_ARC,
        OBJC_BOOL,
        OBJC_DEFAULT_SYNTHESIZE_PROPERTIES,
        OBJC_PROPERTY_EXPLICIT_ATOMIC,
        OBJC_INSTANCETYPE,
        OBJC_SUBSCRIPTING,
        OBJC_ARRAY_LITERALS,
        OBJC_DICTIONARY_LITERALS,
        OBJC_CLASS_PROPERTY,
        UNDERLYING_TYPE,
        IS_BASE_OF,
        NULLABILITY,
        GCC_AUTO_TYPE,
        BUILTIN_AVAILABLE,
        IS_TARGET_ARCH,
        IS_TARGET_VENDOR,
        IS_TARGET_OS,
        IS_TARGET_ENVIRONMENT,
        IS_TARGET_VARIANT_OS,
        IS_TARGET_VARIANT_ENVIRONMENT,
        MS_EXTENSIONS{

            @Override
            @NotNull
            public Boolean compute(@NotNull OCCompilerFeaturesProvider provider) {
                if (provider == null) {
                    1.$$$reportNull$$$0(0);
                }
                Boolean bl = provider.areMSExtensionsEnabled();
                if (bl == null) {
                    1.$$$reportNull$$$0(1);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "provider";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "compute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "compute";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        @Nullable
        private final OCLanguageStandard myAvailableInStandard;

        private Feature() {
            this(null);
        }

        private Feature(OCLanguageStandard availableInStandard) {
            this.myAvailableInStandard = availableInStandard;
        }

        @Override
        @NotNull
        public Boolean getDefault() {
            Boolean bl = this.myAvailableInStandard != null && LANGUAGE_STANDARD.getDefault().supports(this.myAvailableInStandard);
            if (bl == null) {
                Feature.$$$reportNull$$$0(0);
            }
            return bl;
        }

        @Override
        @Nullable
        public Boolean compute(@NotNull OCCompilerFeaturesProvider provider) {
            if (provider == null) {
                Feature.$$$reportNull$$$0(1);
            }
            if (this.myAvailableInStandard != null) {
                OCLanguageStandard standard = (OCLanguageStandard)((Object)ObjectUtils.notNull((Object)((Object)provider.getCompilerFeature(LANGUAGE_STANDARD)), (Object)((Object)LANGUAGE_STANDARD.getDefault())));
                return standard.supports(this.myAvailableInStandard);
            }
            return null;
        }

        @Nullable
        public OCLanguageStandard getAvailableInStandard() {
            return this.myAvailableInStandard;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Type<T>
    extends Serializable {
        @NotNull
        public T getDefault();

        @Nullable
        default public T compute(@NotNull OCCompilerFeaturesProvider provider) {
            if (provider == null) {
                Type.$$$reportNull$$$0(0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Type", "compute"));
        }
    }
}

