/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.PathMapper;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.WSLCidrUtil;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.RemoteDeployment;
import com.jetbrains.cidr.system.RemoteDeploymentHelper;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.toolchains.OSType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteProjectUtil {
    public static final String SOURCE_UPLOAD_MARKER = ".clion.source.upload.marker";

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    public static void syncToHosts(@NotNull List<CPPEnvironment> list, @NotNull Project project, @NotNull String string, @NotNull List<String> list2) throws ExecutionException {
        ProgressIndicator progressIndicator;
        void excludeList;
        void projectDir;
        void project2;
        List<CPPEnvironment> remoteEnvs;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (remoteEnvs == null) {
            RemoteProjectUtil.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            RemoteProjectUtil.$$$reportNull$$$0(1);
        }
        if (projectDir == null) {
            RemoteProjectUtil.$$$reportNull$$$0(2);
        }
        if (excludeList == null) {
            RemoteProjectUtil.$$$reportNull$$$0(3);
        }
        if ((progressIndicator = ProgressManager.getInstance().getProgressIndicator()) == null) {
            progressIndicator = new EmptyProgressIndicator();
        }
        RemoteProjectUtil.syncToHosts(remoteEnvs, (Project)project2, (String)projectDir, (List<String>)excludeList, progressIndicator);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    public static void syncToHosts(@NotNull List<CPPEnvironment> list, @NotNull Project project, @NotNull String string, @NotNull List<String> list2, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        RemoteDeployment remoteDeployment;
        void progressIndicator2;
        void excludeList;
        void projectDir;
        void project2;
        List<CPPEnvironment> remoteEnvs;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (remoteEnvs == null) {
            RemoteProjectUtil.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            RemoteProjectUtil.$$$reportNull$$$0(5);
        }
        if (projectDir == null) {
            RemoteProjectUtil.$$$reportNull$$$0(6);
        }
        if (excludeList == null) {
            RemoteProjectUtil.$$$reportNull$$$0(7);
        }
        if (progressIndicator2 == null) {
            RemoteProjectUtil.$$$reportNull$$$0(8);
        }
        if ((remoteDeployment = (RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class)) == null) {
            return;
        }
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteDeploymentHelper: upload project to " + remoteEnvs.size() + " hosts");
        }
        ArrayList<CompletionStage> uploads = new ArrayList<CompletionStage>(remoteEnvs.size());
        if (Registry.is((String)"clion.remote.resync.system.cache", (boolean)false)) {
            remoteEnvs.forEach(env -> env.getHostMachine().invalidateCache());
        }
        ExecutionException ex = null;
        HashSet<String> hosts = new HashSet<String>(remoteEnvs.size());
        for (CPPEnvironment cPPEnvironment : remoteEnvs) {
            RemoteCredentials credentials;
            String hostId;
            HostMachine host = cPPEnvironment.getHostMachine();
            assert (host.isRemote());
            if (host instanceof WSLCidrUtil.WSLHost || !remoteDeployment.isDeploymentConfigSFTP(hostId = host.getHostId()) || (credentials = RemoteUtil.getCredentials(host)) == null) continue;
            OSType osType = host.getOSType();
            PathMapper pathMapper = RemoteDeploymentHelper.getPathMapper(hostId, (Project)project2);
            if (pathMapper == null) continue;
            try {
                remoteDeployment.addExcludedPaths(hostId, (Project)project2, (List<String>)excludeList);
                boolean isUploaded = RemoteProjectUtil.isRemoteProjectUploaded(osType, credentials, (String)projectDir, pathMapper);
                if (RemoteHostUtil.LOG.isDebugEnabled()) {
                    RemoteHostUtil.LOG.debug("RemoteDeploymentHelper: project is uploaded: " + isUploaded);
                }
                if (!isUploaded) {
                    CompletionStage future = remoteDeployment.upload(hostId, (Project)project2, (ProgressIndicator)progressIndicator2).thenRun(() -> RemoteProjectUtil.lambda$syncToHosts$1(osType, credentials, (String)projectDir, pathMapper));
                    uploads.add(future);
                }
            }
            catch (ExecutionException e) {
                if (ex == null) {
                    ex = e;
                }
                ex.addSuppressed((Throwable)e);
            }
            hosts.add(hostId);
        }
        remoteDeployment.subscribeForUploading((Project)project2, hosts);
        for (Future future : uploads) {
            RemoteDeploymentHelper.waitForTransferOperation(future);
        }
        if (ex != null) {
            throw ex;
        }
    }

    private static boolean isRemoteProjectUploaded(@NotNull OSType osType, @NotNull RemoteCredentials credentials, @NotNull String projectDir, @Nullable PathMapper pathMapper) throws ExecutionException {
        if (osType == null) {
            RemoteProjectUtil.$$$reportNull$$$0(9);
        }
        if (credentials == null) {
            RemoteProjectUtil.$$$reportNull$$$0(10);
        }
        if (projectDir == null) {
            RemoteProjectUtil.$$$reportNull$$$0(11);
        }
        if (pathMapper == null) {
            return false;
        }
        String remotePath = pathMapper.convertToRemote(projectDir);
        String markerPath = remotePath + "/.clion.source.upload.marker";
        return RemoteUtil.fileExists(osType, credentials, markerPath);
    }

    private static void markRemoteProjectAsUploaded(@NotNull OSType osType, @NotNull RemoteCredentials credentials, @NotNull String projectDir, @NotNull PathMapper pathMapper) {
        if (osType == null) {
            RemoteProjectUtil.$$$reportNull$$$0(12);
        }
        if (credentials == null) {
            RemoteProjectUtil.$$$reportNull$$$0(13);
        }
        if (projectDir == null) {
            RemoteProjectUtil.$$$reportNull$$$0(14);
        }
        if (pathMapper == null) {
            RemoteProjectUtil.$$$reportNull$$$0(15);
        }
        String remotePath = pathMapper.convertToRemote(projectDir);
        String markerPath = remotePath + "/.clion.source.upload.marker";
        try {
            RemoteUtil.touch(osType, credentials, markerPath);
        }
        catch (ExecutionException e) {
            throw new CompletionException(e);
        }
    }

    private static /* synthetic */ void lambda$syncToHosts$1(OSType osType, RemoteCredentials credentials, String projectDir, PathMapper pathMapper) {
        RemoteProjectUtil.markRemoteProjectAsUploaded(osType, credentials, projectDir, pathMapper);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteEnvs";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osType";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/system/RemoteProjectUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "syncToHosts";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isRemoteProjectUploaded";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "markRemoteProjectAsUploaded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

