/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.BaseRemoteProcessHandler;
import com.intellij.remote.ColoredRemoteProcessHandler;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteProcess;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.DialogSshSudoPasswordStringProvider;
import com.intellij.ssh.PasswordStringProvider;
import com.intellij.ssh.RSyncUtil;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.nio.UnixSshFileSysProvider;
import com.intellij.ssh.process.CapturingSshProcessHandler;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.ssh.process.SshProcess;
import com.intellij.util.PathMapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.cpp.toolchains.WSLCidrUtil;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.HostUtilKt;
import com.jetbrains.cidr.system.RemoteDeploymentHelper;
import com.jetbrains.cidr.system.RemoteHost;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.system.SystemUtil;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteUtil {
    @NlsSafe
    public static final String DEFAULT_CMAKE_PATH = "/usr/bin/cmake";
    @NlsSafe
    public static final String DEFAULT_GDB_PATH = "/usr/bin/gdb";
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Remote Development", (String)ToolchainsBundle.message("remote.development", new Object[0]));
    public static final int CONNECTION_TIMEOUT = StringUtil.parseInt((String)System.getProperty("clion.remote.connection.timeout"), (int)3000);
    public static final int TEST_CONNECTION_TIMEOUT = StringUtil.parseInt((String)System.getProperty("clion.remote.test.connection.timeout"), (int)5000);

    private RemoteUtil() {
    }

    public static boolean isFullRemoteModeAvailable() {
        return RemoteDeploymentHelper.isRemoteDeploymentServiceAvailable();
    }

    @NotNull
    private static ConnectionBuilder createConnectionBuilder(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(0);
        }
        return RemoteUtil.createConnectionBuilder(credentials, null);
    }

    @NotNull
    private static ConnectionBuilder createConnectionBuilder(@NotNull RemoteCredentials credentials, @Nullable ProgressIndicator indicator) {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(1);
        }
        boolean allowDialogs = false;
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)credentials, null, (ProgressIndicator)indicator, (boolean)false);
        if (connectionBuilder == null) {
            RemoteUtil.$$$reportNull$$$0(2);
        }
        return connectionBuilder;
    }

    @NotNull
    public static CidrProcessBuilder createRemoteProcess(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(3);
        }
        return RemoteUtil.createRemoteProcess(credentials, null);
    }

    @NotNull
    public static CidrProcessBuilder createRemoteProcess(final @NotNull RemoteCredentials credentials, final @Nullable PathMapper pathMapper) {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(4);
        }
        return new CidrProcessBuilder(){

            @NotNull
            protected BaseProcessHandler<?> build(@NotNull GeneralCommandLine cmd, @NotNull CidrProcessBuilder.Parameters parameters) throws ExecutionException {
                if (cmd == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (parameters == null) {
                    1.$$$reportNull$$$0(1);
                }
                BaseProcessHandler<?> baseProcessHandler = RemoteUtil.createRemoteProcess(cmd, credentials, parameters, pathMapper);
                if (baseProcessHandler == null) {
                    1.$$$reportNull$$$0(2);
                }
                return baseProcessHandler;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "cmd";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameters";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/system/RemoteUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/system/RemoteUtil$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "build";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "build";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    private static BaseProcessHandler<?> createRemoteProcess(@NotNull GeneralCommandLine cmd, @NotNull RemoteCredentials credentials, @NotNull CidrProcessBuilder.Parameters params, @Nullable PathMapper pathMapper) throws ExecutionException {
        if (cmd == null) {
            RemoteUtil.$$$reportNull$$$0(5);
        }
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(6);
        }
        if (params == null) {
            RemoteUtil.$$$reportNull$$$0(7);
        }
        RemoteUtil.prepare(cmd, pathMapper);
        try {
            if (RemoteHostUtil.LOG.isTraceEnabled()) {
                RemoteHostUtil.LOG.trace("Create remote process: " + cmd.getCommandLineString());
            }
            ConnectionBuilder connectionBuilder = RemoteUtil.createConnectionBuilder(credentials, params.getProgressIndicator()).withConnectionTimeout((long)CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS);
            SshExecProcess process = SystemUtil.executeOrRunTask(() -> RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)cmd).withAllocatePty(params.isPty()).withSudo(params.isElevated(), (PasswordStringProvider)new DialogSshSudoPasswordStringProvider(credentials)).withChangeDir(true).start());
            if (params.isColored()) {
                return new ParameterizedColoredRemoteProcessHandler((RemoteProcess)process, cmd.getCommandLineString(), cmd.getCharset(), params);
            }
            if (params.isCapturedOutput()) {
                return new ParameterizedCapturingSshProcessHandler((SshProcess<?>)process, cmd.getCharset(), cmd.getCommandLineString(), params);
            }
            return new ParameterizedRemoteProcessHandler<SshExecProcess>(process, cmd.getCommandLineString(), cmd.getCharset(), params);
        }
        catch (Exception e) {
            RemoteHostUtil.LOG.warn((Throwable)e);
            throw new ExecutionException((Throwable)e);
        }
    }

    private static void prepare(@NotNull GeneralCommandLine cl, @Nullable PathMapper pathMapper) {
        if (cl == null) {
            RemoteUtil.$$$reportNull$$$0(8);
        }
        if (pathMapper == null) {
            return;
        }
        File wd = cl.getWorkDirectory();
        if (wd != null) {
            cl.setWorkDirectory(pathMapper.convertToRemote(wd.getPath()));
        }
        String exe = cl.getExePath();
        cl.setExePath(pathMapper.convertToRemote(exe));
        File inputFile = cl.getInputFile();
        if (inputFile != null) {
            cl.withInput(new File(pathMapper.convertToRemote(inputFile.getPath())));
        }
    }

    @NotNull
    public static ProcessOutput runRemoteProcess(@NotNull GeneralCommandLine cl, @NotNull RemoteCredentials credentials, int timeout) throws ExecutionException {
        if (cl == null) {
            RemoteUtil.$$$reportNull$$$0(9);
        }
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(10);
        }
        return RemoteUtil.runRemoteProcess(cl, credentials, null, timeout);
    }

    @NotNull
    public static ProcessOutput runRemoteProcess(@NotNull GeneralCommandLine cl, @NotNull RemoteCredentials credentials, @Nullable ProgressIndicator indicator, int timeout) throws ExecutionException {
        if (cl == null) {
            RemoteUtil.$$$reportNull$$$0(11);
        }
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(12);
        }
        BaseProcessHandler handler = RemoteUtil.createRemoteProcess(credentials).withProgressIndicator(indicator).build(cl);
        ProcessOutput processOutput = CidrToolsUtil.runProcess((BaseProcessHandler)handler, (ProgressIndicator)indicator, (int)timeout);
        if (processOutput == null) {
            RemoteUtil.$$$reportNull$$$0(13);
        }
        return processOutput;
    }

    public static void killProcessTree(@NotNull BaseProcessHandler<?> handler) {
        Process process;
        if (handler == null) {
            RemoteUtil.$$$reportNull$$$0(14);
        }
        if ((process = handler.getProcess()) instanceof RemoteProcess) {
            ((RemoteProcess)process).killProcessTree();
        }
    }

    public static boolean checkConnection(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(15);
        }
        try {
            return SystemUtil.executeOrRunTask(() -> RemoteUtil.createConnectionBuilder(credentials).connect((long)TEST_CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS).isConnected());
        }
        catch (Exception exception) {
            return false;
        }
    }

    @NotNull
    public static NamedPipe openPipe(@NotNull HostMachine host) throws ExecutionException {
        if (host == null) {
            RemoteUtil.$$$reportNull$$$0(16);
        }
        RemoteUtil.assertUnixOnly(host.getOSType());
        return new RemoteUnixPipe(host);
    }

    private static void rmSilently(@NotNull HostMachine host, @NotNull String path) {
        if (host == null) {
            RemoteUtil.$$$reportNull$$$0(17);
        }
        if (path == null) {
            RemoteUtil.$$$reportNull$$$0(18);
        }
        try {
            Path nioPath = host.getPath(path, new String[0]);
            if (host instanceof WSLCidrUtil.WSLHost) {
                if (!WSLCidrUtil.delete(nioPath)) {
                    RemoteHostUtil.LOG.warn("cannot remove file: " + path);
                }
            } else {
                Files.delete(nioPath);
            }
        }
        catch (IOException e) {
            RemoteHostUtil.LOG.warn("cannot remove file: " + path, (Throwable)e);
        }
    }

    @NotNull
    public static String generateTempFileName(@NotNull HostMachine host) throws ExecutionException {
        if (host == null) {
            RemoteUtil.$$$reportNull$$$0(19);
        }
        return RemoteUtil.getTempFileName(command -> host.runProcess(command, RemoteHostUtil.DEFAULT_COMMAND_TIMEOUT), host.getOSType());
    }

    @NotNull
    private static String getTempFileName(@NotNull CommandRunner runner, @NotNull OSType osType) throws ExecutionException {
        GeneralCommandLine command;
        ProcessOutput output;
        if (runner == null) {
            RemoteUtil.$$$reportNull$$$0(20);
        }
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(21);
        }
        RemoteUtil.assertUnixOnly(osType);
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteUtil: get temporary file name");
        }
        if (!(output = runner.run(command = new GeneralCommandLine(new String[]{"mktemp", "-u"}))).checkSuccess(RemoteHostUtil.LOG)) {
            throw new ExecutionException(ToolchainsBundle.message("remote.exception.cannot.generate.temp.path.ext", output.getExitCode()));
        }
        String result = StringUtil.nullize((String)output.getStdout().trim());
        if (result == null) {
            throw new ExecutionException(ToolchainsBundle.message("remote.exception.cannot.generate.temp.path", new Object[0]));
        }
        String string = result;
        if (string == null) {
            RemoteUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private static String createNamedPipe(@NotNull HostMachine host) throws ExecutionException {
        if (host == null) {
            RemoteUtil.$$$reportNull$$$0(23);
        }
        String tmpFileName = RemoteUtil.generateTempFileName(host);
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"mkfifo", tmpFileName});
        ProcessOutput output = host.runProcess(cmd, RemoteHostUtil.DEFAULT_COMMAND_TIMEOUT);
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug(CidrToolsUtil.logInfo((GeneralCommandLine)cmd, (ProcessOutput)output));
        }
        CidrToolsUtil.checkSuccess((GeneralCommandLine)cmd, (ProcessOutput)output, (Logger)RemoteHostUtil.LOG);
        String string = tmpFileName;
        if (string == null) {
            RemoteUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static String mktemp(@NotNull RemoteCredentials credentials, @NotNull OSType osType, boolean createDir) throws ExecutionException {
        ProcessOutput output;
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(25);
        }
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(26);
        }
        RemoteUtil.assertUnixOnly(osType);
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteUtil: mktemp");
        }
        GeneralCommandLine command = new GeneralCommandLine(new String[]{"mktemp"});
        if (createDir) {
            command.addParameter("-d");
        }
        if ((output = RemoteUtil.runRemoteProcess(command, credentials, RemoteHostUtil.DEFAULT_COMMAND_TIMEOUT)).isTimeout() || output.getExitCode() != 0) {
            throw new ExecutionException(ToolchainsBundle.message("remote.exception.cannot.create.temp.file.ext", output.isTimeout() ? "Timed out" : "Exit code " + output.getExitCode(), output.getExitCode()));
        }
        String path = StringUtil.nullize((String)output.getStdout().trim());
        if (path == null) {
            throw new ExecutionException(ToolchainsBundle.message("remote.exception.cannot.create.temp.file", new Object[0]));
        }
        String string = path;
        if (string == null) {
            RemoteUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    public static boolean fileExists(@NotNull RemoteCredentials credentials, @NotNull String path) throws ExecutionException {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(28);
        }
        if (path == null) {
            RemoteUtil.$$$reportNull$$$0(29);
        }
        return RemoteUtil.fileExists(OSType.LINUX, credentials, path);
    }

    public static boolean fileExists(@NotNull OSType osType, @NotNull RemoteCredentials credentials, @NotNull String path) throws ExecutionException {
        GeneralCommandLine command;
        ProcessOutput output;
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(30);
        }
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(31);
        }
        if (path == null) {
            RemoteUtil.$$$reportNull$$$0(32);
        }
        RemoteUtil.assertUnixOnly(osType);
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteUtil: file exists: " + path);
        }
        return (output = RemoteUtil.runRemoteProcess(command = new GeneralCommandLine(new String[]{"test", "-e", path}), credentials, RemoteHostUtil.DEFAULT_COMMAND_TIMEOUT)).getExitCode() == 0;
    }

    public static void touch(@NotNull OSType osType, @NotNull RemoteCredentials credentials, @NotNull String path) throws ExecutionException {
        GeneralCommandLine command;
        ProcessOutput output;
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(33);
        }
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(34);
        }
        if (path == null) {
            RemoteUtil.$$$reportNull$$$0(35);
        }
        RemoteUtil.assertUnixOnly(osType);
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteUtil: touch: " + path);
        }
        if (!(output = RemoteUtil.runRemoteProcess(command = new GeneralCommandLine(new String[]{"touch", path}), credentials, RemoteHostUtil.DEFAULT_COMMAND_TIMEOUT)).checkSuccess(RemoteHostUtil.LOG)) {
            RemoteHostUtil.LOG.warn("Command 'touch' has been failed: " + path);
        }
    }

    @Nullable
    public static String resolveToExecutable(@NotNull HostMachine host, @NotNull String name) throws ExecutionException {
        if (host == null) {
            RemoteUtil.$$$reportNull$$$0(36);
        }
        if (name == null) {
            RemoteUtil.$$$reportNull$$$0(37);
        }
        return RemoteUtil.resolveToExecutable(command -> host.runProcess(command, RemoteHostUtil.DEFAULT_COMMAND_TIMEOUT), host.getOSType(), name);
    }

    @Nullable
    public static String resolveToExecutable(@NotNull RemoteCredentials credentials, @NotNull String name) throws ExecutionException {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(38);
        }
        if (name == null) {
            RemoteUtil.$$$reportNull$$$0(39);
        }
        return RemoteUtil.resolveToExecutable(command -> RemoteUtil.runRemoteProcess(command, credentials, RemoteHostUtil.DEFAULT_COMMAND_TIMEOUT), OSType.LINUX, name);
    }

    @Nullable
    private static String resolveToExecutable(@NotNull CommandRunner runner, @NotNull OSType osType, @NotNull String name) throws ExecutionException {
        ProcessOutput output;
        if (runner == null) {
            RemoteUtil.$$$reportNull$$$0(40);
        }
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(41);
        }
        if (name == null) {
            RemoteUtil.$$$reportNull$$$0(42);
        }
        RemoteUtil.assertUnixOnly(osType);
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteUtil: resolve to executable: " + name);
        }
        if (!(output = runner.run(new GeneralCommandLine(new String[]{"which", name}))).checkSuccess(RemoteHostUtil.LOG)) {
            RemoteHostUtil.LOG.warn("Cannot resolve '" + name + "' to executable.");
            return null;
        }
        return StringUtil.nullize((String)output.getStdout().trim());
    }

    public static boolean isTarInstalled(@NotNull CommandRunner commandRunner) {
        if (commandRunner == null) {
            RemoteUtil.$$$reportNull$$$0(43);
        }
        return RemoteUtil.isToolAvailable(commandRunner, "tar");
    }

    public static boolean isRsyncInstalled(@NotNull CommandRunner commandRunner) {
        if (commandRunner == null) {
            RemoteUtil.$$$reportNull$$$0(44);
        }
        return RemoteUtil.isToolAvailable(commandRunner, "rsync");
    }

    public static boolean isTarInstalled(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(45);
        }
        return RemoteUtil.isToolAvailable(command -> RemoteUtil.runRemoteProcess(command, credentials, RemoteHostUtil.DEFAULT_COMMAND_TIMEOUT), "tar");
    }

    private static boolean isToolAvailable(@NotNull CommandRunner commandRunner, @NotNull @NonNls String tool) {
        if (commandRunner == null) {
            RemoteUtil.$$$reportNull$$$0(46);
        }
        if (tool == null) {
            RemoteUtil.$$$reportNull$$$0(47);
        }
        try {
            ProcessOutput output = commandRunner.run(new GeneralCommandLine(new String[]{tool, "--version"}));
            if (!output.checkSuccess(RemoteHostUtil.LOG)) {
                RemoteHostUtil.LOG.info("RemoteUtil: " + tool + " not found");
                return false;
            }
            if (RemoteHostUtil.LOG.isDebugEnabled()) {
                RemoteHostUtil.LOG.debug("RemoteUtil: " + tool + " version: " + (String)ContainerUtil.getFirstItem((List)output.getStdoutLines()));
            }
        }
        catch (ExecutionException e) {
            RemoteHostUtil.LOG.error("Error during execution of `" + tool + "` command", (Throwable)e);
            return false;
        }
        return true;
    }

    public static void setExecutable(@NotNull RemoteCredentials credentials, @NotNull String uploadPath, @NotNull ProgressIndicator indicator) throws ExecutionException {
        ProcessOutput output;
        GeneralCommandLine cmd;
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(48);
        }
        if (uploadPath == null) {
            RemoteUtil.$$$reportNull$$$0(49);
        }
        if (indicator == null) {
            RemoteUtil.$$$reportNull$$$0(50);
        }
        if (!CidrToolsUtil.checkSuccess((GeneralCommandLine)(cmd = new GeneralCommandLine(new String[]{"chmod", "u+x", uploadPath})), (ProcessOutput)(output = RemoteUtil.runRemoteProcess(cmd, credentials, indicator, RemoteHostUtil.DEFAULT_COMMAND_TIMEOUT)), (Logger)RemoteHostUtil.LOG)) {
            throw new ExecutionException(output.getExitCode() + ": " + output.getStderr());
        }
    }

    @NotNull
    public static CidrToolsUtil.Status verifyConnectionAndRemoteEnvironment(@Nullable RemoteCredentials credentials) {
        CidrToolsUtil.Status status = RemoteUtil.verifyConnection(credentials);
        if (status.code == CidrToolsUtil.StatusCode.ERROR) {
            CidrToolsUtil.Status status2 = status;
            if (status2 == null) {
                RemoteUtil.$$$reportNull$$$0(51);
            }
            return status2;
        }
        assert (status.code == CidrToolsUtil.StatusCode.OK && credentials != null);
        return RemoteUtil.verifyRemoteEnvironment(status, command -> RemoteUtil.runRemoteProcess(command, credentials, RemoteHostUtil.DEFAULT_COMMAND_TIMEOUT));
    }

    @NotNull
    static CidrToolsUtil.Status verifyRemoteEnvironment(@NotNull CidrToolsUtil.Status connectionStatus, @NotNull CommandRunner commandRunner) {
        if (connectionStatus == null) {
            RemoteUtil.$$$reportNull$$$0(52);
        }
        if (commandRunner == null) {
            RemoteUtil.$$$reportNull$$$0(53);
        }
        if (Registry.is((String)"clion.remote.use.rsync") && RSyncUtil.canUseRSync()) {
            if (!RemoteUtil.isRsyncInstalled(commandRunner)) {
                CidrToolsUtil.Status status = CidrToolsUtil.Status.error((String)ToolchainsBundle.message("remote.status.missing.rsync", new Object[0]));
                if (status == null) {
                    RemoteUtil.$$$reportNull$$$0(54);
                }
                return status;
            }
        } else if (Registry.is((String)"clion.remote.compress.tar") && !RemoteUtil.isTarInstalled(commandRunner)) {
            return new CidrToolsUtil.Status(CidrToolsUtil.StatusCode.WARNING, ToolchainsBundle.message("remote.status.missing.tar", new Object[0]));
        }
        CidrToolsUtil.Status status = connectionStatus;
        if (status == null) {
            RemoteUtil.$$$reportNull$$$0(55);
        }
        return status;
    }

    @NotNull
    public static CidrToolsUtil.Status verifyConnection(@Nullable RemoteCredentials credentials) {
        if (credentials == null) {
            CidrToolsUtil.Status status = CidrToolsUtil.Status.error((String)ToolchainsBundle.message("remote.status.empty.credentials", new Object[0]));
            if (status == null) {
                RemoteUtil.$$$reportNull$$$0(56);
            }
            return status;
        }
        boolean connected = RemoteUtil.checkConnection(credentials);
        CidrToolsUtil.Status status = connected ? new CidrToolsUtil.Status(CidrToolsUtil.StatusCode.OK, ToolchainsBundle.message("remote.status.connected", new Object[0])) : CidrToolsUtil.Status.error((String)ToolchainsBundle.message("remote.status.connection.problem", new Object[0]));
        if (status == null) {
            RemoteUtil.$$$reportNull$$$0(57);
        }
        return status;
    }

    @Nullable
    public static Path filterTextFiles(@NotNull RemoteCredentials credentials, @NotNull String workingDir, @NotNull Path outputFile) {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(58);
        }
        if (workingDir == null) {
            RemoteUtil.$$$reportNull$$$0(59);
        }
        if (outputFile == null) {
            RemoteUtil.$$$reportNull$$$0(60);
        }
        return RemoteUtil.filterTextFilesInternal(cl -> RemoteUtil.runRemoteProcess(cl, credentials, RemoteUtil.textFilesFilterTimeout()), workingDir, outputFile);
    }

    @Nullable
    public static Path filterTextFiles(@NotNull HostMachine host, @NotNull String workingDir, @NotNull Path outputFile) {
        if (host == null) {
            RemoteUtil.$$$reportNull$$$0(61);
        }
        if (workingDir == null) {
            RemoteUtil.$$$reportNull$$$0(62);
        }
        if (outputFile == null) {
            RemoteUtil.$$$reportNull$$$0(63);
        }
        return RemoteUtil.filterTextFilesInternal(cl -> host.runProcess(cl, RemoteUtil.textFilesFilterTimeout()), workingDir, outputFile);
    }

    public static boolean isTextFilesSyncEnabled() {
        return Registry.is((String)"clion.remote.sync.text.files", (boolean)true);
    }

    private static int textFilesFilterTimeout() {
        return Registry.intValue((String)"clion.remote.filter.text.files.timeout", (int)240000);
    }

    @Nullable
    private static Path filterTextFilesInternal(@NotNull CommandRunner runner, @NotNull String workingDir, @NotNull Path outputFile) {
        if (runner == null) {
            RemoteUtil.$$$reportNull$$$0(64);
        }
        if (workingDir == null) {
            RemoteUtil.$$$reportNull$$$0(65);
        }
        if (outputFile == null) {
            RemoteUtil.$$$reportNull$$$0(66);
        }
        try {
            RemoteUtil.filterTextFiles(runner, workingDir, outputFile);
            return outputFile;
        }
        catch (IOException e) {
            RemoteHostUtil.LOG.warn((Throwable)e);
            return null;
        }
    }

    public static void filterTextFiles(@NotNull CommandRunner runner, @NotNull String workingDir, @NotNull Path outputFile) throws IOException {
        if (runner == null) {
            RemoteUtil.$$$reportNull$$$0(67);
        }
        if (workingDir == null) {
            RemoteUtil.$$$reportNull$$$0(68);
        }
        if (outputFile == null) {
            RemoteUtil.$$$reportNull$$$0(69);
        }
        try {
            boolean isRemotePath = UnixSshFileSysProvider.isRemotePath(outputFile);
            GeneralCommandLine find = new GeneralCommandLine(new String[]{"sh", "-c"});
            find.addParameter("find . -type l -print -o -type f -exec grep -Il . {} +");
            if (isRemotePath) {
                find.addParameters(new String[]{">", outputFile.toString()});
            }
            find.setWorkDirectory(workingDir);
            Ssh.doNotEscapeArgs((GeneralCommandLine)find);
            ProcessOutput output = runner.run(find);
            if (!CidrToolsUtil.checkSuccess((GeneralCommandLine)find, (ProcessOutput)output, (Logger)RemoteHostUtil.LOG)) {
                throw new IOException("cannot get list of non-binary files: " + CidrToolsUtil.extractError((ProcessOutput)output));
            }
            if (!isRemotePath) {
                PathKt.write((Path)outputFile, (CharSequence)output.getStdout());
            }
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Nullable
    public static RemoteCredentials toCredentials(@Nullable SshConfig sshConfig) {
        return sshConfig != null ? sshConfig.copyToCredentials() : null;
    }

    @Nullable
    public static RemoteCredentials getCredentials(@NotNull HostMachine host) {
        if (host == null) {
            RemoteUtil.$$$reportNull$$$0(70);
        }
        return host instanceof RemoteHost ? ((RemoteHost)host).getCredentials() : null;
    }

    static void assertUnixOnly(@NotNull OSType osType) throws ExecutionException {
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(71);
        }
        if (osType == OSType.WIN) {
            throw new ExecutionException((Throwable)new UnsupportedOperationException(osType.name()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 13: 
            case 22: 
            case 24: 
            case 27: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 13: 
            case 22: 
            case 24: 
            case 27: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 2: 
            case 13: 
            case 22: 
            case 24: 
            case 27: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/RemoteUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 23: 
            case 36: 
            case 61: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 18: 
            case 29: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: 
            case 40: 
            case 64: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 21: 
            case 26: 
            case 30: 
            case 33: 
            case 41: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osType";
                break;
            }
            case 37: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 43: 
            case 44: 
            case 46: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandRunner";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uploadPath";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionStatus";
                break;
            }
            case 59: 
            case 62: 
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 60: 
            case 63: 
            case 66: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/RemoteUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConnectionBuilder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "runRemoteProcess";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempFileName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamedPipe";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "mktemp";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyConnectionAndRemoteEnvironment";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyRemoteEnvironment";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyConnection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConnectionBuilder";
                break;
            }
            case 2: 
            case 13: 
            case 22: 
            case 24: 
            case 27: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteProcess";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runRemoteProcess";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkConnection";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "openPipe";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "rmSilently";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generateTempFileName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTempFileName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createNamedPipe";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "mktemp";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "fileExists";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "touch";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "resolveToExecutable";
                break;
            }
            case 43: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isTarInstalled";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isRsyncInstalled";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isToolAvailable";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "setExecutable";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "verifyRemoteEnvironment";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "filterTextFiles";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "filterTextFilesInternal";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getCredentials";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "assertUnixOnly";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 13: 
            case 22: 
            case 24: 
            case 27: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface CommandRunner {
        @NotNull
        public ProcessOutput run(@NotNull GeneralCommandLine var1) throws ExecutionException;
    }

    private static class RemoteUnixPipe
    implements NamedPipe {
        @NotNull
        final HostMachine myHost;
        @NotNull
        final String pipeName;
        @Nullable
        Process myInputProcess;
        @Nullable
        Process myOutputProcess;

        RemoteUnixPipe(@NotNull HostMachine host) throws ExecutionException {
            if (host == null) {
                RemoteUnixPipe.$$$reportNull$$$0(0);
            }
            this.myHost = host;
            this.pipeName = RemoteUtil.createNamedPipe(host);
        }

        @NotNull
        public String getName() {
            String string = this.pipeName;
            if (string == null) {
                RemoteUnixPipe.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public OutputStream getOutputStream() throws IOException {
            this.myInputProcess = this.runProcess(new GeneralCommandLine(new String[]{"tee", this.pipeName}));
            return new BufferedOutputStream(this.myInputProcess.getOutputStream()){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        this.close();
                    }
                }
            };
        }

        @NotNull
        public InputStream getInputStream() throws IOException {
            this.myOutputProcess = this.runProcess(new GeneralCommandLine(new String[]{"cat", this.pipeName}));
            return new BufferedInputStream(this.myOutputProcess.getInputStream()){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        this.close();
                    }
                }
            };
        }

        public void close() {
            if (this.myInputProcess != null) {
                this.myInputProcess.destroy();
            }
            if (this.myOutputProcess != null) {
                this.myOutputProcess.destroy();
            }
            RemoteUtil.rmSilently(this.myHost, this.pipeName);
        }

        private Process runProcess(@NotNull GeneralCommandLine cmd) throws IOException {
            if (cmd == null) {
                RemoteUnixPipe.$$$reportNull$$$0(2);
            }
            try {
                BaseProcessHandler handler = this.myHost.createProcessBuilder().withPty(true).build(cmd);
                return handler.getProcess();
            }
            catch (ExecutionException | SshTransportException e) {
                throw new IOException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/RemoteUtil$RemoteUnixPipe";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cmd";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/RemoteUtil$RemoteUnixPipe";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "runProcess";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ParameterizedRemoteProcessHandler<T extends RemoteProcess>
    extends BaseRemoteProcessHandler<T> {
        @NotNull
        private final CidrProcessBuilder.Parameters myParameters;

        private ParameterizedRemoteProcessHandler(@NotNull T process, @NotNull String commandLine, @Nullable Charset charset, @NotNull CidrProcessBuilder.Parameters parameters) {
            if (process == null) {
                ParameterizedRemoteProcessHandler.$$$reportNull$$$0(0);
            }
            if (commandLine == null) {
                ParameterizedRemoteProcessHandler.$$$reportNull$$$0(1);
            }
            if (parameters == null) {
                ParameterizedRemoteProcessHandler.$$$reportNull$$$0(2);
            }
            super(process, commandLine, charset);
            this.myParameters = parameters;
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = HostUtilKt.readerOptions((CidrProcessBuilder.Parameters)this.myParameters, (BaseOutputReader.Options)super.readerOptions());
            if (options == null) {
                ParameterizedRemoteProcessHandler.$$$reportNull$$$0(3);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/RemoteUtil$ParameterizedRemoteProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/RemoteUtil$ParameterizedRemoteProcessHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ParameterizedCapturingSshProcessHandler
    extends CapturingSshProcessHandler {
        @NotNull
        private final CidrProcessBuilder.Parameters myParameters;

        private ParameterizedCapturingSshProcessHandler(@NotNull SshProcess<?> process, @Nullable Charset charset, @NotNull String commandLine, @NotNull CidrProcessBuilder.Parameters parameters) {
            if (process == null) {
                ParameterizedCapturingSshProcessHandler.$$$reportNull$$$0(0);
            }
            if (commandLine == null) {
                ParameterizedCapturingSshProcessHandler.$$$reportNull$$$0(1);
            }
            if (parameters == null) {
                ParameterizedCapturingSshProcessHandler.$$$reportNull$$$0(2);
            }
            super(process, charset, commandLine);
            this.myParameters = parameters;
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = HostUtilKt.readerOptions((CidrProcessBuilder.Parameters)this.myParameters, (BaseOutputReader.Options)super.readerOptions());
            if (options == null) {
                ParameterizedCapturingSshProcessHandler.$$$reportNull$$$0(3);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/RemoteUtil$ParameterizedCapturingSshProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/RemoteUtil$ParameterizedCapturingSshProcessHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ParameterizedColoredRemoteProcessHandler
    extends ColoredRemoteProcessHandler<RemoteProcess> {
        @NotNull
        private final CidrProcessBuilder.Parameters myParameters;

        private ParameterizedColoredRemoteProcessHandler(@NotNull RemoteProcess process, String commandLine, @Nullable Charset charset, @NotNull CidrProcessBuilder.Parameters parameters) {
            if (process == null) {
                ParameterizedColoredRemoteProcessHandler.$$$reportNull$$$0(0);
            }
            if (parameters == null) {
                ParameterizedColoredRemoteProcessHandler.$$$reportNull$$$0(1);
            }
            super(process, commandLine, charset);
            this.myParameters = parameters;
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = HostUtilKt.readerOptions((CidrProcessBuilder.Parameters)this.myParameters, (BaseOutputReader.Options)super.readerOptions());
            if (options == null) {
                ParameterizedColoredRemoteProcessHandler.$$$reportNull$$$0(2);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/RemoteUtil$ParameterizedColoredRemoteProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/RemoteUtil$ParameterizedColoredRemoteProcessHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

