/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.remote.RemoteProcess;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.nio.UnixSshFileSysProvider;
import com.intellij.util.PathMapper;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SystemUtil {
    private SystemUtil() {
    }

    public static String toLocalPath(@NotNull PathMapper pathMapper, @Nullable File localBaseDir, @NotNull String absoluteOrRelativeEnvPath) {
        if (pathMapper == null) {
            SystemUtil.$$$reportNull$$$0(0);
        }
        if (absoluteOrRelativeEnvPath == null) {
            SystemUtil.$$$reportNull$$$0(1);
        }
        Object path = absoluteOrRelativeEnvPath;
        if (localBaseDir != null && !FileUtil.isUnixAbsolutePath((String)absoluteOrRelativeEnvPath)) {
            path = localBaseDir.getPath() + "/" + absoluteOrRelativeEnvPath;
        }
        String result = pathMapper.convertToLocal((String)path);
        if (RemoteHostUtil.LOG.isTraceEnabled()) {
            RemoteHostUtil.LOG.trace("convertToLocal: " + (String)path + " -> " + result);
        }
        return result;
    }

    @NotNull
    public static String toEnvPath(@NotNull PathMapper pathMapper, @NotNull String localPath) {
        if (pathMapper == null) {
            SystemUtil.$$$reportNull$$$0(2);
        }
        if (localPath == null) {
            SystemUtil.$$$reportNull$$$0(3);
        }
        String result = pathMapper.convertToRemote(localPath);
        if (RemoteHostUtil.LOG.isTraceEnabled()) {
            RemoteHostUtil.LOG.trace("convertToRemote: " + localPath + " -> " + result);
        }
        String string = result;
        if (string == null) {
            SystemUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static List<String> removeRedundant(@NotNull List<String> pathList) {
        if (pathList == null) {
            SystemUtil.$$$reportNull$$$0(5);
        }
        if (pathList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> paths = new ArrayList<String>(pathList);
        ArrayList<String> result = new ArrayList<String>(paths.size());
        Collections.sort(paths);
        String cur = (String)paths.get(0);
        result.add(cur);
        for (String path : paths) {
            if (path.startsWith(cur)) continue;
            cur = path;
            result.add(cur);
        }
        return result;
    }

    public static void killProcessTree(@NotNull BaseProcessHandler<?> processHandler) {
        Process process;
        if (processHandler == null) {
            SystemUtil.$$$reportNull$$$0(6);
        }
        if ((process = processHandler.getProcess()) instanceof RemoteProcess) {
            ((RemoteProcess)process).killProcessTree();
        } else {
            OSProcessUtil.killProcessTree((Process)process);
        }
    }

    public static boolean isAbsolute(@NotNull HostMachine host, @NotNull String path) {
        if (host == null) {
            SystemUtil.$$$reportNull$$$0(7);
        }
        if (path == null) {
            SystemUtil.$$$reportNull$$$0(8);
        }
        return host.getOSType() != OSType.WIN ? FileUtil.isUnixAbsolutePath((String)path) : OSAgnosticPathUtil.isAbsoluteDosPath((String)path) || OSAgnosticPathUtil.isUncPath((String)path);
    }

    public static boolean isExecutable(@NotNull HostMachine host, @NotNull String path) throws ExecutionException {
        GeneralCommandLine command;
        ProcessOutput output;
        if (host == null) {
            SystemUtil.$$$reportNull$$$0(9);
        }
        if (path == null) {
            SystemUtil.$$$reportNull$$$0(10);
        }
        return (output = host.runProcess(command = new GeneralCommandLine(new String[]{"test", "-e", path}), RemoteHostUtil.DEFAULT_COMMAND_TIMEOUT)).getExitCode() == 0;
    }

    public static int sendUnixSignal(@NotNull HostMachine host, int pid, @NotNull String signalName) {
        if (host == null) {
            SystemUtil.$$$reportNull$$$0(11);
        }
        if (signalName == null) {
            SystemUtil.$$$reportNull$$$0(12);
        }
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"kill", "-s", signalName, Integer.toString(pid)});
        try {
            return host.runProcess(cmd, RemoteHostUtil.DEFAULT_COMMAND_TIMEOUT).getExitCode();
        }
        catch (ExecutionException e) {
            RemoteHostUtil.LOG.warn("Cannot send signal to remote process (pid = " + pid + ", signal = " + signalName + ")", (Throwable)e);
            return -1;
        }
    }

    public static <T> T executeOrRunTask(final @NotNull Supplier<T> processBuilder) {
        if (processBuilder == null) {
            SystemUtil.$$$reportNull$$$0(13);
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return processBuilder.get();
        }
        return (T)ProgressManager.getInstance().run(new Task.WithResult<T, RuntimeException>(null, SshBundle.message((String)"remote.process.start", (Object[])new Object[0]), true){

            protected T compute(@NotNull ProgressIndicator indicator) throws RuntimeException {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return processBuilder.get();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/system/SystemUtil$1", "compute"));
            }
        });
    }

    public static String patchMessage(@NotNull String message, @NotNull Path path, @Nullable String originalMessage) {
        if (message == null) {
            SystemUtil.$$$reportNull$$$0(14);
        }
        if (path == null) {
            SystemUtil.$$$reportNull$$$0(15);
        }
        if (UnixSshFileSysProvider.isRemotePath(path) && originalMessage != null) {
            return message + ": " + originalMessage;
        }
        return message;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteOrRelativeEnvPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/SystemUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 8: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signalName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processBuilder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/SystemUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toEnvPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toLocalPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toEnvPath";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeRedundant";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolute";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isExecutable";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sendUnixSignal";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeOrRunTask";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "patchMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

