/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.Expr;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;

public class ExprRelCompare
extends Expr {
    public static final int LESS = 0;
    public static final int LESSEQU = 1;
    public static final int GREATER = 2;
    public static final int GREATEREQU = 3;
    public static final int EQU = 4;
    public static final int UNEQU = 5;
    private int opCode;
    private String left;
    private String right;
    private boolean rightBool;

    public ExprRelCompare(int opCode, String left, String right, Context context) {
        super(context);
        this.opCode = opCode;
        this.left = left;
        this.right = right;
    }

    public ExprRelCompare(int opCode, String left, boolean rightBool, Context context) {
        super(context);
        this.opCode = opCode;
        this.left = left;
        this.rightBool = rightBool;
    }

    @Override
    public int interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable) {
        IRelation leftRel = variablesManager.getRelation(this.left);
        IRelation rightRel = this.right != null ? variablesManager.getRelation(this.right).fastRename(leftRel.getDomains(), threadCallback) : relationsManager.makeEmptyRelation(leftRel.getDomains(), this.rightBool);
        boolean equ = leftRel.equals(rightRel);
        switch (this.opCode) {
            case 0: {
                return !equ && rightRel.contains(leftRel, threadCallback) ? 1 : 0;
            }
            case 1: {
                return rightRel.contains(leftRel, threadCallback) ? 1 : 0;
            }
            case 2: {
                return !equ && leftRel.contains(rightRel, threadCallback) ? 1 : 0;
            }
            case 3: {
                return leftRel.contains(rightRel, threadCallback) ? 1 : 0;
            }
            case 4: {
                return equ ? 1 : 0;
            }
            case 5: {
                return !equ ? 1 : 0;
            }
        }
        throw new RuntimeException(Messages.getString(ExprRelCompare.class.getName() + "-0"));
    }
}

