/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.scripts.rml.parser.VariablesManager;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import java.util.List;
import java.util.Map;

public class RelExprReflexive
extends RelExpr {
    private String leftDomain;
    private String rightDomain;
    private boolean equ;

    public RelExprReflexive(String leftDomain, String rightDomain, boolean equ, Context context, Nonterm nonterm) {
        super(context, nonterm);
        this.leftDomain = leftDomain;
        this.rightDomain = rightDomain;
        this.equ = equ;
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        long startMillis = System.currentTimeMillis();
        Domain left = variablesManager.getDomain(this.leftDomain);
        Domain right = variablesManager.getDomain(this.rightDomain);
        IRelation result = relationsManager.makeEqual(left, right, threadCallback);
        if (!this.equ) {
            IRelation oldResult = result;
            result = result.complement(threadCallback);
            oldResult.kill();
        }
        if (profileManager != null) {
            long duration = System.currentTimeMillis() - startMillis;
            profileManager.addDuration(this, duration, result.getNumOfBDDNodes());
        }
        return result;
    }

    @Override
    public void collectDomainConstraints(Map<String, List> constraints, VariablesManager variablesManager) {
    }
}

