/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.scripts.rml.parser.VariablesManager;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import java.util.List;
import java.util.Map;

public class RelExprUnary
extends RelExpr {
    public static final int NOT = 0;
    public static final int TC = 1;
    private RelExpr operand;
    private int opCode;

    public RelExprUnary(RelExpr operand, int opCode, Context context, Nonterm nonterm) {
        super(context, nonterm);
        this.operand = operand;
        this.opCode = opCode;
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        long startMillis = System.currentTimeMillis();
        IRelation opResult = this.operand.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        IRelation result = this.opCode == 0 ? opResult.complement(threadCallback) : opResult.transitiveClosure(threadCallback);
        opResult.kill();
        if (profileManager != null) {
            long duration = System.currentTimeMillis() - startMillis;
            profileManager.addDuration(this, duration, result.getNumOfBDDNodes());
        }
        return result;
    }

    @Override
    public void collectDomainConstraints(Map<String, List> constraints, VariablesManager variablesManager) {
        this.operand.collectDomainConstraints(constraints, variablesManager);
    }
}

