/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.makefile.MakefileFile;
import com.jetbrains.lang.makefile.psi.MakefileDefine;
import com.jetbrains.lang.makefile.psi.MakefileElementFactory;
import com.jetbrains.lang.makefile.psi.MakefileNormalPrerequisites;
import com.jetbrains.lang.makefile.psi.MakefilePrerequisite;
import com.jetbrains.lang.makefile.psi.MakefilePrerequisites;
import com.jetbrains.lang.makefile.psi.MakefilePsiImplUtil;
import com.jetbrains.lang.makefile.psi.MakefileRecipe;
import com.jetbrains.lang.makefile.psi.MakefileRule;
import com.jetbrains.lang.makefile.psi.MakefileTarget;
import com.jetbrains.lang.makefile.psi.MakefileTargetLine;
import com.jetbrains.lang.makefile.psi.MakefileTargetPresentation;
import com.jetbrains.lang.makefile.psi.MakefileTargets;
import com.jetbrains.lang.makefile.psi.MakefileTypes;
import com.jetbrains.lang.makefile.psi.MakefileVariable;
import com.jetbrains.lang.makefile.psi.MakefileVariableAssignment;
import com.jetbrains.lang.makefile.psi.MakefileVariableValue;
import com.jetbrains.lang.makefile.psi.impl.MakefilePrerequisiteImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000eH\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0013H\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0013H\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u0011H\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\u0018H\u0007J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\u0006\u0010\f\u001a\u00020\u001bH\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\u000eH\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\u0011H\u0007J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\u0011H\u0007J\u0018\u0010%\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0010H\u0007J\u0018\u0010&\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u0010H\u0007J\u0018\u0010&\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0010H\u0007J\u0018\u0010(\u001a\u00020)2\u0006\u0010\"\u001a\u00020#2\u0006\u0010*\u001a\u00020\u0010H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/lang/makefile/psi/MakefilePsiImplUtil;", "", "()V", "ASSIGNMENT", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "LINE", "suffixRule", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getAssignment", "Lcom/intellij/psi/PsiElement;", "element", "Lcom/jetbrains/lang/makefile/psi/MakefileDefine;", "Lcom/jetbrains/lang/makefile/psi/MakefileVariableAssignment;", "getDocComment", "", "Lcom/jetbrains/lang/makefile/psi/MakefileTarget;", "getName", "Lcom/jetbrains/lang/makefile/psi/MakefileVariable;", "getNameIdentifier", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getTargetName", "Lcom/jetbrains/lang/makefile/psi/MakefileTargetLine;", "getTargets", "", "Lcom/jetbrains/lang/makefile/psi/MakefileRule;", "getValue", "isEmpty", "", "Lcom/jetbrains/lang/makefile/psi/MakefileRecipe;", "isPatternTarget", "isPhonyTarget", "prerequisite", "Lcom/jetbrains/lang/makefile/psi/MakefilePrerequisite;", "isSpecialTarget", "matches", "setName", "newName", "updateText", "Lcom/jetbrains/lang/makefile/psi/impl/MakefilePrerequisiteImpl;", "newText", "intellij.makefile"})
public final class MakefilePsiImplUtil {
    private static final Pattern suffixRule;
    private static final TokenSet ASSIGNMENT;
    private static final TokenSet LINE;
    @NotNull
    public static final MakefilePsiImplUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final List<MakefileTarget> getTargets(@NotNull MakefileRule element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        MakefileTargetLine makefileTargetLine = element.getTargetLine();
        Intrinsics.checkNotNullExpressionValue((Object)makefileTargetLine, (String)"element.targetLine");
        MakefileTargets makefileTargets = makefileTargetLine.getTargets();
        Intrinsics.checkNotNullExpressionValue((Object)makefileTargets, (String)"element.targetLine.targets");
        List<MakefileTarget> list = makefileTargets.getTargetList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"element.targetLine.targets.targetList");
        return list;
    }

    @JvmStatic
    @Nullable
    public static final String getTargetName(@NotNull MakefileTargetLine element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ASTNode aSTNode = element.getNode().findChildByType(MakefileTypes.TARGET);
        if (aSTNode == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.node.findChildBy\u2026pe(TARGET) ?: return null");
        ASTNode targetNode = aSTNode;
        return targetNode.getText();
    }

    @JvmStatic
    @NotNull
    public static final String getName(@NotNull MakefileTarget element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final PsiElement setName(@NotNull MakefileTarget element, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        ASTNode aSTNode = element.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.node");
        ASTNode identifierNode = aSTNode.getFirstChildNode();
        if (identifierNode != null) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
            MakefileTarget target = MakefileElementFactory.INSTANCE.createTarget(project, newName);
            PsiElement psiElement = target.getFirstChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"target.firstChild");
            ASTNode newIdentifierNode = psiElement.getNode();
            element.getNode().replaceChild(identifierNode, newIdentifierNode);
        }
        return (PsiElement)element;
    }

    @JvmStatic
    @NotNull
    public static final String getName(@NotNull MakefileVariable element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final PsiElement setName(@NotNull MakefileVariable element, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        ASTNode aSTNode = element.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.node");
        ASTNode identifierNode = aSTNode.getFirstChildNode();
        if (identifierNode != null) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
            MakefileVariable variable = MakefileElementFactory.INSTANCE.createVariable(project, newName);
            PsiElement psiElement = variable.getFirstChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"variable.firstChild");
            ASTNode newIdentifierNode = psiElement.getNode();
            element.getNode().replaceChild(identifierNode, newIdentifierNode);
        }
        return (PsiElement)element;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getNameIdentifier(@NotNull MakefileTarget element) {
        ASTNode targetNode;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.isSpecialTarget()) {
            return null;
        }
        ASTNode aSTNode = targetNode = element.getNode();
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getNameIdentifier(@NotNull MakefileVariable element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element.getFirstChild();
    }

    @JvmStatic
    @Nullable
    public static final String getDocComment(@NotNull MakefileTarget element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.isSpecialTarget()) {
            return null;
        }
        PsiElement psiElement = element.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.parent");
        PsiElement psiElement2 = psiElement.getParent();
        if (psiElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.lang.makefile.psi.MakefileTargetLine");
        }
        MakefileTargetLine targetLine = (MakefileTargetLine)psiElement2;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)targetLine, PsiComment.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"PsiTreeUtil.findChildren\u2026, PsiComment::class.java)");
        Collection comments = collection;
        Iterator iterator = comments.iterator();
        while (iterator.hasNext()) {
            PsiComment comment;
            PsiComment psiComment = comment = (PsiComment)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)psiComment, (String)"comment");
            if (psiComment.getTokenType() != MakefileTypes.DOC_COMMENT) continue;
            String string = comment.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"comment.text");
            String string2 = string;
            int n = 2;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            return string4;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final ItemPresentation getPresentation(@NotNull MakefileTarget element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return new MakefileTargetPresentation(element);
    }

    @JvmStatic
    public static final boolean isSpecialTarget(@NotNull MakefileTarget element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.name");
        String name = string;
        CharSequence charSequence = name;
        String string2 = "^\\.[A-Z_]*";
        boolean bl = false;
        string2 = new Regex(string2);
        bl = false;
        return string2.matches(charSequence) || Intrinsics.areEqual((Object)name, (Object)"FORCE") || suffixRule.matcher(name).matches();
    }

    @JvmStatic
    public static final boolean isPatternTarget(@NotNull MakefileTarget element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.name");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"%", (boolean)false, (int)2, null);
    }

    @JvmStatic
    public static final boolean matches(@NotNull MakefileTarget element, @NotNull String prerequisite) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)prerequisite, (String)"prerequisite");
        String string = element.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.name");
        String name = string;
        if (StringsKt.startsWith$default((String)name, (String)"%", (boolean)false, (int)2, null)) {
            String string2 = name;
            int n = 1;
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            return StringsKt.endsWith$default((String)prerequisite, (String)string4, (boolean)false, (int)2, null);
        }
        if (StringsKt.endsWith$default((String)name, (String)"%", (boolean)false, (int)2, null)) {
            String string5 = name;
            int n = 0;
            int n2 = name.length() - 1;
            boolean bl3 = false;
            String string6 = string5;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return StringsKt.startsWith$default((String)prerequisite, (String)string7, (boolean)false, (int)2, null);
        }
        Matcher matcher = suffixRule.matcher(name);
        if (matcher.matches()) {
            String string8 = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"matcher.group(1)");
            bl = StringsKt.endsWith$default((String)prerequisite, (String)string8, (boolean)false, (int)2, null);
        } else {
            bl = Intrinsics.areEqual((Object)name, (Object)prerequisite);
        }
        return bl;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getAssignment(@NotNull MakefileVariableAssignment element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ASTNode aSTNode = element.getNode().findChildByType(ASSIGNMENT);
        if (aSTNode == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.node.findChildBy\u2026SSIGNMENT) ?: return null");
        ASTNode node = aSTNode;
        return node.getPsi();
    }

    @JvmStatic
    @Nullable
    public static final String getValue(@NotNull MakefileVariableAssignment element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        MakefileVariableValue makefileVariableValue = element.getVariableValue();
        if (makefileVariableValue == null) {
            return "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)makefileVariableValue, (String)"element.variableValue ?: return \"\"");
        MakefileVariableValue value = makefileVariableValue;
        Object[] nodes = value.getNode().getChildren(TokenSet.ANY);
        Intrinsics.checkNotNullExpressionValue((Object)nodes, (String)"nodes");
        return ArraysKt.joinToString$default((Object[])nodes, (CharSequence)"\n", null, null, (int)0, null, (Function1)getValue.1.INSTANCE, (int)30, null);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getAssignment(@NotNull MakefileDefine element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ASTNode aSTNode = element.getNode().findChildByType(ASSIGNMENT);
        if (aSTNode == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.node.findChildBy\u2026SSIGNMENT) ?: return null");
        ASTNode node = aSTNode;
        return node.getPsi();
    }

    @JvmStatic
    @Nullable
    public static final String getValue(@NotNull MakefileDefine element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object[] objectArray = element.getNode().getChildren(TokenSet.ANY);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"element.node.getChildren(TokenSet.ANY)");
        Sequence nodes = ArraysKt.asSequence((Object[])objectArray);
        return SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)SequencesKt.dropWhile((Sequence)nodes, (Function1)getValue.2.INSTANCE), (Function1)getValue.3.INSTANCE), (CharSequence)"\n", null, null, (int)0, null, (Function1)getValue.4.INSTANCE, (int)30, null);
    }

    @JvmStatic
    public static final boolean isEmpty(@NotNull MakefileRecipe element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element.getCommandList().isEmpty() && element.getConditionalList().isEmpty();
    }

    @JvmStatic
    @NotNull
    public static final MakefilePrerequisiteImpl updateText(@NotNull MakefilePrerequisite prerequisite, @NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)prerequisite, (String)"prerequisite");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        Project project = prerequisite.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"prerequisite.project");
        MakefilePrerequisite replacement = MakefileElementFactory.INSTANCE.createPrerequisite(project, newText);
        PsiElement psiElement = prerequisite.replace(replacement);
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.lang.makefile.psi.impl.MakefilePrerequisiteImpl");
        }
        return (MakefilePrerequisiteImpl)psiElement;
    }

    @JvmStatic
    public static final boolean isPhonyTarget(@NotNull MakefilePrerequisite prerequisite) {
        Intrinsics.checkNotNullParameter((Object)prerequisite, (String)"prerequisite");
        PsiFile file = prerequisite.getContainingFile();
        if (file instanceof MakefileFile) {
            for (MakefileRule rule : ((MakefileFile)file).getPhonyRules()) {
                MakefileNormalPrerequisites normalPrerequisites;
                MakefileTargetLine makefileTargetLine = rule.getTargetLine();
                Intrinsics.checkNotNullExpressionValue((Object)makefileTargetLine, (String)"rule.targetLine");
                MakefilePrerequisites prerequisites = makefileTargetLine.getPrerequisites();
                if (prerequisites == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)prerequisites.getNormalPrerequisites(), (String)"prerequisites.normalPrerequisites");
                Iterator<MakefilePrerequisite> iterator = normalPrerequisites.getPrerequisiteList().iterator();
                while (iterator.hasNext()) {
                    MakefilePrerequisite goal;
                    MakefilePrerequisite makefilePrerequisite = goal = iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)makefilePrerequisite, (String)"goal");
                    if (!Intrinsics.areEqual((Object)makefilePrerequisite.getText(), (Object)prerequisite.getText())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private MakefilePsiImplUtil() {
    }

    static {
        MakefilePsiImplUtil makefilePsiImplUtil;
        INSTANCE = makefilePsiImplUtil = new MakefilePsiImplUtil();
        suffixRule = Pattern.compile("^\\.[a-zA-Z]+(\\.[a-zA-Z]+)$");
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{MakefileTypes.ASSIGN});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TokenSet.create(ASSIGN)");
        ASSIGNMENT = tokenSet;
        TokenSet tokenSet2 = TokenSet.create((IElementType[])new IElementType[]{MakefileTypes.IDENTIFIER, MakefileTypes.VARIABLE_USAGE});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"TokenSet.create(IDENTIFIER, VARIABLE_USAGE)");
        LINE = tokenSet2;
    }
}

