/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions.context;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.actions.BaseTaskAction;
import com.intellij.tasks.actions.SwitchTaskAction;
import com.intellij.tasks.actions.context.UndoableCommand;
import com.intellij.tasks.context.ContextInfo;
import com.intellij.tasks.context.LoadContextUndoableAction;
import com.intellij.tasks.context.WorkingContextManager;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import icons.TasksCoreIcons;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadContextAction
extends BaseTaskAction {
    private static final int MAX_ROW_COUNT = 10;

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            LoadContextAction.$$$reportNull$$$0(0);
        }
        Project project = LoadContextAction.getProject(e);
        assert (project != null);
        DefaultActionGroup group = new DefaultActionGroup();
        final WorkingContextManager manager = WorkingContextManager.getInstance((Project)project);
        List history = manager.getContextHistory();
        ArrayList infos = new ArrayList(ContainerUtil.map2List((Collection)history, info -> new ContextHolder((ContextInfo)info, project){
            final /* synthetic */ ContextInfo val$info;
            final /* synthetic */ Project val$project;
            {
                this.val$info = contextInfo;
                this.val$project = project;
            }

            @Override
            void load(boolean clear) {
                LoadContextUndoableAction undoableAction = LoadContextUndoableAction.createAction((WorkingContextManager)manager, (boolean)clear, (String)this.val$info.name);
                UndoableCommand.execute(this.val$project, (UndoableAction)undoableAction, TaskBundle.message((String)"command.name.load.context", (Object[])new Object[]{this.val$info.comment}), "Context");
            }

            @Override
            void remove() {
                manager.removeContext(this.val$info.name);
            }

            @Override
            Date getDate() {
                return new Date(this.val$info.date);
            }

            @Override
            String getComment() {
                return this.val$info.comment;
            }

            @Override
            Icon getIcon() {
                return TasksCoreIcons.SavedContext;
            }
        }));
        TaskManager taskManager = TaskManager.getManager((Project)project);
        List tasks = taskManager.getLocalTasks();
        infos.addAll(ContainerUtil.mapNotNull((Collection)tasks, (Function)((NullableFunction)task -> {
            if (task.isActive()) {
                return null;
            }
            return new ContextHolder((LocalTask)task, project, taskManager){
                final /* synthetic */ LocalTask val$task;
                final /* synthetic */ Project val$project;
                final /* synthetic */ TaskManager val$taskManager;
                {
                    this.val$task = localTask;
                    this.val$project = project;
                    this.val$taskManager = taskManager;
                }

                @Override
                void load(boolean clear) {
                    LoadContextUndoableAction undoableAction = LoadContextUndoableAction.createAction((WorkingContextManager)manager, (boolean)clear, (Task)this.val$task);
                    UndoableCommand.execute(this.val$project, (UndoableAction)undoableAction, TaskBundle.message((String)"command.name.load.context", (Object[])new Object[]{TaskUtil.getTrimmedSummary((Task)this.val$task)}), "Context");
                }

                @Override
                void remove() {
                    SwitchTaskAction.removeTask(this.val$project, this.val$task, this.val$taskManager);
                }

                @Override
                Date getDate() {
                    return this.val$task.getUpdated();
                }

                @Override
                String getComment() {
                    return TaskUtil.getTrimmedSummary((Task)this.val$task);
                }

                @Override
                Icon getIcon() {
                    return this.val$task.getIcon();
                }
            };
        })));
        infos.sort((o1, o2) -> o2.getDate().compareTo(o1.getDate()));
        final Ref shiftPressed = Ref.create((Object)false);
        boolean today = true;
        Calendar now = Calendar.getInstance();
        for (ContextHolder info2 : infos) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(info2.getDate());
            if (today && (calendar.get(1) != now.get(1) || calendar.get(6) != now.get(6))) {
                group.addSeparator();
                today = false;
            }
            group.add((AnAction)LoadContextAction.createItem(info2, (Ref<Boolean>)shiftPressed));
        }
        final ListPopupImpl popup = (ListPopupImpl)JBPopupFactory.getInstance().createActionGroupPopup(TaskBundle.message((String)"popup.title.load.context", (Object[])new Object[0]), (ActionGroup)group, e.getDataContext(), false, null, 10);
        popup.setAdText(TaskBundle.message((String)"popup.advertisement.press.shift.to.merge.with.current.context", (Object[])new Object[0]));
        popup.registerAction("shiftPressed", KeyStroke.getKeyStroke("shift pressed SHIFT"), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shiftPressed.set((Object)true);
                popup.setCaption(TaskBundle.message((String)"popup.title.merge.with.current.context", (Object[])new Object[0]));
            }
        });
        popup.registerAction("shiftReleased", KeyStroke.getKeyStroke("released SHIFT"), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shiftPressed.set((Object)false);
                popup.setCaption(TaskBundle.message((String)"popup.title.load.context", (Object[])new Object[0]));
            }
        });
        popup.registerAction("invoke", KeyStroke.getKeyStroke("shift ENTER"), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.handleSelect(true);
            }
        });
        popup.showCenteredInCurrentWindow(project);
    }

    private static ActionGroup createItem(final ContextHolder holder, final Ref<Boolean> shiftPressed) {
        Object text = DateFormatUtil.formatPrettyDateTime((Date)holder.getDate());
        String comment = holder.getComment();
        if (!StringUtil.isEmpty((String)comment)) {
            text = comment + " (" + (String)text + ")";
        }
        final AnAction loadAction = new AnAction(TaskBundle.messagePointer((String)"action.LoadContextAction.Anonymous.text.load", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                holder.load((Boolean)shiftPressed.get() == false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tasks/actions/context/LoadContextAction$6", "actionPerformed"));
            }
        };
        ActionGroup contextGroup = new ActionGroup((String)text, (String)text, holder.getIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                loadAction.actionPerformed(e);
            }

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                AnAction[] anActionArray = new AnAction[]{loadAction, new AnAction(TaskBundle.messagePointer((String)"action.LoadContextAction.Anonymous.text.remove", (Object[])new Object[0])){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        holder.remove();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tasks/actions/context/LoadContextAction$7$1", "actionPerformed"));
                    }
                }};
                if (anActionArray == null) {
                    7.$$$reportNull$$$0(1);
                }
                return anActionArray;
            }

            public boolean canBePerformed(@NotNull DataContext context) {
                if (context == null) {
                    7.$$$reportNull$$$0(2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/tasks/actions/context/LoadContextAction$7";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/tasks/actions/context/LoadContextAction$7";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "canBePerformed";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        contextGroup.setPopup(true);
        return contextGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tasks/actions/context/LoadContextAction", "actionPerformed"));
    }

    static abstract class ContextHolder {
        ContextHolder() {
        }

        abstract void load(boolean var1);

        abstract void remove();

        abstract Date getDate();

        abstract String getComment();

        abstract Icon getIcon();
    }
}

