/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.jql.JqlLanguage;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class JiraRepositoryEditor
extends BaseRepositoryEditor<JiraRepository> {
    private EditorTextField mySearchQueryField;
    private JBLabel mySearchLabel;
    private JBLabel myNoteLabel;

    public JiraRepositoryEditor(Project project, JiraRepository repository, Consumer<? super JiraRepository> changeListener) {
        super(project, repository, changeListener);
    }

    @Override
    public void apply() {
        ((JiraRepository)this.myRepository).setSearchQuery(this.mySearchQueryField.getText());
        super.apply();
        this.adjustSettingsForServerProperties();
    }

    @Override
    protected void afterTestConnection(boolean connectionSuccessful) {
        super.afterTestConnection(connectionSuccessful);
        if (connectionSuccessful) {
            this.adjustSettingsForServerProperties();
        }
    }

    @Override
    @Nullable
    protected JComponent createCustomPanel() {
        this.mySearchQueryField = new LanguageTextField((Language)JqlLanguage.INSTANCE, this.myProject, ((JiraRepository)this.myRepository).getSearchQuery());
        this.installListener(this.mySearchQueryField);
        this.mySearchLabel = new JBLabel(TaskBundle.message((String)"label.search", (Object[])new Object[0]), 4);
        this.myNoteLabel = new JBLabel();
        this.myNoteLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        this.adjustSettingsForServerProperties();
        return FormBuilder.createFormBuilder().addLabeledComponent((JComponent)this.mySearchLabel, (JComponent)this.mySearchQueryField).addComponentToRightColumn((JComponent)this.myNoteLabel).getPanel();
    }

    @Override
    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.mySearchLabel.setAnchor(anchor);
    }

    private void adjustSettingsForServerProperties() {
        if (((JiraRepository)this.myRepository).isJqlSupported()) {
            this.mySearchQueryField.setEnabled(true);
            this.myNoteLabel.setVisible(false);
        } else {
            this.mySearchQueryField.setEnabled(false);
            this.myNoteLabel.setText(TaskBundle.message((String)"label.jql.search.cannot.be.used.in.jira.versions.prior.your.version", (Object[])new Object[]{((JiraRepository)this.myRepository).getPresentableVersion()}));
            this.myNoteLabel.setVisible(true);
        }
        if (((JiraRepository)this.myRepository).isInCloud()) {
            this.myUsernameLabel.setText(TaskBundle.message((String)"label.email", (Object[])new Object[0]));
            this.myPasswordLabel.setText(TaskBundle.message((String)"label.api.token", (Object[])new Object[0]));
        } else {
            this.myUsernameLabel.setText(TaskBundle.message((String)"label.username", (Object[])new Object[0]));
            this.myPasswordLabel.setText(TaskBundle.message((String)"label.password", (Object[])new Object[0]));
        }
    }
}

