/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DbCredentialManager;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseCredentials {
    private static final String DB_SSL_PHR = "db:ssl:phr@";
    private final DbCredentialManager myCredentialManager;

    public DatabaseCredentials(DbCredentialManager manager) {
        this.myCredentialManager = manager;
    }

    public static DatabaseCredentials getInstance() {
        return (DatabaseCredentials)ApplicationManager.getApplication().getService(DatabaseCredentials.class);
    }

    @Nullable
    private static LocalDataSource getLocalDataSource(@Nullable DasDataSource info) {
        if (!(info instanceof LocalDataSource)) {
            return null;
        }
        return (LocalDataSource)info;
    }

    @Nullable
    public Credentials getCredentials(@NotNull DasDataSource info) {
        LocalDataSource dataSource2;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(0);
        }
        if ((dataSource2 = DatabaseCredentials.getLocalDataSource(info)) == null) {
            return null;
        }
        return new Credentials(dataSource2.getUsername(), this.getPassword(info));
    }

    @Nullable
    public OneTimeString getPassword(@NotNull DasDataSource info) {
        LocalDataSource dataSource2;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(1);
        }
        if ((dataSource2 = DatabaseCredentials.getLocalDataSource(info)) == null) {
            return null;
        }
        return this.myCredentialManager.getPassword(dataSource2, dataSource2.getPasswordStorage(), null);
    }

    @Nullable
    public OneTimeString getSslPassphrase(@NotNull DasDataSource info) {
        LocalDataSource dataSource2;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(2);
        }
        if ((dataSource2 = DatabaseCredentials.getLocalDataSource(info)) == null) {
            return null;
        }
        DataSourceSslConfiguration cfg = dataSource2.getSslCfg();
        if (cfg == null || !cfg.myEnabled) {
            return null;
        }
        return this.myCredentialManager.getPassword(dataSource2, cfg.myPasswordStorage, DB_SSL_PHR);
    }

    @NotNull
    public CompletionStage<Credentials> getCredentialsAsync(@NotNull DasDataSource info) {
        LocalDataSource dataSource2;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(3);
        }
        if ((dataSource2 = DatabaseCredentials.getLocalDataSource(info)) == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                DatabaseCredentials.$$$reportNull$$$0(4);
            }
            return completableFuture;
        }
        CompletionStage<Credentials> completionStage = AsyncUtil.supplyAsync(() -> CompletableFuture.completedFuture(this.getCredentials(info)), AsyncUtil.getPoolExecutor());
        if (completionStage == null) {
            DatabaseCredentials.$$$reportNull$$$0(5);
        }
        return completionStage;
    }

    public void setPassword(@NotNull DasDataSource info, @Nullable OneTimeString password) {
        LocalDataSource dataSource2;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(6);
        }
        if ((dataSource2 = DatabaseCredentials.getLocalDataSource(info)) == null) {
            return;
        }
        this.myCredentialManager.setPassword(dataSource2, password, dataSource2.getPasswordStorage());
    }

    public void setSslPassphrase(@NotNull DasDataSource info, @Nullable OneTimeString password) {
        LocalDataSource dataSource2;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(7);
        }
        if ((dataSource2 = DatabaseCredentials.getLocalDataSource(info)) == null) {
            return;
        }
        DataSourceSslConfiguration cfg = dataSource2.getSslCfg();
        if (cfg == null || !cfg.myEnabled) {
            return;
        }
        this.myCredentialManager.setPassword(dataSource2, password, cfg.myPasswordStorage, DB_SSL_PHR);
    }

    public void copyAllCredentials(@NotNull DasDataSource from, @NotNull DasDataSource to, @NotNull DatabaseCredentials toStorage) {
        if (from == null) {
            DatabaseCredentials.$$$reportNull$$$0(8);
        }
        if (to == null) {
            DatabaseCredentials.$$$reportNull$$$0(9);
        }
        if (toStorage == null) {
            DatabaseCredentials.$$$reportNull$$$0(10);
        }
        toStorage.setPassword(to, this.getPassword(from));
        toStorage.setSslPassphrase(to, this.getSslPassphrase(from));
    }

    public void handleSessionFinished(@NotNull DasDataSource info) {
        DataSourceSslConfiguration ssl;
        LocalDataSource dataSource2;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(11);
        }
        if ((dataSource2 = DatabaseCredentials.getLocalDataSource(info)) == null) {
            return;
        }
        LocalDataSource.Storage storage = dataSource2.getPasswordStorage();
        if (storage == LocalDataSource.Storage.SESSION) {
            this.setPassword(info, null);
        }
        if ((ssl = dataSource2.getSslCfg()) != null && ssl.myPasswordStorage == LocalDataSource.Storage.SESSION) {
            this.setSslPassphrase(info, null);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public OneTimeString getSshPassword(@NotNull DasDataSource info) {
        LocalDataSource dataSource2;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(12);
        }
        return (dataSource2 = (LocalDataSource)ObjectUtils.tryCast((Object)info, LocalDataSource.class)) != null ? this.myCredentialManager.getPassword(dataSource2, LocalDataSource.Storage.PERSIST, "db:ssh:pwd@") : null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public OneTimeString getSshPassphrase(@NotNull DasDataSource info) {
        LocalDataSource dataSource2;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(13);
        }
        return (dataSource2 = (LocalDataSource)ObjectUtils.tryCast((Object)info, LocalDataSource.class)) != null ? this.myCredentialManager.getPassword(dataSource2, LocalDataSource.Storage.PERSIST, "db:ssh:phr@") : null;
    }

    public static <T> CompletionStage<T> getInitialCredentialsImpl2(boolean canAskPassword, Supplier<? extends CompletionStage<T>> get2, Function<Throwable, ? extends CompletionStage<T>> ask, Condition<? super T> isEmpty) {
        if (!canAskPassword) {
            return get2.get();
        }
        return get2.get().handle(Pair::create).thenCompose(p2 -> {
            if (p2.second != null) {
                if (AsyncUtil.isCancellation((Throwable)p2.second)) {
                    return AsyncUtil.cancelled();
                }
                return (CompletionStage)ask.apply((Throwable)p2.second);
            }
            if (isEmpty.value(p2.first)) {
                return (CompletionStage)ask.apply(null);
            }
            return CompletableFuture.completedFuture(p2.first);
        });
    }

    public static <T> AsyncTask<T> getInitialCredentialsImpl(@NotNull LocalDataSource.Storage storage, boolean canAskPassword, Supplier<AsyncTask<T>> get2, Function<Throwable, AsyncTask<T>> ask, Condition<? super T> isEmpty) {
        if (storage == null) {
            DatabaseCredentials.$$$reportNull$$$0(14);
        }
        if (storage.isOneTime() && canAskPassword) {
            return ask.apply(null);
        }
        if (!canAskPassword) {
            return get2.get();
        }
        return get2.get().handle().applyAsync(null, p2 -> {
            if (p2.second != null) {
                if (AsyncUtil.isCancellation((Throwable)p2.second)) {
                    return AsyncTask.cancelled();
                }
                return (AsyncTask)ask.apply((Throwable)p2.second);
            }
            if (storage.isMemory() && isEmpty.value(p2.first)) {
                return (AsyncTask)ask.apply(null);
            }
            return AsyncTask.completed(p2.first);
        });
    }

    public DbCredentialManager getCredentialManager() {
        return this.myCredentialManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/access/DatabaseCredentials";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toStorage";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/access/DatabaseCredentials";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentialsAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCredentials";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPassword";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSslPassphrase";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCredentialsAsync";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setPassword";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSslPassphrase";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyAllCredentials";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handleSessionFinished";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSshPassword";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSshPassphrase";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getInitialCredentialsImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

