/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DbCredentialManager;
import com.intellij.database.access.LocalCredentialManager;
import com.intellij.database.dataSource.LocalDataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/access/OneTimeCredentialManager;", "Lcom/intellij/database/access/LocalCredentialManager;", "backend", "Lcom/intellij/database/access/DbCredentialManager;", "(Lcom/intellij/database/access/DbCredentialManager;)V", "getBackend", "()Lcom/intellij/database/access/DbCredentialManager;", "getPassword", "Lcom/intellij/credentialStore/OneTimeString;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "storage", "Lcom/intellij/database/dataSource/LocalDataSource$Storage;", "prefix", "", "setPassword", "", "password", "intellij.database.connectivity"})
public final class OneTimeCredentialManager
extends LocalCredentialManager {
    @NotNull
    private final DbCredentialManager backend;

    @Override
    public void setPassword(@NotNull LocalDataSource dataSource2, @Nullable OneTimeString password, @NotNull LocalDataSource.Storage storage, @Nullable String prefix) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)((Object)storage), (String)"storage");
        if (storage.isOneTime()) {
            super.setPassword(dataSource2, password, LocalDataSource.Storage.MEMORY, prefix);
        }
        this.backend.setPassword(dataSource2, password, storage, prefix);
    }

    @Override
    @Nullable
    public OneTimeString getPassword(@NotNull LocalDataSource dataSource2, @NotNull LocalDataSource.Storage storage, @Nullable String prefix) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)((Object)storage), (String)"storage");
        OneTimeString oneTimeString = super.getPassword(dataSource2, LocalDataSource.Storage.MEMORY, prefix);
        if (oneTimeString == null) {
            oneTimeString = this.backend.getPassword(dataSource2, storage, prefix);
        }
        return oneTimeString;
    }

    @NotNull
    public final DbCredentialManager getBackend() {
        return this.backend;
    }

    public OneTimeCredentialManager(@NotNull DbCredentialManager backend) {
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        this.backend = backend;
    }
}

