/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.SelectionModelWithViewColumns;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.ResultViewWithColumns;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public abstract class ColumnsWidthAction
extends DumbAwareAction
implements GridAction {
    private static final int DELTA = 8;

    public void update(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            ColumnsWidthAction.$$$reportNull$$$0(0);
        }
        SelectionModel selectionModel = (grid = DataGridUtil.getDataGrid(e.getDataContext())) == null ? null : grid.getSelectionModel();
        int selectedColumns = selectionModel instanceof SelectionModelWithViewColumns ? ((SelectionModelWithViewColumns)((Object)selectionModel)).selectedViewColumnsCount() : 0;
        ResultViewWithColumns resultView = grid == null ? null : (ResultViewWithColumns)ObjectUtils.tryCast((Object)grid.getResultView(), ResultViewWithColumns.class);
        e.getPresentation().setEnabledAndVisible(grid != null && resultView != null && !grid.isEditing() && selectedColumns > 0);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        ResultViewWithColumns resultView;
        if (e == null) {
            ColumnsWidthAction.$$$reportNull$$$0(1);
        }
        ResultViewWithColumns resultViewWithColumns = resultView = (dataGrid = DataGridUtil.getDataGrid(e.getDataContext())) == null ? null : (ResultViewWithColumns)ObjectUtils.tryCast((Object)dataGrid.getResultView(), ResultViewWithColumns.class);
        if (resultView != null) {
            resultView.changeSelectedColumnsWidth(this.getDelta());
        }
    }

    abstract int getDelta();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/database/actions/ColumnsWidthAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class IncreaseColumnsWidthAction
    extends ColumnsWidthAction {
        @Override
        int getDelta() {
            return 8;
        }
    }

    public static class DecreaseColumnsWidthAction
    extends ColumnsWidthAction {
        @Override
        int getDelta() {
            return -8;
        }
    }
}

