/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.autoconfig.DataSourceConfiguration;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtilCore;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.LoaderContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataSourceConfigUtil {
    private DataSourceConfigUtil() {
    }

    public static void configureDetectedDataSources(@NotNull Project project, @NotNull DataSourceRegistry registry, boolean silentUpdate, boolean silentCreate) {
        if (project == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(0);
        }
        if (registry == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(1);
        }
        DataSourceStorage storage = DataSourceStorage.getProjectStorage(project);
        Map map2 = JBIterable.from(storage.getDataSources()).toReverseMap(AbstractDataSource::getName);
        WriteAction.run(() -> {
            for (LocalDataSource dataSource2 : registry.getDataSources()) {
                OneTimeString password;
                AbstractDataSource existing = (AbstractDataSource)map2.get(dataSource2.getName());
                boolean toUpdate = existing instanceof LocalDataSource;
                if (toUpdate && silentUpdate) {
                    DataSourceConfigUtil.copy(dataSource2, (LocalDataSource)existing);
                    continue;
                }
                if (toUpdate || !silentCreate) continue;
                DataSourceConfigUtil.copy(dataSource2, dataSource2);
                OneTimeString oneTimeString = password = StringUtil.isNotEmpty((String)dataSource2.getUsername()) ? registry.getCredentialsStore().getPassword(dataSource2) : null;
                if (!StringUtil.isEmpty((CharSequence)password)) {
                    DatabaseCredentials.getInstance().setPassword(dataSource2, password);
                }
                storage.addDataSource(dataSource2);
            }
        });
        DataSourceConfigUtil.runRegistryCallbacks(project, registry);
    }

    public static void runRegistryCallbacks(@NotNull Project project, @NotNull DataSourceRegistry registry) {
        if (project == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(2);
        }
        if (registry == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(3);
        }
        DataSourceStorage storage = DataSourceStorage.getProjectStorage(project);
        Map map2 = JBIterable.from(storage.getDataSources()).toReverseMap(AbstractDataSource::getName);
        for (LocalDataSource dataSource2 : registry.getDataSources()) {
            if (storage.getDataSourceById(dataSource2.getUniqueId()) == null) continue;
            DataSourceDetector.Callback callback = registry.getCallback(dataSource2);
            AbstractDataSource existing = (AbstractDataSource)map2.get(dataSource2.getName());
            if (Comparing.equal((Object)existing, (Object)dataSource2)) {
                if (callback == null) continue;
                callback.onCreated(dataSource2);
                continue;
            }
            if (!(existing instanceof LocalDataSource) || callback == null) continue;
            callback.onUpdated(existing);
        }
    }

    private static void copy(@NotNull LocalDataSource from, @NotNull LocalDataSource to) {
        if (from == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(4);
        }
        if (to == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(5);
        }
        to.setUrl(from.getUrl());
        to.setClasspathElements(new ArrayList<SimpleClasspathElement>(from.getClasspathElements()));
        if (to.getDatabaseDriver() == null || !to.getOwnClasspath().isEmpty()) {
            to.ensureDriverConfigured();
        }
    }

    public static void refreshTablesInBackground(Project project, Collection<? extends LocalDataSource> dataSources) {
        for (LocalDataSource localDataSource : dataSources) {
            DataSourceUtil.performAutoSyncTask(LoaderContext.loadAll(project, localDataSource));
        }
    }

    public static void buildDataSource(@NotNull Dbms dbms, @NotNull String name, @Nullable String unused, @Nullable PsiElement origin, @NotNull DataSourceConfiguration configuration, @NotNull DataSourceDetector.Builder builder) {
        DatabaseDriver driver;
        if (dbms == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(6);
        }
        if (name == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(9);
        }
        if ((driver = DbImplUtilCore.guessDatabaseDriver(dbms)) == null) {
            return;
        }
        String url = DataSourceConfigUtil.composeUrl(dbms, driver, configuration);
        if (StringUtil.isEmpty((String)url)) {
            return;
        }
        builder.withName(name).withDbms(dbms).withUser(configuration.getUserName()).withPassword(configuration.getPassword()).withUrl(url).withOrigin(origin).commit();
    }

    @Nullable
    private static String composeUrl(@NotNull Dbms dbms, @NotNull DatabaseDriver driver, @NotNull DataSourceConfiguration configuration) {
        StatelessJdbcUrlParser parser2;
        String database;
        if (dbms == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(10);
        }
        if (driver == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(11);
        }
        if (configuration == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(12);
        }
        if ((database = configuration.getDatabase()) == null) {
            return null;
        }
        String host = configuration.getHost();
        String port = configuration.getPort();
        List<StatelessJdbcUrlParser> parsers = driver.getJDBCUrlParsers();
        HashMap<String, String> params = new HashMap<String, String>();
        boolean fileBased = false;
        if (host == null && port == null) {
            String path = FileUtil.toSystemIndependentName((String)database);
            File file = new File(path);
            if (!file.exists()) {
                String rootPath;
                VirtualFile root2 = configuration.getApplicationRoot();
                String string = rootPath = root2 != null ? root2.getPath() : null;
                if (rootPath != null && !database.startsWith(rootPath)) {
                    file = new File(rootPath, database);
                }
            }
            StatelessJdbcUrlParser single = parsers.size() == 1 ? parsers.get(0) : null;
            path = file.getPath();
            if (dbms == Dbms.H2) {
                path = StringUtil.trimEnd((String)path, (String)".h2.db");
            }
            if (file.exists()) {
                fileBased = true;
                params.put(file.isDirectory() ? "path" : "file", path);
            } else if (single != null) {
                boolean hasPath;
                boolean hasFile = single.getParameterType("file") != null;
                boolean bl = hasPath = single.getParameterType("path") != null;
                if (hasFile || hasPath) {
                    fileBased = true;
                    params.put(hasPath ? "path" : "file", path);
                }
            }
        }
        if (!fileBased) {
            String string = host = host != null ? host : "localhost";
            if ("localhost".equals(host)) {
                host = System.getProperty("java.rmi.server.hostname", "127.0.0.1");
            }
            params.put("host", host);
            if (port != null) {
                params.put("port", port);
            }
            if (dbms == Dbms.ORACLE) {
                params.put("service", database);
            } else {
                params.put("database", database);
            }
        }
        if ((parser2 = (StatelessJdbcUrlParser)ContainerUtil.find(parsers, p2 -> JdbcUrlParserUtilCore.areParametersValidFor(p2, params))) == null) {
            return null;
        }
        JdbcUrlParser stateful = parser2.createStateful();
        for (String parameter : parser2.getParameters()) {
            String value2 = (String)params.get(parameter);
            if (StringUtil.isEmpty((String)value2)) {
                value2 = parser2.getParameterDefValue(parameter);
            }
            if (StringUtil.isEmpty((String)value2)) continue;
            stateful.setParameter(parameter, value2);
        }
        return stateful.isValid() ? stateful.getUrlText() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/autoconfig/DataSourceConfigUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureDetectedDataSources";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runRegistryCallbacks";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "copy";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "buildDataSource";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "composeUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

