/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.AssignColorAction;
import com.intellij.database.actions.DatabaseToggleNotebookModeAction;
import com.intellij.database.actions.ShowSqlParametersPanelAction;
import com.intellij.database.console.ConsoleErrorProviderFactory;
import com.intellij.database.console.ExecutionConcession;
import com.intellij.database.console.InlineProgressHelper;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.SearchPathReceiver;
import com.intellij.database.console.SearchPathSender;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.client.SessionClientHolder;
import com.intellij.database.console.session.DatabaseClientLogView;
import com.intellij.database.console.session.DatabaseClientLogViewBase;
import com.intellij.database.console.session.DatabaseConsoleHistoryController;
import com.intellij.database.console.session.DatabaseInEditorResults;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.DatabaseSessionViewService;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.ConsoleGridDataHookUp;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseEditorHelperCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ParametersHolder;
import com.intellij.database.run.ScriptingClientDataConsumer;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.run.audit.AuditorChain;
import com.intellij.database.run.audit.JdbcConsoleAuditor;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.StateWatcher;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.content.Content;
import com.intellij.util.EventDispatcher;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JdbcConsole
extends AbstractQueryLanguageConsole<LocalDataSource, DatabaseSessionClientWithFile>
implements JdbcConsoleBase,
SearchPathReceiver.Listener {
    private static final Key<Boolean> SCHEDULE_REFRESH = Key.create((String)"SCHEDULE_REFRESH");
    private static final Key<IntrospectionScopeUpdater> SCOPE_UPDATER = Key.create((String)"SCOPE_UPDATER");
    private static final String TOGGLE_CONSOLE_TOOLBAR_PROP = "Database.Console";
    private final AtomicReference<SearchPath> mySearchPath;
    private final AtomicReference<Boolean> myScheduleRefresh;
    private final AtomicReference<ScriptModel<?>> myScriptModel;
    private final DatabaseSession mySession;
    private final VirtualFile myVirtualFile;
    private final EventDispatcher<SearchPathReceiver> myPathDispatcher;
    private final DGDepartment.Console myDepartment;
    private final InlineProgressHelper myProgressHelper;
    private ScriptingClientDataConsumer myConsumer;
    private volatile boolean myNotebookMode;

    public LanguageConsoleView getConsoleView() {
        return JdbcConsole.getLangConsoleView((DatabaseClientLogViewBase<DatabaseSessionClientWithFile>)this.getView());
    }

    @NotNull
    public static Builder newConsole(@NotNull Project project) {
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(0);
        }
        return new Builder(project);
    }

    @NotNull
    public static ToggleToolbarAction createToggleConsoleToolbarAction(@NotNull Project project) {
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(1);
        }
        ToggleToolbarAction action2 = ToggleToolbarAction.createAction((String)TOGGLE_CONSOLE_TOOLBAR_PROP, (PropertiesComponent)PropertiesComponent.getInstance((Project)project), () -> DatabaseEditorHelper.getAllOpenedEditors(project).filter(editorEx -> {
            VirtualFile vFile = editorEx.getVirtualFile();
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
            return editorEx.getPermanentHeaderComponent() != null && (JdbcConsoleProviderCore.getValidConsole(project, vFile) != null || psiFile != null && DbSqlUtil.isSqlFile(psiFile) && !DbImplUtil.isDatabaseVirtualFile(vFile));
        }).map(o -> o.getComponent()));
        action2.getTemplatePresentation().setText(DatabaseBundle.message("JdbcConsole.toolbar.text", new Object[0]));
        ToggleToolbarAction toggleToolbarAction = action2;
        if (toggleToolbarAction == null) {
            JdbcConsole.$$$reportNull$$$0(2);
        }
        return toggleToolbarAction;
    }

    public static boolean beforeExecuteRange(@NotNull JdbcConsole console, TextRange range) {
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(3);
        }
        if (range.isEmpty()) {
            return false;
        }
        ScriptModel<?> subModel = console.getScriptModel().subModel(range);
        return console.beforeExecuteQueries(subModel);
    }

    @Nullable
    public static String getQueryText(@NotNull JdbcConsole console, @NotNull Editor editor) {
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            JdbcConsole.$$$reportNull$$$0(5);
        }
        TextRange range = ScriptModelUtil.getSelectedStatementsRange(console, editor, DatabaseSettings.getDefaultExecOption());
        return JdbcConsole.getQueryText(console, range);
    }

    @Nullable
    public static String getQueryText(@NotNull JdbcConsole console, @NotNull TextRange range) {
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(6);
        }
        if (range == null) {
            JdbcConsole.$$$reportNull$$$0(7);
        }
        if (range.isEmpty()) {
            return null;
        }
        String selected = range.subSequence((CharSequence)console.getDocument().getText()).toString();
        JBIterable<ScriptModel.ParamIt<?>> parameters = console.getScriptModel().subModel(range).parameters();
        return ScriptModelUtilCore.statementText(console.getPStorage(), parameters, selected, 0);
    }

    public static DataAuditor createAdvancedErrorsObtainer(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable DataAuditor sink) {
        ConsoleErrorProviderFactory factory;
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(8);
        }
        if (dataSource2 == null) {
            JdbcConsole.$$$reportNull$$$0(9);
        }
        return (factory = ConsoleErrorProviderFactory.EP.forDbms(dataSource2.getDbms())) == null ? null : factory.createErrorProvider(project, dataSource2, sink);
    }

    private JdbcConsole(@NotNull Project project, @NotNull VirtualFile file, @NotNull DatabaseSession session2, @NotNull LocalDataSource dataSource2, @Nullable DatabaseSession old) {
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(10);
        }
        if (file == null) {
            JdbcConsole.$$$reportNull$$$0(11);
        }
        if (session2 == null) {
            JdbcConsole.$$$reportNull$$$0(12);
        }
        if (dataSource2 == null) {
            JdbcConsole.$$$reportNull$$$0(13);
        }
        super(project, dataSource2, session2.getMessageBus());
        this.mySearchPath = new AtomicReference();
        this.myScheduleRefresh = new AtomicReference<Boolean>(false);
        this.myScriptModel = new AtomicReference();
        this.myPathDispatcher = EventDispatcher.create(SearchPathReceiver.class);
        this.myVirtualFile = file;
        this.mySession = session2;
        this.myScriptModel.set(this.updateScriptModel(null));
        this.myDepartment = new DGDepartment.Console(DataSourceUtil.getConsoleTitle(this.getProject(), this.getVirtualFile()));
        JdbcDriverManager.getDriverManager(this.getProject()).addModificationTrackerListener(new FilePresentationUpdater(), this);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.console");
        this.getMessageBus().addAuditor(new JdbcConsoleAuditor(this));
        if (old == null) {
            session2.attach(this);
        } else {
            old.exchange(this, session2);
        }
        this.myProgressHelper = new InlineProgressHelper(this);
        this.myNotebookMode = DatabaseToggleNotebookModeAction.isNotebookMode(project, file);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getView();
        }
    }

    @NotNull
    private ScriptModel<?> updateScriptModel(@Nullable ScriptModel<?> prevModel) {
        if (prevModel != null) {
            Disposer.dispose(prevModel);
        }
        ScriptModel model = SqlPsiFacade.getInstance((Project)this.getProject()).createScriptModel(this.getFile());
        Disposer.register((Disposable)this, (Disposable)model);
        ScriptModel scriptModel = model;
        if (scriptModel == null) {
            JdbcConsole.$$$reportNull$$$0(14);
        }
        return scriptModel;
    }

    public void setNotebookMode(boolean enabled, boolean persist) {
        if (!DatabaseToggleNotebookModeAction.isAvailable(this.getFile())) {
            return;
        }
        this.myNotebookMode = enabled;
        if (persist) {
            DatabaseToggleNotebookModeAction.setNotebookMode(this.getProject(), this, enabled);
        }
    }

    @Override
    public boolean isNotebookMode() {
        return DatabaseToggleNotebookModeAction.isAvailable(this.getFile()) && this.myNotebookMode;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.isValid() ? this.getFile().getIcon(0) : AllIcons.Nodes.Unknown;
    }

    @NotNull
    public Collection<? extends DatabaseInEditorResults.Result> getEmbeddedResults(@NotNull Editor editor) {
        if (editor == null) {
            JdbcConsole.$$$reportNull$$$0(15);
        }
        Collection<Object> collection = this.myConsumer == null ? Collections.emptyList() : this.myConsumer.getEmbeddedResults(editor);
        if (collection == null) {
            JdbcConsole.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    public InlineProgressHelper getProgressHelper() {
        InlineProgressHelper inlineProgressHelper = this.myProgressHelper;
        if (inlineProgressHelper == null) {
            JdbcConsole.$$$reportNull$$$0(17);
        }
        return inlineProgressHelper;
    }

    @Override
    public int getTxIsolation() {
        return this.mySession.getTxIsolation();
    }

    @Override
    public void setTxIsolation(int isolation) {
        this.mySession.setTxIsolation(isolation);
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = Objects.requireNonNull(FileDocumentManager.getInstance().getDocument(this.myVirtualFile));
        if (document == null) {
            JdbcConsole.$$$reportNull$$$0(18);
        }
        return document;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiUtilCore.getPsiFile((Project)this.getProject(), (VirtualFile)this.myVirtualFile));
        if (psiFile == null) {
            JdbcConsole.$$$reportNull$$$0(19);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = DatabaseSession.getClientTitle(this.getProject(), this.getVirtualFile());
        if (string == null) {
            JdbcConsole.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isTargetValid();
    }

    @Override
    @NotNull
    @NlsSafe
    public String getDisplayName() {
        String string = DataSourceUtil.getConsoleTitle(this.getProject(), this.myVirtualFile);
        if (string == null) {
            JdbcConsole.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.getFile().getLanguage();
        if (language == null) {
            JdbcConsole.$$$reportNull$$$0(22);
        }
        return language;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void detached(@NotNull DatabaseSessionClient.DetachTrigger trigger) {
        if (trigger == null) {
            JdbcConsole.$$$reportNull$$$0(23);
        }
        LogView<DatabaseSessionClientWithFile> view2 = DatabaseSessionViewService.getInstance().getClientViewIfAny(this);
        DatabaseSession.State state = this.getSession().getState();
        DatabaseSession.State.Work work = state.getWorkFor(this);
        if (trigger != DatabaseSessionClient.DetachTrigger.FILE_CLOSED || (view2 == null || view2.isEmpty()) && (work == null || work.getState() == DatabaseSession.State.WorkState.FINISHED)) {
            VirtualFile file = this.getVirtualFile();
            JdbcConsoleProvider.detachConsole(this.getProject(), file);
            if (trigger != DatabaseSessionClient.DetachTrigger.SESSION_SWITCH) {
                DatabaseSessionViewService.getInstance().destroyView(this);
                if (DbVFSUtils.isConsoleFile(file)) {
                    FileEditorManager.getInstance((Project)this.getProject()).closeFile(file);
                }
            }
        }
    }

    @Override
    public boolean showOnAttention(@NotNull DataRequest.Context context) {
        ConsoleDataRequest request;
        if (context == null) {
            JdbcConsole.$$$reportNull$$$0(24);
        }
        return (request = (ConsoleDataRequest)ObjectUtils.tryCast((Object)((Object)context.request), ConsoleDataRequest.class)) != null && (request.queryIndex == 0 || !request.hasNext);
    }

    @Override
    public boolean focusOnError(@NotNull DataRequest.Context context) {
        if (context == null) {
            JdbcConsole.$$$reportNull$$$0(25);
        }
        return !(context.request instanceof ConsoleDataRequest) && !(context.request.owner instanceof ConsoleGridDataHookUp);
    }

    @Override
    public boolean getShowOnActivity() {
        return true;
    }

    @Override
    @NotNull
    public DatabaseDepartment getDepartment() {
        DGDepartment.Console console = this.myDepartment;
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(26);
        }
        return console;
    }

    @Override
    @NotNull
    public DatabaseSession getSession() {
        DatabaseSession databaseSession = this.mySession;
        if (databaseSession == null) {
            JdbcConsole.$$$reportNull$$$0(27);
        }
        return databaseSession;
    }

    @Override
    @NotNull
    public PlaceInGrid getResultsPlaceInView() {
        PlaceInGrid placeInGrid = PlaceInGrid.center;
        if (placeInGrid == null) {
            JdbcConsole.$$$reportNull$$$0(28);
        }
        return placeInGrid;
    }

    @Override
    @NotNull
    public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> createGridDataHookUp(@NotNull Disposable parent2) {
        if (parent2 == null) {
            JdbcConsole.$$$reportNull$$$0(29);
        }
        GridDataHookUpManager manager = GridDataHookUpManager.getInstance(this.getProject());
        ConsoleGridDataHookUp hookUp = manager.createDatabaseHookUp(parent2, this.getSession(), new Sender(this), this.getDepartment(), this);
        LogView view2 = this.getView();
        view2.registerHookUp(parent2, hookUp);
        ConsoleGridDataHookUp consoleGridDataHookUp = hookUp;
        if (consoleGridDataHookUp == null) {
            JdbcConsole.$$$reportNull$$$0(30);
        }
        return consoleGridDataHookUp;
    }

    @Override
    @NotNull
    public ScriptModel<?> getScriptModel() {
        ScriptModel<?> model = this.myScriptModel.get();
        if (!model.isActual()) {
            ScriptModel<?> scriptModel = this.myScriptModel.updateAndGet(prevModel -> !prevModel.isActual() ? this.updateScriptModel((ScriptModel<?>)prevModel) : prevModel);
            if (scriptModel == null) {
                JdbcConsole.$$$reportNull$$$0(31);
            }
            return scriptModel;
        }
        ScriptModel<?> scriptModel = model;
        if (scriptModel == null) {
            JdbcConsole.$$$reportNull$$$0(32);
        }
        return scriptModel;
    }

    @Override
    public void addSearchPathReceiver(@NotNull Disposable parent2, @NotNull SearchPathReceiver receiver) {
        if (parent2 == null) {
            JdbcConsole.$$$reportNull$$$0(33);
        }
        if (receiver == null) {
            JdbcConsole.$$$reportNull$$$0(34);
        }
        this.myPathDispatcher.addListener((EventListener)receiver, parent2);
    }

    public void updateConsoleOnRequestStarted(@NotNull DataRequest.Context context) {
        if (context == null) {
            JdbcConsole.$$$reportNull$$$0(35);
        }
        if (this.mySearchPath.get() == null) {
            this.updateSearchPath(context.getSearchPath());
        }
    }

    @Override
    public boolean getAutoClose() {
        return false;
    }

    public void updateConsoleOnRequestFinished(@NotNull DataRequest.Context context) {
        IntrospectionScopeUpdater scopeUpdater;
        ConsoleDataRequest consoleRequest;
        if (context == null) {
            JdbcConsole.$$$reportNull$$$0(36);
        }
        boolean requestAutoSync = (consoleRequest = (ConsoleDataRequest)ObjectUtils.tryCast((Object)((Object)context.request), ConsoleDataRequest.class)) != null && consoleRequest.isExecutionStopper() && Boolean.TRUE.equals(consoleRequest.getSharedDataHolder().getUserData(SCHEDULE_REFRESH)) && (!((LocalDataSource)this.getTarget()).isReadOnly() || consoleRequest.concessions.contains((Object)ExecutionConcession.SIDE_EFFECTS_IN_RO_MODE));
        boolean inTransaction = context.txMarker.isTransactionInProgress();
        IntrospectionScopeUpdater introspectionScopeUpdater = scopeUpdater = consoleRequest == null ? null : (IntrospectionScopeUpdater)consoleRequest.getSharedDataHolder().getUserData(SCOPE_UPDATER);
        if (this.isValid()) {
            this.updateSearchPath(context.getSearchPath());
        }
        if (this.isTargetValid() && requestAutoSync) {
            LoaderContext loaderContext = this.prepareContext();
            if (scopeUpdater != null) {
                loaderContext.getScopeUpdater().merge(scopeUpdater);
            }
            DataSourceUtil.performAutoSyncTask(loaderContext);
            if (inTransaction) {
                this.myScheduleRefresh.set(true);
            }
        }
    }

    public void updateConsoleOnTxCompleted(boolean commit) {
        if (this.isTargetValid() && commit && this.myScheduleRefresh.getAndSet(false).booleanValue()) {
            DataSourceUtil.performAutoSyncTask(this.prepareContext());
        }
    }

    @TestOnly
    public void setSearchPath(@Nullable SearchPath schemaPaths) {
        this.updateSearchPath(schemaPaths);
    }

    @Override
    @NotNull
    public ScriptModel.PStorage getPStorage() {
        ScriptModel.PStorage pStorage = ShowSqlParametersPanelAction.getStorage(this);
        if (pStorage == null) {
            JdbcConsole.$$$reportNull$$$0(37);
        }
        return pStorage;
    }

    @NotNull
    private LoaderContext prepareContext() {
        LoaderContext loaderContext = DataSourceUiUtil.getConnectionContext(this.getProject(), (LocalDataSource)this.getTarget(), SearchPath.getCurrent(this.mySearchPath.get()));
        if (loaderContext == null) {
            JdbcConsole.$$$reportNull$$$0(38);
        }
        return loaderContext;
    }

    private void updateSearchPath(@Nullable SearchPath schemaPaths) {
        if (Comparing.equal((Object)schemaPaths, (Object)this.mySearchPath.get()) || !this.isValid()) {
            return;
        }
        this.mySearchPath.set(schemaPaths);
        TransactionGuard.submitTransaction((Disposable)this.getProject(), () -> {
            VirtualFile virtualFile = this.getVirtualFile();
            DatabaseEditorHelperCore.initSearchPath(this.getFile());
            ChooseSchemaAction.setSelectedSearchPath(this.getProject(), virtualFile, this.mySearchPath.get());
            FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{virtualFile});
            AssignColorAction.updateFileEditors(FileEditorManagerEx.getInstanceEx((Project)this.getProject()), virtualFile);
        });
    }

    @Nullable
    public ObjectPath getCurrentNamespace() {
        SearchPath path = this.getSearchPath();
        return path == null ? null : path.getCurrent();
    }

    @Override
    @Nullable
    public SearchPath getSearchPath() {
        return this.mySearchPath.get();
    }

    @NotNull
    public static List<JdbcConsole> getActiveConsoles(Project project) {
        List<JdbcConsole> list = ScriptingDatabaseSessionClientHolder.INSTANCE.getActiveClients(project);
        if (list == null) {
            JdbcConsole.$$$reportNull$$$0(39);
        }
        return list;
    }

    @Nullable
    public static JdbcConsole findConsole(@NotNull AnActionEvent e) {
        VirtualFile file;
        if (e == null) {
            JdbcConsole.$$$reportNull$$$0(40);
        }
        JdbcConsole console = (file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) == null ? null : JdbcConsoleProvider.getValidConsole(e.getProject(), file);
        JdbcConsole result2 = console != null ? console : (JdbcConsole)ObjectUtils.tryCast((Object)e.getData(SessionClientHolder.CLIENT_KEY), JdbcConsole.class);
        return result2 == null || !result2.isValid() ? null : result2;
    }

    @Override
    protected String getHelpID() {
        return "reference.runToolWindow.jdbcTab";
    }

    @Override
    protected boolean isViewValid() {
        LogView<DatabaseSessionClientWithFile> maybeView = DatabaseSessionViewService.getInstance().getClientViewIfAny(this);
        return maybeView == null || maybeView.isValid();
    }

    public static void buildHeaderComponent(@NotNull Editor editor, @Nullable JdbcConsole console) {
        JComponent header;
        if (editor == null) {
            JdbcConsole.$$$reportNull$$$0(41);
        }
        if ((header = (JComponent)ObjectUtils.doIfCast((Object)editor, EditorEx.class, e -> e.getPermanentHeaderComponent())) == null) {
            ActionManager actionManager = ActionManager.getInstance();
            ActionGroup leftGroup = (ActionGroup)actionManager.getAction("Console.Jdbc.Left");
            ActionGroup rightGroup = (ActionGroup)actionManager.getAction("Console.Jdbc.Right");
            EditorHeaderComponent headerComponent = new EditorHeaderComponent();
            ActionToolbar leftToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", leftGroup, true);
            ActionToolbar rightToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", rightGroup, true);
            rightToolbar.setReservePlaceAutoPopupIcon(false);
            leftToolbar.setTargetComponent(editor.getContentComponent());
            rightToolbar.setTargetComponent(editor.getContentComponent());
            headerComponent.add((Component)leftToolbar.getComponent(), "Center");
            headerComponent.add((Component)rightToolbar.getComponent(), "East");
            ObjectUtils.consumeIfCast((Object)editor, EditorEx.class, arg_0 -> JdbcConsole.lambda$buildHeaderComponent$7((JPanel)headerComponent, arg_0));
            editor.setHeaderComponent((JComponent)headerComponent);
            ToggleToolbarAction.setToolbarVisible((String)TOGGLE_CONSOLE_TOOLBAR_PROP, (PropertiesComponent)PropertiesComponent.getInstance((Project)Objects.requireNonNull(editor.getProject())), (Iterable)JBIterable.of((Object)headerComponent), null);
            header = headerComponent;
        }
        DatabaseEditorHelper.configureEditorHeader(console == null ? editor.getProject() : console.getProject(), console == null ? null : console.getVirtualFile(), header);
    }

    @Override
    public boolean beforeExecuteQueries(@NotNull ScriptModel<?> scriptModel) {
        if (scriptModel == null) {
            JdbcConsole.$$$reportNull$$$0(42);
        }
        if (!this.isValid()) {
            return false;
        }
        ScriptModel.PStorage storage = ShowSqlParametersPanelAction.getStorage(this);
        boolean result2 = ParametersHolder.beforeExecuteQueries(this.myVirtualFile, storage, this.getProject(), scriptModel);
        if (result2) {
            this.getView().beforeExecution();
        }
        return result2;
    }

    public void executeQueries(@NotNull Editor sourceEditor, @NotNull ScriptModel<?> model, @NotNull DatabaseSettings.ExecOption execOption) {
        boolean scheduleRefresh;
        if (sourceEditor == null) {
            JdbcConsole.$$$reportNull$$$0(43);
        }
        if (model == null) {
            JdbcConsole.$$$reportNull$$$0(44);
        }
        if (execOption == null) {
            JdbcConsole.$$$reportNull$$$0(45);
        }
        IntrospectionScopeUpdater scopeUpdater = null;
        LocalDataSource target = (LocalDataSource)this.getTarget();
        if (target.isAutoSynchronize()) {
            SyntaxTraverser s2 = (SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)model.statements().transform(ScriptModelUtilCore.TO_OBJECT).filter(PsiElement.class).toList());
            boolean bl = scheduleRefresh = !((SyntaxTraverser)s2.filter(e -> JdbcConsole.triggersIntrospection(e, target))).traverse().isEmpty();
            if (scheduleRefresh && DatabaseSettings.getSettings().trackNamespaces) {
                scopeUpdater = DbSqlUtil.getScopeUpdater((SyntaxTraverser<PsiElement>)s2, this.getCurrentNamespace(), target.getModel());
            }
        } else {
            scheduleRefresh = false;
        }
        ConsoleDataRequest request = ConsoleDataRequest.newConsoleRequest(this, sourceEditor, model, execOption.newTab);
        if (request == null) {
            return;
        }
        request.getSharedDataHolder().putUserData(SCHEDULE_REFRESH, (Object)scheduleRefresh);
        request.getSharedDataHolder().putUserData(SCOPE_UPDATER, scopeUpdater);
        this.getMessageBus().getDataProducer().processRequest(request);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.console.run.intention");
    }

    @Override
    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = (LocalDataSource)this.getTarget();
        if (localDataSource == null) {
            JdbcConsole.$$$reportNull$$$0(46);
        }
        return localDataSource;
    }

    public void switchSchema(@NotNull SearchPath to, boolean force) {
        if (to == null) {
            JdbcConsole.$$$reportNull$$$0(47);
        }
        if (force && this.getCurrentTx().isTransactionInProgress() && JdbcUrlParserUtil.outOfBounds(this.getDataSource(), SearchPath.getCurrent(this.getSearchPath()), to.getCurrent())) {
            int res2 = Messages.showYesNoCancelDialog((Project)this.getProject(), (String)DatabaseBundle.message("JdbcConsole.transaction.message", new Object[0]), (String)DatabaseBundle.message("JdbcConsole.transaction.title", new Object[0]), (Icon)Messages.getWarningIcon());
            if (res2 == 0) {
                this.getMessageBus().getDataProducer().processRequest(DataRequest.newTxCommit(this));
            } else if (res2 == 1) {
                this.getMessageBus().getDataProducer().processRequest(DataRequest.newTxRollback(this));
            } else {
                return;
            }
        }
        this.fireSearchPathChanged(to);
        this.updateSearchPath(to);
        this.getMessageBus().getDataProducer().processRequest(DataRequest.newSchemaSwitchRequest(this, to, force));
    }

    private void fireSearchPathChanged(@NotNull SearchPath to) {
        FileEditorManager manager;
        if (to == null) {
            JdbcConsole.$$$reportNull$$$0(48);
        }
        if (!(manager = FileEditorManager.getInstance((Project)this.getProject())).isFileOpen(this.myVirtualFile) || !this.myVirtualFile.isValid()) {
            return;
        }
        FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{this.myVirtualFile});
        ((SearchPathReceiver)this.myPathDispatcher.getMulticaster()).receive(to);
    }

    @Override
    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        DataRequest.TxMarker txMarker = this.mySession.getCurrentTx();
        if (txMarker == null) {
            JdbcConsole.$$$reportNull$$$0(49);
        }
        return txMarker;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.mySession.setAutoCommit(autoCommit);
    }

    @Nullable
    public RunnerLayoutUi getUi() {
        LogView<DatabaseSessionClientWithFile> view2 = DatabaseSessionViewService.getInstance().getClientViewIfAny(this);
        return view2 == null ? null : view2.getUi();
    }

    @NotNull
    public List<Content> getContents() {
        if (this.myConsumer == null) {
            List<Content> list = Collections.emptyList();
            if (list == null) {
                JdbcConsole.$$$reportNull$$$0(50);
            }
            return list;
        }
        Collection<RunnerLayoutUi> uis = this.myConsumer.getUis();
        List list = ContainerUtil.flatMap(uis, ui -> Arrays.asList(ui.getContents()));
        if (list == null) {
            JdbcConsole.$$$reportNull$$$0(51);
        }
        return list;
    }

    public void showPlan(@Nullable PlanModel plan) {
        this.getView().showPlan(plan);
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            JdbcConsole.$$$reportNull$$$0(52);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public DatabaseClientLogViewBase<DatabaseSessionClientWithFile> getView() {
        DatabaseClientLogViewBase<DatabaseSessionClientWithFile> databaseClientLogViewBase = DatabaseSessionViewService.getInstance().getClientView(this, (Function1<? super DatabaseClientLogViewBase<DatabaseSessionClientWithFile>, Unit>)((Function1)v -> {
            this.myConsumer = ScriptingClientDataConsumer.install(this.getProject(), this, ((DatabaseClientLogView)v).getResultsPlaceChooser());
            DatabaseConsoleHistoryController controller = new DatabaseConsoleHistoryController(this.getDataSource(), JdbcConsole.getLangConsoleView(v), this);
            controller.install();
            Disposer.register((Disposable)this, (Disposable)controller);
            Disposer.register((Disposable)this, () -> {
                this.myConsumer = null;
            });
            DataAuditor obtainer = JdbcConsole.createAdvancedErrorsObtainer(this.getProject(), this.getDataSource(), this.getErrorsLogger((DatabaseClientLogViewBase<DatabaseSessionClientWithFile>)v));
            if (obtainer != null) {
                if (obtainer instanceof Disposable) {
                    Disposer.register((Disposable)this, (Disposable)((Disposable)obtainer));
                }
                this.getMessageBus().addAuditor(obtainer);
            }
            new StateWatcher.ClientWatcher(this);
            return Unit.INSTANCE;
        }));
        if (databaseClientLogViewBase == null) {
            JdbcConsole.$$$reportNull$$$0(53);
        }
        return databaseClientLogViewBase;
    }

    @Nullable
    private static LanguageConsoleView getLangConsoleView(DatabaseClientLogViewBase<DatabaseSessionClientWithFile> logView) {
        if (logView instanceof DatabaseClientLogView) {
            return ((DatabaseClientLogView)logView).getConsoleView();
        }
        return null;
    }

    @NotNull
    private DataAuditor getErrorsLogger(@NotNull DatabaseClientLogViewBase<DatabaseSessionClientWithFile> view2) {
        if (view2 == null) {
            JdbcConsole.$$$reportNull$$$0(54);
        }
        return new AuditorChain(view2.getHistoryLogger(), DatabaseSessionViewService.getInstance().getView(this.mySession).getHistoryLogger());
    }

    @Override
    public boolean isIdle() {
        return this.mySession.isIdle();
    }

    @Override
    public boolean cleanup() {
        return false;
    }

    private boolean isTargetValid() {
        return DataSourceUtil.isDataSourceValid(DbPsiFacade.getInstance(this.getProject()), this.getDataSource());
    }

    private static boolean triggersIntrospection(@NotNull PsiElement e, @NotNull LocalDataSource dataSource2) {
        DatabaseDialect dialect;
        if (e == null) {
            JdbcConsole.$$$reportNull$$$0(55);
        }
        if (dataSource2 == null) {
            JdbcConsole.$$$reportNull$$$0(56);
        }
        return (dialect = DatabaseDialect.EP.forDbms(dataSource2.getDbms())) != null && dialect.triggersIntrospection(e);
    }

    private static /* synthetic */ void lambda$buildHeaderComponent$7(JPanel headerComponent, EditorEx e) {
        e.setPermanentHeaderComponent((JComponent)headerComponent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcConsole";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 5: 
            case 15: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: 
            case 13: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trigger";
                break;
            }
            case 24: 
            case 25: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 40: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptModel";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceEditor";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execOption";
                break;
            }
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcConsole";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToggleConsoleToolbarAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "updateScriptModel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmbeddedResults";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressHelper";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDepartment";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultsPlaceInView";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createGridDataHookUp";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptModel";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPStorage";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareContext";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveConsoles";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTx";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newConsole";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createToggleConsoleToolbarAction";
                break;
            }
            case 2: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecuteRange";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getQueryText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAdvancedErrorsObtainer";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getEmbeddedResults";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "detached";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "showOnAttention";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "focusOnError";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createGridDataHookUp";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addSearchPathReceiver";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "updateConsoleOnRequestStarted";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "updateConsoleOnRequestFinished";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findConsole";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "buildHeaderComponent";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecuteQueries";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "executeQueries";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "switchSchema";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "fireSearchPathChanged";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getErrorsLogger";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "triggersIntrospection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Sender
    implements SearchPathSender {
        private final JdbcConsole myConsole;

        Sender(@NotNull JdbcConsole console) {
            if (console == null) {
                Sender.$$$reportNull$$$0(0);
            }
            this.myConsole = console;
        }

        @Override
        public void subscribe(@NotNull SearchPathReceiver receiver) {
            if (receiver == null) {
                Sender.$$$reportNull$$$0(1);
            }
            this.myConsole.addSearchPathReceiver(receiver, receiver);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcConsole$Sender";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "subscribe";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class FilePresentationUpdater
    implements ModificationTrackerListener<JdbcDriverManager> {
        private FilePresentationUpdater() {
        }

        public void modificationCountChanged(@NotNull JdbcDriverManager source) {
            if (source == null) {
                FilePresentationUpdater.$$$reportNull$$$0(0);
            }
            FileEditorManagerEx.getInstanceEx((Project)JdbcConsole.this.getProject()).updateFilePresentation(JdbcConsole.this.myVirtualFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/JdbcConsole$FilePresentationUpdater", "modificationCountChanged"));
        }
    }

    public static class ScriptingDatabaseSessionClientHolder
    extends SessionClientHolder<JdbcConsole, Parameters> {
        public static final ScriptingDatabaseSessionClientHolder INSTANCE = new ScriptingDatabaseSessionClientHolder();
        private static final Key<List<JdbcConsole>> DATABASE_CONSOLE_LIST = Key.create((String)"DATABASE_CONSOLE_LIST");

        protected ScriptingDatabaseSessionClientHolder() {
            super(JdbcConsole.class);
        }

        @Override
        @NotNull
        protected JdbcConsole createClientInner(@NotNull Parameters parameters) {
            if (parameters == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(0);
            }
            return new JdbcConsole(parameters.project, parameters.virtualFile, parameters.session, parameters.dataSource, parameters.old);
        }

        @Override
        @NotNull
        protected List<JdbcConsole> getActiveClients(@NotNull Project project) {
            if (project == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(1);
            }
            List<JdbcConsole> data = ScriptingDatabaseSessionClientHolder.getMutableConsolesList(project);
            List invalid = ContainerUtil.filter(data, c2 -> !c2.isValid());
            for (JdbcConsole console : invalid) {
                Disposer.dispose((Disposable)console);
            }
            List<JdbcConsole> list = data;
            if (list == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        protected void register(@NotNull Project project, @NotNull JdbcConsole console) {
            if (project == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(3);
            }
            if (console == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(4);
            }
            ScriptingDatabaseSessionClientHolder.getMutableConsolesList(project).add(console);
            Disposer.register((Disposable)console, () -> ScriptingDatabaseSessionClientHolder.getMutableConsolesList(project).remove(console));
        }

        @NotNull
        private static List<JdbcConsole> getMutableConsolesList(@NotNull Project project) {
            List data;
            if (project == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(5);
            }
            if ((data = (List)project.getUserData(DATABASE_CONSOLE_LIST)) == null) {
                data = ContainerUtil.createLockFreeCopyOnWriteList();
                project.putUserData(DATABASE_CONSOLE_LIST, (Object)data);
            }
            List list = data;
            if (list == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcConsole$ScriptingDatabaseSessionClientHolder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcConsole$ScriptingDatabaseSessionClientHolder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveClients";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMutableConsolesList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createClientInner";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getActiveClients";
                    break;
                }
                case 2: 
                case 6: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "register";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getMutableConsolesList";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static class Parameters
        extends SessionClientHolder.Parameters {
            final LocalDataSource dataSource;
            final VirtualFile virtualFile;
            final DatabaseSession old;

            Parameters(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull DatabaseSession session2, @NotNull LocalDataSource dataSource2, @Nullable DatabaseSession old) {
                if (project == null) {
                    Parameters.$$$reportNull$$$0(0);
                }
                if (virtualFile == null) {
                    Parameters.$$$reportNull$$$0(1);
                }
                if (session2 == null) {
                    Parameters.$$$reportNull$$$0(2);
                }
                if (dataSource2 == null) {
                    Parameters.$$$reportNull$$$0(3);
                }
                super(project, session2);
                this.virtualFile = virtualFile;
                this.dataSource = dataSource2;
                this.old = old;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "virtualFile";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "session";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSource";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/console/JdbcConsole$ScriptingDatabaseSessionClientHolder$Parameters";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static interface RawErrorsObtainer
    extends DataAuditor,
    Disposable {
        public void obtainErrors(@NotNull String var1, @NotNull DatabaseConnection var2, @Nullable SearchPath var3, @NotNull Consumer<@Nls String> var4);
    }

    public static class Builder {
        private final Project myProject;
        private VirtualFile myVirtualFile;
        private DasDataSource myDataSource;
        private DatabaseSession mySession;
        private DatabaseSession myOldSession;

        public Builder(@NotNull Project project) {
            if (project == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public Builder forFile(VirtualFile file) {
            this.myVirtualFile = file;
            return this;
        }

        public Builder useSession(DatabaseSession session2) {
            this.mySession = session2;
            return this;
        }

        public Builder insteadOf(DatabaseSession old) {
            this.myOldSession = old;
            return this;
        }

        public Builder fromDataSource(DasDataSource info) {
            this.myDataSource = info;
            return this;
        }

        @NotNull
        public JdbcConsole build() {
            ValueLookupManager instance = ValueLookupManager.getInstance((Project)this.myProject);
            if (instance != null) {
                instance.startListening();
            }
            LocalDataSource dataSource2 = DbImplUtil.getLocalDataSource(this.myDataSource);
            VirtualFile file = this.myVirtualFile != null ? this.myVirtualFile : DatabaseEditorHelper.getConsoleVirtualFile(this.myDataSource);
            LOG.assertTrue(file != null, (Object)"Console file is not available");
            JdbcConsole existing = (JdbcConsole)JBIterable.from(JdbcConsole.getActiveConsoles(this.myProject)).find(s2 -> s2.getVirtualFile().equals(file));
            LOG.assertTrue(existing == null, (Object)("Console already created for " + file.getName()));
            DatabaseSession session2 = this.mySession == null ? DatabaseSessionManager.getSession(this.myProject, dataSource2, DatabaseSession.getTitle(this.myProject, file)) : this.mySession;
            JdbcConsole jdbcConsole = (JdbcConsole)ScriptingDatabaseSessionClientHolder.INSTANCE.createClient(new ScriptingDatabaseSessionClientHolder.Parameters(this.myProject, file, session2, dataSource2, this.myOldSession));
            if (jdbcConsole == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return jdbcConsole;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcConsole$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcConsole$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

