/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.PersistentCsvFormat;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.StreamCsvFormatParser;
import com.intellij.database.editor.CsvTableFileEditorProvider;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CsvFormatResolver {
    private static final Logger LOG = Logger.getInstance(CsvFormatResolver.class);
    private static final int VERSION = 1;
    private static final FileAttribute CSV_FORMAT_ATTRIBUTES = new FileAttribute("csv_format", 1, true);
    private static final VfsDependentEnum<String> ENUM = new VfsDependentEnum("csv_format_enumerator", (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, 1);
    private static final int LIMIT = 3000;

    private CsvFormatResolver() {
    }

    @Nullable
    public static CsvFormat getFormatFromState(@NotNull Project project, @NotNull VirtualFile file) {
        CsvTableFileEditorProvider provider;
        if (project == null) {
            CsvFormatResolver.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CsvFormatResolver.$$$reportNull$$$0(1);
        }
        return (provider = CsvTableFileEditorProvider.getProvider()) == null ? null : CsvFormatResolver.getFormatFromState(project, file, provider);
    }

    @Nullable
    public static CsvFormat getFormatFromState(@NotNull Project project, @NotNull VirtualFile file, @NotNull CsvTableFileEditorProvider provider) {
        if (project == null) {
            CsvFormatResolver.$$$reportNull$$$0(2);
        }
        if (file == null) {
            CsvFormatResolver.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            CsvFormatResolver.$$$reportNull$$$0(4);
        }
        if (project.isDisposed()) {
            return null;
        }
        EditorHistoryManager editorHistoryManager = EditorHistoryManager.getInstance((Project)project);
        FileEditorState state = editorHistoryManager == null ? null : editorHistoryManager.getState(file, (FileEditorProvider)provider);
        return editorHistoryManager != null && state != null ? CsvFormatResolver.readCsvFormat(state) : null;
    }

    @Nullable
    public static CsvFormat getMoreSuitableCsvFormat(@NotNull CharSequence sequence) {
        if (sequence == null) {
            CsvFormatResolver.$$$reportNull$$$0(5);
        }
        List<CsvFormat> formats = DatabaseSettings.getSettings().getCsvFormats();
        ArrayList<MyParserResult> results2 = new ArrayList<MyParserResult>();
        for (CsvFormat format : formats) {
            CsvFormat simpleFormat2 = CsvFormatResolver.simplifyFormat(format);
            StreamCsvFormatParser parser2 = new StreamCsvFormatParser(simpleFormat2, 3000);
            try {
                results2.add(new MyParserResult(parser2.parse(new StringReader(sequence.toString())), format));
            }
            catch (IOException e) {
                results2.add(new MyParserResult(null, format));
            }
        }
        ContainerUtil.sort(results2);
        MyParserResult item = (MyParserResult)ContainerUtil.getFirstItem(results2);
        return item == null ? null : item.myFormat;
    }

    @Contract(value="null -> null; !null -> !null")
    public static CsvFormat simplifyFormat(@Nullable CsvFormat format) {
        if (format == null) {
            return null;
        }
        return new CsvFormat("Simple " + format.name, format.dataRecord, null, format.id, false);
    }

    @Nullable
    public static CsvFormat getFormatFromFile(@NotNull VirtualFile file) {
        CsvFormat csvFormat;
        block10: {
            DataInputStream stream;
            if (file == null) {
                CsvFormatResolver.$$$reportNull$$$0(6);
            }
            DataInputStream dataInputStream = stream = file instanceof VirtualFileWithId ? CSV_FORMAT_ATTRIBUTES.readAttribute(file) : null;
            if (stream == null) {
                return null;
            }
            DataInputStream resource = stream;
            try {
                int i2 = DataInputOutputUtil.readINT((DataInput)resource);
                String id = (String)ENUM.getById(i2);
                Element load = JDOMUtil.load((CharSequence)id);
                PersistentCsvFormat format = (PersistentCsvFormat)XmlSerializer.deserialize((Element)load, PersistentCsvFormat.class);
                csvFormat = format.immutable();
                if (resource == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | JDOMException e) {
                    LOG.warn(e);
                    return null;
                }
            }
            resource.close();
        }
        return csvFormat;
    }

    public static void saveCsvFormat(@NotNull CsvFormat format, @NotNull VirtualFile file) {
        if (format == null) {
            CsvFormatResolver.$$$reportNull$$$0(7);
        }
        if (file == null) {
            CsvFormatResolver.$$$reportNull$$$0(8);
        }
        PersistentCsvFormat persistentFormat = new PersistentCsvFormat(format);
        Element element2 = XmlSerializer.serialize((Object)persistentFormat);
        String string = JDOMUtil.write((Element)element2);
        try (DataOutputStream resource = CSV_FORMAT_ATTRIBUTES.writeAttribute(file);){
            DataInputOutputUtil.writeINT((DataOutput)resource, (int)ENUM.getId((Object)string));
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    public static FileEditorState getState(@NotNull FileEditorStateLevel level, @NotNull CsvDocumentDataHookUp hookup) {
        if (level == null) {
            CsvFormatResolver.$$$reportNull$$$0(9);
        }
        if (hookup == null) {
            CsvFormatResolver.$$$reportNull$$$0(10);
        }
        FileEditorState fileEditorState = level == FileEditorStateLevel.FULL && hookup.getRange() == null ? new State(hookup.getFormat()) : FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            CsvFormatResolver.$$$reportNull$$$0(11);
        }
        return fileEditorState;
    }

    @Nullable
    public static CsvFormat readCsvFormat(@Nullable FileEditorState state) {
        State csvState = (State)ObjectUtils.tryCast((Object)state, State.class);
        return csvState != null ? csvState.format.immutable() : null;
    }

    @Nullable
    public static CsvFormat getFormat(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            CsvFormatResolver.$$$reportNull$$$0(12);
        }
        if (file == null) {
            CsvFormatResolver.$$$reportNull$$$0(13);
        }
        return CsvFormatResolver.getFormat(project, file, FormatGetter.FILE, FormatGetter.STATE, FormatGetter.CONTENT);
    }

    @Nullable
    public static CsvFormat getFormat(@NotNull Project project, @NotNull VirtualFile file, FormatGetter ... getters) {
        if (project == null) {
            CsvFormatResolver.$$$reportNull$$$0(14);
        }
        if (file == null) {
            CsvFormatResolver.$$$reportNull$$$0(15);
        }
        if (getters == null) {
            CsvFormatResolver.$$$reportNull$$$0(16);
        }
        for (FormatGetter getter : getters) {
            CsvFormat format = getter.get(project, file);
            if (format == null) continue;
            return format;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookup";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/csv/CsvFormatResolver";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/csv/CsvFormatResolver";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFormatFromState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMoreSuitableCsvFormat";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFormatFromFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveCsvFormat";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFormat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum FormatGetter {
        STATE{

            @Override
            @Nullable
            CsvFormat get(@NotNull Project project, @NotNull VirtualFile file) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                return CsvFormatResolver.getFormatFromState(project, file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/csv/CsvFormatResolver$FormatGetter$1";
                objectArray[2] = "get";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        FILE{

            @Override
            @Nullable
            CsvFormat get(@NotNull Project project, @NotNull VirtualFile file) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    2.$$$reportNull$$$0(1);
                }
                return CsvFormatResolver.getFormatFromFile(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/csv/CsvFormatResolver$FormatGetter$2";
                objectArray[2] = "get";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        CONTENT{

            @Override
            @Nullable
            CsvFormat get(@NotNull Project project, @NotNull VirtualFile file) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    3.$$$reportNull$$$0(1);
                }
                CharSequence sequence = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getContent() : (file.getFileType().isBinary() ? null : LoadTextUtil.loadText((VirtualFile)file, (int)3000));
                return sequence == null ? null : CsvFormatResolver.getMoreSuitableCsvFormat(sequence);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/csv/CsvFormatResolver$FormatGetter$3";
                objectArray[2] = "get";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };


        @Nullable
        abstract CsvFormat get(@NotNull Project var1, @NotNull VirtualFile var2);
    }

    private static final class MyParserResult
    implements Comparable<MyParserResult> {
        private final StreamCsvFormatParser.CsvParserResult myResult;
        private final CsvFormat myFormat;

        private MyParserResult(@Nullable StreamCsvFormatParser.CsvParserResult result2, @NotNull CsvFormat format) {
            if (format == null) {
                MyParserResult.$$$reportNull$$$0(0);
            }
            this.myResult = result2;
            this.myFormat = format;
        }

        @Override
        public int compareTo(@NotNull MyParserResult o) {
            if (o == null) {
                MyParserResult.$$$reportNull$$$0(1);
            }
            if (this.myResult == null) {
                return o.myResult == null ? 0 : 1;
            }
            if (o.myResult == null) {
                return -1;
            }
            List<StreamCsvFormatParser.Token[]> records = this.myResult.getRecords();
            List<StreamCsvFormatParser.Token[]> oRecords = o.myResult.getRecords();
            if (records.isEmpty()) {
                return oRecords.isEmpty() ? 0 : 1;
            }
            if (oRecords.isEmpty()) {
                return -1;
            }
            int compare = Integer.compare(oRecords.get(0).length, records.get(0).length);
            return compare != 0 ? compare : Integer.compare(MyParserResult.errorsCount(this.myResult), MyParserResult.errorsCount(o.myResult));
        }

        private static int errorsCount(@NotNull StreamCsvFormatParser.CsvParserResult result2) {
            List<ErrorRecord> errors;
            ErrorRecord item;
            if (result2 == null) {
                MyParserResult.$$$reportNull$$$0(2);
            }
            if ((item = (ErrorRecord)ContainerUtil.getLastItem(errors = result2.getErrors())) == null) {
                return 0;
            }
            String message2 = item.getMessage();
            return StringUtil.containsIgnoreCase((String)message2, (String)"end of file") ? errors.size() - 1 : errors.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/csv/CsvFormatResolver$MyParserResult";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorsCount";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class State
    implements FileEditorState {
        @Tag(value="format")
        public PersistentCsvFormat format;

        public State() {
        }

        public State(@NotNull CsvFormat format) {
            if (format == null) {
                State.$$$reportNull$$$0(0);
            }
            this.format = new PersistentCsvFormat(format);
        }

        public boolean canBeMergedWith(@NotNull FileEditorState otherState, @NotNull FileEditorStateLevel level) {
            if (otherState == null) {
                State.$$$reportNull$$$0(1);
            }
            if (level == null) {
                State.$$$reportNull$$$0(2);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherState";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/csv/CsvFormatResolver$State";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canBeMergedWith";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

