/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CsvRecordFormat {
    public final String prefix;
    public final String suffix;
    public final String nullText;
    public final ImmutableList<Quotes> quotes;
    public final QuotationPolicy quotationPolicy;
    public final String valueSeparator;
    public final String recordSeparator;
    public final boolean trimWhitespace;

    public CsvRecordFormat(@NotNull String prefix, @NotNull String suffix, @Nullable String nullText, @NotNull List<Quotes> quotes, @NotNull QuotationPolicy quotationPolicy, @NotNull String valueSeparator, @NotNull String recordSeparator, boolean trimWhitespace) {
        if (prefix == null) {
            CsvRecordFormat.$$$reportNull$$$0(0);
        }
        if (suffix == null) {
            CsvRecordFormat.$$$reportNull$$$0(1);
        }
        if (quotes == null) {
            CsvRecordFormat.$$$reportNull$$$0(2);
        }
        if (quotationPolicy == null) {
            CsvRecordFormat.$$$reportNull$$$0(3);
        }
        if (valueSeparator == null) {
            CsvRecordFormat.$$$reportNull$$$0(4);
        }
        if (recordSeparator == null) {
            CsvRecordFormat.$$$reportNull$$$0(5);
        }
        this.prefix = prefix;
        this.suffix = suffix;
        this.nullText = nullText;
        this.quotes = ContainerUtil.immutableList(quotes);
        this.quotationPolicy = quotationPolicy;
        this.valueSeparator = valueSeparator;
        this.recordSeparator = recordSeparator;
        this.trimWhitespace = trimWhitespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CsvRecordFormat)) {
            return false;
        }
        CsvRecordFormat format = (CsvRecordFormat)o;
        if (this.trimWhitespace != format.trimWhitespace) {
            return false;
        }
        if (!this.prefix.equals(format.prefix)) {
            return false;
        }
        if (!this.suffix.equals(format.suffix)) {
            return false;
        }
        if (!Objects.equals(this.nullText, format.nullText)) {
            return false;
        }
        if (!this.quotes.equals(format.quotes)) {
            return false;
        }
        if (this.quotationPolicy != format.quotationPolicy) {
            return false;
        }
        if (!this.valueSeparator.equals(format.valueSeparator)) {
            return false;
        }
        return this.recordSeparator.equals(format.recordSeparator);
    }

    public int hashCode() {
        int result2 = this.prefix.hashCode();
        result2 = 31 * result2 + this.suffix.hashCode();
        result2 = 31 * result2 + Objects.hashCode(this.nullText);
        result2 = 31 * result2 + this.quotes.hashCode();
        result2 = 31 * result2 + this.quotationPolicy.hashCode();
        result2 = 31 * result2 + this.valueSeparator.hashCode();
        result2 = 31 * result2 + this.recordSeparator.hashCode();
        result2 = 31 * result2 + (this.trimWhitespace ? 1 : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "prefix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "suffix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "quotes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "quotationPolicy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "valueSeparator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "recordSeparator";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/csv/CsvRecordFormat";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum QuotationPolicy {
        ALWAYS,
        AS_NEEDED,
        NEVER;

    }

    public static final class Quotes {
        public final String leftQuote;
        public final String rightQuote;
        public final String leftQuoteEscaped;
        public final String rightQuoteEscaped;

        public Quotes(@NotNull String leftQuote, @NotNull String rightQuote, @NotNull String leftQuoteEscaped, @NotNull String rightQuoteEscaped) {
            if (leftQuote == null) {
                Quotes.$$$reportNull$$$0(0);
            }
            if (rightQuote == null) {
                Quotes.$$$reportNull$$$0(1);
            }
            if (leftQuoteEscaped == null) {
                Quotes.$$$reportNull$$$0(2);
            }
            if (rightQuoteEscaped == null) {
                Quotes.$$$reportNull$$$0(3);
            }
            this.leftQuote = leftQuote;
            this.rightQuote = rightQuote;
            this.leftQuoteEscaped = leftQuoteEscaped;
            this.rightQuoteEscaped = rightQuoteEscaped;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Quotes)) {
                return false;
            }
            Quotes quotes = (Quotes)o;
            if (!this.leftQuote.equals(quotes.leftQuote)) {
                return false;
            }
            if (!this.rightQuote.equals(quotes.rightQuote)) {
                return false;
            }
            if (!this.leftQuoteEscaped.equals(quotes.leftQuoteEscaped)) {
                return false;
            }
            return this.rightQuoteEscaped.equals(quotes.rightQuoteEscaped);
        }

        public int hashCode() {
            int result2 = this.leftQuote.hashCode();
            result2 = 31 * result2 + this.rightQuote.hashCode();
            result2 = 31 * result2 + this.leftQuoteEscaped.hashCode();
            result2 = 31 * result2 + this.rightQuoteEscaped.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "leftQuote";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rightQuote";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "leftQuoteEscaped";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rightQuoteEscaped";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/csv/CsvRecordFormat$Quotes";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

