/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceScopeEditor;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverCore;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.settings.DatabaseSettingsConfigurable;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class DataSourceUiUtil {
    private DataSourceUiUtil() {
    }

    public static ActionCallback navigate(@NotNull DatabaseConfigEditor editor, @NotNull LocalDataSource dataSource2, @NotNull Consumer<? super DataSourceConfigurable> modifier) {
        if (editor == null) {
            DataSourceUiUtil.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(1);
        }
        if (modifier == null) {
            DataSourceUiUtil.$$$reportNull$$$0(2);
        }
        return editor.navigateTo(dataSource2, false).doWhenDone(() -> {
            DataSourceConfigurable configurable = editor.getConfigurable(dataSource2, false, DataSourceConfigurable.class);
            if (configurable == null) {
                return;
            }
            modifier.consume((Object)configurable);
        });
    }

    public static ActionCallback modify(@NotNull DatabaseConfigEditor editor, @NotNull LocalDataSource dataSource2, @NotNull Consumer<? super LocalDataSource> modifier) {
        if (editor == null) {
            DataSourceUiUtil.$$$reportNull$$$0(3);
        }
        if (dataSource2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(4);
        }
        if (modifier == null) {
            DataSourceUiUtil.$$$reportNull$$$0(5);
        }
        return DataSourceUiUtil.navigate(editor, dataSource2, (Consumer<? super DataSourceConfigurable>)((Consumer)configurable -> DataSourceUiUtil.modify(configurable, modifier)));
    }

    public static void modify(DataSourceConfigurable configurable, @NotNull Consumer<? super LocalDataSource> modifier) {
        if (modifier == null) {
            DataSourceUiUtil.$$$reportNull$$$0(6);
        }
        LocalDataSource ds = configurable.getTempDataSource().copy(true);
        modifier.consume((Object)ds);
        configurable.reset(ds, false);
    }

    public static ActionCallback navigate(@NotNull DatabaseConfigEditor editor, @NotNull DatabaseDriverCore driver, @NotNull Consumer<? super DatabaseDriverConfigurable> modifier) {
        if (editor == null) {
            DataSourceUiUtil.$$$reportNull$$$0(7);
        }
        if (driver == null) {
            DataSourceUiUtil.$$$reportNull$$$0(8);
        }
        if (modifier == null) {
            DataSourceUiUtil.$$$reportNull$$$0(9);
        }
        return editor.navigateTo(driver, false).doWhenDone(() -> {
            DatabaseDriverConfigurable configurable = editor.getConfigurable(driver, false, DatabaseDriverConfigurable.class);
            if (configurable == null) {
                return;
            }
            modifier.consume((Object)configurable);
        });
    }

    public static void modify(@NotNull Consumer<? super DatabaseDriverImpl> modifier, DatabaseDriverConfigurable configurable) {
        if (modifier == null) {
            DataSourceUiUtil.$$$reportNull$$$0(10);
        }
        DatabaseDriverImpl dr = configurable.getTempDriver().copy(null, true);
        modifier.consume((Object)dr);
        configurable.reset(dr);
    }

    @NotNull
    public static LoaderContext getConnectionContext(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable ObjectPath path) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(11);
        }
        if (dataSource2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(12);
        }
        LoaderContext context = new LoaderContext(project, dataSource2);
        if (JdbcUrlParserUtil.isDatabaseBounded(dataSource2)) {
            if ((path = JdbcUrlParserUtil.toBound(dataSource2, path)) == null) {
                context.include(ObjectPath.create("@", ObjectKind.DATABASE));
            } else {
                context.include(path);
            }
        } else {
            context.includeAllSchemas();
        }
        LoaderContext loaderContext = context;
        if (loaderContext == null) {
            DataSourceUiUtil.$$$reportNull$$$0(13);
        }
        return loaderContext;
    }

    public static void showErrorBalloon(Throwable error2, Component component, Point point, boolean showArrow, boolean showConfig) {
        if (!component.isVisible() || !component.isShowing()) {
            return;
        }
        String errorText = StringUtil.notNullize((String)error2.getMessage(), (String)error2.getClass().getSimpleName());
        errorText = DataSourceUiUtil.wrap(errorText, 50, "\n", true);
        errorText = StringUtil.trimLog((String)errorText, (int)200);
        errorText = StringUtil.trimTrailing((String)errorText);
        @NlsSafe String errorFullText = ExceptionUtil.getThrowableText((Throwable)error2, (String)"com.intellij.");
        String imgURL = DataSourceUiUtil.getIconUrl("/general/settings.png");
        String detailsLinkMessage = " <a href=\"more\">" + DatabaseBundle.message("message.hyperlink.click.for.more", new Object[0]) + "</a>";
        @NlsSafe String balloonContent = showConfig ? "<table border=0 cellspacing=0 cellpadding=0><tr valign=top><td>" + errorText + detailsLinkMessage + "</td><td align=right>&nbsp;&nbsp;<a href=\"config\"><img alt=\"Disable error balloons\" hspace=0 vspace=0 border=0 width=16 height=16 src=\"" + imgURL + "\"></a></td></tr></table>" : errorText + detailsLinkMessage;
        HyperlinkListener hyperlinkListener = e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if ("more".equals(e.getDescription())) {
                    Messages.showIdeaMessageDialog(null, (String)errorFullText, (String)DatabaseBundle.message("dialog.title.query.error", new Object[0]), (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)Messages.getErrorIcon(), null);
                } else if ("config".equals(e.getDescription())) {
                    ShowSettingsUtilImpl.showSettingsDialog(null, (String)DatabaseSettingsConfigurable.CONFIGURABLE_ID, (String)"");
                }
            }
        };
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(balloonContent, MessageType.ERROR, hyperlinkListener).setClickHandler(e -> {}, true).setShowCallout(showArrow).setHideOnAction(true).setHideOnClickOutside(true);
        Balloon balloon = builder.createBalloon();
        balloon.show(new RelativePoint(component, point), Balloon.Position.below);
    }

    @Nullable
    public static String getIconUrl(@NotNull String icon) {
        if (icon == null) {
            DataSourceUiUtil.$$$reportNull$$$0(14);
        }
        String imgURL = null;
        URL resource = AllIcons.class.getClassLoader().getResource(StringUtil.trimStart((String)icon, (String)"/"));
        try {
            imgURL = resource != null ? resource.toURI().toURL().toExternalForm() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imgURL;
    }

    public static String wrap(@NotNull String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
        if (str == null) {
            DataSourceUiUtil.$$$reportNull$$$0(15);
        }
        if (newLineStr == null) {
            newLineStr = "\n";
        }
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        while (inputLineLength - offset > wrapLength) {
            if (str.charAt(offset) == ' ') {
                ++offset;
                continue;
            }
            int spaceToWrapAt = str.lastIndexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                wrappedLine.append(str, offset, wrapLength + offset);
                wrappedLine.append(newLineStr);
                offset += wrapLength;
                continue;
            }
            spaceToWrapAt = str.indexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str.substring(offset));
            offset = inputLineLength;
        }
        wrappedLine.append(str.substring(offset));
        return wrappedLine.toString();
    }

    public static void runAsyncWithCorrectModality(@NotNull Task.Backgroundable task2) {
        if (task2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(16);
        }
        ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2), null, ModalityState.current());
    }

    public static void runSynchronously(@NotNull Task task2) {
        ProgressIndicator indicator;
        if (task2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(17);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) == null) {
            indicator = new EmptyProgressIndicator();
        }
        try {
            task2.run(indicator);
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        finally {
            if (indicator.isCanceled()) {
                task2.onCancel();
            } else {
                task2.onSuccess();
            }
        }
    }

    @NotNull
    public static JBPopup buildHiddenNamespacesPopup(@NotNull Project project, final @NotNull LocalDataSource dataSource2, @Nullable BasicElement selection) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(18);
        }
        if (dataSource2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(19);
        }
        final DataSourceScopeEditor editor = new DataSourceScopeEditor(project){

            @Override
            protected LocalDataSource getDataSource(boolean withCredentials) {
                return dataSource2;
            }

            @Override
            @NotNull
            protected Dbms getDbms() {
                Dbms dbms = dataSource2.getDbms();
                if (dbms == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dbms;
            }

            @Override
            @NotNull
            public DataSourceSchemaMapping getSchemaMapping() {
                TreePattern scope = this.getEditorState();
                this.mySchemaMapping.setIntrospectionScope(scope);
                DataSourceSchemaMapping dataSourceSchemaMapping = this.mySchemaMapping;
                if (dataSourceSchemaMapping == null) {
                    1.$$$reportNull$$$0(1);
                }
                return dataSourceSchemaMapping;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/database/dataSource/DataSourceUiUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDbms";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSchemaMapping";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        editor.setInitialModel(dataSource2, (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class));
        TreePattern pattern = dataSource2.getIntrospectionScope();
        editor.setScopes(pattern, pattern);
        editor.setFakeCurrentSchema(dataSource2.getFakeCurrentSchema());
        editor.setSchemaMapping(dataSource2.getSchemaMapping());
        editor.select(selection);
        Ref notApply = Ref.create();
        final Ref popupRef = Ref.create();
        JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder(editor.getComponent(), (JComponent)editor.getTree()).setMovable(true).setResizable(true).setRequestFocus(true).setMinSize((Dimension)JBUI.size((int)250)).setDimensionServiceKey(project, "HiddenNamespacesPopup", false).setAdText(DatabaseBundle.message("manage.data.sources.ad", new Object[0])).setKeyEventHandler(event -> {
            if (event.getID() == 401) {
                if (event.getKeyCode() == 10) {
                    ((JBPopup)popupRef.get()).closeOk((InputEvent)event);
                    return true;
                }
                if (event.getKeyCode() == 27 && !editor.hasSpeedSearchActive()) {
                    notApply.set((Object)Boolean.TRUE);
                    ((JBPopup)popupRef.get()).cancel();
                    return true;
                }
            }
            return false;
        }).addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ((AbstractPopup)popupRef.get()).setShowHints(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dataSource/DataSourceUiUtil$2", "beforeShown"));
            }
        }).createPopup();
        popupRef.set((Object)popup2);
        popup2.setFinalRunnable(() -> {
            if (notApply.get() == Boolean.TRUE) {
                return;
            }
            Couple<String> fcs = editor.getFakeCurrentSchema();
            DataSourceSchemaMapping mapping = editor.getSchemaMapping();
            if (Comparing.equal(fcs, dataSource2.getFakeCurrentSchema()) && Comparing.equal((Object)mapping, (Object)dataSource2.getSchemaMapping())) {
                return;
            }
            @NotNull TreePattern oldScope = dataSource2.getIntrospectionScope();
            dataSource2.setFakeCurrentSchema(fcs);
            dataSource2.setSchemaMapping(mapping);
            DataSourceStorage.getProjectStorage(project).updateDataSource(dataSource2);
            DataSourceUtil.applyMappings(project, dataSource2);
            DataSourceUtil.performAutoSyncTask(DataSourceUiUtil.scopeChange(new LoaderContext(project, dataSource2), oldScope, dataSource2.getIntrospectionScope()));
        });
        new UiNotifyConnector.Once((Component)editor.getComponent(), new Activatable(){

            public void showNotify() {
                editor.introspectIfEmpty();
            }
        });
        JBPopup jBPopup = popup2;
        if (jBPopup == null) {
            DataSourceUiUtil.$$$reportNull$$$0(20);
        }
        return jBPopup;
    }

    public static LoaderContext scopeChange(@NotNull LoaderContext context, @NotNull TreePattern oldScope, @NotNull TreePattern newScope) {
        TreePattern diff2;
        if (context == null) {
            DataSourceUiUtil.$$$reportNull$$$0(21);
        }
        if (oldScope == null) {
            DataSourceUiUtil.$$$reportNull$$$0(22);
        }
        if (newScope == null) {
            DataSourceUiUtil.$$$reportNull$$$0(23);
        }
        if (!(diff2 = TreePatternUtils.minus(newScope, oldScope)).isEmpty()) {
            context.include(diff2);
        }
        return context;
    }

    public static boolean createDataSourceFromFiles(@NotNull Project project, @NotNull List<VirtualFile> files2) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(24);
        }
        if (files2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(25);
        }
        ArrayList<VirtualFile> extraFiles = new ArrayList<VirtualFile>(files2);
        ArrayList<DbDataSource> dataSources = new ArrayList<DbDataSource>();
        Iterator it2 = extraFiles.iterator();
        while (it2.hasNext()) {
            VirtualFile file = (VirtualFile)it2.next();
            DbDataSource dataSource2 = DbImplUtil.findDataSourceByFile(project, file);
            if (dataSource2 == null) continue;
            dataSources.add(dataSource2);
            it2.remove();
        }
        int existingSize = dataSources.size();
        DbPsiFacade facade = DbPsiFacade.getInstance(project);
        if (!extraFiles.isEmpty()) {
            for (DataSourceManager dataSourceManager : DataSourceManager.getManagers(project)) {
                for (DasDataSource system : dataSourceManager.createDataSourceByFiles(files2)) {
                    ContainerUtil.addIfNotNull(dataSources, (Object)facade.findDataSource(system.getUniqueId()));
                }
            }
        }
        if (!dataSources.isEmpty()) {
            Promise<?> prepare = existingSize != dataSources.size() ? DataSourceUtil.promiseFacadeUpdate(facade, null) : Promises.resolvedPromise();
            prepare.thenAsync(o -> DatabaseView.select(project, dataSources, true)).onProcessed(o -> ApplicationManager.getApplication().invokeLater(() -> DbNavigationUtils.navigateToDataSourceFile((DbElement)ContainerUtil.getFirstItem((List)dataSources), true)));
            return true;
        }
        return false;
    }

    public static DatabaseDriver createDefaultDatabaseDriver(@NotNull Collection<? extends DatabaseDriver> existing) {
        if (existing == null) {
            DataSourceUiUtil.$$$reportNull$$$0(26);
        }
        Set names = (Set)JBIterable.from(existing).map(DatabaseDriver::getName).addAllTo((Collection)CollectionFactory.createCaseInsensitiveStringSet());
        return DatabaseDriverManager.getInstance().createDriver(DbUtil.generateUniqueName("User Driver", names), "java.sql.Driver", null);
    }

    public static void applyFix(@NotNull Project project, @NotNull DatabaseErrorHandler.Fix fix, @Nullable DatabaseConfigEditor editor) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(27);
        }
        if (fix == null) {
            DataSourceUiUtil.$$$reportNull$$$0(28);
        }
        if (!fix.isSilent() && editor == null) {
            DbPsiFacade facade = DbPsiFacade.getInstance(project);
            DataSourceManagerDialog.showDialog(facade, null, null, (Consumer<? super DatabaseConfigEditor>)((Consumer)e -> DataSourceUiUtil.applyFixImpl(fix, project, e)));
        } else {
            DataSourceUiUtil.applyFixImpl(fix, project, editor);
        }
    }

    private static void applyFixImpl(@NotNull DatabaseErrorHandler.Fix fix, @NotNull Project project, @Nullable DatabaseConfigEditor editor) {
        if (fix == null) {
            DataSourceUiUtil.$$$reportNull$$$0(29);
        }
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(30);
        }
        DataContext context = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)project).add(DatabaseConfigEditor.CONFIG_EDITOR, (Object)editor).build();
        fix.apply(context);
    }

    public static void showTroubleshooting() {
        HelpManager.getInstance().invokeHelp("Connectivity_problems");
    }

    public static void performAutoSyncTask(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(31);
        }
        if (dataSource2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(32);
        }
        DataSourceUiUtil.performAutoSyncTask(LoaderContext.loadAll(project, dataSource2));
    }

    @NotNull
    public static AsyncTask<DataSourceSyncManager.SyncResult> performAutoSyncTask(@NotNull LoaderContext context) {
        if (context == null) {
            DataSourceUiUtil.$$$reportNull$$$0(33);
        }
        return DataSourceUiUtil.performAutoSyncTask(context, false);
    }

    @NotNull
    public static AsyncTask<DataSourceSyncManager.SyncResult> performAutoSyncTask(@NotNull LoaderContext context, boolean stopRunning) {
        if (context == null) {
            DataSourceUiUtil.$$$reportNull$$$0(34);
        }
        AsyncTask<DataSourceSyncManager.SyncResult> asyncTask = DataSourceUtil.performAutoSyncTask(context, stopRunning);
        if (asyncTask == null) {
            DataSourceUiUtil.$$$reportNull$$$0(35);
        }
        return asyncTask;
    }

    @NotNull
    public static AsyncTask<DataSourceSyncManager.SyncResult> performManualSyncTask(@NotNull LoaderContext context) {
        if (context == null) {
            DataSourceUiUtil.$$$reportNull$$$0(36);
        }
        AsyncTask<DataSourceSyncManager.SyncResult> asyncTask = DataSourceUtil.performManualSyncTask(context);
        if (asyncTask == null) {
            DataSourceUiUtil.$$$reportNull$$$0(37);
        }
        return asyncTask;
    }

    public static <K, V> V putOrRemove(Map<K, V> m, K k, V v) {
        return DataSourceUtil.putOrRemove(m, k, v);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 20: 
            case 35: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 20: 
            case 35: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 19: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 11: 
            case 18: 
            case 24: 
            case 27: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 20: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceUiUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 21: 
            case 33: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldScope";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newScope";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceUiUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionContext";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHiddenNamespacesPopup";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "performAutoSyncTask";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "performManualSyncTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getConnectionContext";
                break;
            }
            case 13: 
            case 20: 
            case 35: 
            case 37: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIconUrl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runAsyncWithCorrectModality";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runSynchronously";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildHiddenNamespacesPopup";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "scopeChange";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceFromFiles";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultDatabaseDriver";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "applyFixImpl";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "performAutoSyncTask";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "performManualSyncTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 20: 
            case 35: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DbGroupDropTarget
    implements DnDTarget {
        private final String myGroupName;

        public DbGroupDropTarget(@NotNull String groupName) {
            if (groupName == null) {
                DbGroupDropTarget.$$$reportNull$$$0(0);
            }
            this.myGroupName = groupName;
        }

        public void drop(DnDEvent event) {
            List dataSources = DbGroupDropTarget.getDataSources(event).toList();
            DbDataSource first2 = (DbDataSource)ContainerUtil.getFirstItem((Collection)dataSources);
            if (first2 == null) {
                return;
            }
            Project project = first2.getProject();
            DvTreeStructureService tss = (DvTreeStructureService)project.getService(DvTreeStructureService.class);
            for (DbDataSource dataSource2 : dataSources) {
                AbstractDataSource ds = (AbstractDataSource)dataSource2.getDelegate();
                ds.setGroupName(this.myGroupName);
                tss.notifyDataSourcePathChanged(ds);
            }
            DatabaseView.refreshViewAndSelect(project, dataSources);
        }

        public boolean update(DnDEvent event) {
            return DbGroupDropTarget.getDataSources(event).isNotEmpty();
        }

        @NotNull
        private static JBIterable<DbDataSource> getDataSources(DnDEvent event) {
            block4: {
                JBIterable jBIterable;
                try {
                    JBIterable result2;
                    Object data = event.getTransferData(DnDEventImpl.ourDataFlavor);
                    if (!(data instanceof Object[]) || !(result2 = JBIterable.of((Object[])((Object[])data)).map(o -> o instanceof DataSourceNode ? ((DataSourceNode)o).dbDataSource : o)).filter(o -> !(o instanceof DbDataSource)).isEmpty()) break block4;
                    jBIterable = result2.filter(DbDataSource.class);
                }
                catch (UnsupportedFlavorException | IOException exception) {
                    // empty catch block
                }
                if (jBIterable == null) {
                    DbGroupDropTarget.$$$reportNull$$$0(1);
                }
                return jBIterable;
            }
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbGroupDropTarget.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceUiUtil$DbGroupDropTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceUiUtil$DbGroupDropTarget";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

