/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseDriverCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DatabaseDriver
extends DatabaseDriverCore {
    public static final DatabaseDriverCore.Option<Boolean> OPTION_AUTO_COMMIT = new DatabaseDriverCore.Option<Boolean>("auto-commit", true);
    public static final DatabaseDriverCore.Option<Boolean> OPTION_AUTO_SYNC = new DatabaseDriverCore.Option<Boolean>("auto-sync", true);
    public static final DatabaseDriverCore.Option<Boolean> OPTION_FORMAT_SOURCES_ON_SYNC = new DatabaseDriverCore.Option<Boolean>("format-sources-on-sync", true);
    public static final DatabaseDriverCore.Option<Boolean> OPTION_SEND_APP_INFO = new DatabaseDriverCore.Option<Boolean>("send-app-info", true);
    public static final DatabaseDriverCore.Option<SchemaControl> OPTION_SCHEMA_CONTROL = new DatabaseDriverCore.Option<SchemaControl>("schema-control", SchemaControl.AUTOMATIC);
    public static final DatabaseDriverCore.Option<DBIntrospectionOptions.SourceLoading> OPTION_SOURCE_LOADING = new DatabaseDriverCore.Option<DBIntrospectionOptions.SourceLoading>("source-loading", DBIntrospectionOptions.SourceLoading.USER_SOURCES);

    @NlsSafe
    @NotNull
    public String getName();

    @NlsSafe
    @Nullable
    public String getComment();

    @NotNull
    public EnumSet<StatelessJdbcUrlParser.LocationType> getSupportedLocations();

    public boolean matchesUrl(@NotNull String var1);

    @NotNull
    public String getSampleUrl();

    public Map<String, String> getDriverProperties();

    public Map<String, String> getVmEnv();

    @NotNull
    public List<ArtifactRef> getArtifacts();

    public List<SimpleClasspathElement> getNativeLibraryPaths();

    public List<SimpleClasspathElement> getClasspathElements();

    public List<SimpleClasspathElement> getAdditionalClasspathElements();

    public LocalDataSource createDataSource(@Nullable String var1);

    public void setAdditionalClasspathElements(List<SimpleClasspathElement> var1);

    @NotNull
    public DatabaseDriver copy(@Nullable String var1, boolean var2);

    public static interface ArtifactRef {
        @NotNull
        public String getId();

        @Nullable
        public Version getArtifactVersion();

        public String getChannel();
    }
}

