/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.autoconfig.DataSourceConfiguration;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.BasicDataSourceManager;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalDataSourceManager
extends BasicDataSourceManager<LocalDataSource> {
    private static final String LRU_KEY = "DatabaseDriversLRU";
    private final DataSourceStorage myProjectStorage;

    @NotNull
    public static LocalDataSourceManager getInstance(@NotNull Project project) {
        if (project == null) {
            LocalDataSourceManager.$$$reportNull$$$0(0);
        }
        LocalDataSourceManager localDataSourceManager = Objects.requireNonNull((LocalDataSourceManager)ContainerUtil.findInstance((Iterable)EP_NAME.getExtensions((AreaInstance)project), LocalDataSourceManager.class));
        if (localDataSourceManager == null) {
            LocalDataSourceManager.$$$reportNull$$$0(1);
        }
        return localDataSourceManager;
    }

    public LocalDataSourceManager(@NotNull Project project) {
        if (project == null) {
            LocalDataSourceManager.$$$reportNull$$$0(2);
        }
        super(project, DataSourceStorage.getProjectStorage(project).getDataSources());
        this.myProjectStorage = DataSourceStorage.getProjectStorage(project);
        project.getMessageBus().connect().subscribe(DataSourceStorage.TOPIC, (Object)new DataSourceStorage.Listener(){

            @Override
            public void dataSourceAdded(@NotNull LocalDataSource dataSource2) {
                if (dataSource2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                LocalDataSourceManager.this.attachDataSource(dataSource2);
            }

            @Override
            public void dataSourceRemoved(@NotNull LocalDataSource dataSource2) {
                if (dataSource2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                LocalDataSourceManager.this.detachDataSource(dataSource2);
            }

            @Override
            public void dataSourceChanged(@Nullable LocalDataSource dataSource2) {
                if (dataSource2 == null) {
                    LocalDataSourceManager.this.resetElementMap(LocalDataSourceManager.this.myProjectStorage.getDataSources());
                } else {
                    LocalDataSourceManager.this.updateDataSource(dataSource2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataSource";
                objectArray2[1] = "com/intellij/database/dataSource/LocalDataSourceManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void addDataSource(@NotNull LocalDataSource element2) {
        if (element2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(3);
        }
        this.myProjectStorage.addDataSource(element2);
    }

    @Override
    public void removeDataSource(@NotNull LocalDataSource element2) {
        if (element2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(4);
        }
        this.myProjectStorage.removeDataSource(element2);
    }

    @Override
    public void renameDataSource(@NotNull LocalDataSource element2, @NotNull String name) {
        if (element2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(5);
        }
        if (name == null) {
            LocalDataSourceManager.$$$reportNull$$$0(6);
        }
        element2.setName(name);
        this.myProjectStorage.updateDataSource(element2);
    }

    @Override
    @NotNull
    public Configurable createDataSourceEditor(@NotNull LocalDataSource element2) {
        if (element2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(7);
        }
        return new DataSourceConfigurable(this, element2, this.myProject);
    }

    @Override
    @NotNull
    public AnAction getCreateDataSourceAction(@NotNull Consumer<? super LocalDataSource> consumer2) {
        if (consumer2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(8);
        }
        List<AnAction> actions = this.getCreateDataSourceActions(DatabaseDriverManager.getInstance().getDrivers(), consumer2);
        DefaultActionGroup group = new DefaultActionGroup(DatabaseBundle.messagePointer("default.datasource.name", new Object[0]), actions){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.update(e);
                if (!DatabaseViewActions.isDataSourceActionsEnabled(e)) {
                    e.getPresentation().setEnabledAndVisible(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/LocalDataSourceManager$2", "update"));
            }
        };
        group.setPopup(true);
        group.getTemplatePresentation().setIcon(DatabaseIcons.Dbms);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            LocalDataSourceManager.$$$reportNull$$$0(9);
        }
        return defaultActionGroup;
    }

    @NotNull
    public List<AnAction> getCreateDataSourceActions(@NotNull Collection<? extends DatabaseDriver> allDrivers, @NotNull Consumer<? super LocalDataSource> consumer2) {
        if (allDrivers == null) {
            LocalDataSourceManager.$$$reportNull$$$0(10);
        }
        if (consumer2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(11);
        }
        List<String> lruNames = DatabaseViewActions.getLRUNames(this.myProject, LRU_KEY);
        Comparator<DatabaseDriver> comparator2 = Comparator.comparing(LocalDataSourceManager::getDisplayDriverName);
        LinkedHashMap<String, DatabaseDriver> fromLru = new LinkedHashMap<String, DatabaseDriver>();
        LinkedHashMap<String, DatabaseDriver> completeSupport = new LinkedHashMap<String, DatabaseDriver>();
        LinkedHashMap<String, DatabaseDriver> userCreated = new LinkedHashMap<String, DatabaseDriver>();
        LinkedHashMap<String, DatabaseDriver> basicSupport = new LinkedHashMap<String, DatabaseDriver>();
        for (DatabaseDriver databaseDriver : allDrivers) {
            String key = this.getDriverKey(databaseDriver);
            if (lruNames.contains(key)) {
                fromLru.putIfAbsent(key, databaseDriver);
                if (!databaseDriver.isPredefined() || !LocalDataSourceManager.isGenericSupport(databaseDriver)) continue;
                basicSupport.putIfAbsent(key, databaseDriver);
                continue;
            }
            if (!databaseDriver.isPredefined()) {
                userCreated.putIfAbsent(key, databaseDriver);
                continue;
            }
            if (!LocalDataSourceManager.isGenericSupport(databaseDriver)) {
                completeSupport.putIfAbsent(key, databaseDriver);
                continue;
            }
            basicSupport.putIfAbsent(key, databaseDriver);
        }
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        this.addActions(Separator.create((String)DatabaseBundle.message("separator.data.sources.recent", new Object[0])), result2, fromLru.values(), Comparator.comparingInt(o -> lruNames.indexOf(this.getDriverKey((DatabaseDriver)o))).thenComparing(o -> LocalDataSourceManager.getDisplayDriverName(o)), consumer2);
        this.addActions(Separator.create((String)DatabaseBundle.message("separator.user.drivers", new Object[0])), result2, userCreated.values(), comparator2, consumer2);
        this.addActions(Separator.create((String)DatabaseBundle.message("separator.complete.support", new Object[0])), result2, completeSupport.values(), comparator2, consumer2);
        if (!basicSupport.isEmpty()) {
            result2.add((AnAction)Separator.getInstance());
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup(DatabaseBundle.message("action.data.sources.other.text", new Object[0]), true);
            result2.add((AnAction)defaultActionGroup);
            defaultActionGroup.addSeparator(DatabaseBundle.message("separator.basic.support", new Object[0]));
            Comparator<DatabaseDriver> bc = Comparator.comparing(d2 -> LocalDataSourceManager.getExtraSection(d2), Comparing::compare).thenComparing(comparator2);
            String ps = null;
            for (DatabaseDriver driver : ContainerUtil.sorted(basicSupport.values(), bc)) {
                String section = LocalDataSourceManager.getExtraSection(driver);
                if (!Objects.equals(ps, section)) {
                    defaultActionGroup.addSeparator(section);
                    ps = section;
                }
                defaultActionGroup.add((AnAction)this.createAction(consumer2, driver));
            }
        }
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            LocalDataSourceManager.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public static boolean isGenericSupport(DatabaseDriver driver) {
        return DbImplUtil.isGenericSupport(DbImplUtilCore.getDbms(driver)) || LocalDataSourceManager.getExtraSection(driver) != null;
    }

    @NlsSafe
    @Nullable
    public static String getExtraSection(DatabaseDriver d2) {
        String comment = d2.getComment();
        return comment != null && comment.endsWith("drivers.xml") ? comment : null;
    }

    public void addActions(@Nullable Separator separator, List<? super AnAction> result2, Iterable<? extends DatabaseDriver> drivers, Comparator<? super DatabaseDriver> comparator2, @NotNull Consumer<? super LocalDataSource> consumer2) {
        if (consumer2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(13);
        }
        if (separator != null) {
            result2.add((AnAction)separator);
        }
        for (DatabaseDriver driver : ContainerUtil.sorted(drivers, comparator2)) {
            result2.add((AnAction)this.createAction(consumer2, driver));
        }
    }

    @NotNull
    private DumbAwareAction createAction(final @NotNull Consumer<? super LocalDataSource> consumer2, final DatabaseDriver driver) {
        if (consumer2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(14);
        }
        return new DumbAwareAction(LocalDataSourceManager.getDisplayDriverName(driver), null, driver.getIcon(0)){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                DatabaseViewActions.addToLRUNames(LocalDataSourceManager.this.myProject, 5, LocalDataSourceManager.LRU_KEY, LocalDataSourceManager.this.getDriverKey(driver));
                consumer2.consume((Object)driver.createDataSource(null));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/LocalDataSourceManager$3", "actionPerformed"));
            }
        };
    }

    public String getDriverKey(DatabaseDriver o) {
        return o.isPredefined() && LocalDataSourceManager.getExtraSection(o) == null ? LocalDataSourceManager.predefinedDriverKey(o) : o.getId();
    }

    private static String predefinedDriverKey(DatabaseDriver o) {
        String beforeDot = StringUtil.notNullize((String)StringUtil.substringBefore((String)o.getId(), (String)"."), (String)o.getId());
        return StringUtil.trimEnd((String)beforeDot, (String)"_aurora");
    }

    @NlsActions.ActionText
    @NotNull
    private static String getDisplayDriverName(DatabaseDriver o) {
        if (!o.isPredefined() || LocalDataSourceManager.getExtraSection(o) != null) {
            String string = o.getName();
            if (string == null) {
                LocalDataSourceManager.$$$reportNull$$$0(15);
            }
            return string;
        }
        Dbms dbms = DbImplUtilCore.getDbms(o);
        String string = dbms == Dbms.UNKNOWN ? o.getName() : dbms.getDisplayName();
        if (string == null) {
            LocalDataSourceManager.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Override
    @NotNull
    public LocalDataSource copyDataSource(@NotNull String newName, @NotNull LocalDataSource copyFrom) {
        if (newName == null) {
            LocalDataSourceManager.$$$reportNull$$$0(17);
        }
        if (copyFrom == null) {
            LocalDataSourceManager.$$$reportNull$$$0(18);
        }
        LocalDataSource result2 = copyFrom.copy(false);
        result2.setName(StringUtil.notNullize((String)newName));
        LocalDataSource localDataSource = result2;
        if (localDataSource == null) {
            LocalDataSourceManager.$$$reportNull$$$0(19);
        }
        return localDataSource;
    }

    @Override
    public boolean canCreateDataSourceByFiles(@NotNull Collection<VirtualFile> files2) {
        if (files2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(20);
        }
        for (VirtualFile file : files2) {
            if (!(file.getFileType() instanceof DbStorageFileType)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<LocalDataSource> createDataSourceByFiles(@NotNull List<VirtualFile> files2) {
        if (files2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(21);
        }
        final ArrayList<LocalDataSource> result2 = new ArrayList<LocalDataSource>();
        DataSourceRegistry registry = new DataSourceRegistry(this.myProject);
        registry.setImportedFlag(false);
        DataSourceDetector.Callback callback = new DataSourceDetector.Callback(){

            @Override
            public void onCreated(@NotNull DasDataSource dataSource2) {
                if (dataSource2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                result2.add((LocalDataSource)dataSource2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/LocalDataSourceManager$4", "onCreated"));
            }
        };
        for (VirtualFile file : files2) {
            FileType fileType = file.getFileType();
            if (!(fileType instanceof DbStorageFileType)) continue;
            Dbms dbms = ((DbStorageFileType)fileType).getDbms();
            String defaultName = DbUtil.generateUniqueDataSourceName(this.myProject, file.getNameWithoutExtension());
            final String path = VfsUtilCore.virtualToIoFile((VirtualFile)file).getAbsolutePath();
            DataSourceConfigUtil.buildDataSource(dbms, defaultName, null, null, new DataSourceConfiguration(){

                @Override
                public String getDatabase() {
                    return path;
                }
            }, registry.getBuilder().withCallback(callback));
        }
        DataSourceConfigUtil.configureDetectedDataSources(this.myProject, registry, true, true);
        DataSourceConfigUtil.refreshTablesInBackground(this.myProject, registry.getDataSources());
        ArrayList<LocalDataSource> arrayList = result2;
        if (arrayList == null) {
            LocalDataSourceManager.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @Override
    public boolean isMyDataSource(@NotNull Class<? extends DasDataSource> clazz) {
        if (clazz == null) {
            LocalDataSourceManager.$$$reportNull$$$0(23);
        }
        return LocalDataSource.class.isAssignableFrom(clazz);
    }

    public void fireDataSourceUpdated(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(24);
        }
        this.myProjectStorage.updateDataSource(dataSource2);
    }

    @Override
    @Nullable
    public DatabaseDialectEx getDatabaseDialect(@NotNull LocalDataSource element2) {
        if (element2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(25);
        }
        return (DatabaseDialectEx)ObjectUtils.tryCast((Object)DbImplUtilCore.guessDatabaseDialect(element2), DatabaseDialectEx.class);
    }

    @Override
    @Nullable
    public Language getQueryLanguage(LocalDataSource element2) {
        return DbSqlUtilCore.findLanguage(element2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/LocalDataSourceManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDrivers";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFrom";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/LocalDataSourceManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateDataSourceAction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateDataSourceActions";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayDriverName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "copyDataSource";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceByFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 22: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addDataSource";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeDataSource";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renameDataSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceEditor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDataSourceAction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDataSourceActions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createAction";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "copyDataSource";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "canCreateDataSourceByFiles";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceByFiles";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isMyDataSource";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fireDataSourceUpdated";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

