/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.data.types.PredicatesHelperKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.CellColors;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataAuditors;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridPositionWidget;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.IndexSet;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.NamedRow;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.ExtractionConfigKt;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.actions.TransactionAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.ResultView;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.CellAttributesKey;
import com.intellij.database.run.ui.grid.GridMainPanel;
import com.intellij.database.run.ui.grid.GridScrollPositionManager;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.database.run.ui.treetable.TreeTableResultView;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarInfo;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.TwoSideComponent;
import com.intellij.ui.content.Content;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataGridUtil
extends DataGridUtilCore {
    public static final Logger LOG = Logger.getInstance(DataGridUtil.class);

    private DataGridUtil() {
    }

    @Nullable
    public static DataGrid getDataGrid(DataContext dataContext) {
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        if (editor instanceof TableEditorBase) {
            return ((TableEditorBase)editor).getDataGrid();
        }
        return (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(dataContext);
    }

    @NotNull
    public static DataGrid createDataGrid(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp, @NotNull ActionGroup popupActions) {
        if (project == null) {
            DataGridUtil.$$$reportNull$$$0(0);
        }
        if (dataHookUp == null) {
            DataGridUtil.$$$reportNull$$$0(1);
        }
        if (popupActions == null) {
            DataGridUtil.$$$reportNull$$$0(2);
        }
        return new TableResultPanel(project, dataHookUp, popupActions);
    }

    public static DataGrid createPreviewDataGrid(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp) {
        if (project == null) {
            DataGridUtil.$$$reportNull$$$0(3);
        }
        if (dataHookUp == null) {
            DataGridUtil.$$$reportNull$$$0(4);
        }
        ActionGroup popup2 = (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.Csv.PreviewPopupGroup");
        ActionGroup columnHeaderActions = (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.Csv.PreviewColumnHeaderPopup");
        return new TableResultPanel(project, dataHookUp, popup2, popup2, columnHeaderActions, ActionGroup.EMPTY_GROUP, null, false);
    }

    @NotNull
    public static ModelIndex<DataConsumer.Column> findColumn(@NotNull DataGrid dataGrid, @Nullable String name) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(5);
        }
        return DataGridUtil.findColumn(dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS), name, true);
    }

    @NotNull
    public static ModelIndex<DataConsumer.Column> findColumn(@NotNull GridModel<DataConsumer.Row, DataConsumer.Column> gridModel, @Nullable String name, boolean caseSensitive) {
        if (gridModel == null) {
            DataGridUtil.$$$reportNull$$$0(6);
        }
        for (ModelIndex c2 : gridModel.getColumnIndices().asIterable()) {
            DataConsumer.Column column2 = gridModel.getColumn(c2);
            if (column2 == null || !Comparing.strEqual((String)name, (String)column2.name, (boolean)caseSensitive)) continue;
            ModelIndex modelIndex = c2;
            if (modelIndex == null) {
                DataGridUtil.$$$reportNull$$$0(7);
            }
            return modelIndex;
        }
        ModelIndex<DataConsumer.Column> modelIndex = ModelIndex.forColumn(gridModel, -1);
        if (modelIndex == null) {
            DataGridUtil.$$$reportNull$$$0(8);
        }
        return modelIndex;
    }

    public static void updateWidgets(@Nullable DataGrid grid) {
        GridPositionWidget.Listener listener2 = (GridPositionWidget.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(GridPositionWidget.TOPIC);
        if (grid == null) {
            listener2.closed();
            return;
        }
        listener2.changed(grid);
    }

    @NlsSafe
    @NotNull
    public static String getSqlType(@NotNull DataGrid grid, @Nullable DataConsumer.Column column2) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(9);
        }
        if (column2 == null) {
            return "";
        }
        String typeNameSafe = StringUtil.notNullize((String)column2.typeName);
        DatabaseGridDataHookUp hookUp = DataGridUtil.getDatabaseHookUp(grid);
        if (hookUp == null) {
            String string = typeNameSafe;
            if (string == null) {
                DataGridUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        DasColumn dasColumn = DataGridUtil.getDatabaseColumn(grid, column2);
        if (dasColumn != null) {
            String string = dasColumn.getDataType().getSpecification();
            if (string == null) {
                DataGridUtil.$$$reportNull$$$0(11);
            }
            return string;
        }
        DataType type = DataTypeFactory.of(column2.schema, typeNameSafe, column2.precision, column2.scale, null, null, false, false, column2.type);
        String string = hookUp.getDatabaseDialect().getTypeName(type);
        if (string == null) {
            DataGridUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static void focusDataGrid(DataGrid grid) {
        if (grid != null) {
            JComponent toFocus = grid.getPreferredFocusedComponent();
            IdeFocusManager.findInstanceByComponent((Component)toFocus).requestFocus((Component)toFocus, true);
        }
    }

    public static void setupProgressIndicatingAuditor(final @NotNull DataGrid grid) {
        DataRequest.OwnerEx ownerEx;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(13);
        }
        if ((ownerEx = (DataRequest.OwnerEx)ObjectUtils.tryCast(grid.getDataHookup(), DataRequest.OwnerEx.class)) == null) {
            return;
        }
        ownerEx.getMessageBus().addAuditor(new DataAuditors.Adapter(){

            @Override
            public void print(@NotNull DataRequest.Context context, @Nullable String message2) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (message2 != null && message2.contains("retrieved starting")) {
                    return;
                }
                ((StatusBarInfo)DataGridUtil.getProject(grid).getMessageBus().syncPublisher(StatusBar.Info.TOPIC)).setInfo(message2);
            }

            @Override
            public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
                if (request == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (producer == null) {
                    1.$$$reportNull$$$0(2);
                }
                DataGridUtil.setProgressMessage(grid, DatabaseBundle.message("DataView.connecting", new Object[0]));
            }

            @Override
            public void requestStarted(@NotNull DataRequest.Context context) {
                if (context == null) {
                    1.$$$reportNull$$$0(3);
                }
                DataGridUtil.setProgressMessage(grid, DatabaseBundle.message("DataView.processing", new Object[0]));
            }

            @Override
            public void beforeStatement(@NotNull DataRequest.Context context) {
                if (context == null) {
                    1.$$$reportNull$$$0(4);
                }
                DataGridUtil.setProgressMessage(grid, DatabaseBundle.message("DataView.querying", new Object[0]));
            }

            @Override
            public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
                if (request == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (producer == null) {
                    1.$$$reportNull$$$0(6);
                }
                DataGridUtil.setProgressMessage(grid, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "request";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "producer";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/datagrid/DataGridUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "print";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jobSubmitted";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "requestStarted";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeStatement";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jobFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static void setProgressMessage(@NotNull DataGrid grid, @Nls @Nullable String message2) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(14);
        }
        DbImplUtil.invokeLaterIfNeeded(() -> {
            JBLoadingPanel loadingPanel = grid.getLoadingPanel();
            if (message2 != null) {
                loadingPanel.startLoading();
            } else {
                loadingPanel.stopLoading();
            }
            loadingPanel.setLoadingText(message2);
        });
    }

    @Contract(value="null->null;!null->_")
    public static DasTable getDatabaseTable(@Nullable DataGrid grid) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        return hookup != null ? hookup.getDatabaseTable() : null;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@Nullable DataGrid grid) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        DatabaseDialectEx databaseDialectEx = hookup != null ? hookup.getDatabaseDialect() : DatabaseDialects.getGenericDialect();
        if (databaseDialectEx == null) {
            DataGridUtil.$$$reportNull$$$0(15);
        }
        return databaseDialectEx;
    }

    @NotNull
    public static Dbms getDbms(@Nullable DataGrid grid) {
        return DataGridUtil.getDbms((CoreGrid<DataConsumer.Row, DataConsumer.Column>)grid);
    }

    @NotNull
    public static Dbms getDbms(@Nullable CoreGrid<DataConsumer.Row, DataConsumer.Column> grid) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        Dbms dbms = hookup == null ? Dbms.UNKNOWN : ((LocalDataSource)hookup.getSession().getTarget()).getDbms();
        if (dbms == null) {
            DataGridUtil.$$$reportNull$$$0(16);
        }
        return dbms;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DataGrid grid) {
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect(DataGridUtil.getDbms(grid));
        if (sqlLanguageDialect == null) {
            DataGridUtil.$$$reportNull$$$0(17);
        }
        return sqlLanguageDialect;
    }

    @Contract(value="null->null;!null->_")
    public static DbDataSource getDatabaseSystem(@Nullable DataGrid grid) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        return hookup != null ? hookup.getDataSource() : null;
    }

    public static int getResultSetIndex(@Nullable DataGrid grid) {
        DataBusGridDataHookUp dataBusHookup = DataGridUtil.getDataBusHookUp(grid);
        return dataBusHookup != null ? dataBusHookup.getResultSetIndex() : 1;
    }

    @Contract(value="null->null;!null->_")
    public static String getQueryText(@Nullable DataGrid grid) {
        DataBusGridDataHookUp dataBusHookUp = DataGridUtil.getDataBusHookUp(grid);
        return dataBusHookUp != null ? dataBusHookUp.getQueryText() : null;
    }

    public static DataBusGridDataHookUp getDataBusHookUp(@Nullable DataGrid grid) {
        return DataGridUtil.getHookUp(grid, DataBusGridDataHookUp.class);
    }

    public static DatabaseGridDataHookUp getDatabaseHookUp(@Nullable CoreGrid<DataConsumer.Row, DataConsumer.Column> grid) {
        return DataGridUtil.getHookUp(grid, DatabaseGridDataHookUp.class);
    }

    public static DataGridSessionClient getDataGridClient(@Nullable DataGrid grid) {
        return DataGridUtil.getHookUp(grid, DataGridSessionClient.class);
    }

    @Nullable
    public static VirtualFile getVirtualFile(@Nullable DataGrid grid) {
        return grid == null ? null : DataGridUtil.getVirtualFile(grid.getDataHookup());
    }

    @Nullable
    public static VirtualFile getVirtualFile(@Nullable GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookup) {
        if (hookup instanceof DocumentDataHookUp) {
            Document document = ((DocumentDataHookUp)hookup).getDocument();
            return FileDocumentManager.getInstance().getFile(document);
        }
        if (hookup instanceof DatabaseTableGridDataHookUp) {
            return ((DatabaseTableGridDataHookUp)hookup).getVirtualFile();
        }
        return null;
    }

    @Nullable
    public static DocumentDataHookUp getDocumentDataHookUp(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(18);
        }
        return DataGridUtil.getHookUp(grid, DocumentDataHookUp.class);
    }

    @NotNull
    public static JComponent addGridHeaderComponent(@NotNull DataGrid dataGrid, @Nullable VirtualFile virtualFile) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(19);
        }
        return DataGridUtil.addGridHeaderComponent(dataGrid, virtualFile, "Console.EditorTableResult.Group");
    }

    @NotNull
    public static JComponent addGridHeaderComponent(@NotNull DataGrid dataGrid, @Nullable VirtualFile virtualFile, @NotNull String actionGroupName) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(20);
        }
        if (actionGroupName == null) {
            DataGridUtil.$$$reportNull$$$0(21);
        }
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup actions = (ActionGroup)actionManager.getAction(actionGroupName);
        ActionGroup secondaryActions = (ActionGroup)actionManager.getAction("Console.TableResult.Group.Secondary");
        ActionToolbar toolbar2 = actionManager.createActionToolbar("EditorToolbar", actions, true);
        ActionToolbar toolbarSecondary = actionManager.createActionToolbar("EditorToolbar", secondaryActions, true);
        toolbar2.setTargetComponent((JComponent)((Object)dataGrid.getComponent()));
        toolbarSecondary.setTargetComponent((JComponent)((Object)dataGrid.getComponent()));
        toolbarSecondary.setReservePlaceAutoPopupIcon(false);
        TwoSideComponent header = new TwoSideComponent(toolbar2.getComponent(), toolbarSecondary.getComponent());
        header.setBorder(new CompoundBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0), (Border)JBUI.Borders.empty((int)1, (int)0, (int)0, (int)5)));
        toolbar2.getComponent().setBorder((Border)JBUI.Borders.empty());
        toolbarSecondary.getComponent().setBorder((Border)JBUI.Borders.empty());
        dataGrid.setTopComponent((Component)header);
        if (dataGrid.isFilteringSupported()) {
            dataGrid.setSecondTopComponent((Component)((Object)dataGrid.getFilterComponent()));
        }
        DatabaseEditorHelper.configureEditorHeader(DataGridUtil.getProject(dataGrid), virtualFile, (JComponent)header);
        TwoSideComponent twoSideComponent = header;
        if (twoSideComponent == null) {
            DataGridUtil.$$$reportNull$$$0(22);
        }
        return twoSideComponent;
    }

    public static void configureNumericEditor(@NotNull DataGrid grid, @NotNull Editor editor) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(23);
        }
        if (editor == null) {
            DataGridUtil.$$$reportNull$$$0(24);
        }
        if (!(editor instanceof EditorImpl)) {
            return;
        }
        EditorImpl editorImpl = (EditorImpl)editor;
        boolean regular = !grid.getResultView().isTransposed() && grid.getResultView() instanceof TableResultView;
        int textAlignment = regular ? 1 : 0;
        int scrollbarOrientation = regular ? 0 : 1;
        editorImpl.setHorizontalTextAlignment(textAlignment);
        editorImpl.setVerticalScrollbarOrientation(scrollbarOrientation);
    }

    public static boolean canBuildWhereClause(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(25);
        }
        GridModel model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        List columns = model.getColumns();
        DasTable table = DataGridUtil.getDatabaseTable(grid);
        return !DbImplUtil.getWhereClauseColumns(table, columns, DataGridUtil.getDbms(grid)).isEmpty();
    }

    public static ActionGroup getGridPopupActions() {
        return (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.PopupGroup");
    }

    public static ActionGroup getGridColumnHeaderPopupActions() {
        return (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.ColumnHeaderPopup");
    }

    public static DataConsumer createEDTSafeWrapper(final @NotNull DataConsumer handler, @NotNull Disposable disposableParent) {
        if (handler == null) {
            DataGridUtil.$$$reportNull$$$0(26);
        }
        if (disposableParent == null) {
            DataGridUtil.$$$reportNull$$$0(27);
        }
        final MergingUpdateQueue queue = new MergingUpdateQueue("DataConsumer[EDT]", 300, true, MergingUpdateQueue.ANY_COMPONENT, disposableParent);
        return new DataConsumer(){
            DataConsumer.Column[] columns;

            @Override
            public void setColumns(final @NotNull DataRequest.Context context, final int resultSetIndex, final DataConsumer.Column @NotNull [] columns, final int firstRowNum) {
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (columns == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.columns = columns;
                queue.queue(new Update("init"){

                    public void run() {
                        handler.setColumns(context, resultSetIndex, columns, firstRowNum);
                    }
                });
            }

            @Override
            public void updateColumns(final @NotNull DataRequest.Context context, final DataConsumer.Column @NotNull [] columns) {
                if (context == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (columns == null) {
                    2.$$$reportNull$$$0(3);
                }
                this.columns = columns;
                queue.queue(new Update("updateColumns"){

                    public void run() {
                        handler.updateColumns(context, columns);
                    }
                });
            }

            @Override
            public void addRows(final @NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
                if (context == null) {
                    2.$$$reportNull$$$0(4);
                }
                Dbms dbms = (Dbms)ObjectUtils.chooseNotNull((Object)TransactionAction.getDbms(context.request.owner), (Object)Dbms.UNKNOWN);
                ObjectFormatter.convertRows(rows, Arrays.asList(this.columns), dbms);
                class AddRows
                extends Update {
                    final List<List<DataConsumer.Row>> rows;

                    AddRows(List<DataConsumer.Row> rows) {
                        super(new Object());
                        this.rows = new SmartList();
                        this.rows.add(rows);
                    }

                    public boolean canEat(Update update2) {
                        if (update2 instanceof AddRows) {
                            this.rows.addAll(((AddRows)update2).rows);
                            return true;
                        }
                        return false;
                    }

                    public void run() {
                        List combined = this.rows.size() == 1 ? this.rows.get(0) : ContainerUtil.concat((List[])this.rows.toArray(new List[0]));
                        handler.addRows(context, combined);
                    }
                }
                queue.queue((Update)new AddRows(rows));
            }

            @Override
            public void afterLastRowAdded(final @NotNull DataRequest.Context context, final int total) {
                if (context == null) {
                    2.$$$reportNull$$$0(5);
                }
                this.columns = null;
                queue.queue(new Update("afterLastRowAdded"){

                    public void run() {
                        handler.afterLastRowAdded(context, total);
                    }
                });
                queue.flush();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "columns";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/datagrid/DataGridUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setColumns";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateColumns";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addRows";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterLastRowAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public static ReservedCellValue getDefaultNullValue(@NotNull DataGrid grid, @Nullable ModelIndex<DataConsumer.Column> columnIdx) {
        DataConsumer.Column column2;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(28);
        }
        DataConsumer.Column column3 = column2 = columnIdx == null ? null : grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(columnIdx);
        if (DbImplUtilCore.isRowId(column2)) {
            return ReservedCellValue.COMPUTED;
        }
        DasColumn dasColumn = DataGridUtil.getDatabaseColumn(grid, column2);
        return DataGridUtil.getDefaultNullValue(dasColumn, DataGridUtil.getDbms(grid));
    }

    @Nullable
    public static DasColumn getDatabaseColumn(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(29);
        }
        if (columnIdx == null) {
            DataGridUtil.$$$reportNull$$$0(30);
        }
        DataConsumer.Column column2 = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(columnIdx);
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        return hookup != null ? hookup.getDatabaseColumn(column2) : null;
    }

    @NotNull
    public static List<RowMutation> mergeAll(@NotNull List<? extends CellMutation> mutations, @NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model) {
        if (mutations == null) {
            DataGridUtil.$$$reportNull$$$0(31);
        }
        if (model == null) {
            DataGridUtil.$$$reportNull$$$0(32);
        }
        ArrayList<? extends CellMutation> copy = new ArrayList<CellMutation>(mutations);
        ArrayList<RowMutation> rowMutations = new ArrayList<RowMutation>();
        while (!copy.isEmpty()) {
            rowMutations.add(DataGridUtil.merge(copy, model));
        }
        List<RowMutation> list = rowMutations.stream().filter(Objects::nonNull).sorted().collect(Collectors.toList());
        if (list == null) {
            DataGridUtil.$$$reportNull$$$0(33);
        }
        return list;
    }

    @Nullable
    private static RowMutation merge(@NotNull List<? extends CellMutation> mutations, @NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model) {
        CellMutation item;
        if (mutations == null) {
            DataGridUtil.$$$reportNull$$$0(34);
        }
        if (model == null) {
            DataGridUtil.$$$reportNull$$$0(35);
        }
        if ((item = (CellMutation)ContainerUtil.getFirstItem(mutations)) == null) {
            throw new IllegalStateException("Shouldn't call merge() when there is no pending changes");
        }
        mutations.remove(item);
        List toMerge = ContainerUtil.filter(mutations, item::canMergeByRowWith);
        mutations.removeAll(toMerge);
        RowMutation merged = item.createRowMutation(model);
        for (CellMutation mutation : toMerge) {
            if (merged == null) {
                merged = mutation.createRowMutation(model);
                continue;
            }
            merged = merged.merge(mutation.createRowMutation(model));
        }
        return merged;
    }

    @Nullable
    public static ReservedCellValue getDefaultNullValue(@Nullable DasColumn dasColumn, @NotNull Dbms dbms) {
        EnumSet<ReservedCellValue> opts;
        if (dbms == null) {
            DataGridUtil.$$$reportNull$$$0(36);
        }
        return (opts = DbImplUtil.getSpecialValues(dasColumn, dbms)).contains((Object)ReservedCellValue.UNSET) ? ReservedCellValue.UNSET : (opts.contains((Object)ReservedCellValue.GENERATED) ? ReservedCellValue.GENERATED : (opts.contains((Object)ReservedCellValue.COMPUTED) ? ReservedCellValue.COMPUTED : (opts.contains((Object)ReservedCellValue.DEFAULT) ? ReservedCellValue.DEFAULT : (opts.contains((Object)ReservedCellValue.NULL) ? ReservedCellValue.NULL : null))));
    }

    public static Project getProject(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(37);
        }
        return grid instanceof TableResultPanel ? grid.getProject() : (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)((Object)grid.getComponent())));
    }

    public static PsiElement getPsiElementForSelection(@NotNull DataGrid grid) {
        SelectionModel selectionModel;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(38);
        }
        if ((selectionModel = grid.getSelectionModel()).isSelectionEmpty()) {
            return DataGridPomTarget.wrapDataGrid(DataGridUtil.getProject(grid), grid);
        }
        return DataGridPomTarget.wrapCell(DataGridUtil.getProject(grid), grid, selectionModel.getSelectedRows(), selectionModel.getSelectedColumns());
    }

    public static boolean isFailedToLoad(Object value2) {
        return value2 instanceof String && StringUtil.startsWith((CharSequence)((String)value2), (CharSequence)"<failed to load>");
    }

    public static boolean showIgnoreUnsubmittedChangesYesNoDialog(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(39);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        String title = DatabaseBundle.message("dialog.title.ignore.unsubmitted.changes", new Object[0]);
        String message2 = DatabaseBundle.message("dialog.message.changes.are.submitted.data.will.be.lost.continue", new Object[0]);
        return 0 == Messages.showYesNoDialog((Component)((Object)grid.getComponent()), (String)message2, (String)title, (Icon)AllIcons.General.NotificationWarning);
    }

    public static void showCannotApplyCellEditorChanges(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(40);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        String title = DatabaseBundle.message("dialog.title.cannot.apply.changes", new Object[0]);
        String message2 = DatabaseBundle.message("dialog.message.this.table.read.only.changes.cannot.be.applied", new Object[0]);
        Messages.showInfoMessage((Component)((Object)grid.getComponent()), (String)message2, (String)title);
    }

    @NotNull
    public static CharOut extractSelectedValues(@NotNull DataGrid dataGrid, @NotNull DataExtractor.Text extractor) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(41);
        }
        if (extractor == null) {
            DataGridUtil.$$$reportNull$$$0(42);
        }
        return DataGridUtil.extractValues(dataGrid, extractor, CharOut.Util.newSink(), true, true);
    }

    public static void extractSelectedValues(DataGrid dataGrid, DataExtractor.Text extractor, CharOut out) {
        DataGridUtil.extractValues(dataGrid, extractor, out, true, true);
    }

    @NotNull
    public static CharOut extractValues(@NotNull DataGrid dataGrid, @NotNull DataExtractor.Text extractor, @NotNull CharOut out, boolean selection, boolean transpositionAllowed) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(43);
        }
        if (extractor == null) {
            DataGridUtil.$$$reportNull$$$0(44);
        }
        if (out == null) {
            DataGridUtil.$$$reportNull$$$0(45);
        }
        GridModel model = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        int[] columns = (selection ? dataGrid.getSelectionModel().getSelectedColumns() : model.getColumnIndices()).asArray();
        List<DataConsumer.Row> rows = selection ? DataGridUtil.getSelectedRows(dataGrid) : model.getRows();
        Dbms dbms = DataGridUtil.getDbms(dataGrid);
        boolean transposed = transpositionAllowed && dataGrid.getResultView().isTransposed();
        ExtractorsUtil.extract(out, dbms, ExtractionConfigKt.builder().setTransposed(transposed).build(), model.getColumns(), extractor, rows, columns);
        CharOut charOut = out;
        if (charOut == null) {
            DataGridUtil.$$$reportNull$$$0(46);
        }
        return charOut;
    }

    @NotNull
    public static List<DataConsumer.Row> getSelectedRows(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(47);
        }
        ModelIndexSet rowIndices = dataGrid.getSelectionModel().getSelectedRows();
        GridModel model = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        List<DataConsumer.Row> rows = model.getRows(rowIndices);
        List<DataConsumer.Row> list = rows.isEmpty() ? model.getRows() : rows;
        if (list == null) {
            DataGridUtil.$$$reportNull$$$0(48);
        }
        return list;
    }

    public static Pair<RelativePoint, Balloon.Position> getBestPositionForBalloon(@NotNull DataGrid grid) {
        RelativePoint point;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(49);
        }
        ResultView view2 = grid.getResultView();
        Balloon.Position position = Balloon.Position.below;
        if (view2 instanceof TableResultView) {
            point = JBPopupFactory.getInstance().guessBestPopupLocation(view2.getComponent());
        } else if (view2 instanceof TreeTableResultView) {
            point = JBPopupFactory.getInstance().guessBestPopupLocation((JComponent)((TreeTableResultView)view2).getComponent().getTree());
        } else {
            GridMainPanel component = grid.getComponent();
            point = new RelativePoint((Component)((Object)component), new Point(component.getWidth() / 3, component.getHeight()));
            position = Balloon.Position.above;
        }
        return new Pair((Object)point, (Object)position);
    }

    @NotNull
    public static List<CellMutation> createMutations(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @Nullable Object value2) {
        if (rows == null) {
            DataGridUtil.$$$reportNull$$$0(50);
        }
        if (columns == null) {
            DataGridUtil.$$$reportNull$$$0(51);
        }
        ArrayList<CellMutation> mutations = new ArrayList<CellMutation>();
        for (ModelIndex rowIdx : rows.asIterable()) {
            for (ModelIndex columnIdx : columns.asIterable()) {
                mutations.add(new CellMutation(rowIdx, columnIdx, value2));
            }
        }
        ArrayList<CellMutation> arrayList = mutations;
        if (arrayList == null) {
            DataGridUtil.$$$reportNull$$$0(52);
        }
        return arrayList;
    }

    public static int min(@NotNull IndexSet<?> set) {
        OptionalInt min;
        if (set == null) {
            DataGridUtil.$$$reportNull$$$0(53);
        }
        return (min = set.asList().stream().mapToInt(Index::asInteger).min()).isPresent() ? min.getAsInt() : -1;
    }

    @NlsContexts.ColumnName
    @NotNull
    public static String getRowName(@NotNull DataGrid grid, int relativeIndex) {
        GridDataHookUp dataHookup;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(54);
        }
        boolean trueRows = (dataHookup = grid.getDataHookup()) instanceof CsvDocumentDataHookUp && ((CsvDocumentDataHookUp)dataHookup).getFormat().rowNumbers;
        ModelIndex<DataConsumer.Row> rowIndex = trueRows ? ViewIndex.forRow(grid, relativeIndex).toModel(grid) : ModelIndex.forRow(grid, relativeIndex);
        DataConsumer.Row row = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRow(rowIndex);
        String string = row instanceof NamedRow ? ((NamedRow)row).name : String.valueOf(row == null ? DatabaseBundle.message("column.name.not.applicable", new Object[0]) : Integer.valueOf(DataGridUtil.isInsertedRow(grid, rowIndex) ? DataGridUtil.getInsertedRowIdx(grid, relativeIndex) : row.getRowNum()));
        if (string == null) {
            DataGridUtil.$$$reportNull$$$0(55);
        }
        return string;
    }

    public static boolean isInsertedRow(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> index2) {
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(56);
        }
        if (index2 == null) {
            DataGridUtil.$$$reportNull$$$0(57);
        }
        return (mutator = DataGridUtil.getRowsMutator(grid)) != null && mutator.isInsertedRow(index2);
    }

    @Nullable
    public static String getResultSetName(@NotNull AnActionEvent e) {
        if (e == null) {
            DataGridUtil.$$$reportNull$$$0(58);
        }
        DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
        JdbcConsole console = JdbcConsole.findConsole(e);
        return DataGridUtil.getResultSetName(grid, console);
    }

    @Nullable
    public static String getResultSetName(@NotNull Project project, @NotNull DataGrid grid) {
        if (project == null) {
            DataGridUtil.$$$reportNull$$$0(59);
        }
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(60);
        }
        return DataGridUtil.getResultSetName(grid, DataGridUtil.findGridRelatedConsole(project, grid));
    }

    @Nullable
    public static String getResultSetName(@Nullable DataGrid grid, @Nullable JdbcConsole console) {
        DasTable table = DataGridUtil.getDatabaseTable(grid);
        return console != null && grid != null ? DataGridUtil.getNameFromConsole(console, grid) : (table != null ? table.getName() : null);
    }

    @Nullable
    private static String getNameFromConsole(@NotNull JdbcConsole console, @NotNull DataGrid dataGrid) {
        RunnerLayoutUi ui;
        if (console == null) {
            DataGridUtil.$$$reportNull$$$0(61);
        }
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(62);
        }
        Content content = (ui = console.getUi()) == null ? null : ui.getContentManager().getContent((JComponent)((Object)dataGrid.getComponent()));
        return content == null ? null : content.getDisplayName();
    }

    private static int getInsertedRowIdx(@NotNull DataGrid grid, int relativeIndex) {
        ModelIndex<DataConsumer.Row> rowIdx;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(63);
        }
        DataConsumer.Row row = (rowIdx = DataGridUtil.getLastNotInsertedRow(grid)) == null ? null : grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRow(rowIdx);
        int humanReadable = relativeIndex + 1;
        if (row == null) {
            return humanReadable;
        }
        int difference = relativeIndex - rowIdx.asInteger();
        return difference < 0 ? humanReadable : row.getRowNum() + difference;
    }

    @Nullable
    private static ModelIndex<DataConsumer.Row> getLastNotInsertedRow(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(64);
        }
        List rows = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowIndices().asList();
        for (int i2 = rows.size() - 1; i2 >= 0; --i2) {
            ModelIndex index2 = (ModelIndex)rows.get(i2);
            if (DataGridUtil.isInsertedRow(grid, index2)) continue;
            return index2;
        }
        return null;
    }

    @Nullable
    private static JdbcConsole findGridRelatedConsole(@NotNull Project project, @NotNull DataGrid grid) {
        if (project == null) {
            DataGridUtil.$$$reportNull$$$0(65);
        }
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(66);
        }
        List<JdbcConsole> consoles = JdbcConsole.getActiveConsoles(project);
        for (JdbcConsole console : consoles) {
            RunnerLayoutUi ui = console.getUi();
            Content content = ui == null ? null : ui.getContentManager().getContent((JComponent)((Object)grid.getComponent()));
            if (content == null) continue;
            return console;
        }
        return null;
    }

    public static void saveAndRestoreSelection(@NotNull DataGrid grid, Runnable runnable) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(67);
        }
        GridSelection selection = grid.getSelectionModel().store();
        GridScrollPositionManager.GridScrollPosition scrollPosition = GridScrollPositionManager.get(grid.getResultView(), grid).store();
        runnable.run();
        DbImplUtil.invokeLater(() -> {
            grid.getSelectionModel().restore(selection);
            GridScrollPositionManager.get(grid.getResultView(), grid).restore(scrollPosition);
        });
    }

    public static boolean areOnlySortedColumns(@NotNull List<ModelIndex<DataConsumer.Column>> columns, @NotNull DataGrid grid) {
        if (columns == null) {
            DataGridUtil.$$$reportNull$$$0(68);
        }
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(69);
        }
        Set newColumns = ContainerUtil.map2Set(columns, c2 -> c2.asInteger());
        return grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumnIndices().asIterable().find(column2 -> !newColumns.contains(column2.asInteger()) && grid.getSortOrder((ModelIndex<DataConsumer.Column>)column2) != RowSortOrder.Type.UNSORTED) == null;
    }

    @Nullable
    public static CellAttributesKey getMutationCellAttributes(@Nullable MutationType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case MODIFY: {
                return CellColors.REPLACE;
            }
            case INSERT: {
                return CellColors.INSERT;
            }
            case DELETE: {
                return CellColors.REMOVE;
            }
        }
        return null;
    }

    public static boolean canInsertBlob(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        int type;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(70);
        }
        if (row == null) {
            DataGridUtil.$$$reportNull$$$0(71);
        }
        if (column2 == null) {
            DataGridUtil.$$$reportNull$$$0(72);
        }
        return (type = GridCellEditorsUtil.guessJdbcTypeForEditing(grid, row, column2)) == -2 || type == 2004 || type == -4 || type == -3;
    }

    public static boolean canInsertClob(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        int type;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(73);
        }
        if (row == null) {
            DataGridUtil.$$$reportNull$$$0(74);
        }
        if (column2 == null) {
            DataGridUtil.$$$reportNull$$$0(75);
        }
        return (type = GridCellEditorsUtil.guessJdbcTypeForEditing(grid, row, column2)) == 2005 || type == 2011 || type == -1 || type == -16 || type == -15 || type == 1 || type == 12 || type == -9 || type == 2009;
    }

    public static String[] formatValues(@NotNull DataGrid dataGrid, @NotNull String[] columnNames, Object[] values2) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(76);
        }
        if (columnNames == null) {
            DataGridUtil.$$$reportNull$$$0(77);
        }
        ArrayList<String> formattedValues = new ArrayList<String>();
        GridModel model = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        Dbms dbms = DataGridUtil.getDbms(dataGrid);
        ObjectFormatter objectFormatter = new ObjectFormatter();
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            ModelIndex<DataConsumer.Column> idx = DataGridUtil.findColumn(dataGrid, columnNames[i2]);
            formattedValues.add(DataGridUtil.formatValue(model.getColumn(idx), objectFormatter, dbms, values2[i2]));
        }
        return ArrayUtil.toStringArray(formattedValues);
    }

    @Nullable
    public static String formatValue(@Nullable DataConsumer.Column column2, @NotNull ObjectFormatter objectFormatter, @NotNull Dbms dbms, @Nullable Object value2) {
        if (objectFormatter == null) {
            DataGridUtil.$$$reportNull$$$0(78);
        }
        if (dbms == null) {
            DataGridUtil.$$$reportNull$$$0(79);
        }
        return column2 == null ? (value2 == null ? null : value2.toString()) : objectFormatter.objectToString(value2, column2, dbms, PredicatesHelperKt.predicatesHelper(dbms).getMode());
    }

    public static boolean canMutateColumns(@Nullable DataGrid grid) {
        GridDataHookUp hookup;
        GridDataHookUp gridDataHookUp = hookup = grid == null ? null : grid.getDataHookup();
        if (!(hookup != null && grid.isEditable() && grid.isReady() && hookup.getMutator() instanceof GridMutator.ColumnsMutator)) {
            return false;
        }
        if (hookup instanceof DocumentDataHookUp) {
            return grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowCount() != 0;
        }
        return Registry.is((String)"database.enable.columns.mutation.for.mongodb") && DataGridUtil.getDbms(grid).is(Dbms.MONGO);
    }

    @Nullable
    public static GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> getColumnsMutator(@Nullable DataGrid grid) {
        return (GridMutator.ColumnsMutator)ObjectUtils.tryCast(grid == null ? null : grid.getDataHookup().getMutator(), GridMutator.ColumnsMutator.class);
    }

    @Nullable
    public static GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> getRowsMutator(@Nullable DataGrid grid) {
        return (GridMutator.RowsMutator)ObjectUtils.tryCast(grid == null ? null : grid.getDataHookup().getMutator(), GridMutator.RowsMutator.class);
    }

    public static void scrollToLocally(@NotNull DataGrid grid, @NotNull ViewIndex<DataConsumer.Row> row, @NotNull ViewIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(80);
        }
        if (row == null) {
            DataGridUtil.$$$reportNull$$$0(81);
        }
        if (column2 == null) {
            DataGridUtil.$$$reportNull$$$0(82);
        }
        Pair<Integer, Integer> rowAndColumn = grid.getRawIndexConverter().rowAndColumn2Model().fun(row.asInteger(), column2.asInteger());
        grid.getSelectionModel().setSelection(ModelIndex.forRow(grid, (int)((Integer)rowAndColumn.first)), ModelIndex.forColumn(grid, (int)((Integer)rowAndColumn.second)));
    }

    public static void scrollToLocally(@NotNull DataGrid grid, @NotNull ViewIndex<DataConsumer.Row> row) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(83);
        }
        if (row == null) {
            DataGridUtil.$$$reportNull$$$0(84);
        }
        grid.getSelectionModel().setRowSelection(row.toModel(grid), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 33: 
            case 46: 
            case 48: 
            case 52: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 33: 
            case 46: 
            case 48: 
            case 52: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHookUp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupActions";
                break;
            }
            case 5: 
            case 19: 
            case 20: 
            case 41: 
            case 43: 
            case 47: 
            case 62: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gridModel";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 33: 
            case 46: 
            case 48: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DataGridUtil";
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 49: 
            case 54: 
            case 56: 
            case 60: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 73: 
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroupName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 36: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 51: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 71: 
            case 74: 
            case 81: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 72: 
            case 75: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DataGridUtil";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findColumn";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "addGridHeaderComponent";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeAll";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "extractValues";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRows";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createMutations";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDataGrid";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPreviewDataGrid";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findColumn";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 33: 
            case 46: 
            case 48: 
            case 52: 
            case 55: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSqlType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setupProgressIndicatingAuditor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setProgressMessage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentDataHookUp";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addGridHeaderComponent";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "configureNumericEditor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "canBuildWhereClause";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createEDTSafeWrapper";
                break;
            }
            case 28: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultNullValue";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseColumn";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "mergeAll";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getProject";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementForSelection";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "showIgnoreUnsubmittedChangesYesNoDialog";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "showCannotApplyCellEditorChanges";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "extractSelectedValues";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "extractValues";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRows";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getBestPositionForBalloon";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createMutations";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "min";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getRowName";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isInsertedRow";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getResultSetName";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromConsole";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getInsertedRowIdx";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getLastNotInsertedRow";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "findGridRelatedConsole";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "saveAndRestoreSelection";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "areOnlySortedColumns";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "canInsertBlob";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "canInsertClob";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "formatValues";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "formatValue";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "scrollToLocally";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 33: 
            case 46: 
            case 48: 
            case 52: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

