/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.Dbms;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.datagrid.AbstractGridSortingModel;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridListModel;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.model.DasObject;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.script.generator.dml.ColumnsOrderBy;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderByKt;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseSortingModel
extends AbstractGridSortingModel<DataConsumer.Row, DataConsumer.Column> {
    private final Document myDocument;
    private String appliedOrderingText;
    private final DatabaseGridDataHookUp myHookUp;

    DatabaseSortingModel(@NotNull DatabaseGridDataHookUp hookUp) {
        if (hookUp == null) {
            DatabaseSortingModel.$$$reportNull$$$0(0);
        }
        this.myHookUp = hookUp;
        String emptySortingText = DmlUtilKt.dmlGenerator(hookUp.getDbms()).getEmptySortingText();
        this.myDocument = EditorFactory.getInstance().createDocument((CharSequence)emptySortingText);
        this.myHookUp.getModel(DataAccessType.DATA_WITH_MUTATIONS).addListener(new GridModel.Listener<DataConsumer.Row, DataConsumer.Column>(){

            @Override
            public void columnsAdded(ModelIndexSet<DataConsumer.Column> columns) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    DatabaseSortingModel.this.myAppliedOrdering = DatabaseSortingModel.parseOrdering(DatabaseSortingModel.this.myHookUp.getProject(), DatabaseSortingModel.this.myDocument, DatabaseSortingModel.this.myHookUp.getDataModel(), DatabaseSortingModel.this.myHookUp.getDbms());
                    ((GridSortingModel.Listener)DatabaseSortingModel.this.myEventDispatcher.getMulticaster()).orderingChanged();
                });
            }

            @Override
            public void columnsRemoved(ModelIndexSet<DataConsumer.Column> columns) {
            }

            @Override
            public void rowsAdded(ModelIndexSet<DataConsumer.Row> rows) {
            }

            @Override
            public void rowsRemoved(ModelIndexSet<DataConsumer.Row> rows) {
            }

            @Override
            public void cellsUpdated(ModelIndexSet<DataConsumer.Row> rows, ModelIndexSet<DataConsumer.Column> columns, @Nullable GridRequestSource.RequestPlace place) {
            }
        }, hookUp);
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            DatabaseSortingModel.$$$reportNull$$$0(1);
        }
        return document;
    }

    @Override
    public void setOrdering(@NotNull List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering) {
        if (ordering == null) {
            DatabaseSortingModel.$$$reportNull$$$0(2);
        }
        super.setOrdering(ordering);
        ApplicationManager.getApplication().runWriteAction(() -> this.myDocument.setText((CharSequence)this.generateText(ordering)));
    }

    @Override
    @NotNull
    public String getAppliedOrderingText() {
        return this.isSortingEnabled() ? StringUtil.notNullize((String)this.appliedOrderingText) : "";
    }

    @Override
    public void apply() {
        this.myOrdering = DatabaseSortingModel.parseOrdering(this.myHookUp.getProject(), this.myDocument, this.myHookUp.getDataModel(), this.myHookUp.getDbms());
        this.appliedOrderingText = this.myDocument.getText().trim();
        this.addToHistory(this.appliedOrderingText);
        super.apply();
    }

    private static List<RowSortOrder<ModelIndex<DataConsumer.Column>>> parseOrdering(@NotNull Project project, @NotNull Document document, @NotNull DataGridListModel model, @NotNull Dbms dbms) {
        if (project == null) {
            DatabaseSortingModel.$$$reportNull$$$0(3);
        }
        if (document == null) {
            DatabaseSortingModel.$$$reportNull$$$0(4);
        }
        if (model == null) {
            DatabaseSortingModel.$$$reportNull$$$0(5);
        }
        if (dbms == null) {
            DatabaseSortingModel.$$$reportNull$$$0(6);
        }
        if (model.getColumnCount() == 0) {
            return Collections.emptyList();
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.mapNotNull(ExecutionEnvironmentHelper.EP.forDbms(dbms).getOrderByElements(psiFile), order -> {
            ModelIndex<DataConsumer.Column> idx = DataGridUtil.findColumn(model, (String)order.getColumn(), false);
            return idx.asInteger() == -1 ? null : (order.getOrder() == RowSortOrder.Type.ASC ? RowSortOrder.asc(idx) : RowSortOrder.desc(idx));
        });
    }

    @NotNull
    private String generateText(@NotNull List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering) {
        if (ordering == null) {
            DatabaseSortingModel.$$$reportNull$$$0(7);
        }
        Dbms dbms = this.myHookUp.getDbms();
        ColumnsOrderBy orderBy = OrderByKt.orderBy(ordering, this.myHookUp.getModel(DataAccessType.DATABASE_DATA));
        DmlHelper dmlHelper = DmlUtilKt.dmlGenerator(dbms);
        if (orderBy == null) {
            String string = dmlHelper.getEmptySortingText();
            if (string == null) {
                DatabaseSortingModel.$$$reportNull$$$0(8);
            }
            return string;
        }
        DdlBuilder builder = DbImplUtilCore.createBuilderForUIExec(this.myHookUp.getDatabaseDialect(), (DasObject)this.myHookUp.getDatabaseTable());
        dmlHelper.generate(DmlTaskKt.orderBy(orderBy).build(builder));
        String string = builder.getStatement();
        if (string == null) {
            DatabaseSortingModel.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DatabaseSortingModel";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DatabaseSortingModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setOrdering";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseOrdering";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

