/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ImportAction;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dbimport.DatabaseInputType;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.ImportPanel;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.database.view.ui.ResultProcessorProvider;
import com.intellij.database.view.ui.TableSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportDialog
extends DialogWrapper
implements ResultProcessorProvider {
    private static final Logger LOG = Logger.getInstance(ImportDialog.class);
    private static final Dimension SIZE = JBUI.size((int)800, (int)600);
    private final ImportPanel myPanel;
    private final ImportInfo.Builder myBuilder;
    private final ImportEditorContext myContext;

    public ImportDialog(@NotNull ImportEditorContext context, @NotNull ImportPanel panel2) {
        if (context == null) {
            ImportDialog.$$$reportNull$$$0(0);
        }
        if (panel2 == null) {
            ImportDialog.$$$reportNull$$$0(1);
        }
        super(context.getProject());
        this.myBuilder = context.getBuilder();
        this.myContext = context;
        this.setOKButtonText(DatabaseBundle.message("database.data.import.ok.text", new Object[0]));
        this.setTitle(((ImportAction.InputType)this.myBuilder.getInputType()).getDialogTitle());
        this.myPanel = panel2;
        this.myPanel.getContentPanel().setPreferredSize(SIZE);
        this.myPanel.init().whenComplete((o, e) -> {
            this.myOKAction.setEnabled(true);
            this.initValidation();
        });
        this.init();
    }

    @NotNull
    public ImportInfo getImportInfo() {
        ImportInfo importInfo = this.myPanel.getImportInfo();
        if (importInfo == null) {
            ImportDialog.$$$reportNull$$$0(2);
        }
        return importInfo;
    }

    @Override
    public void settingsChanged() {
    }

    @Override
    @NotNull
    public JBIterable<Pair<PsiElement, String>> collectRenames() {
        JBIterable<Pair<PsiElement, String>> jBIterable = this.myBuilder.getImportType().isTableCreated() ? DbRenamePsiElementProcessor.collectRenameElements(this.myContext.getDeModel(), this.myContext.getDataSource()) : JBIterable.empty();
        if (jBIterable == null) {
            ImportDialog.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @Override
    public Project getProject() {
        return this.myBuilder.getContext().getProject();
    }

    @Override
    public boolean isPreviewUsages() {
        return true;
    }

    @Override
    public void success(boolean ok) {
        this.close(ok ? 0 : 1);
    }

    @Override
    public void error(@NotNull String message2) {
        if (message2 == null) {
            ImportDialog.$$$reportNull$$$0(4);
        }
        this.myPanel.reportError(message2);
        this.myOKAction.setEnabled(true);
    }

    @Override
    @NotNull
    public String statement() {
        String string = this.myPanel.getDdlComponent().getDdlPreview().getPreviewText();
        if (string == null) {
            ImportDialog.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myBuilder.getContext();
        if (databaseEditorContext == null) {
            ImportDialog.$$$reportNull$$$0(6);
        }
        return databaseEditorContext;
    }

    @Override
    @NotNull
    public DeModel getModel() {
        DeModel deModel = this.myContext.getDeModel();
        if (deModel == null) {
            ImportDialog.$$$reportNull$$$0(7);
        }
        return deModel;
    }

    @Override
    @NotNull
    public DatabaseEditorBaseEx getEditor() {
        ImportDatabaseTableEditor<?> editor = this.myPanel.getTableEditorComponent().getEditor();
        DatabaseEditorBaseEx databaseEditorBaseEx = Objects.requireNonNull(editor);
        if (databaseEditorBaseEx == null) {
            ImportDialog.$$$reportNull$$$0(8);
        }
        return databaseEditorBaseEx;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction.setEnabled(false);
    }

    protected void doOKAction() {
        String text2;
        if (!this.getOKAction().isEnabled()) {
            return;
        }
        String string = text2 = this.myBuilder.getImportType().isTableCreated() ? this.myPanel.getDdlComponent().getDdlPreview().getPreviewText() : "";
        if (!StringUtil.isEmptyOrSpaces((String)text2) && !MessageDialogBuilder.yesNo((String)DatabaseBundle.message("database.data.import.schema.change.confirmation.title", new Object[0]), (String)DatabaseBundle.message("database.data.import.schema.change.confirmation.text", new Object[0])).ask((Component)this.getRootPane())) {
            return;
        }
        this.getOKAction().setEnabled(false);
        try {
            ImportType type = this.myContext.getBuilder().getImportType();
            MyResultProcessor processor = new MyResultProcessor(this, type.getCodeGenerationSettings(), null);
            String error2 = ((GenericEditingResultProcessor)processor).process();
            if (error2 != null) {
                this.error(error2);
            }
        }
        catch (Throwable t) {
            LOG.warn(t);
            this.error(t.getMessage());
        }
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.myPanel.validationInfo();
    }

    protected int getErrorTextAlignment() {
        return 4;
    }

    protected boolean shouldAddErrorNearButtons() {
        return !ImportDialog.isMoveHelpButtonLeft();
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return this.getClass().getName();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    protected String getHelpId() {
        return this.myBuilder.getInputType() instanceof DatabaseInputType ? "import.table.dialog" : (this.myBuilder.getProducers() == null ? "import.file.format.dialog" : "import.file.dialog");
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.disposeAll();
    }

    private void disposeAll() {
        Disposer.dispose((Disposable)this.myContext.getDisposable());
    }

    private void runImport() {
        try {
            this.runImport(this.getImportInfo());
        }
        finally {
            this.disposeAll();
        }
    }

    private void runImport(@NotNull ImportInfo info) {
        if (info == null) {
            ImportDialog.$$$reportNull$$$0(9);
        }
        try {
            if (!info.getType().isTableCreated() && info.getConsumersForInsert().isEmpty()) {
                return;
            }
            new DataImporter(this.getProject(), this.myContext.getElement(), (ImportAction.InputType)info.getInputType(), info).importData();
        }
        catch (IOException ex) {
            DataSourceUtil.showNotification(this.getProject(), DatabaseBundle.message("notification.title.can.t.create.input", new Object[0]), ex.getMessage(), true, Collections.emptyList());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRenames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "statement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ImportRenameProcessor
    extends DbRenamePsiElementProcessor.MyRenameProcessor {
        private ImportInfo myInfo;

        ImportRenameProcessor(@NotNull Project project, @NotNull PsiElement element2, @NotNull @NonNls DatabaseRefactoringHandler handler, @NotNull String newName, JBIterable<Pair<PsiElement, String>> renames, boolean isSearchInComments, boolean isSearchTextOccurrences) {
            if (project == null) {
                ImportRenameProcessor.$$$reportNull$$$0(0);
            }
            if (element2 == null) {
                ImportRenameProcessor.$$$reportNull$$$0(1);
            }
            if (handler == null) {
                ImportRenameProcessor.$$$reportNull$$$0(2);
            }
            if (newName == null) {
                ImportRenameProcessor.$$$reportNull$$$0(3);
            }
            if (renames == null) {
                ImportRenameProcessor.$$$reportNull$$$0(4);
            }
            super(project, element2, handler, newName, (Iterable<Pair<PsiElement, String>>)renames, (SearchScope)GlobalSearchScope.projectScope((Project)project), isSearchInComments, isSearchTextOccurrences);
        }

        @Override
        @NotNull
        protected AsyncTask<?> runStatements(UsageInfo @NotNull [] usages2) {
            if (usages2 == null) {
                ImportRenameProcessor.$$$reportNull$$$0(5);
            }
            AsyncTask<Object> asyncTask = super.runStatements(usages2).whenComplete(AsyncUtil.getEdtExecutor(), (r, e) -> {
                if (e == null) {
                    ImportDialog.this.runImport(this.myInfo);
                }
            });
            if (asyncTask == null) {
                ImportRenameProcessor.$$$reportNull$$$0(6);
            }
            return asyncTask;
        }

        protected void prepareSuccessful() {
            try {
                this.myInfo = ImportDialog.this.getImportInfo();
                ImportDialog.this.disposeAll();
                super.prepareSuccessful();
            }
            catch (Throwable t) {
                LOG.warn(t);
                ImportDialog.this.error(t.getMessage());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renames";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usages";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runStatements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "runStatements";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyResultProcessor
    extends GenericEditingResultProcessor {
        MyResultProcessor(@NotNull ResultProcessorProvider provider, @Nullable TableSettings settings, RangeMarker insertPos) {
            if (provider == null) {
                MyResultProcessor.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                MyResultProcessor.$$$reportNull$$$0(1);
            }
            super(provider, settings, insertPos);
        }

        @Override
        @NotNull
        protected RenameProcessor createRenameProcessor(@NotNull JBIterable<Pair<PsiElement, String>> renames, @NotNull DatabaseRefactoringHandler handler) {
            Pair r;
            if (renames == null) {
                MyResultProcessor.$$$reportNull$$$0(2);
            }
            if (handler == null) {
                MyResultProcessor.$$$reportNull$$$0(3);
            }
            if ((r = (Pair)renames.first()) == null) {
                throw new AssertionError((Object)"No renames");
            }
            return new ImportRenameProcessor(ImportDialog.this.getContext().getProject(), (PsiElement)r.first, handler, (String)r.second, renames, this.mySettings.renameInCommentsAndLiterals, this.mySettings.renameTextOccurrences);
        }

        @Override
        public String process() {
            return super.process();
        }

        @Override
        protected String getTitle() {
            return DatabaseBundle.message("progress.text.import", new Object[0]);
        }

        @Override
        @NotNull
        protected AsyncTask<Boolean> processWithoutRenames(@NotNull DatabaseRefactoringHandler handler) {
            if (handler == null) {
                MyResultProcessor.$$$reportNull$$$0(4);
            }
            if (StringUtil.isEmpty((String)ImportDialog.this.statement())) {
                ImportDialog.this.success(true);
                ImportDialog.this.runImport();
                AsyncTask<Object> asyncTask = AsyncTask.completed(null);
                if (asyncTask == null) {
                    MyResultProcessor.$$$reportNull$$$0(5);
                }
                return asyncTask;
            }
            AsyncTask<Boolean> asyncTask = super.processWithoutRenames(handler).whenComplete(null, (r, e) -> {
                if (Boolean.TRUE.equals(r)) {
                    ImportDialog.this.runImport();
                }
            });
            if (asyncTask == null) {
                MyResultProcessor.$$$reportNull$$$0(6);
            }
            return asyncTask;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renames";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportDialog$MyResultProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportDialog$MyResultProcessor";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processWithoutRenames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createRenameProcessor";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processWithoutRenames";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

