/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.csv;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.ImportAction;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.csv.CsvInput;
import com.intellij.database.dbimport.csv.CsvPreviewModel;
import com.intellij.database.dbimport.ui.ImportSettingsComponent;
import com.intellij.database.dbimport.ui.component.DdlPreviewComponent;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.dbimport.ui.csv.CharsetComponent;
import com.intellij.database.dbimport.ui.csv.CsvFormatComponent;
import com.intellij.database.dbimport.ui.csv.CsvPreviewComponent;
import com.intellij.database.dbimport.ui.csv.CsvTableEditorComponent;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvInputType
implements ImportAction.InputType {
    private final VirtualFile myFile;
    private final int myCharCount;

    public CsvInputType(@NotNull VirtualFile file, int charCountToRead) {
        if (file == null) {
            CsvInputType.$$$reportNull$$$0(0);
        }
        this.myFile = file;
        this.myCharCount = charCountToRead;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            CsvInputType.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public ReaderTask.Input createInput(@NotNull ImportInfo info) {
        if (info == null) {
            CsvInputType.$$$reportNull$$$0(2);
        }
        return new CsvInput((ThrowableComputable<InputStream, IOException>)((ThrowableComputable)() -> ImportUtil.getInputStream(this.myFile)), this.myFile.getCharset(), info, this.myCharCount, this.myFile.getLength());
    }

    @Override
    @NotNull
    public List<ImportComponent<?, ?>> getComponents(@NotNull ImportEditorContext context) throws Exception {
        if (context == null) {
            CsvInputType.$$$reportNull$$$0(3);
        }
        CsvPreviewModel model = new CsvPreviewModel(this.myFile);
        List<ImportComponent<?, ?>> list = Arrays.asList(new CsvPreviewComponent(context, model), new CsvFormatComponent(context, this.myFile), new CsvTableEditorComponent(context), new ImportSettingsComponent(context), new DdlPreviewComponent(context), new CharsetComponent(model));
        if (list == null) {
            CsvInputType.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @Nullable
    public DasDataSource getProducerSystem() {
        return null;
    }

    @Override
    @NotNull
    public String getDialogTitle() {
        String string = DatabaseBundle.message("import.0.file", this.myFile.getName());
        if (string == null) {
            CsvInputType.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.UNKNOWN;
        if (dbms == null) {
            CsvInputType.$$$reportNull$$$0(6);
        }
        return dbms;
    }

    @Override
    @NotNull
    public DeTable createNewTable(@NotNull ImportEditorContext context, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<DataConsumer.Row> rows) {
        if (context == null) {
            CsvInputType.$$$reportNull$$$0(7);
        }
        if (descriptors == null) {
            CsvInputType.$$$reportNull$$$0(8);
        }
        DeTable deTable = ImportUtil.createTable(context, descriptors, rows, (Function<? super ImportUtil.ColumnTypePredictorInfo, String>)((Function)ImportUtil::getPreferredTypeBasedOnContent));
        if (deTable == null) {
            CsvInputType.$$$reportNull$$$0(9);
        }
        return deTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/csv/CsvInputType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/csv/CsvInputType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialogTitle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createInput";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getComponents";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNewTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

