/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DefaultValuesExtractor;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.FormatBasedExtractor;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.Out;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpRequest
extends DataRequest.IsolatedQueryRequest {
    private static final Logger LOG = Logger.getInstance(DumpRequest.class);
    @NotNull
    private final DataExtractor myExtractor;
    @NotNull
    private final Dbms myDbms;
    @NotNull
    private final Out myOutput;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    @Nullable
    private final ModelIndexSet<DataConsumer.Column> mySelectedColumns;
    @Nullable
    private final String myName;
    @NotNull
    private final ExtractionConfig myConfig;
    protected DataConsumer.Column[] myColumns;
    private int myFirstRowNum;
    private DataExtractor.Extraction myExtraction;

    protected DumpRequest(@NotNull DataRequest.Owner owner, @NotNull String query, @NotNull DataRequest.Constraints constraints, @Nullable ModelIndexSet<DataConsumer.Column> columns, @NotNull DataExtractor extractor, @NotNull Dbms dbms, @NotNull Out output, @Nullable String name, @NotNull ExtractionConfig config) {
        if (owner == null) {
            DumpRequest.$$$reportNull$$$0(0);
        }
        if (query == null) {
            DumpRequest.$$$reportNull$$$0(1);
        }
        if (constraints == null) {
            DumpRequest.$$$reportNull$$$0(2);
        }
        if (extractor == null) {
            DumpRequest.$$$reportNull$$$0(3);
        }
        if (dbms == null) {
            DumpRequest.$$$reportNull$$$0(4);
        }
        if (output == null) {
            DumpRequest.$$$reportNull$$$0(5);
        }
        if (config == null) {
            DumpRequest.$$$reportNull$$$0(6);
        }
        super(owner, query, constraints, null);
        this.mySelectedColumns = columns;
        this.myExtractor = extractor;
        this.myDbms = dbms;
        this.myOutput = output;
        this.myName = name;
        this.myConfig = config;
        this.myProgressIndicator = (ProgressIndicator)ObjectUtils.chooseNotNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)new EmptyProgressIndicator());
    }

    @Override
    public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column @NotNull [] columns, int firstRowNum) {
        if (context == null) {
            DumpRequest.$$$reportNull$$$0(7);
        }
        if (columns == null) {
            DumpRequest.$$$reportNull$$$0(8);
        }
        LOG.assertTrue(resultSetIndex == this.constraints.resultSetNumber);
        this.myColumns = columns;
        this.myFirstRowNum = firstRowNum;
        this.myProgressIndicator.setText(this.getSavingText());
    }

    @NotNull
    protected DataExtractor.Extraction startExtraction() {
        int[] selectedColumns;
        int[] nArray = selectedColumns = this.mySelectedColumns != null ? this.mySelectedColumns.asArray() : ArrayUtilRt.EMPTY_INT_ARRAY;
        if (this.myExtractor instanceof DataExtractor.Text) {
            if (!(this.myOutput instanceof CharOut)) {
                throw new AssertionError((Object)("Output must be an instance of " + CharOut.class + " but instead it is " + this.myOutput.getClass()));
            }
            DataExtractor.Extraction extraction = ((DataExtractor.Text)this.myExtractor).startExtraction((CharOut)this.myOutput, this.myDbms, Arrays.asList(this.myColumns), this.myConfig, selectedColumns);
            if (extraction == null) {
                DumpRequest.$$$reportNull$$$0(9);
            }
            return extraction;
        }
        OutputStream outputStream = this.myOutput.tryCast(OutputStream.class);
        if (outputStream == null) {
            throw new AssertionError((Object)("Out instance must contain OutputStream. " + this.myOutput.getClass()));
        }
        DataExtractor.Extraction extraction = ((DataExtractor.Binary)this.myExtractor).startExtraction(outputStream, this.myDbms, Arrays.asList(this.myColumns), this.query, this.myConfig, selectedColumns);
        if (extraction == null) {
            DumpRequest.$$$reportNull$$$0(10);
        }
        return extraction;
    }

    @Override
    public void updateColumns(@NotNull DataRequest.Context context, @NotNull DataConsumer.Column[] columns) {
        if (context == null) {
            DumpRequest.$$$reportNull$$$0(11);
        }
        if (columns == null) {
            DumpRequest.$$$reportNull$$$0(12);
        }
        if (this.myExtraction == null) {
            this.myColumns = columns;
        } else {
            this.myExtraction.updateColumns(columns);
        }
    }

    @Override
    public void addRows(@NotNull DataRequest.Context context, @NotNull List<DataConsumer.Row> rows) {
        if (context == null) {
            DumpRequest.$$$reportNull$$$0(13);
        }
        if (rows == null) {
            DumpRequest.$$$reportNull$$$0(14);
        }
        if (this.myExtraction == null) {
            this.myExtraction = this.startExtraction();
        }
        this.myProgressIndicator.checkCanceled();
        if (rows.isEmpty()) {
            return;
        }
        int maxRow = rows.get(rows.size() - 1).getRowNum();
        if (this.myOutput instanceof CharOut && rows.get(0).getRowNum() > this.myFirstRowNum && this.myExtractor instanceof DefaultValuesExtractor && !(this.myExtractor instanceof FormatBasedExtractor)) {
            ((CharOut)this.myOutput).append(((DefaultValuesExtractor)this.myExtractor).getLineSeparator());
        }
        this.myExtraction.addData(rows);
        this.myProgressIndicator.setText(DatabaseBundle.message("progress.text.rows", this.getSavingText(), maxRow, this.myOutput instanceof CharOut ? " / " + ExtractorsUtil.getPresentableSize(((CharOut)this.myOutput).length()) + DatabaseBundle.message("progress.text.rows.chars.loaded", new Object[0]) : ""));
    }

    @NlsContexts.ProgressText
    @NotNull
    private String getSavingText() {
        String string = DatabaseBundle.message("progress.text.saving.choice", this.myName, this.myName == null ? 0 : 1);
        if (string == null) {
            DumpRequest.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
        if (context == null) {
            DumpRequest.$$$reportNull$$$0(16);
        }
        if (this.myExtraction == null) {
            this.myExtraction = this.startExtraction();
        }
        this.myExtraction.complete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 9: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dump/DumpRequest";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dump/DumpRequest";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "startExtraction";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSavingText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setColumns";
                break;
            }
            case 9: 
            case 10: 
            case 15: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateColumns";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addRows";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "afterLastRowAdded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

