/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.layoutedQueries.impl;

import com.intellij.database.layoutedQueries.DBCommandRunner;
import com.intellij.database.layoutedQueries.DBLeasedSession;
import com.intellij.database.layoutedQueries.DBQueryRunner;
import com.intellij.database.layoutedQueries.DBScriptRunner;
import com.intellij.database.remote.jdba.core.ResultLayout;
import com.intellij.database.remote.jdba.exceptions.DBSessionIsClosedException;
import com.intellij.database.remote.jdba.sql.SqlCommand;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.remote.jdba.sql.SqlScript;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DBLeasedSessionWrapper
implements DBLeasedSession {
    private DBLeasedSession myOriginalSession;

    public DBLeasedSessionWrapper(@NotNull DBLeasedSession originalSession) {
        if (originalSession == null) {
            DBLeasedSessionWrapper.$$$reportNull$$$0(0);
        }
        this.myOriginalSession = originalSession;
    }

    private void checkIsNotClosed() {
        if (this.myOriginalSession == null) {
            throw new DBSessionIsClosedException("The session is already closed or returned back.");
        }
    }

    @Override
    public synchronized boolean isClosed() {
        return this.myOriginalSession == null || this.myOriginalSession.isClosed();
    }

    @Override
    public synchronized void close() {
        DBLeasedSession theSessionToClose = this.myOriginalSession;
        this.myOriginalSession = null;
        if (theSessionToClose != null) {
            theSessionToClose.close();
        }
    }

    @Override
    @NotNull
    public synchronized DBCommandRunner command(@NotNull SqlCommand command) {
        if (command == null) {
            DBLeasedSessionWrapper.$$$reportNull$$$0(1);
        }
        this.checkIsNotClosed();
        DBCommandRunner dBCommandRunner = this.myOriginalSession.command(command);
        if (dBCommandRunner == null) {
            DBLeasedSessionWrapper.$$$reportNull$$$0(2);
        }
        return dBCommandRunner;
    }

    @Override
    @NotNull
    public synchronized DBCommandRunner command(@NotNull String commandText) {
        if (commandText == null) {
            DBLeasedSessionWrapper.$$$reportNull$$$0(3);
        }
        this.checkIsNotClosed();
        DBCommandRunner dBCommandRunner = this.myOriginalSession.command(commandText);
        if (dBCommandRunner == null) {
            DBLeasedSessionWrapper.$$$reportNull$$$0(4);
        }
        return dBCommandRunner;
    }

    @Override
    @NotNull
    public synchronized <S> DBQueryRunner<S> query(@NotNull SqlQuery<S> query) {
        if (query == null) {
            DBLeasedSessionWrapper.$$$reportNull$$$0(5);
        }
        this.checkIsNotClosed();
        DBQueryRunner<S> dBQueryRunner = this.myOriginalSession.query(query);
        if (dBQueryRunner == null) {
            DBLeasedSessionWrapper.$$$reportNull$$$0(6);
        }
        return dBQueryRunner;
    }

    @Override
    @NotNull
    public synchronized <S> DBQueryRunner<S> query(@NotNull String queryText2, @NotNull ResultLayout<S> layout) {
        if (queryText2 == null) {
            DBLeasedSessionWrapper.$$$reportNull$$$0(7);
        }
        if (layout == null) {
            DBLeasedSessionWrapper.$$$reportNull$$$0(8);
        }
        this.checkIsNotClosed();
        DBQueryRunner<S> dBQueryRunner = this.myOriginalSession.query(queryText2, layout);
        if (dBQueryRunner == null) {
            DBLeasedSessionWrapper.$$$reportNull$$$0(9);
        }
        return dBQueryRunner;
    }

    @Override
    @NotNull
    public synchronized DBScriptRunner script(@NotNull SqlScript script) {
        if (script == null) {
            DBLeasedSessionWrapper.$$$reportNull$$$0(10);
        }
        this.checkIsNotClosed();
        DBScriptRunner dBScriptRunner = this.myOriginalSession.script(script);
        if (dBScriptRunner == null) {
            DBLeasedSessionWrapper.$$$reportNull$$$0(11);
        }
        return dBScriptRunner;
    }

    @Nullable
    public synchronized <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) throws ClassCastException {
        if (serviceClass == null) {
            DBLeasedSessionWrapper.$$$reportNull$$$0(12);
        }
        if (serviceName == null) {
            DBLeasedSessionWrapper.$$$reportNull$$$0(13);
        }
        this.checkIsNotClosed();
        return (I)this.myOriginalSession.getSpecificService(serviceClass, serviceName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalSession";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/layoutedQueries/impl/DBLeasedSessionWrapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/layoutedQueries/impl/DBLeasedSessionWrapper";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "command";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "query";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "script";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "command";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "query";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "script";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSpecificService";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

