/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.diff;

import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.diff.DbDiffRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.ModelLightCopier;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.ide.diff.AsyncDiffElement;
import com.intellij.ide.diff.DiffElement;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.dir.ComparableDiffElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.SqlFileType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DbDiffElement
extends DiffElement<BasicElement>
implements AsyncDiffElement,
ComparableDiffElement {
    static final Logger LOG = Logger.getInstance(DbDiffElement.class);
    public static final String IGNORE_ORDER = "IGNORE_ORDER";
    public static final String IGNORE_CASE = "IGNORE_CASE";
    public static final String IGNORE_SOURCE_CODE = "IGNORE_SOURCE_CODE";
    public static final String IGNORE_IMPLICIT_OBJECTS = "IGNORE_IMPLICIT_OBJECTS";
    public static final String PG_IGNORE_OWNER = "PG_IGNORE_OWNER";
    public static final String MYSQL_IGNORE_DEFINER = "MYSQL_IGNORE_DEFINER";
    private final Object myParent;
    private final BasicElement myElement;
    private final BasicModElement myAltElement;

    public DbDiffElement(@NotNull DbDiffRoot root2, @NotNull BasicElement element2, @Nullable BasicModElement altElement) {
        if (root2 == null) {
            DbDiffElement.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            DbDiffElement.$$$reportNull$$$0(1);
        }
        this.myParent = root2;
        this.myElement = element2;
        this.myAltElement = altElement;
    }

    private DbDiffElement(@NotNull DbDiffElement parent2, @NotNull BasicElement element2, @Nullable BasicModElement altElement) {
        if (parent2 == null) {
            DbDiffElement.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            DbDiffElement.$$$reportNull$$$0(3);
        }
        this.myParent = parent2;
        this.myElement = element2;
        this.myAltElement = altElement;
    }

    public void refresh(boolean userInitiated) {
    }

    @NotNull
    public DbDiffRoot getRoot() {
        DbDiffRoot dbDiffRoot = this.myParent instanceof DbDiffRoot ? (DbDiffRoot)this.myParent : Objects.requireNonNull(this.getParent()).getRoot();
        if (dbDiffRoot == null) {
            DbDiffElement.$$$reportNull$$$0(4);
        }
        return dbDiffRoot;
    }

    @Nullable
    public DbDiffElement getParent() {
        return (DbDiffElement)((Object)ObjectUtils.tryCast((Object)this.myParent, DbDiffElement.class));
    }

    public String getPresentablePath() {
        return this.getRoot().getDataSource().getName() + ":/" + this.getPath(this.getValue());
    }

    public String getPath() {
        return this.getPresentablePath();
    }

    @NotNull
    private String getPath(@Nullable BasicElement value2) {
        if (value2 == null) {
            return "";
        }
        String name = this.getIdentifierMode().apply(value2.getName());
        BasicElement parent2 = value2.getParent();
        String string = (String)(parent2 == null ? "" : this.getPath(parent2) + DbDiffElement.getSeparator()) + name;
        if (string == null) {
            DbDiffElement.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String elementName = this.myElement.identity(false) + ":" + this.myElement.getKind().code();
        String string = this.getIdentifierMode().apply(elementName);
        if (string == null) {
            DbDiffElement.$$$reportNull$$$0(6);
        }
        return string;
    }

    public String getPresentableName() {
        String elementName = this.myElement.getName();
        if (StringUtil.isEmpty((String)elementName)) {
            if (this.myElement instanceof DasForeignKey) {
                elementName = "foreign key";
            } else if (this.myElement instanceof DasTableKey) {
                elementName = ((DasTableKey)((Object)this.myElement)).isPrimary() ? "primary key" : "key";
            } else if (this.myElement instanceof DasIndex) {
                boolean unique = ((DasIndex)((Object)this.myElement)).isUnique();
                elementName = unique ? "unique index" : "index";
            }
        }
        return this.getIdentifierMode().apply(elementName);
    }

    public long getSize() {
        return -1L;
    }

    public long getTimeStamp() {
        return -1L;
    }

    public FileType getFileType() {
        return SqlFileType.INSTANCE;
    }

    public boolean isContainer() {
        return DbDiffElement.isContainer(this.myElement);
    }

    static boolean isContainer(BasicElement element2) {
        return element2.hasChildren() && !(element2 instanceof BasicSourceAware);
    }

    public DiffElement<?>[] getChildren() {
        BasicElement targetElement = this.getParent() == null && this.getRoot().getRootElement().getParent() == this.myElement ? this.getRoot().getRootElement() : null;
        ArrayList<DbDiffElement> list = new ArrayList<DbDiffElement>();
        LocalDataSource lds = DbImplUtil.getMaybeLocalDataSource(this.getRoot().getDataSource());
        TreePattern scope = lds == null ? null : lds.getIntrospectionScope();
        Condition<DasObject> uiFilter = this.getRoot().getFilter();
        boolean ignoreImplicit = this.isIgnoreImplicit();
        Condition filter2 = n -> DataSourceSchemaMapping.isIntrospected(scope, n) && uiFilter.value(n) && (!ignoreImplicit || !(n instanceof BasicElement) || !DbDiffElement.isImplicitObject((BasicElement)n));
        Set<String> hidden = DatabaseViewOptions.getInstance((Project)this.getRoot().getProject()).HIDDEN_KINDS;
        for (Family<? extends BasicElement> family : this.myElement.getFamilies()) {
            Family altF;
            if (hidden.contains(family.getMetaObject().kind.code())) continue;
            Family family2 = altF = this.myAltElement == null ? null : this.myAltElement.familyOf(((ModFamily)family).getMetaObject().kind);
            Object objects2 = targetElement == null ? family.jbi().filter(filter2) : (targetElement.getParentFamily() == family ? Collections.singleton(targetElement) : Collections.emptyList());
            this.appendChildren((List<DbDiffElement>)list, (Iterable<? extends BasicElement>)objects2, (ModFamily<?>)altF);
        }
        return list.isEmpty() ? EMPTY_ARRAY : list.toArray(DiffElement.EMPTY_ARRAY);
    }

    private static boolean isImplicitObject(BasicElement obj) {
        return obj.isAutoCreated() || obj.isElementSurrogate() || obj instanceof BasicIndex && !DbDiffElement.isExplicitIndex((BasicIndex)obj);
    }

    private static boolean isExplicitIndex(BasicIndex obj) {
        BasicLikeTable table = obj.getLikeTable();
        if (table == null) {
            return true;
        }
        BasicKey key = (BasicKey)table.getDasChildren(ObjectKind.KEY).filter(BasicKey.class).filter(k -> k.getUnderlyingIndex() == obj).first();
        if (key == null) {
            return true;
        }
        return ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(DbImplUtilCore.getDbms(obj))).isIndexExplicitFor(obj, key);
    }

    private void appendChildren(List<DbDiffElement> list, Iterable<? extends BasicElement> f, ModFamily<?> altF) {
        if (altF != null) {
            altF.markChildrenAsSyncPending();
        }
        Iterator it2 = altF == null ? null : altF.iterator();
        for (BasicElement basicElement : f) {
            BasicModElement alt;
            if (it2 != null && !it2.hasNext()) {
                it2 = null;
            }
            BasicModElement basicModElement = altF == null ? null : (alt = it2 == null ? (BasicModElement)altF.createNewOne() : (BasicModElement)it2.next());
            if (alt != null) {
                alt.resetSyncPending();
            }
            list.add(new DbDiffElement(this, basicElement, alt));
        }
        if (altF != null) {
            altF.removeSyncPendingChildren();
        }
    }

    @NotNull
    public byte[] getContent() throws IOException {
        ScriptingSingleModelTaskBuilder builder = new ScriptingSingleModelTaskBuilder(this.getRoot().getModel(), ScriptCategory.CREATE_COMPLETE);
        builder.getElements().add(this.getValue());
        builder.setOptions(this.getRoot().createOptions());
        builder.setCurrentNamespace(DasUtil.getParentOfClass(this.getValue(), BasicNamespace.class, false));
        ScriptingResult result2 = ScriptGenerators.INSTANCE.makeScript(this.getRoot().getProject(), builder.build());
        CompositeText script = result2.getScript();
        byte[] byArray = script.getText().toString().getBytes(this.getCharset());
        if (byArray == null) {
            DbDiffElement.$$$reportNull$$$0(7);
        }
        return byArray;
    }

    @NotNull
    public DiffContent createDiffContent(@Nullable Project project, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        if (indicator == null) {
            DbDiffElement.$$$reportNull$$$0(8);
        }
        DiffContent diffContent = (DiffContent)ApplicationManager.getApplication().runReadAction(() -> {
            try {
                Project project1 = this.getRoot().getProject();
                Language language = this.getRoot().getLanguage();
                PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project1);
                PsiFile psiFile = psiFileFactory.createFileFromText("a." + this.getFileType().getDefaultExtension(), language, (CharSequence)StringUtil.convertLineSeparators((String)new String(this.getContent(), this.getCharset())), false, true);
                VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
                if (virtualFile instanceof LightVirtualFile) {
                    ((LightVirtualFile)virtualFile).setWritable(false);
                }
                Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
                assert (document != null);
                DocumentContent content = DiffContentFactory.getInstance().create(project1, document, virtualFile);
                content.putUserData(DiffUserDataKeys.LANGUAGE, (Object)language);
                return content;
            }
            catch (IOException e) {
                throw new DiffRequestProducerException((Throwable)e);
            }
        });
        if (diffContent == null) {
            DbDiffElement.$$$reportNull$$$0(9);
        }
        return diffContent;
    }

    @NotNull
    private Case getIdentifierMode() {
        Case case_ = this.isIgnoreCase() ? Case.LOWER : Case.MIXED;
        if (case_ == null) {
            DbDiffElement.$$$reportNull$$$0(10);
        }
        return case_;
    }

    @NotNull
    private Case getKeywordMode() {
        Case case_ = this.isIgnoreCase() ? Case.UPPER : Case.MIXED;
        if (case_ == null) {
            DbDiffElement.$$$reportNull$$$0(11);
        }
        return case_;
    }

    private boolean isIgnoreCase() {
        return (Boolean)this.getRoot().getSettings().customSettings.get(IGNORE_CASE);
    }

    private boolean isIgnoreImplicit() {
        return (Boolean)this.getRoot().getSettings().customSettings.get(IGNORE_IMPLICIT_OBJECTS);
    }

    private boolean isIgnoreSources() {
        return (Boolean)this.getRoot().getSettings().customSettings.get(IGNORE_SOURCE_CODE);
    }

    @NotNull
    public BasicElement getValue() {
        BasicElement basicElement = this.myElement;
        if (basicElement == null) {
            DbDiffElement.$$$reportNull$$$0(12);
        }
        return basicElement;
    }

    public Icon getIcon() {
        return this.myParent instanceof DbDiffRoot ? this.getRoot().getDataSource().getIcon() : DbPresentationCore.getIcon(this.getValue());
    }

    public boolean isOperationsEnabled() {
        return true;
    }

    @NotNull
    public Promise<DiffElement> copyToAsync(@NotNull DiffElement container, @Nullable DiffElement target, @NotNull String relativePath) {
        if (container == null) {
            DbDiffElement.$$$reportNull$$$0(13);
        }
        if (relativePath == null) {
            DbDiffElement.$$$reportNull$$$0(14);
        }
        Promise promise = Promises.cancelledPromise();
        if (promise == null) {
            DbDiffElement.$$$reportNull$$$0(15);
        }
        return promise;
    }

    @NotNull
    public Promise<Void> deleteAsync() {
        Promise promise = Promises.cancelledPromise();
        if (promise == null) {
            DbDiffElement.$$$reportNull$$$0(16);
        }
        return promise;
    }

    public String toString() {
        return "DbDiffElement{kind=" + this.myElement.getKind() + ", name=" + QNameUtil.getQualifiedName(this.myElement) + "}";
    }

    @Nullable
    public Boolean isContentEqual(@NotNull DiffElement other) {
        DbDiffElement e2;
        if (other == null) {
            DbDiffElement.$$$reportNull$$$0(17);
        }
        if ((e2 = (DbDiffElement)((Object)ObjectUtils.tryCast((Object)other, DbDiffElement.class))) == null) {
            return null;
        }
        if (this.myAltElement == null && e2.myAltElement == null) {
            return this.isEqual(this.getValue(), e2.getValue());
        }
        if (this.myAltElement == null || e2.myAltElement == null) {
            return null;
        }
        return this.isEqual(Objects.requireNonNull(this.myAltElement), e2.getValue()) && this.isEqual(Objects.requireNonNull(e2.myAltElement), this.getValue());
    }

    @Nullable
    public BasicModElement getAltElement() {
        return this.myAltElement;
    }

    private void fillAltElement(DbDiffElement other, boolean withSources) {
        if (this.myAltElement == null) {
            return;
        }
        if (other != null) {
            DbDiffElement.assignElement(other.getValue(), this.myAltElement, false);
        }
        BasicMetaUtils.copyMatchedProperties(this.getValue(), this.myAltElement, other == null, withSources);
    }

    private void fillAltElementUpward(@NotNull DbDiffElement other, boolean withSources) {
        if (other == null) {
            DbDiffElement.$$$reportNull$$$0(18);
        }
        if (this.myAltElement == null) {
            return;
        }
        BasicElement alt = this.myAltElement;
        for (BasicElement o = other.getValue(); alt != null && o != null; alt = alt.getParent(), o = o.getParent()) {
            DbDiffElement.assignElement(o, alt, withSources);
        }
    }

    public void prepare(@Nullable DiffElement<?> other) {
        boolean withSources;
        DbDiffElement o = (DbDiffElement)((Object)ObjectUtils.tryCast(other, DbDiffElement.class));
        boolean bl = withSources = !this.isIgnoreSources();
        if (!this.isContainer()) {
            DbDiffElement.copyChildren(this.getValue(), this.myAltElement, withSources);
        }
        this.fillAltElement(o, withSources);
        if (o != null && this.getParent() == null) {
            this.fillAltElementUpward(o, withSources);
        }
    }

    private static void copyChildren(BasicElement from, BasicModElement to, boolean withSources) {
        for (Family<? extends BasicElement> family : from.getFamilies()) {
            Family toF;
            if (family.isEmpty() || (toF = to.familyOf(family.first().getKind())) == null) continue;
            toF.clear();
            for (BasicElement basicElement : family) {
                Object toC = toF.createNewOne();
                DbDiffElement.assignElement(basicElement, toC, withSources);
                DbDiffElement.copyChildren(basicElement, toC, withSources);
            }
        }
    }

    public static void assignElement(@NotNull BasicElement from, BasicModElement to, boolean withSources) {
        if (from == null) {
            DbDiffElement.$$$reportNull$$$0(19);
        }
        if (to == null) {
            return;
        }
        if (from.getMetaObject() != to.getMetaObject()) {
            BasicMetaUtils.copyMatchedProperties(from, to, true, withSources);
        } else {
            ModelLightCopier.copyProperties(from, to, withSources);
        }
    }

    private boolean isEqual(@NotNull BasicElement o1, @NotNull BasicElement o2) {
        boolean equal;
        if (o1 == null) {
            DbDiffElement.$$$reportNull$$$0(20);
        }
        if (o2 == null) {
            DbDiffElement.$$$reportNull$$$0(21);
        }
        return equal = ScriptGenerators.INSTANCE.byModel(this.getRoot().getModel()).isEqual(o1, o2, this.getRoot().createOptions());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/diff/DbDiffElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/diff/DbDiffElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffContent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifierMode";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordMode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToAsync";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDiffContent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyToAsync";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isContentEqual";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fillAltElementUpward";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "assignElement";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isEqual";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

