/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.Dbms;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.NameValueType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.ColumnKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.model.properties.IndexColumn;
import com.intellij.database.model.properties.RoutineSqlAccess;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.util.CalendarFun;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterator;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PropertyConverter {
    public static final Logger ourLog = Logger.getInstance(PropertyConverter.class);
    public static final BasicMetaType<Boolean> T_BOOLEAN = new BasicMetaType<Boolean>(Boolean.TYPE, PropertyConverter::importBoolean, PropertyConverter::export);
    public static final BasicMetaType<Byte> T_BYTE = new BasicMetaType<Byte>(Byte.TYPE, PropertyConverter::importByte, PropertyConverter::export);
    public static final BasicMetaType<Short> T_SHORT = new BasicMetaType<Short>(Short.TYPE, PropertyConverter::importShort, PropertyConverter::export);
    public static final BasicMetaType<Integer> T_INT = new BasicMetaType<Integer>(Integer.TYPE, PropertyConverter::importInt, PropertyConverter::export);
    public static final BasicMetaType<Long> T_LONG = new BasicMetaType<Long>(Long.TYPE, PropertyConverter::importLong, PropertyConverter::export);
    public static final BasicMetaType<Float> T_FLOAT = new BasicMetaType<Float>(Float.TYPE, PropertyConverter::importFloat, PropertyConverter::export);
    public static final BasicMetaType<Double> T_DOUBLE = new BasicMetaType<Double>(Double.TYPE, PropertyConverter::importDouble, PropertyConverter::export);
    public static final BasicMetaType<String> T_STRING = new BasicMetaType<String>(String.class, PropertyConverter::importString, PropertyConverter::export);
    public static final BasicMetaType<OneTimeString> T_ONE_TIME_STRING = new BasicMetaType<OneTimeString>(OneTimeString.class, PropertyConverter::importOneTimeString, PropertyConverter::export);
    public static final BasicMetaType<Date> T_DATE = new BasicMetaType<Date>(Date.class, PropertyConverter::importDate, PropertyConverter::export);
    public static final BasicMetaType<ObjectKind> T_OBJECT_KIND = new BasicMetaType<ObjectKind>(ObjectKind.class, PropertyConverter::importObjectKind, PropertyConverter::export);
    public static final BasicMetaType<BigInteger> T_BIG_INTEGER = new BasicMetaType<BigInteger>(BigInteger.class, PropertyConverter::importBigInteger, PropertyConverter::export);
    public static final BasicMetaType<DataType> T_DATA_TYPE = new BasicMetaType<DataType>(DataType.class, PropertyConverter::importDataType, PropertyConverter::export);
    public static final BasicMetaType<SequenceIdentity> T_SEQUENCE_IDENTITY = new BasicMetaType<SequenceIdentity>(SequenceIdentity.class, PropertyConverter::importSequenceIdentity, PropertyConverter::export);
    public static final BasicMetaType<ArgumentDirection> T_ARGUMENT_DIRECTION = new BasicMetaType<ArgumentDirection>(ArgumentDirection.class, PropertyConverter::importArgumentDirection, PropertyConverter::export);
    public static final BasicMetaType<Casing> T_CASING = new BasicMetaType<Casing>(Casing.class, PropertyConverter::importCasing, PropertyConverter::export);
    public static final BasicMetaType<CascadeRule> T_CASCADE_RULE = new BasicMetaType<CascadeRule>(CascadeRule.class, PropertyConverter::importCascadeRule, PropertyConverter::export);
    public static final BasicMetaType<DasRoutine.Kind> T_DAS_ROUTINE_KIND = new BasicMetaType<DasRoutine.Kind>(DasRoutine.Kind.class, PropertyConverter::importDasRoutineKind, PropertyConverter::export);
    public static final BasicMetaType<TrigTurn> T_TRIG_TURN = new BasicMetaType<TrigTurn>(TrigTurn.class, PropertyConverter::importTrigTurn, PropertyConverter::export);
    public static final BasicMetaType<ColumnKind> T_COLUMN_KIND = new BasicMetaType<ColumnKind>(ColumnKind.class, PropertyConverter::importColumnKind, PropertyConverter::export);
    public static final BasicMetaType<ClusterType> T_CLUSTER_TYPE = new BasicMetaType<ClusterType>(ClusterType.class, PropertyConverter::importClusterType, PropertyConverter::export);
    public static final BasicMetaType<Version> T_VERSION = new BasicMetaType<Version>(Version.class, PropertyConverter::importVersion, PropertyConverter::export);
    public static final BasicMetaType<Dbms> T_DBMS = new BasicMetaType<Dbms>(Dbms.class, PropertyConverter::importDbms, PropertyConverter::export);
    public static final BasicMetaType<List<Short>> T_LIST_OF_SHORT = new BasicMetaType.CollectionMetaType<Short, List<Short>>(List.class, Short.class, PropertyConverter::importListOfShort, PropertyConverter::exportListOfShort);
    public static final BasicMetaType<List<Long>> T_LIST_OF_LONG = new BasicMetaType.CollectionMetaType<Long, List<Long>>(List.class, Long.class, PropertyConverter::importListOfLong, PropertyConverter::exportListOfLong);
    public static final BasicMetaType<List<Integer>> T_LIST_OF_INTEGER = new BasicMetaType.CollectionMetaType<Integer, List<Integer>>(List.class, Integer.class, PropertyConverter::importListOfInteger, PropertyConverter::exportListOfInteger);
    public static final BasicMetaType<Set<Long>> T_SET_OF_LONG = new BasicMetaType.CollectionMetaType<Long, Set<Long>>(Set.class, Long.class, PropertyConverter::importSetOfLong, PropertyConverter::exportSetOfLong);
    public static final BasicMetaType<List<String>> T_LIST_OF_STRING = new BasicMetaType.CollectionMetaType<String, List<String>>(List.class, String.class, PropertyConverter::importListOfString, PropertyConverter::exportListOfString);
    public static final BasicMetaType<Set<String>> T_SET_OF_STRING = new BasicMetaType.CollectionMetaType<String, Set<String>>(Set.class, String.class, PropertyConverter::importSetOfString, PropertyConverter::exportSetOfString);
    public static final BasicMetaType<List<NameValue>> T_LIST_OF_NAME_VALUE = new BasicMetaType.CollectionMetaType<NameValue, List<NameValue>>(List.class, NameValue.class, PropertyConverter::importListOfNameValue, PropertyConverter::exportListOfNameValue);
    public static final BasicMetaType<List<NameValueType>> T_LIST_OF_NAME_VALUE_TYPE = new BasicMetaType.CollectionMetaType<NameValueType, List<NameValueType>>(List.class, NameValueType.class, PropertyConverter::importListOfNameValueType, PropertyConverter::exportListOfNameValueType);
    public static final BasicMetaType<Set<TrigEvent>> T_SET_OF_TRIG_EVENT = new BasicMetaType.CollectionMetaType<TrigEvent, Set<TrigEvent>>(Set.class, TrigEvent.class, PropertyConverter::importSetOfTrigEvent, PropertyConverter::exportSetOfTrigEvent);
    public static final BasicMetaType<List<IndexColumn>> T_LIST_OF_INDEX_COLUMN = new BasicMetaType.CollectionMetaType<IndexColumn, List<IndexColumn>>(List.class, IndexColumn.class, PropertyConverter::importListOfIndexColumn, PropertyConverter::exportListOfIndexColumn);
    public static final BasicMetaType<List<SourceError>> T_LIST_OF_SOURCE_ERROR = new BasicMetaType.CollectionMetaType<SourceError, List<SourceError>>(List.class, SourceError.class, PropertyConverter::importListOfSourceError, PropertyConverter::exportListOfSourceError);
    public static final BasicMetaType<RoutineSqlAccess> T_ROUTINE_SQL_ACCESS = new BasicMetaType<RoutineSqlAccess>(RoutineSqlAccess.class, PropertyConverter::importRoutineSqlAccess, PropertyConverter::export);

    public static String export(boolean value2) {
        return value2 ? "1" : "0";
    }

    public static String export(byte value2) {
        return Byte.toString(value2);
    }

    public static String export(short value2) {
        return Short.toString(value2);
    }

    public static String export(int value2) {
        return Integer.toString(value2);
    }

    public static String export(long value2) {
        return Long.toString(value2);
    }

    public static String export(float value2) {
        return Float.toString(value2);
    }

    public static String export(double value2) {
        return Double.toString(value2);
    }

    @Nullable
    public static String export(@NotNull String string) {
        if (string == null) {
            PropertyConverter.$$$reportNull$$$0(0);
        }
        return StringUtil.nullize((String)string);
    }

    @Nullable
    public static String export(@NotNull OneTimeString string) {
        if (string == null) {
            PropertyConverter.$$$reportNull$$$0(1);
        }
        return string.toString(false);
    }

    public static String export(@NotNull Date timestamp) {
        if (timestamp == null) {
            PropertyConverter.$$$reportNull$$$0(2);
        }
        return CalendarFun.export(timestamp);
    }

    public static String export(@NotNull ObjectKind kind) {
        if (kind == null) {
            PropertyConverter.$$$reportNull$$$0(3);
        }
        return kind.code();
    }

    public static String export(@NotNull BigInteger bigInteger) {
        if (bigInteger == null) {
            PropertyConverter.$$$reportNull$$$0(4);
        }
        return bigInteger.toString();
    }

    public static String export(@NotNull DataType dt) {
        if (dt == null) {
            PropertyConverter.$$$reportNull$$$0(5);
        }
        return DataTypeFactory.serialize(dt);
    }

    public static String export(@NotNull SequenceIdentity si) {
        if (si == null) {
            PropertyConverter.$$$reportNull$$$0(6);
        }
        return si.getSpecification(true);
    }

    public static String export(@NotNull Enum item) {
        if (item == null) {
            PropertyConverter.$$$reportNull$$$0(7);
        }
        return StringUtil.toLowerCase((String)item.name()).replace('_', '-');
    }

    public static String export(@NotNull ArgumentDirection dir) {
        if (dir == null) {
            PropertyConverter.$$$reportNull$$$0(8);
        }
        return Character.toString(dir.code);
    }

    public static String export(@NotNull Casing casing) {
        if (casing == null) {
            PropertyConverter.$$$reportNull$$$0(9);
        }
        return casing.specification();
    }

    public static String export(@NotNull Version version) {
        if (version == null) {
            PropertyConverter.$$$reportNull$$$0(10);
        }
        return version.toString();
    }

    public static String export(@NotNull Dbms dbms) {
        if (dbms == null) {
            PropertyConverter.$$$reportNull$$$0(11);
        }
        return dbms.getName();
    }

    public static String export(@NotNull Grants<?> grants) {
        if (grants == null) {
            PropertyConverter.$$$reportNull$$$0(12);
        }
        return grants.serialize();
    }

    public static String exportEnumCode(@NotNull Enum item) {
        Object value2;
        if (item == null) {
            PropertyConverter.$$$reportNull$$$0(13);
        }
        Class<?> clazz = item.getClass();
        try {
            Field field = clazz.getField("code");
            value2 = field.get(item);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to serialize an item " + item.name() + " of class " + clazz.getName(), e);
        }
        return value2 != null ? value2.toString() : null;
    }

    @Nullable
    public static String exportListOfShort(@NotNull List<Short> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(14);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportListOfLong(@NotNull List<Long> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(15);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportListOfInteger(@NotNull List<Integer> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(16);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportSetOfLong(@NotNull Set<Long> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(17);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportCollectionOfNumber(@NotNull Collection<? extends Number> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(18);
        }
        int n = numbers.size();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return numbers.iterator().next().toString();
            }
        }
        return StringUtil.join(numbers, (String)",");
    }

    @Nullable
    public static String exportListOfString(@NotNull List<String> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(19);
        }
        return PropertyConverter.exportCollectionOfString(strings);
    }

    @Nullable
    public static String exportListOfNameValue(@NotNull List<NameValue> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(20);
        }
        if (strings.isEmpty()) {
            return null;
        }
        MultilineExporter exporter = new MultilineExporter();
        for (NameValue nv : strings) {
            exporter.append(nv.getName()).newLine().append(nv.getValue()).newLine();
        }
        return exporter.build();
    }

    @Nullable
    public static String exportListOfNameValueType(@NotNull List<NameValueType> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(21);
        }
        if (strings.isEmpty()) {
            return null;
        }
        MultilineExporter exporter = new MultilineExporter();
        for (NameValueType nv : strings) {
            exporter.append(nv.getName()).newLine().append(nv.getValue()).newLine().append(nv.getType()).newLine();
        }
        return exporter.build();
    }

    @Nullable
    public static String exportSetOfString(@NotNull Set<String> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(22);
        }
        return PropertyConverter.exportCollectionOfString(strings);
    }

    @Nullable
    public static String exportCollectionOfString(@NotNull Collection<String> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(23);
        }
        int n = strings.size();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return PropertyConverter.escapeSlashN(strings.iterator().next());
            }
        }
        MultilineExporter exporter = new MultilineExporter();
        for (String string : strings) {
            exporter.append(string).newLine();
        }
        return exporter.build();
    }

    @NotNull
    public static <T> String joinAll(@NotNull Collection<? extends T> items2, @NotNull Function<? super T, String> f, @NotNull String separator) {
        if (items2 == null) {
            PropertyConverter.$$$reportNull$$$0(24);
        }
        if (f == null) {
            PropertyConverter.$$$reportNull$$$0(25);
        }
        if (separator == null) {
            PropertyConverter.$$$reportNull$$$0(26);
        }
        StringBuilder res2 = new StringBuilder();
        boolean first2 = true;
        for (T item : items2) {
            if (!first2) {
                res2.append(separator);
            } else {
                first2 = false;
            }
            res2.append((String)f.fun(item));
        }
        String string = res2.toString();
        if (string == null) {
            PropertyConverter.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static String escapeSlashN(String s2) {
        String string = s2.replace("\\", "\\\\").replace("\n", "\\n");
        if (string == null) {
            PropertyConverter.$$$reportNull$$$0(28);
        }
        return string;
    }

    public static String exportSetOfTrigEvent(@NotNull Set<TrigEvent> events) {
        if (events == null) {
            PropertyConverter.$$$reportNull$$$0(29);
        }
        StringBuilder b2 = new StringBuilder(events.size());
        for (TrigEvent event : events) {
            b2.append(event.code);
        }
        return b2.toString();
    }

    public static String exportListOfIndexColumn(List<IndexColumn> indexColumns) {
        MultilineExporter exporter = new MultilineExporter();
        for (IndexColumn indexColumn : indexColumns) {
            exporter.append(indexColumn.export()).newLine();
        }
        return exporter.build();
    }

    public static String exportListOfSourceError(List<SourceError> errors) {
        MultilineExporter exporter = new MultilineExporter();
        for (SourceError error2 : errors) {
            exporter.append(error2.export()).newLine();
        }
        return exporter.build();
    }

    public static boolean importBoolean(String text2) {
        char c2 = text2 != null && !text2.isEmpty() ? text2.charAt(0) : (char)'\u0000';
        c2 = Character.toUpperCase(c2);
        return c2 >= '1' && c2 <= '9' || c2 == 'Y' || c2 == 'T' || c2 == '+';
    }

    public static byte importByte(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0;
        }
        try {
            return Byte.parseByte(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static short importShort(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0;
        }
        try {
            return Short.parseShort(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int importInt(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long importLong(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static float importFloat(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static double importDouble(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static BigInteger importBigInteger(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return BigInteger.ZERO;
        }
        try {
            return new BigInteger(text2.trim());
        }
        catch (NumberFormatException e) {
            return BigInteger.ZERO;
        }
    }

    public static String importString(String text2) {
        return DbUtil.intern(text2);
    }

    public static OneTimeString importOneTimeString(String text2) {
        return text2 == null ? null : new OneTimeString(text2);
    }

    public static ObjectKind importObjectKind(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return ObjectKind.ourKinds.get(StringUtil.toLowerCase((String)text2.trim()));
    }

    public static DataType importDataType(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return DataTypeFactory.deserialize(text2);
    }

    public static <E extends Enum> E importEnumByCode(Class<E> enumClass, String text2) {
        if (text2 == null) {
            return null;
        }
        int length = text2.length();
        Enum enumItem = null;
        try {
            Object o;
            Method methodWithChar = PropertyConverter.getStaticMethod(enumClass, "of", Character.TYPE);
            Method methodWithByte = PropertyConverter.getStaticMethod(enumClass, "of", Byte.TYPE);
            Method methodWithString = PropertyConverter.getStaticMethod(enumClass, "of", String.class);
            if (methodWithChar == null && methodWithByte == null && methodWithString == null) {
                throw new IllegalArgumentException(String.format("Cannot import property of type %s: no static method of.", enumClass));
            }
            if (length == 1) {
                if (methodWithChar != null) {
                    Character c2 = Character.valueOf(text2.charAt(0));
                    o = methodWithChar.invoke(null, c2);
                } else if (methodWithByte != null) {
                    char c3 = text2.charAt(0);
                    Byte b2 = PropertyConverter.charDigit(c3);
                    o = methodWithByte.invoke(null, b2);
                } else {
                    o = methodWithString.invoke(null, text2);
                }
            } else if (methodWithString != null) {
                o = methodWithString.invoke(null, text2);
            } else if (methodWithByte != null) {
                Byte b3 = PropertyConverter.safeParseByte(text2);
                o = methodWithByte.invoke(null, b3);
            } else {
                Character c4 = Character.valueOf(text2.charAt(0));
                o = methodWithChar.invoke(null, c4);
            }
            enumItem = (Enum)o;
        }
        catch (Exception e) {
            String message2 = String.format("Failed to import property value \"%s\" as enum %s: exception %s: %s", text2, enumClass.getSimpleName(), e.getClass().getSimpleName(), e.getMessage());
            if (ourLog.isDebugEnabled()) {
                ourLog.warn(message2, (Throwable)e);
            }
            ourLog.warn(message2);
        }
        return (E)enumItem;
    }

    public static Byte charDigit(char c2) {
        return c2 >= '0' && c2 <= '9' ? Byte.valueOf((byte)(c2 - 48)) : null;
    }

    public static Byte safeParseByte(String str) {
        String s2 = str.trim();
        if (s2.isEmpty()) {
            return null;
        }
        try {
            return Byte.parseByte(s2);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static DasRoutine.Kind importDasRoutineKind(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return DasRoutine.Kind.byChar(text2.charAt(0));
    }

    public static ArgumentDirection importArgumentDirection(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return ArgumentDirection.of(text2.charAt(0));
    }

    @Contract(value="null -> null")
    public static Date importDate(String text2) {
        if (text2 == null) {
            return null;
        }
        return CalendarFun.importSqlDateTime(text2);
    }

    @Contract(value="null -> null")
    public static Version importVersion(String text2) {
        if (text2 == null) {
            return null;
        }
        try {
            return Version.of(text2);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Contract(value="null -> null")
    public static Dbms importDbms(String text2) {
        if (text2 == null) {
            return null;
        }
        return Dbms.byName(text2);
    }

    @NotNull
    public static List<Short> importListOfShort(String text2) {
        List<Long> listOfLong = PropertyConverter.importListOfLong(text2);
        ArrayList<Short> listOfShort = new ArrayList<Short>(listOfLong.size());
        for (long value2 : listOfLong) {
            if (value2 < -32768L || value2 > 32767L) continue;
            listOfShort.add(new Short((short)value2));
        }
        ArrayList<Short> arrayList = listOfShort;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @NotNull
    public static Set<Long> importSetOfLong(String text2) {
        return PropertyConverter.convertListToSet(PropertyConverter.importListOfLong(text2));
    }

    @NotNull
    public static List<Integer> importListOfInteger(String text2) {
        return PropertyConverter.importList(text2, Integer::parseInt);
    }

    @NotNull
    public static List<Long> importListOfLong(String text2) {
        return PropertyConverter.importList(text2, Long::parseLong);
    }

    @NotNull
    public static <T> List<T> importList(@Nullable String text2, @NotNull Function<String, T> converter) {
        if (converter == null) {
            PropertyConverter.$$$reportNull$$$0(31);
        }
        if (text2 == null || text2.length() == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(32);
            }
            return list;
        }
        List strings = StringUtil.split((String)text2, (String)",");
        int n = strings.size();
        if (n == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(33);
            }
            return list;
        }
        ArrayList<Object> values2 = new ArrayList<Object>(n);
        for (String string : strings) {
            try {
                Object value2 = converter.fun((Object)string);
                values2.add(value2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        switch (values2.size()) {
            case 0: {
                List list = Collections.emptyList();
                if (list == null) {
                    PropertyConverter.$$$reportNull$$$0(34);
                }
                return list;
            }
            case 1: {
                List list = Collections.singletonList(values2.get(0));
                if (list == null) {
                    PropertyConverter.$$$reportNull$$$0(35);
                }
                return list;
            }
        }
        ArrayList<Object> arrayList = values2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @NotNull
    public static Set<String> importSetOfString(String text2) {
        if (text2 == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PropertyConverter.$$$reportNull$$$0(37);
            }
            return set;
        }
        if (text2.length() == 0) {
            Set<String> set = Collections.singleton("");
            if (set == null) {
                PropertyConverter.$$$reportNull$$$0(38);
            }
            return set;
        }
        return PropertyConverter.convertToSet(new MultilineImporter(text2, true));
    }

    @NotNull
    public static <T> Set<T> convertListToSet(@NotNull List<T> items2) {
        if (items2 == null) {
            PropertyConverter.$$$reportNull$$$0(39);
        }
        int n = items2.size();
        switch (n) {
            case 0: {
                Set set = Collections.emptySet();
                if (set == null) {
                    PropertyConverter.$$$reportNull$$$0(40);
                }
                return set;
            }
            case 1: {
                Set<T> set = Collections.singleton(items2.get(0));
                if (set == null) {
                    PropertyConverter.$$$reportNull$$$0(41);
                }
                return set;
            }
        }
        return new TreeSet<T>(items2);
    }

    @NotNull
    public static <T> Set<T> convertToSet(@NotNull Iterator<T> items2) {
        if (items2 == null) {
            PropertyConverter.$$$reportNull$$$0(42);
        }
        if (!items2.hasNext()) {
            Set set = Collections.emptySet();
            if (set == null) {
                PropertyConverter.$$$reportNull$$$0(43);
            }
            return set;
        }
        T first2 = items2.next();
        if (!items2.hasNext()) {
            Set<T> set = Collections.singleton(first2);
            if (set == null) {
                PropertyConverter.$$$reportNull$$$0(44);
            }
            return set;
        }
        TreeSet<T> set = new TreeSet<T>();
        set.add(first2);
        while (items2.hasNext()) {
            set.add(items2.next());
        }
        TreeSet<T> treeSet = set;
        if (treeSet == null) {
            PropertyConverter.$$$reportNull$$$0(45);
        }
        return treeSet;
    }

    @NotNull
    public static List<String> importListOfString(String text2) {
        if (text2 == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(46);
            }
            return list;
        }
        if (text2.length() == 0) {
            List<String> list = Collections.singletonList("");
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(47);
            }
            return list;
        }
        List list = ContainerUtil.collect((Iterator)((Object)new MultilineImporter(text2, true)));
        if (list == null) {
            PropertyConverter.$$$reportNull$$$0(48);
        }
        return list;
    }

    @NotNull
    public static List<NameValue> importListOfNameValue(String text2) {
        if (text2 == null || text2.length() == 0) {
            List<NameValue> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(49);
            }
            return list;
        }
        ArrayList<NameValue> res2 = new ArrayList<NameValue>();
        MultilineImporter importer = new MultilineImporter(text2, true);
        while (importer.hasNext()) {
            String name = (String)importer.next();
            String value2 = importer.nextOr("");
            res2.add(new NameValue(name, value2));
        }
        ArrayList<NameValue> arrayList = res2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(50);
        }
        return arrayList;
    }

    @NotNull
    public static List<NameValueType> importListOfNameValueType(String text2) {
        if (text2 == null || text2.length() == 0) {
            List<NameValueType> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(51);
            }
            return list;
        }
        ArrayList<NameValueType> res2 = new ArrayList<NameValueType>();
        MultilineImporter importer = new MultilineImporter(text2, true);
        while (importer.hasNext()) {
            String name = (String)importer.next();
            String value2 = importer.nextOr("");
            String type = importer.nextOr("");
            res2.add(new NameValueType(name, value2, type));
        }
        ArrayList<NameValueType> arrayList = res2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(52);
        }
        return arrayList;
    }

    public static SequenceIdentity importSequenceIdentity(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return SequenceIdentity.of(text2);
    }

    @NotNull
    public static Set<TrigEvent> importSetOfTrigEvent(String text2) {
        EnumSet<TrigEvent> events = EnumSet.noneOf(TrigEvent.class);
        for (TrigEvent e : TrigEvent.values()) {
            if (text2.indexOf(e.code) < 0) continue;
            events.add(e);
        }
        EnumSet<TrigEvent> enumSet = events;
        if (enumSet == null) {
            PropertyConverter.$$$reportNull$$$0(53);
        }
        return enumSet;
    }

    public static RoutineSqlAccess importRoutineSqlAccess(String text2) {
        return PropertyConverter.importEnum(RoutineSqlAccess.class, text2);
    }

    public static TrigEvent importTrigEvent(String text2) {
        return PropertyConverter.importEnum(TrigEvent.class, text2);
    }

    public static TrigTurn importTrigTurn(String text2) {
        return PropertyConverter.importEnum(TrigTurn.class, text2);
    }

    public static CascadeRule importCascadeRule(String text2) {
        return PropertyConverter.importEnumLC(CascadeRule.class, text2);
    }

    public static Casing importCasing(String text2) {
        return Casing.of(text2);
    }

    public static ClusterType importClusterType(String text2) {
        return ClusterType.of(text2);
    }

    public static <E extends Enum<E>> E importEnum(Class<E> enumClass, String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        String big = StringUtil.toUpperCase((String)text2.trim().replace('-', '_'));
        return Enum.valueOf(enumClass, big);
    }

    public static <E extends Enum<E>> E importEnumLC(Class<E> enumClass, String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        String big = text2.trim().replace('-', '_');
        return Enum.valueOf(enumClass, big);
    }

    @Nullable
    public static ColumnKind importColumnKind(String kind) {
        return PropertyConverter.importEnum(ColumnKind.class, kind);
    }

    @NotNull
    public static List<IndexColumn> importListOfIndexColumn(String text2) {
        if (text2 == null) {
            List<IndexColumn> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(54);
            }
            return list;
        }
        ArrayList<IndexColumn> res2 = new ArrayList<IndexColumn>();
        MultilineImporter importer = new MultilineImporter(text2, false);
        while (importer.hasNext()) {
            res2.add(IndexColumn.read((String)importer.next()));
        }
        ArrayList<IndexColumn> arrayList = res2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(55);
        }
        return arrayList;
    }

    @NotNull
    public static List<SourceError> importListOfSourceError(String text2) {
        if (text2 == null) {
            List<SourceError> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(56);
            }
            return list;
        }
        ArrayList<SourceError> res2 = new ArrayList<SourceError>();
        MultilineImporter importer = new MultilineImporter(text2, false);
        while (importer.hasNext()) {
            res2.add(SourceError.importError((String)importer.next()));
        }
        ArrayList<SourceError> arrayList = res2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(57);
        }
        return arrayList;
    }

    public static void internElements(@NotNull List<String> list) {
        if (list == null) {
            PropertyConverter.$$$reportNull$$$0(58);
        }
        int n = list.size();
        for (int i2 = 0; i2 < n; ++i2) {
            String s2 = list.get(i2);
            if (s2 == null) continue;
            list.set(i2, DbUtil.intern(s2));
        }
    }

    public static <E extends Enum> Method getStaticMethod(@NotNull Class<E> clazz, @NotNull String name, Class<?> ... parameterTypes) {
        Method method;
        if (clazz == null) {
            PropertyConverter.$$$reportNull$$$0(59);
        }
        if (name == null) {
            PropertyConverter.$$$reportNull$$$0(60);
        }
        try {
            method = clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalStateException(String.format("Method %s.%s(%s) must be static", clazz.getSimpleName(), name, StringUtil.join((Object[])parameterTypes, t -> t.getSimpleName(), (String)", ")));
        }
        method.setAccessible(true);
        return method;
    }

    public static int extractCompact(int compact, int offset, int mask) {
        return (compact & mask) >> offset;
    }

    public static int prepareCompact(int value2, int offset, int mask) {
        return value2 << offset & mask;
    }

    public static int applyCompact(int compact, int value2, int offset, int mask) {
        return compact & ~mask | PropertyConverter.prepareCompact(value2, offset, mask);
    }

    public static boolean extractBoolean(int compact) {
        return compact != 0;
    }

    public static int compactBoolean(boolean value2) {
        return value2 ? 1 : 0;
    }

    public static <T extends Enum<?>> T extractEnum(int value2, Class<T> clazz) {
        Enum[] constants = (Enum[])clazz.getEnumConstants();
        return (T)constants[value2];
    }

    public static int compactEnum(Enum<?> value2) {
        return value2.ordinal();
    }

    public static <T extends Enum<?>> T extractNullableEnum(int value2, Class<T> clazz) {
        if (value2 == 0) {
            return null;
        }
        Enum[] constants = (Enum[])clazz.getEnumConstants();
        return (T)constants[value2 - 1];
    }

    public static int compactNullableEnum(Enum<?> value2) {
        return value2 == null ? 0 : value2.ordinal() + 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bigInteger";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dt";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "si";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grants";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "numbers";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 24: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/PropertyConverter";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/PropertyConverter";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "joinAll";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeSlashN";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfShort";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "importList";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "importSetOfString";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "convertListToSet";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToSet";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfString";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfNameValue";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfNameValueType";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "importSetOfTrigEvent";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfIndexColumn";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfSourceError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "exportEnumCode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfShort";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfLong";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfInteger";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "exportSetOfLong";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "exportCollectionOfNumber";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfString";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfNameValue";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfNameValueType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "exportSetOfString";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "exportCollectionOfString";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "joinAll";
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "exportSetOfTrigEvent";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "importList";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "convertListToSet";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "convertToSet";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "internElements";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getStaticMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MultilineImporter
    extends JBIterator<String> {
        private final String myText;
        private final boolean myIntern;
        private int cur = 0;

        public MultilineImporter(@Nullable String text2, boolean intern) {
            this.myText = text2;
            this.myIntern = intern;
        }

        protected String nextImpl() {
            if (this.myText == null || this.cur == -1) {
                return (String)this.stop();
            }
            int nx = StringUtil.indexOf((CharSequence)this.myText, (char)'\n', (int)this.cur);
            String res2 = StringUtil.unescapeStringCharacters((String)this.myText.substring(this.cur, nx == -1 ? this.myText.length() : nx));
            this.cur = nx == -1 ? -1 : nx + 1;
            return this.myIntern ? DbUtil.intern(res2) : res2;
        }

        public String nextOr(String def) {
            return this.hasNext() ? (String)this.next() : def;
        }
    }

    public static class MultilineExporter {
        private final StringBuilder builder = new StringBuilder();
        private boolean nl = false;

        public MultilineExporter append(String s2) {
            this.flushNl();
            this.builder.append(PropertyConverter.escapeSlashN(s2));
            return this;
        }

        public MultilineExporter newLine() {
            this.flushNl();
            this.nl = true;
            return this;
        }

        private void flushNl() {
            if (this.nl) {
                this.builder.append('\n');
            }
            this.nl = false;
        }

        public String build() {
            return this.builder.length() == 0 && !this.nl ? null : this.builder.toString();
        }
    }
}

