/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.model.serialization.converters.Naming;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RelativeReference
implements Serializable {
    static final char ARGS_OPEN_MARKER = '(';
    static final char ARGS_CLOSE_MARKER = ')';
    static final char PATH_SEPARATOR = '.';
    static final char ARGS_SEPARATOR = ',';
    static final char HOME_MARKER = '~';
    static final String HOME_MARKER_STR = Character.toString('~').intern();
    @NotNull
    public final ExplicitOrigin explicitOrigin;
    public final String @NotNull [] path;
    public final String @Nullable [] args;

    @NotNull
    public static RelativeReference of(@NotNull ExplicitOrigin explicitOrigin, String @NotNull [] path, String @Nullable [] args) {
        if (explicitOrigin == null) {
            RelativeReference.$$$reportNull$$$0(0);
        }
        if (path == null) {
            RelativeReference.$$$reportNull$$$0(1);
        }
        String[] copiedPath = RelativeReference.copyStrings(path);
        String[] copiedArgs = RelativeReference.copyStrings(args);
        return new RelativeReference(explicitOrigin, copiedPath, copiedArgs);
    }

    @NotNull
    public static RelativeReference of(String @NotNull [] path, String @Nullable [] args) {
        if (path == null) {
            RelativeReference.$$$reportNull$$$0(2);
        }
        String[] copiedPath = RelativeReference.copyStrings(path);
        String[] copiedArgs = RelativeReference.copyStrings(args);
        return new RelativeReference(copiedPath, copiedArgs);
    }

    @NotNull
    public static RelativeReference of(@NotNull String string) {
        if (string == null) {
            RelativeReference.$$$reportNull$$$0(3);
        }
        return RelativeReference.parseForImport(string);
    }

    private RelativeReference(@NotNull ExplicitOrigin explicitOrigin, String @NotNull [] path, String @Nullable [] args) {
        if (explicitOrigin == null) {
            RelativeReference.$$$reportNull$$$0(4);
        }
        if (path == null) {
            RelativeReference.$$$reportNull$$$0(5);
        }
        this.explicitOrigin = explicitOrigin;
        this.path = path;
        this.args = args;
    }

    private RelativeReference(String @NotNull [] path, String @Nullable [] args) {
        if (path == null) {
            RelativeReference.$$$reportNull$$$0(6);
        }
        this.explicitOrigin = ExplicitOrigin.NONE;
        this.path = path;
        this.args = args;
    }

    @NotNull
    public String export() {
        String s2;
        int i2;
        int n = this.path.length;
        int m = this.args == null ? 0 : this.args.length;
        StringBuilder b2 = new StringBuilder((n + m) * 32);
        switch (this.explicitOrigin) {
            case DATABASE: {
                b2.append('~');
                break;
            }
            case SCHEMA: {
                b2.append('~').append('.');
            }
        }
        for (i2 = 0; i2 < n; ++i2) {
            if (i2 != 0) {
                b2.append('.');
            }
            s2 = Naming.exportName(this.path[i2]);
            b2.append(s2);
        }
        if (this.args != null) {
            b2.append('(');
            for (i2 = 0; i2 < m; ++i2) {
                if (i2 != 0) {
                    b2.append(',');
                }
                s2 = Naming.exportName(this.args[i2]);
                b2.append(s2);
            }
            b2.append(')');
        }
        String string = b2.toString();
        if (string == null) {
            RelativeReference.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    static RelativeReference parseForImport(@NotNull String string) {
        String[] args;
        String[] path;
        int p1;
        int p2;
        if (string == null) {
            RelativeReference.$$$reportNull$$$0(8);
        }
        int n = p2 = (p1 = string.indexOf(40)) == -1 ? -1 : string.indexOf(41, p1 + 1);
        if (p1 > -1 && p2 == -1) {
            throw new IllegalArgumentException("Cannot import reference: \"" + string + "\"");
        }
        if (p2 == -1) {
            path = RelativeReference.splitNames(string, '.');
            args = null;
        } else {
            String pathStr = string.substring(0, p1);
            String argsStr = string.substring(p1 + 1, p2);
            path = RelativeReference.splitNames(pathStr, '.');
            args = RelativeReference.splitNames(argsStr, ',');
        }
        ExplicitOrigin eo = ExplicitOrigin.NONE;
        if (path.length > 0) {
            String s1 = path[0];
            assert (s1 != null);
            if ((s1 = s1.trim()).equals(HOME_MARKER_STR)) {
                eo = ExplicitOrigin.SCHEMA;
                path = Arrays.copyOfRange(path, 1, path.length);
            } else if (s1.startsWith(HOME_MARKER_STR) && s1.length() >= 2) {
                eo = ExplicitOrigin.DATABASE;
                path[0] = s1.substring(1);
            }
        }
        return new RelativeReference(eo, path, args);
    }

    private static String[] splitNames(@NotNull String names, char separator) {
        if (names == null) {
            RelativeReference.$$$reportNull$$$0(9);
        }
        List escapedNames = StringUtil.split((String)names, (String)Character.toString(separator), (boolean)true, (boolean)true);
        int n = escapedNames.size();
        String[] result2 = new String[n];
        for (int i2 = 0; i2 < n; ++i2) {
            result2[i2] = Naming.importName((String)escapedNames.get(i2));
        }
        return result2;
    }

    @Contract(value="!null -> !null; null -> null", pure=true)
    static String[] copyStrings(String[] strings) {
        if (strings != null) {
            String[] newStrings;
            int n = strings.length;
            if (n > 0) {
                newStrings = new String[n];
                System.arraycopy(strings, 0, newStrings, 0, n);
            } else {
                newStrings = ArrayUtilRt.EMPTY_STRING_ARRAY;
            }
            return newStrings;
        }
        return null;
    }

    public String toString() {
        return this.export();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelativeReference that = (RelativeReference)o;
        if (!Arrays.equals(this.path, that.path)) {
            return false;
        }
        if (!Arrays.equals(this.args, that.args)) {
            return false;
        }
        return this.explicitOrigin == that.explicitOrigin;
    }

    public int hashCode() {
        return Arrays.hashCode(this.path) * 17 + Arrays.hashCode(this.args);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitOrigin";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/serialization/converters/RelativeReference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/serialization/converters/RelativeReference";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "export";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseForImport";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "splitNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ExplicitOrigin {
        NONE,
        SCHEMA,
        DATABASE;

    }
}

