/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbPresentationCore {
    public static final SimpleTextAttributes INFO_ATTRS = SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES;
    public static final @NlsContexts.Label String UNNAMED = DatabaseBundle.message("label.unnamed1", new Object[0]);
    private static final Map<ObjectKind, Icon> ourIcons = ContainerUtil.immutableMapBuilder().put((Object)ObjectKind.DATABASE, (Object)DatabaseIcons.Database).put((Object)ObjectKind.SCHEMA, (Object)DatabaseIcons.Schema).put((Object)ObjectKind.SEQUENCE, (Object)DatabaseIcons.Sequence).put((Object)ObjectKind.CLUSTER, (Object)DatabaseIcons.UnspecifiedCluster).put((Object)ObjectKind.TABLE, (Object)DatabaseIcons.Table).put((Object)ObjectKind.COLUMN, (Object)DatabaseIcons.Col).put((Object)ObjectKind.INDEX, (Object)DatabaseIcons.Index).put((Object)ObjectKind.KEY, (Object)DatabaseIcons.GoldKeyAlt).put((Object)ObjectKind.FOREIGN_KEY, (Object)DatabaseIcons.BlueKey).put((Object)ObjectKind.MAT_LOG, (Object)DatabaseIcons.MaterializedLog).put((Object)ObjectKind.MAT_VIEW, (Object)DatabaseIcons.MaterializedView).put((Object)ObjectKind.VIEW, (Object)AllIcons.Nodes.DataSchema).put((Object)ObjectKind.CHECK, (Object)DatabaseIcons.CheckConstraint).put((Object)ObjectKind.DEFAULT, (Object)DatabaseIcons.DefaultConstraint).put((Object)ObjectKind.RULE, (Object)DatabaseIcons.Rule).put((Object)ObjectKind.TRIGGER, (Object)DatabaseIcons.Trigger).put((Object)ObjectKind.PACKAGE, (Object)DatabaseIcons.Package).put((Object)ObjectKind.ALIAS_TYPE, (Object)AllIcons.Nodes.Type).put((Object)ObjectKind.TABLE_TYPE, (Object)AllIcons.Nodes.Type).put((Object)ObjectKind.OBJECT_TYPE, (Object)AllIcons.Nodes.Type).put((Object)ObjectKind.OBJECT_ATTRIBUTE, (Object)AllIcons.Nodes.ObjectTypeAttribute).put((Object)ObjectKind.COLLECTION_TYPE, (Object)DatabaseIcons.CollectionType).put((Object)ObjectKind.BODY, (Object)DatabaseIcons.Body).put((Object)ObjectKind.ROUTINE, (Object)DatabaseIcons.Routine).put((Object)ObjectKind.ARGUMENT, (Object)DatabaseIcons.Argument).put((Object)ObjectKind.OPERATOR, (Object)DatabaseIcons.Operator).put((Object)ObjectKind.OPERATOR_FAMILY, (Object)DatabaseIcons.OperatorFamily).put((Object)ObjectKind.OPERATOR_CLASS, (Object)DatabaseIcons.OperatorClass).put((Object)ObjectKind.VARIABLE, (Object)AllIcons.Nodes.Variable).put((Object)ObjectKind.SYNONYM, (Object)DatabaseIcons.Synonym).put((Object)ObjectKind.VIRTUAL_TABLE, (Object)DatabaseIcons.Table).put((Object)ObjectKind.SCRIPT, (Object)DatabaseIcons.Scripting_script).put((Object)ObjectKind.COLLATION, (Object)DatabaseIcons.Collation).put((Object)ObjectKind.CONNECTION, (Object)DatabaseIcons.Connector).put((Object)ObjectKind.USER, (Object)AllIcons.General.User).put((Object)ObjectKind.ROLE, (Object)DatabaseIcons.Role).put((Object)ObjectKind.GROUP, (Object)DatabaseIcons.Role).put((Object)ObjectKind.LOGIN, (Object)AllIcons.General.User).put((Object)ObjectKind.FOREIGN_DATA_WRAPPER, (Object)DatabaseIcons.Foreign_datawrapper).put((Object)ObjectKind.FOREIGN_TABLE, (Object)DatabaseIcons.Foreign_table).put((Object)ObjectKind.SERVER, (Object)DatabaseIcons.Foreign_server).put((Object)ObjectKind.USER_MAPPING, (Object)DatabaseIcons.User_mapping).put((Object)ObjectKind.DB_LINK, (Object)DatabaseIcons.DatabaseLink).put((Object)ObjectKind.EXTERNAL_SCHEMA, (Object)DatabaseIcons.External_schema_object).put((Object)ObjectKind.SCHEDULED_EVENT, (Object)DatabaseIcons.ScheduledEvent).put((Object)ObjectKind.ACCESS_METHOD, (Object)DatabaseIcons.Access_method).put((Object)ObjectKind.AGGREGATE, (Object)DatabaseIcons.Aggregate).put((Object)ObjectKind.EXCEPTION, (Object)AllIcons.Nodes.ExceptionClass).put((Object)ObjectKind.EXTENSION, (Object)DatabaseIcons.Extension).put((Object)ObjectKind.LANGUAGE, (Object)DatabaseIcons.Extension).put((Object)ObjectKind.TABLESPACE, (Object)DatabaseIcons.Tablespace).put((Object)ObjectKind.MACRO, (Object)DatabaseIcons.Macro).put((Object)ObjectKind.PROJECTION, (Object)DatabaseIcons.Projection).put((Object)ObjectKind.DATA_FILE, (Object)DatabaseIcons.DataFile).put((Object)ObjectKind.PARTITION, (Object)DatabaseIcons.Partition).put((Object)ObjectKind.METHOD, (Object)AllIcons.Nodes.Method).put((Object)ObjectKind.WAREHOUSE, (Object)DatabaseIcons.Warehouse).put((Object)ObjectKind.FORMAT, (Object)DatabaseIcons.FileFormat).put((Object)ObjectKind.INDEX_EXTENSION, (Object)DatabaseIcons.IndexFun).put((Object)ObjectKind.INDEX_SEARCH_METHOD, (Object)DatabaseIcons.Access_method).put((Object)ObjectKind.CONSTANT, (Object)DatabaseIcons.Constant).put((Object)ObjectKind.SECURITY_POLICY, (Object)DatabaseIcons.Trigger).put((Object)ObjectKind.SECURITY_PREDICATE, (Object)DatabaseIcons.Trigger).put((Object)ObjectKind.LINKED_SERVER, (Object)DatabaseIcons.DatabaseLink).build();

    protected DbPresentationCore() {
    }

    public static String arrowToColumns(@Nullable String schemaName, @Nullable String tableName, @NotNull MultiRef<? extends DasTypedObject> columnsRef) {
        if (columnsRef == null) {
            DbPresentationCore.$$$reportNull$$$0(0);
        }
        Object prefix = schemaName != null ? schemaName + "." : "";
        return StringUtil.isEmpty((String)tableName) ? "" : DbPresentationCore.arrow() + " " + (String)prefix + tableName + " " + DbPresentationCore.multiRef(columnsRef);
    }

    @NotNull
    public static String multiRef(@NotNull MultiRef<? extends DasTypedObject> ref) {
        if (ref == null) {
            DbPresentationCore.$$$reportNull$$$0(1);
        }
        Object object = ref.size() == 0 ? "" : "(" + StringUtil.join((Iterable)JBIterable.from(ref.names()).filter(n -> n != null), (String)", ") + ")";
        if (object == null) {
            DbPresentationCore.$$$reportNull$$$0(2);
        }
        return object;
    }

    @NlsSafe
    @NotNull
    public static String arrow() {
        String string = ApplicationManager.getApplication().isUnitTestMode() ? "->" : UIUtil.rightArrow();
        if (string == null) {
            DbPresentationCore.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static Icon getIcon(@Nullable ObjectKind kind) {
        return ourIcons.get(kind);
    }

    @Nls
    @NotNull
    public static String getPresentableName(@NotNull ObjectKind o, @NotNull Dbms dbms) {
        if (o == null) {
            DbPresentationCore.$$$reportNull$$$0(4);
        }
        if (dbms == null) {
            DbPresentationCore.$$$reportNull$$$0(5);
        }
        String string = ModelFacade.forDbms(dbms).getModelHelper().getName(o);
        if (string == null) {
            DbPresentationCore.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public static Icon getIcon(@NotNull DasObject c2) {
        if (c2 == null) {
            DbPresentationCore.$$$reportNull$$$0(7);
        }
        Dbms dbms = DbImplUtilCore.getDbms(c2);
        ModelHelper helper = ModelFacade.forDbms(dbms).getModelHelper();
        return helper.getIcon(c2);
    }

    @Nullable
    public static Icon getIcon(@NotNull Dbms dbms, @Nullable ObjectKind kind) {
        if (dbms == null) {
            DbPresentationCore.$$$reportNull$$$0(8);
        }
        ModelHelper helper = ModelFacade.forDbms(dbms).getModelHelper();
        return kind == null ? null : helper.getIcon(kind);
    }

    @Nullable
    public static Icon getIcon(@NotNull BasicMetaObject<?> meta) {
        if (meta == null) {
            DbPresentationCore.$$$reportNull$$$0(9);
        }
        return DbPresentationCore.getIcon(meta.getModel().dbms, meta.kind);
    }

    @NotNull
    @NlsContexts.Label
    public static String getPresentableName(@NotNull DasObject o, boolean unnamed) {
        if (o == null) {
            DbPresentationCore.$$$reportNull$$$0(10);
        }
        DasObject d2 = o instanceof DbElement ? ((DbElement)o).getDelegate() : o;
        String name = d2 instanceof BasicNode ? ((BasicNode)((Object)d2)).getDisplayName() : o.getName();
        String string = StringUtil.isEmpty((String)name) && unnamed ? UNNAMED : name;
        if (string == null) {
            DbPresentationCore.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nls
    @NotNull
    public static String getPresentableName(@NotNull BasicMetaObject<?> meta) {
        if (meta == null) {
            DbPresentationCore.$$$reportNull$$$0(12);
        }
        return DbPresentationCore.getPresentableName(meta.kind, meta.getModel().dbms);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsRef";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbPresentationCore";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbPresentationCore";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiRef";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "arrow";
                break;
            }
            case 6: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "arrowToColumns";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "multiRef";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

