/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.console.ExecutionConcession;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.script.translator.TranslateException;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.EvaluationHelper;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConsoleDataRequest
extends DataRequest.QueryRequest
implements DataRequest.CoupledWithEditor {
    @RegExp
    private static final String TITLE_PREFIX_PATTERN = "(--|/\\*|//)?\\s*%s([^\\s].+(\\*[^/]?|[^*/]))\\s*($|\\*/)";
    private final Shared shared;
    private final TextRange myInitialRange;
    public final int queryIndex;
    public final boolean hasNext;
    public final boolean newTab;
    public final Set<ExecutionConcession> concessions;
    private final SubQueriesInfo mySubQueriesInfo;

    @Nullable
    public static ConsoleDataRequest newConsoleRequest(@NotNull JdbcConsoleBase console, @NotNull Editor editor, @NotNull ScriptModel<?> model, boolean newTab) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ConsoleDataRequest.$$$reportNull$$$0(1);
        }
        if (model == null) {
            ConsoleDataRequest.$$$reportNull$$$0(2);
        }
        DataRequest.Constraints constraints = ConsoleDataRequest.newConstraints(DbImplUtil.getDbms(console));
        Shared shared = new Shared(editor, model, constraints);
        shared.queries.advance();
        return ConsoleDataRequest.newConsoleRequest(console, shared, 0, newTab, EnumSet.noneOf(ExecutionConcession.class));
    }

    @Nullable
    private static ConsoleDataRequest newConsoleRequest(@NotNull JdbcConsoleBase console, @NotNull Shared shared, int queryIndex, boolean newTab, @NotNull Set<ExecutionConcession> concessions) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(3);
        }
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(4);
        }
        if (concessions == null) {
            ConsoleDataRequest.$$$reportNull$$$0(5);
        }
        QueryTextResult queryTextResult = ConsoleDataRequest.currentQueryTextResult(console, shared);
        ConsoleDataRequest newRequest = new ConsoleDataRequest(console, queryTextResult.getText(), shared, queryIndex, newTab, concessions);
        TranslateException translateException = queryTextResult.getTranslateException();
        if (translateException != null) {
            DataRequest.CoupledWithEditor.ErrorNavigator navigator = newRequest.onError(translateException.getMessage(), null, null);
            SwingUtilities.invokeLater(() -> {
                if (navigator != null && navigator.canNavigate()) {
                    navigator.navigate();
                }
            });
            return null;
        }
        return newRequest;
    }

    private ConsoleDataRequest(@NotNull JdbcConsoleBase console, @NotNull String query, @NotNull Shared shared, int queryIndex, boolean newTab, @NotNull Set<ExecutionConcession> concessions) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(6);
        }
        if (query == null) {
            ConsoleDataRequest.$$$reportNull$$$0(7);
        }
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(8);
        }
        if (concessions == null) {
            ConsoleDataRequest.$$$reportNull$$$0(9);
        }
        super(console, query, shared.constraints, null);
        this.shared = shared;
        this.queryIndex = queryIndex;
        this.newTab = newTab;
        this.concessions = concessions;
        ScriptModel.StatementIt currentQuery = (ScriptModel.StatementIt)shared.queries.current();
        this.mySubQueriesInfo = ConsoleDataRequest.computeSubQueriesInfo(currentQuery, console, shared.scriptModel.getLanguage(), shared.scriptModel.getTextRange());
        this.hasNext = shared.queries.hasNext();
        this.myInitialRange = this.getRange();
    }

    @Nullable
    public static <E> String computeTitle(@Nullable E object, @NotNull SyntaxTraverser.Api<E> api, @NotNull Project project) {
        String[] lines;
        String commentText;
        if (api == null) {
            ConsoleDataRequest.$$$reportNull$$$0(10);
        }
        if (project == null) {
            ConsoleDataRequest.$$$reportNull$$$0(11);
        }
        DatabaseSettings settings = DatabaseSettings.getSettings();
        if (object == null || !settings.resultsTitlePrefixEnabled) {
            return null;
        }
        Object comment = SqlPsiFacade.getInstance((Project)project).getNotebookManager().getPrecedingComment(object, api);
        String string = commentText = comment == null ? null : api.textOf(comment).toString();
        if (commentText == null) {
            return null;
        }
        String patternText = StringUtil.isEmptyOrSpaces((String)settings.resultsTitlePrefix) ? "" : Pattern.quote(settings.resultsTitlePrefix) + "\\s+";
        Pattern pattern = Pattern.compile(String.format(TITLE_PREFIX_PATTERN, patternText));
        for (String line : lines = StringUtil.splitByLines((String)commentText)) {
            Matcher lineMatcher = pattern.matcher(line);
            if (!lineMatcher.matches()) continue;
            return lineMatcher.group(2);
        }
        return null;
    }

    @NotNull
    private static <E> SubQueriesInfo computeSubQueriesInfo(@NotNull ScriptModel.StatementIt<E> statementIt, @NotNull JdbcConsoleBase console, @NotNull Language language, @Nullable TextRange range) {
        if (statementIt == null) {
            ConsoleDataRequest.$$$reportNull$$$0(12);
        }
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(13);
        }
        if (language == null) {
            ConsoleDataRequest.$$$reportNull$$$0(14);
        }
        Object object = statementIt.object();
        SyntaxTraverser.Api api = statementIt.api();
        EvaluationHelper helper = (EvaluationHelper)EvaluationHelper.EP.forLanguage(language);
        boolean canContainStatements = helper.canContainStatements(statementIt.api()).value(object) && ScriptModelUtilCore.getSelectionOption(range) != 1;
        SyntaxTraverser s2 = canContainStatements ? (SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.syntaxTraverser(api).withRoot(object)).expand(helper.canContainStatements(api))).filter(helper.isStatement(api)) : (SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.syntaxTraverser(api).withRoot(object)).expand(Conditions.alwaysFalse());
        boolean justOne = s2.traverse().take(2).size() == 1;
        List resultSetSubQueries = s2.traverse().map(st -> {
            String query = api.textOf(st).toString();
            String title = ConsoleDataRequest.computeTitle(st, api, console.getProject());
            SqlTableType resultType = DbSqlUtil.parseQueryTableType(console, language, query);
            return resultType != null || justOne ? new ResultSetSubQuery(query, title, resultType) : null;
        }).filter(Objects::nonNull).toList();
        return new SubQueriesInfo(justOne, resultSetSubQueries);
    }

    @NotNull
    private static String handleQueryText(@NotNull JdbcConsoleBase console, String text2) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(15);
        }
        String lineSeparator = (String)ObjectUtils.notNull((Object)console.getVirtualFile().getDetectedLineSeparator(), (Object)LineSeparator.getSystemLineSeparator().getSeparatorString());
        String string = StringUtil.convertLineSeparators((String)text2, (String)lineSeparator);
        if (string == null) {
            ConsoleDataRequest.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static QueryTextResult currentQueryTextResult(@NotNull JdbcConsoleBase console, @NotNull Shared shared) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(17);
        }
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(18);
        }
        ScriptModel.PStorage storage = console.getPStorage();
        try {
            String currentText = ((ScriptModel.StatementIt)shared.queries.current()).text(storage, Conditions.alwaysFalse());
            return new QueryTextResult(ConsoleDataRequest.handleQueryText(console, currentText), null);
        }
        catch (TranslateException e) {
            String currentRawText = ((ScriptModel.StatementIt)shared.queries.current()).text();
            return new QueryTextResult(ConsoleDataRequest.handleQueryText(console, currentRawText), e);
        }
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.shared.sourceEditor;
    }

    @Override
    @NotNull
    public DataRequest getRequest() {
        ConsoleDataRequest consoleDataRequest = this;
        if (consoleDataRequest == null) {
            ConsoleDataRequest.$$$reportNull$$$0(19);
        }
        return consoleDataRequest;
    }

    @NotNull
    public JdbcConsoleBase getConsole() {
        JdbcConsoleBase jdbcConsoleBase = (JdbcConsoleBase)this.owner;
        if (jdbcConsoleBase == null) {
            ConsoleDataRequest.$$$reportNull$$$0(20);
        }
        return jdbcConsoleBase;
    }

    @NotNull
    private DataProducer getDataProducer() {
        DataProducer dataProducer = this.getConsole().getMessageBus().getDataProducer();
        if (dataProducer == null) {
            ConsoleDataRequest.$$$reportNull$$$0(21);
        }
        return dataProducer;
    }

    @NotNull
    public UserDataHolder getSharedDataHolder() {
        Shared shared = this.shared;
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(22);
        }
        return shared;
    }

    public boolean containSingleSubQuery() {
        return this.mySubQueriesInfo.containSingleSubQuery();
    }

    public boolean produceResultSet() {
        ResultSetSubQuery subQuery = this.getResultSetSubquery(1);
        return subQuery != null && subQuery.resultType != null;
    }

    @Nullable
    public ResultSetSubQuery getResultSetSubquery(int resultSetIndex) {
        return this.mySubQueriesInfo.getResultSetSubquery(resultSetIndex);
    }

    @Override
    @Nullable
    public DataRequest.CoupledWithEditor.ErrorNavigator onError(@Nullable String message2, @Nullable Throwable th, @Nullable List<DatabaseErrorHandler.Fix> fixes) {
        return message2 != null ? DatabaseUiService.getInstance().reportError(this, ConsoleDataRequest.createThrowable(message2, th), ErrorInfo.ERROR, null, fixes) : (th != null ? DatabaseUiService.getInstance().reportError(this, th, ErrorInfo.ERROR, null, fixes) : null);
    }

    @Override
    public void onWarning(@Nullable String message2, @Nullable Runnable suppressAction, @NotNull ExecutionConcession concession) {
        if (concession == null) {
            ConsoleDataRequest.$$$reportNull$$$0(23);
        }
        if (message2 != null) {
            DatabaseUiService.getInstance().reportError(this, ConsoleDataRequest.createThrowable(message2, null), suppressAction == null ? ErrorInfo.WARNING : new ErrorInfo(true, suppressAction), concession, null);
        }
    }

    public void onFinished() {
        if (!this.isExecutionStopper()) {
            this.processNextRequest();
        }
    }

    public boolean isExecutionStopper() {
        return this.isLastInChain() || this.hasPendingProblems();
    }

    public boolean isLastInChain() {
        return !this.hasNext;
    }

    private boolean hasPendingProblems() {
        return JBIterable.of((Object[])new ProblemSolver[]{this.shared.errorsSolver, this.shared.warningsSolver}).filter(ProblemSolver::isEnabled).isNotEmpty();
    }

    private void processNextRequest() {
        ConsoleDataRequest nextRequest = this.nextRequest();
        if (nextRequest != null) {
            this.getDataProducer().processRequest(nextRequest);
        }
    }

    @Nullable
    private ConsoleDataRequest nextRequest() {
        this.shared.queries.advance();
        JdbcConsoleBase console = this.getConsole();
        return ConsoleDataRequest.newConsoleRequest(console, this.shared, this.queryIndex + 1, this.newTab, EnumSet.copyOf(this.shared.warningsSolver.getConcessions()));
    }

    private void processClonedRequest() {
        ConsoleDataRequest clonedRequest = this.cloneRequest();
        if (clonedRequest != null) {
            this.getDataProducer().processRequest(clonedRequest);
        }
    }

    @Nullable
    private ConsoleDataRequest cloneRequest() {
        JdbcConsoleBase console = this.getConsole();
        EnumSet<ExecutionConcession> concessions = EnumSet.copyOf(this.concessions);
        concessions.addAll(this.shared.warningsSolver.getConcessions());
        return ConsoleDataRequest.newConsoleRequest(console, this.shared, this.queryIndex, this.newTab, concessions);
    }

    public void onStarted() {
        SwingUtilities.invokeLater(() -> {
            if (!this.hasNext || this.shared.lastUpdateTime < 0L || System.currentTimeMillis() - this.shared.lastUpdateTime > 100L) {
                DatabaseUiService.getInstance().updateConsoleUI(this, false);
            }
        });
        this.shared.lastUpdateTime = System.currentTimeMillis();
    }

    @NotNull
    private static Throwable createThrowable(@NotNull String message2, @Nullable Throwable th) {
        if (message2 == null) {
            ConsoleDataRequest.$$$reportNull$$$0(24);
        }
        Throwable throwable = new Throwable(message2);
        throwable.setStackTrace(th == null ? new StackTraceElement[]{} : th.getStackTrace());
        Throwable throwable2 = throwable;
        if (throwable2 == null) {
            ConsoleDataRequest.$$$reportNull$$$0(25);
        }
        return throwable2;
    }

    public TextRange getInitialRange() {
        return this.myInitialRange;
    }

    @Override
    @Nullable
    public TextRange getRange() {
        return this.shared.adjustedRange(this.queryIndex);
    }

    public WarningsSolver getWarningSolver() {
        return this.shared.warningsSolver;
    }

    public ProblemSolver getErrorSolver() {
        return this.shared.errorsSolver;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shared";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "concessions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "api";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementIt";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ConsoleDataRequest";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "concession";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "handleQueryText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequest";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataProducer";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedDataHolder";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createThrowable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newConsoleRequest";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeTitle";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeSubQueriesInfo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "handleQueryText";
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "currentQueryTextResult";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "onWarning";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createThrowable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class WarningsSolver
    implements ProblemSolver {
        private final EnumSet<ExecutionConcession> myConcessions = EnumSet.noneOf(ExecutionConcession.class);
        private final EnumSet<ExecutionConcession> myRequiredConcessions = EnumSet.noneOf(ExecutionConcession.class);
        private final EnumSet<ExecutionConcession> myIgnoredConcessions = EnumSet.noneOf(ExecutionConcession.class);

        @Override
        public void solve(@NotNull Decision decision, @NotNull ConsoleDataRequest request, @Nullable ExecutionConcession concession) {
            if (decision == null) {
                WarningsSolver.$$$reportNull$$$0(0);
            }
            if (request == null) {
                WarningsSolver.$$$reportNull$$$0(1);
            }
            if (concession != null) {
                this.myRequiredConcessions.remove((Object)concession);
            }
            switch (decision) {
                case FORCE_EXECUTE: {
                    if (concession != null) {
                        request.concessions.add(concession);
                    }
                    request.processClonedRequest();
                    break;
                }
                case FORCE_EXECUTE_ALL: {
                    if (concession != null) {
                        this.myConcessions.add(concession);
                    }
                    request.processClonedRequest();
                    break;
                }
                case RETRY: {
                    request.processClonedRequest();
                    break;
                }
                case IGNORE: {
                    request.processNextRequest();
                    break;
                }
                case IGNORE_ALL: {
                    if (concession != null) {
                        this.myIgnoredConcessions.add(concession);
                    }
                    request.processNextRequest();
                    break;
                }
            }
        }

        @Override
        public void newProblem(@Nullable ExecutionConcession concession) {
            if (concession != null && !this.myIgnoredConcessions.contains((Object)concession)) {
                this.myRequiredConcessions.add(concession);
            }
        }

        @Override
        public boolean isEnabled() {
            return !this.myConcessions.containsAll(this.myRequiredConcessions);
        }

        @NotNull
        EnumSet<ExecutionConcession> getConcessions() {
            EnumSet<ExecutionConcession> enumSet = this.myConcessions;
            if (enumSet == null) {
                WarningsSolver.$$$reportNull$$$0(2);
            }
            return enumSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "decision";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ConsoleDataRequest$WarningsSolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest$WarningsSolver";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConcessions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "solve";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ErrorsSolver
    implements ProblemSolver {
        private boolean myEnabled = true;
        private int myCount;

        @Override
        public void solve(@NotNull Decision decision, @NotNull ConsoleDataRequest request, @Nullable ExecutionConcession concession) {
            if (decision == null) {
                ErrorsSolver.$$$reportNull$$$0(0);
            }
            if (request == null) {
                ErrorsSolver.$$$reportNull$$$0(1);
            }
            --this.myCount;
            switch (decision) {
                case RETRY: {
                    request.processClonedRequest();
                    break;
                }
                case IGNORE_ALL: {
                    this.myEnabled = false;
                    request.processNextRequest();
                    break;
                }
                case IGNORE: {
                    request.processNextRequest();
                    break;
                }
            }
        }

        @Override
        public void newProblem(@Nullable ExecutionConcession concession) {
            if (this.myEnabled) {
                ++this.myCount;
            }
        }

        @Override
        public boolean isEnabled() {
            return this.myCount > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "decision";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "request";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ConsoleDataRequest$ErrorsSolver";
            objectArray[2] = "solve";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ProblemSolver {
        public void solve(@NotNull Decision var1, @NotNull ConsoleDataRequest var2, @Nullable ExecutionConcession var3);

        public void newProblem(@Nullable ExecutionConcession var1);

        public boolean isEnabled();
    }

    private static class QueryTextResult {
        private final String myText;
        private final TranslateException myTranslateException;

        QueryTextResult(@NotNull String text2, @Nullable TranslateException translateException) {
            if (text2 == null) {
                QueryTextResult.$$$reportNull$$$0(0);
            }
            this.myText = text2;
            this.myTranslateException = translateException;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                QueryTextResult.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public TranslateException getTranslateException() {
            return this.myTranslateException;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ConsoleDataRequest$QueryTextResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest$QueryTextResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class SubQueriesInfo {
        public final boolean myContainSingleSubQuery;
        public final List<ResultSetSubQuery> myResultSetSubQueries;

        SubQueriesInfo(boolean containSingleSubQuery, @NotNull List<ResultSetSubQuery> resultSetSubQueries) {
            if (resultSetSubQueries == null) {
                SubQueriesInfo.$$$reportNull$$$0(0);
            }
            this.myContainSingleSubQuery = containSingleSubQuery;
            this.myResultSetSubQueries = resultSetSubQueries;
        }

        public boolean containSingleSubQuery() {
            return this.myContainSingleSubQuery;
        }

        @Nullable
        public ResultSetSubQuery getResultSetSubquery(int resultSetIndex) {
            return this.myResultSetSubQueries.size() >= resultSetIndex ? this.myResultSetSubQueries.get(resultSetIndex - 1) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSetSubQueries", "com/intellij/database/run/ConsoleDataRequest$SubQueriesInfo", "<init>"));
        }
    }

    public static class ResultSetSubQuery {
        public final String query;
        public final String title;
        public final SqlTableType resultType;

        ResultSetSubQuery(@NotNull String query, @Nullable String title, @Nullable SqlTableType resultType) {
            if (query == null) {
                ResultSetSubQuery.$$$reportNull$$$0(0);
            }
            this.query = query;
            this.title = title;
            this.resultType = resultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/run/ConsoleDataRequest$ResultSetSubQuery", "<init>"));
        }
    }

    public static class ErrorInfo {
        static ErrorInfo WARNING = new ErrorInfo(true);
        static ErrorInfo ERROR = new ErrorInfo(false);
        private final boolean myIsWarning;
        @Nullable
        private final Runnable mySuppressAction;

        ErrorInfo(boolean isWarning, @Nullable Runnable suppressAction) {
            this.myIsWarning = isWarning;
            this.mySuppressAction = suppressAction;
        }

        private ErrorInfo(boolean isWarning) {
            this.myIsWarning = isWarning;
            this.mySuppressAction = null;
        }

        public boolean isWarning() {
            return this.myIsWarning;
        }

        @Nullable
        public Runnable getSuppressAction() {
            return this.mySuppressAction;
        }
    }

    public static class Shared
    extends UserDataHolderBase {
        final Editor sourceEditor;
        final ScriptModel<?> scriptModel;
        final DataRequest.Constraints constraints;
        final JBIterator<? extends ScriptModel.StatementIt<?>> queries;
        final List<RangeMarker> rangeMarkers;
        long lastUpdateTime = -1L;
        ProblemSolver errorsSolver = new ErrorsSolver();
        WarningsSolver warningsSolver = new WarningsSolver();

        public Shared(Editor sourceEditor, ScriptModel<?> scriptModel, DataRequest.Constraints constraints) {
            this.queries = JBIterator.from((Iterator)scriptModel.statements().iterator());
            this.sourceEditor = sourceEditor;
            this.scriptModel = scriptModel;
            this.constraints = constraints;
            Document document = sourceEditor.getDocument();
            this.rangeMarkers = scriptModel.statements().transform(it2 -> {
                TextRange range = it2.range().shiftRight((int)it2.rangeOffset());
                return range.getEndOffset() <= document.getTextLength() ? document.createRangeMarker(range) : null;
            }).toList();
        }

        @Nullable
        TextRange adjustedRange(int idx) {
            return (TextRange)ApplicationManager.getApplication().runReadAction(() -> {
                RangeMarker marker = this.rangeMarkers.get(idx);
                return marker != null && marker.isValid() ? TextRange.create((Segment)marker) : null;
            });
        }
    }

    public static enum Decision {
        STOP,
        RETRY,
        IGNORE,
        IGNORE_ALL,
        FORCE_EXECUTE,
        FORCE_EXECUTE_ALL;

    }
}

