/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloseSessionAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        DatabaseSession session2;
        if (e == null) {
            CloseSessionAction.$$$reportNull$$$0(0);
        }
        boolean visible = (session2 = DatabaseSessionManager.findSession(e)) != null;
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && CloseSessionAction.canClose(session2));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DatabaseSession session2;
        if (e == null) {
            CloseSessionAction.$$$reportNull$$$0(1);
        }
        if ((session2 = DatabaseSessionManager.findSession(e)) != null) {
            CloseSessionAction.close(session2);
        }
    }

    public static boolean canClose(@NotNull DatabaseSession session2) {
        if (session2 == null) {
            CloseSessionAction.$$$reportNull$$$0(2);
        }
        return SessionsUtil.canClose(session2);
    }

    public static void close(@NotNull DatabaseSession session2) {
        if (session2 == null) {
            CloseSessionAction.$$$reportNull$$$0(3);
        }
        SessionsUtil.close(session2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/CloseSessionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canClose";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "close";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CloseAll
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAll.$$$reportNull$$$0(0);
            }
            LocalDataSource localDataSource = CloseAll.getDataSource(e);
            Project project = e.getProject();
            if (localDataSource == null || project == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(CloseAll.canCloseAll(project, localDataSource));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAll.$$$reportNull$$$0(1);
            }
            LocalDataSource localDataSource = CloseAll.getDataSource(e);
            Project project = e.getProject();
            if (localDataSource != null && project != null) {
                CloseAll.closeAll(project, localDataSource);
            }
        }

        public static boolean canCloseAll(@NotNull Project project, @NotNull LocalDataSource localDataSource) {
            if (project == null) {
                CloseAll.$$$reportNull$$$0(2);
            }
            if (localDataSource == null) {
                CloseAll.$$$reportNull$$$0(3);
            }
            List<DatabaseSession> sessions = DatabaseSessionManager.getSessions(project, localDataSource);
            for (DatabaseSession session2 : sessions) {
                if (CloseSessionAction.canClose(session2)) continue;
                return false;
            }
            return true;
        }

        public static void closeAll(@NotNull Project project, @NotNull LocalDataSource localDataSource) {
            if (project == null) {
                CloseAll.$$$reportNull$$$0(4);
            }
            if (localDataSource == null) {
                CloseAll.$$$reportNull$$$0(5);
            }
            List<DatabaseSession> sessions = DatabaseSessionManager.getSessions(project, localDataSource);
            for (DatabaseSession session2 : sessions) {
                CloseSessionAction.close(session2);
            }
        }

        @Nullable
        private static LocalDataSource getDataSource(@NotNull AnActionEvent e) {
            PsiElement[] data;
            if (e == null) {
                CloseAll.$$$reportNull$$$0(6);
            }
            return (data = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)) == null || data.length != 1 ? null : DbImplUtil.getMaybeLocalDataSource((DasDataSource)ObjectUtils.tryCast((Object)data[0], DasDataSource.class));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localDataSource";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/CloseSessionAction$CloseAll";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canCloseAll";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "closeAll";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDataSource";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

