/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.actions.DeleteActionBase;
import com.intellij.database.run.ui.DataGridRequestPlace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteColumnsAction
extends DeleteActionBase {
    @Override
    protected boolean isVisible(@Nullable DataGrid grid) {
        return DataGridUtil.canMutateColumns(grid);
    }

    @Override
    protected boolean isEnabled(@NotNull DataGrid grid) {
        if (grid == null) {
            DeleteColumnsAction.$$$reportNull$$$0(0);
        }
        return DataGridUtil.canMutateColumns(grid) && DeleteColumnsAction.getColumns(grid).size() != 0;
    }

    @NotNull
    public static ModelIndexSet<DataConsumer.Column> getColumns(@NotNull DataGrid grid) {
        if (grid == null) {
            DeleteColumnsAction.$$$reportNull$$$0(1);
        }
        ModelIndex<DataConsumer.Column> column2 = grid.getContextColumn();
        ModelIndexSet<DataConsumer.Column> modelIndexSet = column2.value != -1 ? ModelIndexSet.forColumns(grid, column2.value) : grid.getSelectionModel().getSelectedColumns();
        if (modelIndexSet == null) {
            DeleteColumnsAction.$$$reportNull$$$0(2);
        }
        return modelIndexSet;
    }

    @Override
    protected void doDelete(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> contextColumn) {
        if (grid == null) {
            DeleteColumnsAction.$$$reportNull$$$0(3);
        }
        if (contextColumn == null) {
            DeleteColumnsAction.$$$reportNull$$$0(4);
        }
        DeleteColumnsAction.deleteColumns(grid, contextColumn.value != -1 ? ModelIndexSet.forColumns(grid, contextColumn.value) : grid.getSelectionModel().getSelectedColumns());
    }

    public static void deleteColumns(@NotNull DataGrid grid, @NotNull ModelIndexSet<DataConsumer.Column> columns) {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (grid == null) {
            DeleteColumnsAction.$$$reportNull$$$0(5);
        }
        if (columns == null) {
            DeleteColumnsAction.$$$reportNull$$$0(6);
        }
        if ((mutator = DataGridUtil.getColumnsMutator(grid)) != null) {
            GridSelection selection = grid.getSelectionModel().store();
            GridRequestSource source = new GridRequestSource(new DataGridRequestPlace(grid, ModelIndexSet.forRows(grid, new int[0]), columns));
            mutator.deleteColumns(source, columns);
            source.getActionCallback().doWhenDone(() -> grid.getAutoscrollLocker().runWithLock(() -> grid.getSelectionModel().restore(grid.getSelectionModel().fit(selection))));
        }
    }

    @Override
    protected int itemsCount(@NotNull DataGrid grid) {
        if (grid == null) {
            DeleteColumnsAction.$$$reportNull$$$0(7);
        }
        return grid.getSelectionModel().getSelectedColumnCount();
    }

    @Override
    @NotNull
    protected DeleteActionBase.ActionText text() {
        return new DeleteActionBase.ActionText(DatabaseBundle.message("grid.delete.column.action.text", new Object[0]), DatabaseBundle.message("grid.delete.columns.action.text", new Object[0]), DatabaseBundle.message("grid.delete.selected.column.action.text", new Object[0]), DatabaseBundle.message("grid.delete.selected.columns.action.text", new Object[0]), DatabaseBundle.message("grid.delete.selected.column.action.confirmation", new Object[0]), DatabaseBundle.message("grid.delete.selected.columns.action.confirmation", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/DeleteColumnsAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextColumn";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/DeleteColumnsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doDelete";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deleteColumns";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "itemsCount";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

