/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.actions.DeleteActionBase;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.run.ui.GridDataSupport;
import org.jetbrains.annotations.NotNull;

public class DeleteRowsAction
extends DeleteActionBase {
    @Override
    protected boolean isEnabled(@NotNull DataGrid grid) {
        GridDataSupport support;
        if (grid == null) {
            DeleteRowsAction.$$$reportNull$$$0(0);
        }
        return !(support = grid.getDataSupport()).isDeletedRows(grid.getSelectionModel().getSelectedRows());
    }

    @Override
    protected void doDelete(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> contextColumn) {
        if (grid == null) {
            DeleteRowsAction.$$$reportNull$$$0(1);
        }
        if (contextColumn == null) {
            DeleteRowsAction.$$$reportNull$$$0(2);
        }
        DeleteRowsAction.deleteRows(grid, grid.getSelectionModel().getSelectedRows());
    }

    private static void deleteRows(@NotNull DataGrid grid, @NotNull ModelIndexSet<DataConsumer.Row> rows) {
        boolean canDelete;
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (grid == null) {
            DeleteRowsAction.$$$reportNull$$$0(3);
        }
        if (rows == null) {
            DeleteRowsAction.$$$reportNull$$$0(4);
        }
        if ((mutator = DataGridUtil.getRowsMutator(grid)) == null) {
            return;
        }
        boolean areRowsInserted = true;
        for (ModelIndex index2 : rows.asIterable()) {
            areRowsInserted &= mutator.isInsertedRow(index2);
        }
        boolean bl = canDelete = !mutator.hasPendingChanges() || !mutator.isUpdateImmediately() || areRowsInserted || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(grid);
        if (!canDelete) {
            return;
        }
        GridSelection selection = grid.getSelectionModel().store();
        GridRequestSource source = new GridRequestSource(new DataGridRequestPlace(grid, rows, ModelIndexSet.forColumns(grid, new int[0])));
        mutator.deleteRows(source, rows);
        source.getActionCallback().doWhenDone(() -> grid.getAutoscrollLocker().runWithLock(() -> grid.getSelectionModel().restore(grid.getSelectionModel().fit(selection))));
    }

    @Override
    protected int itemsCount(@NotNull DataGrid grid) {
        if (grid == null) {
            DeleteRowsAction.$$$reportNull$$$0(5);
        }
        return grid.getSelectionModel().getSelectedRowCount();
    }

    @Override
    @NotNull
    protected DeleteActionBase.ActionText text() {
        return new DeleteActionBase.ActionText(DatabaseBundle.message("grid.delete.action.row.item", new Object[0]), DatabaseBundle.message("grid.delete.action.row.items", new Object[0]), DatabaseBundle.message("grid.delete.selected.row.action.text", new Object[0]), DatabaseBundle.message("grid.delete.selected.rows.action.text", new Object[0]), DatabaseBundle.message("grid.delete.selected.row.action.confirmation", new Object[0]), DatabaseBundle.message("grid.delete.selected.rows.action.confirmation", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextColumn";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/DeleteRowsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doDelete";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteRows";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "itemsCount";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

