/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class PageAction
extends DumbAwareAction
implements GridAction {
    public PageAction(Icon icon) {
        super(icon);
    }

    protected abstract boolean isEnabled(GridPagingModel<DataConsumer.Row, DataConsumer.Column> var1);

    protected abstract void actionPerformed(GridRequestSource var1, GridLoader<DataConsumer.Row, DataConsumer.Column> var2);

    public void update(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            PageAction.$$$reportNull$$$0(0);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null || dataGrid.getDataHookup() instanceof DocumentDataHookUp) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(dataGrid.isReady() && this.isEnabled(dataGrid.getDataHookup().getPageModel()));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        GridMutator mutator;
        DataGrid dataGrid;
        if (e == null) {
            PageAction.$$$reportNull$$$0(1);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
            return;
        }
        if (!dataGrid.stopEditing()) {
            dataGrid.cancelEditing();
        }
        if ((mutator = dataGrid.getDataHookup().getMutator()) == null || !mutator.hasPendingChanges() || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(dataGrid)) {
            this.actionPerformed(new GridRequestSource(new DataGridRequestPlace(dataGrid)), dataGrid.getDataHookup().getLoader());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/database/run/actions/PageAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Previous
    extends PageAction {
        public Previous() {
            super(AllIcons.Actions.Play_back);
        }

        @Override
        protected boolean isEnabled(GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel) {
            return !pageModel.isFirstPage();
        }

        @Override
        protected void actionPerformed(GridRequestSource source, GridLoader<DataConsumer.Row, DataConsumer.Column> loader) {
            loader.loadPreviousPage(source);
        }
    }

    public static class Next
    extends PageAction {
        public Next() {
            super(AllIcons.Actions.Play_forward);
        }

        @Override
        protected boolean isEnabled(GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel) {
            return !pageModel.isLastPage();
        }

        @Override
        protected void actionPerformed(GridRequestSource source, GridLoader<DataConsumer.Row, DataConsumer.Column> loader) {
            loader.loadNextPage(source);
        }
    }

    public static class Last
    extends PageAction {
        public Last() {
            super(AllIcons.Actions.Play_last);
        }

        @Override
        protected boolean isEnabled(GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel) {
            return !pageModel.isLastPage();
        }

        @Override
        protected void actionPerformed(GridRequestSource source, GridLoader<DataConsumer.Row, DataConsumer.Column> loader) {
            loader.loadLastPage(source);
        }
    }

    public static class First
    extends PageAction {
        public First() {
            super(AllIcons.Actions.Play_first);
        }

        @Override
        protected boolean isEnabled(GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel) {
            return !pageModel.isFirstPage();
        }

        @Override
        protected void actionPerformed(GridRequestSource source, GridLoader<DataConsumer.Row, DataConsumer.Column> loader) {
            loader.loadFirstPage(source);
        }
    }

    public static class Reload
    extends PageAction {
        public Reload() {
            super(PlatformIcons.SYNCHRONIZE_ICON);
        }

        @Override
        protected boolean isEnabled(GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel) {
            return true;
        }

        @Override
        protected void actionPerformed(GridRequestSource source, GridLoader<DataConsumer.Row, DataConsumer.Column> loader) {
            loader.reloadCurrentPage(source);
        }
    }
}

