/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum TxIsolation {
    DEFAULT(DatabaseBundle.message("transaction.mode.database.default", new Object[0]), -1),
    READ_UNCOMMITTED(DatabaseBundle.message("transaction.mode.read.uncommitted", new Object[0]), 1){

        @Override
        public boolean isSupported(@NotNull Dbms id, @Nullable DasTable table) {
            if (id == null) {
                1.$$$reportNull$$$0(0);
            }
            return !id.isOracle() && !id.isPostgres() && !id.isHsqldb() && !id.isVertica() && this.availableIfSybase(id, table);
        }

        private boolean availableIfSybase(@NotNull Dbms id, @Nullable DasTable table) {
            if (id == null) {
                1.$$$reportNull$$$0(1);
            }
            return !id.isSybase() || table == null || table.getDasChildren(ObjectKind.INDEX).filter(DasIndex.class).filter(i2 -> i2.isUnique()).first() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "id";
            objectArray2[1] = "com/intellij/database/run/actions/TxIsolation$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSupported";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "availableIfSybase";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
    ,
    READ_COMMITTED(DatabaseBundle.message("transaction.mode.read.committed", new Object[0]), 2),
    REPEATABLE_READ(DatabaseBundle.message("transaction.mode.repeatable.read", new Object[0]), 4){

        @Override
        public boolean isSupported(@NotNull Dbms id, @Nullable DasTable table) {
            if (id == null) {
                2.$$$reportNull$$$0(0);
            }
            return !id.isH2() && !id.isOracle() && !id.isHsqldb() && !id.isVertica();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/run/actions/TxIsolation$2", "isSupported"));
        }
    }
    ,
    SERIALIZABLE(DatabaseBundle.message("transaction.mode.serializable", new Object[0]), 8);

    private final int myIsolation;
    private final @NlsContexts.Checkbox String myName;

    private TxIsolation(String name, int isolation) {
        if (name == null) {
            TxIsolation.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myIsolation = isolation;
    }

    @NotNull
    @NlsContexts.Checkbox
    public String getName() {
        String string = this.myName;
        if (string == null) {
            TxIsolation.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int getIsolation() {
        return this.myIsolation;
    }

    public boolean isSupported(@NotNull Dbms id, @Nullable DasTable table) {
        if (id == null) {
            TxIsolation.$$$reportNull$$$0(2);
        }
        return true;
    }

    @NotNull
    public static TxIsolation of(int value2) {
        for (TxIsolation isolation : TxIsolation.values()) {
            if (isolation.myIsolation != value2) continue;
            TxIsolation txIsolation = isolation;
            if (txIsolation == null) {
                TxIsolation.$$$reportNull$$$0(3);
            }
            return txIsolation;
        }
        TxIsolation txIsolation = DEFAULT;
        if (txIsolation == null) {
            TxIsolation.$$$reportNull$$$0(4);
        }
        return txIsolation;
    }

    public static boolean levelsSupported(@NotNull Dbms id) {
        if (id == null) {
            TxIsolation.$$$reportNull$$$0(5);
        }
        return ArrayUtil.contains((Object)id, (Object[])new Dbms[]{Dbms.ORACLE, Dbms.MYSQL, Dbms.MYSQL_AURORA, Dbms.MARIA, Dbms.MEMSQL, Dbms.POSTGRES, Dbms.MSSQL, Dbms.AZURE, Dbms.SYBASE, Dbms.DB2_LUW, Dbms.DB2_IS, Dbms.DB2_ZOS, Dbms.DB2, Dbms.HSQL, Dbms.H2, Dbms.DERBY, Dbms.VERTICA});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/TxIsolation";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/TxIsolation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "levelsSupported";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

