/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.run.ui.grid.GridPanelWithEditor;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Dimension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridFilterPanel
extends GridPanelWithEditor {
    private JBPopup myFilterHistoryPopup;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public GridFilterPanel(@NotNull Project project, @NotNull DataGrid grid) {
        if (project == null) {
            GridFilterPanel.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            GridFilterPanel.$$$reportNull$$$0(1);
        }
        super(project, grid, DmlUtilKt.dmlGenerator(DataGridUtil.getDbms(grid)).getWherePrefix() + " ", DmlUtilKt.dmlGenerator(DataGridUtil.getDbms(grid)).getEmptyFilterText(), GridFilterPanel.getFilterDocument(grid));
        @NotNull @Nullable Function getPanel = g -> g.getFilterComponent().getFilterPanel();
        new GridPanelWithEditor.ApplyAction((Function<DataGrid, GridPanelWithEditor>)getPanel).registerCustomShortcutSet(CommonShortcuts.ENTER, this.myEditor.getComponent());
        new GridPanelWithEditor.CancelAction((Function<DataGrid, GridPanelWithEditor>)getPanel).registerCustomShortcutSet(CommonShortcuts.ESCAPE, this.myEditor.getComponent());
        new GridPanelWithEditor.ShowHistoryAction((Function<DataGrid, GridPanelWithEditor>)getPanel).registerCustomShortcutSet((ShortcutSet)GridFilterPanel.getShowHistoryShortcut(), this.myEditor.getComponent());
        GridFilteringModel filteringModel = this.myGrid.getDataHookup().getFilteringModel();
        if (filteringModel != null) {
            filteringModel.addListener(this::setHighlighter, this.myGrid);
        }
        this.add((Component)((Object)new GridPanelWithEditor.HistoryIcon(this, DatabaseIcons.FilterHistory)), "West");
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        return new Dimension(Math.max(300, preferredSize.width), preferredSize.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    void clearText() {
        GridFilteringModel filteringModel = this.myGrid.getDataHookup().getFilteringModel();
        boolean wasApplied = filteringModel != null && !StringUtil.isEmpty((String)filteringModel.getAppliedText());
        this.setText("", -1);
        if (wasApplied) {
            this.myGrid.getFilterComponent().getFilterPanel().apply();
        }
    }

    @Override
    @NotNull
    @NlsContexts.PopupContent
    String getInvalidTextErrorMessage() {
        String string = DatabaseBundle.message("popup.content.invalid.filter.criteria", new Object[0]);
        if (string == null) {
            GridFilterPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static Document getFilterDocument(@NotNull DataGrid grid) {
        GridFilteringModel filteringMode;
        if (grid == null) {
            GridFilterPanel.$$$reportNull$$$0(3);
        }
        Document document = (filteringMode = grid.getDataHookup().getFilteringModel()) == null ? EditorFactory.getInstance().createDocument((CharSequence)"") : filteringMode.getFilterDocument();
        if (document == null) {
            GridFilterPanel.$$$reportNull$$$0(4);
        }
        return document;
    }

    public void setText(String filter2, int caretPosition) {
        GridFilteringModel model = this.myGrid.getDataHookup().getFilteringModel();
        if (model == null) {
            return;
        }
        model.setFilterText(filter2);
        if (caretPosition < 0) {
            return;
        }
        this.requestFocusInWindow();
        this.myEditor.getCaretModel().moveToOffset(caretPosition);
    }

    @Override
    void showHistoryPopup() {
        GridFilteringModel model;
        if (this.myFilterHistoryPopup != null) {
            this.myFilterHistoryPopup.cancel();
            this.myFilterHistoryPopup = null;
        }
        if ((model = this.myGrid.getDataHookup().getFilteringModel()) == null) {
            return;
        }
        this.myFilterHistoryPopup = GridFilterPanel.createHistoryPopup(model.getHistory(), this.myProject, (Editor)this.myEditor, () -> this.myGrid.getFilterComponent().getFilterPanel().apply());
        this.myFilterHistoryPopup.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                GridFilterPanel.this.myFilterHistoryPopup = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/run/ui/grid/GridFilterPanel$1", "onClosed"));
            }
        });
        if (this.myGrid.getComponent().isShowing()) {
            this.myFilterHistoryPopup.showUnderneathOf((Component)this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridFilterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridFilterPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidTextErrorMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFilterDocument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

