/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridListModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationsStorage;
import com.intellij.database.run.ui.grid.GridMutationModel;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridStorageAndModelUpdater {
    private final DataGridListModel myModel;
    private final GridMutationModel myMutationModel;
    private final MutationsStorage myStorage;

    public GridStorageAndModelUpdater(@NotNull DataGridListModel model, @NotNull GridMutationModel mutationModel, @Nullable MutationsStorage storage) {
        if (model == null) {
            GridStorageAndModelUpdater.$$$reportNull$$$0(0);
        }
        if (mutationModel == null) {
            GridStorageAndModelUpdater.$$$reportNull$$$0(1);
        }
        this.myModel = model;
        this.myMutationModel = mutationModel;
        this.myStorage = storage;
    }

    public void removeRows(int firstRowIndex, int rowCount) {
        ModelIndexSet<DataConsumer.Row> rows = ModelIndexSet.forRows(this.myMutationModel, GridStorageAndModelUpdater.range(firstRowIndex, rowCount));
        if (this.myStorage != null) {
            for (ModelIndex rowIdx : rows.asIterable()) {
                this.myStorage.clearRow(rowIdx);
            }
        }
        if (firstRowIndex < this.myModel.getRowCount()) {
            this.myModel.removeRows(firstRowIndex, Math.min(rowCount, this.myModel.getRowCount() - firstRowIndex));
        }
        this.myMutationModel.notifyRowsRemoved(rows);
    }

    public void setColumns(@NotNull List<DataConsumer.Column> columns) {
        if (columns == null) {
            GridStorageAndModelUpdater.$$$reportNull$$$0(2);
        }
        int oldColumnCount = this.myMutationModel.getColumnCount();
        int newColumnCount = columns.size();
        this.myModel.clearColumns(newColumnCount);
        if (this.myStorage != null) {
            this.myStorage.clearColumns();
        }
        this.myMutationModel.notifyColumnsRemoved(ModelIndexSet.forColumns(this.myMutationModel, GridStorageAndModelUpdater.range(0, oldColumnCount)));
        this.myModel.setColumns(columns);
        this.myMutationModel.notifyColumnsAdded(ModelIndexSet.forColumns(this.myMutationModel, GridStorageAndModelUpdater.range(0, newColumnCount)));
    }

    public void setRows(int firstRowIndex, @NotNull List<DataConsumer.Row> rows) {
        if (rows == null) {
            GridStorageAndModelUpdater.$$$reportNull$$$0(3);
        }
        int firstChangedRowIndex = -1;
        int rowsUpdated = 0;
        for (int i2 = firstRowIndex; i2 < this.myMutationModel.getRowCount() && rowsUpdated < rows.size(); ++i2, ++rowsUpdated) {
            ModelIndex<DataConsumer.Row> rowIdx = ModelIndex.forRow(this.myModel, i2);
            Object oldRow = this.myMutationModel.getRow((ModelIndex)rowIdx);
            DataConsumer.Row newRow = rows.get(rowsUpdated);
            if (this.myStorage != null && this.myStorage.isInsertedRow(rowIdx)) {
                this.myModel.addRow(newRow);
            } else {
                this.myModel.set(i2, newRow);
            }
            if (GridStorageAndModelUpdater.rowsEqual((DataConsumer.Row)Objects.requireNonNull(oldRow), newRow)) {
                if (firstChangedRowIndex != -1) {
                    ModelIndexSet<DataConsumer.Row> updatedRows = ModelIndexSet.forRows(this.myMutationModel, GridStorageAndModelUpdater.range(firstChangedRowIndex, i2 - firstChangedRowIndex));
                    ModelIndexSet<DataConsumer.Column> updatedColumns = ModelIndexSet.forColumns(this.myMutationModel, GridStorageAndModelUpdater.range(0, this.myMutationModel.getColumnCount()));
                    this.myMutationModel.notifyCellsUpdated(updatedRows, updatedColumns, null);
                }
                firstChangedRowIndex = -1;
            } else if (firstChangedRowIndex == -1) {
                firstChangedRowIndex = i2;
            }
            if (this.myStorage == null) continue;
            this.myStorage.clearRow(rowIdx);
        }
        if (firstChangedRowIndex != -1) {
            ModelIndexSet<DataConsumer.Row> updatedRows = ModelIndexSet.forRows(this.myMutationModel, GridStorageAndModelUpdater.range(firstChangedRowIndex, firstRowIndex + rowsUpdated - firstChangedRowIndex));
            ModelIndexSet<DataConsumer.Column> updatedColumns = ModelIndexSet.forColumns(this.myMutationModel, GridStorageAndModelUpdater.range(0, this.myMutationModel.getColumnCount()));
            this.myMutationModel.notifyCellsUpdated(updatedRows, updatedColumns, null);
        }
        int firstRow = this.myMutationModel.getRowCount();
        List newRows = ContainerUtil.subList(rows, (int)rowsUpdated);
        this.myModel.addRows(newRows);
        this.myMutationModel.notifyRowsAdded(ModelIndexSet.forRows(this.myMutationModel, GridStorageAndModelUpdater.range(firstRow, newRows.size())));
    }

    public void addRows(List<DataConsumer.Row> rows) {
        int firstRow = this.myMutationModel.getRowCount();
        this.myModel.addRows(rows);
        this.myMutationModel.notifyRowsAdded(ModelIndexSet.forRows(this.myMutationModel, GridStorageAndModelUpdater.range(firstRow, rows.size())));
    }

    private static int[] range(int first2, int length) {
        int[] range = new int[length];
        for (int i2 = 0; i2 < length; ++i2) {
            range[i2] = first2 + i2;
        }
        return range;
    }

    private static boolean rowsEqual(@NotNull DataConsumer.Row row1, @NotNull DataConsumer.Row row2) {
        if (row1 == null) {
            GridStorageAndModelUpdater.$$$reportNull$$$0(4);
        }
        if (row2 == null) {
            GridStorageAndModelUpdater.$$$reportNull$$$0(5);
        }
        if (row1.getSize() != row2.getSize()) {
            return false;
        }
        for (int i2 = 0; i2 < row1.getSize(); ++i2) {
            if (Objects.equals(row1.getValue(i2), row2.getValue(i2))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutationModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/GridStorageAndModelUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setColumns";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setRows";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "rowsEqual";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

