/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtilCore;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import com.intellij.database.run.ui.grid.editors.Formatter;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DateAndTimeFormatter<T, V extends TemporalAccessor>
implements Formatter {
    private final DateTimeFormatter myFormatter;
    private final String myPattern;
    private final DateAndTimeFormatterDelegate<T, V> myDelegate;
    private final BoundaryValueResolver myBoundaryValuesResolver;
    private final DateTimeFormatter myDateFormatterForValueWithoutTime;

    public DateAndTimeFormatter(@NotNull String pattern, @NotNull DateTimeFormatter formatter, @NotNull DateAndTimeFormatterDelegate<T, V> delegate) {
        if (pattern == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(0);
        }
        if (formatter == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(1);
        }
        if (delegate == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(2);
        }
        this(pattern, formatter, delegate, BoundaryValueResolver.ALWAYS_NULL, null);
    }

    public DateAndTimeFormatter(@NotNull String pattern, @NotNull DateTimeFormatter formatter, @NotNull DateAndTimeFormatterDelegate<T, V> delegate, @NotNull BoundaryValueResolver resolver, @Nullable DateTimeFormatter dateFormatterForValueWithoutTime) {
        if (pattern == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(3);
        }
        if (formatter == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(4);
        }
        if (delegate == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(5);
        }
        if (resolver == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(6);
        }
        this.myPattern = pattern;
        this.myFormatter = formatter;
        this.myDelegate = delegate;
        this.myBoundaryValuesResolver = resolver;
        this.myDateFormatterForValueWithoutTime = dateFormatterForValueWithoutTime;
    }

    @Override
    public Object parse(@NotNull String value2) throws ParseException {
        Object boundary;
        if (value2 == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(7);
        }
        if ((boundary = this.myBoundaryValuesResolver.createFromInfinityString(value2)) != null) {
            return boundary;
        }
        try {
            V temporal = this.parseInternal(value2, this.myDelegate.getQueries());
            T result2 = this.myDelegate.createFromTemporal(temporal);
            String boundaryString = this.myBoundaryValuesResolver.resolve(result2);
            return boundaryString != null ? this.myBoundaryValuesResolver.createFromInfinityString(boundaryString) : result2;
        }
        catch (DateTimeParseException e) {
            throw new ParseException(value2, e.getErrorIndex());
        }
    }

    private V parseInternal(String value2, TemporalQuery<V> ... queries) {
        for (TemporalQuery<V> query : queries) {
            try {
                return (V)((TemporalAccessor)this.myFormatter.parse((CharSequence)value2, query));
            }
            catch (DateTimeException dateTimeException) {
            }
        }
        throw new DateTimeParseException(value2 + "can't be parsed", value2, 0);
    }

    @Override
    public Object parse(@NotNull String value2, @NotNull ParsePosition position) {
        if (value2 == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(8);
        }
        if (position == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(9);
        }
        try {
            return this.parse(value2);
        }
        catch (ParseException e) {
            position.setErrorIndex(e.getErrorOffset());
            return null;
        }
    }

    @Override
    public String format(@NotNull Object value2) {
        String boundary;
        if (value2 == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(10);
        }
        if ((boundary = this.myBoundaryValuesResolver.resolve(value2)) != null) {
            return boundary;
        }
        V temporalAccessor = this.myDelegate.toTemporalAccessor(value2);
        if (this.myDateFormatterForValueWithoutTime != null && DataGridFormattersUtilCore.isEmptyTime(temporalAccessor)) {
            return this.myDateFormatterForValueWithoutTime.format((TemporalAccessor)temporalAccessor);
        }
        return this.myFormatter.format((TemporalAccessor)temporalAccessor);
    }

    public TemporalAccessor getTemporalAccessor(@NotNull Object value2) {
        if (value2 == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(11);
        }
        return this.myDelegate.toTemporalAccessor(value2);
    }

    public String toString() {
        return this.myPattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DateAndTimeFormatter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "format";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getTemporalAccessor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

