/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.csv.PersistentCsvFormat;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.settings.ExtraParametersProvider;
import com.intellij.database.settings.UserPatterns;
import com.intellij.database.util.TokenPatternCache;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="DatabaseSettings", storages={@Storage(value="databaseSettings.xml")})
public final class DatabaseSettings
implements PersistentStateComponent<DatabaseSettings>,
ModificationTracker {
    public static final int MAX_FETCH_SIZE = 1000;
    private static final int CURRENT_VERSION = 7;
    private static final int DEFAULT_PAGE_SIZE = 500;
    static final String STATE_NAME = "databaseSettings";
    static final int EXEC_COUNT = 3;
    public static final int EXECUTE_INSIDE_SHOW_CHOOSER = 1;
    public static final int EXECUTE_INSIDE_SMALLEST = 2;
    public static final int EXECUTE_INSIDE_LARGEST = 3;
    public static final int EXECUTE_INSIDE_BATCH = 4;
    public static final int EXECUTE_INSIDE_WHOLE_SCRIPT = 5;
    public static final int EXECUTE_INSIDE_SCRIPT_TAIL = 6;
    public static final int EXECUTE_OUTSIDE_NOTHING = 1;
    public static final int EXECUTE_OUTSIDE_WHOLE_SCRIPT = 2;
    public static final int EXECUTE_OUTSIDE_SCRIPT_TAIL = 3;
    public static final int EXECUTE_SELECTION_EXACTLY_ONE = 1;
    public static final int EXECUTE_SELECTION_EXACTLY_SCRIPT = 2;
    public static final int EXECUTE_SELECTION_SMART_EXPAND = 3;
    public static final NotNullLazyValue<CsvFormat> TSV_FORMAT = NotNullLazyValue.lazy(() -> DatabaseSettings.xsvFormat(DatabaseBundle.message("csv.format.tsv.default.name", new Object[0]), "Tab-separated (TSV)_id", "\t"));
    public static final NotNullLazyValue<CsvFormat> CSV_FORMAT = NotNullLazyValue.lazy(() -> DatabaseSettings.xsvFormat(DatabaseBundle.message("csv.format.csv.default.name", new Object[0]), "Comma-separated (CSV)_id", ","));
    public static final NotNullLazyValue<CsvFormat> PIPE_SEPARATED_FORMAT = NotNullLazyValue.lazy(() -> DatabaseSettings.xsvFormat(DatabaseBundle.message("csv.format.pipe.separated.default.name", new Object[0]), "Pipe-separated_id", "|"));
    private final AtomicLong myModificationCount = new AtomicLong();
    public static final Topic<Listener> TOPIC = Topic.create((String)"Database settings", Listener.class);
    @Attribute(value="version")
    @Property(alwaysWrite=true)
    private int version = 0;
    @OptionTag(value="results-title-prefix")
    public String resultsTitlePrefix = null;
    @OptionTag(value="results-title-prefix-enabled")
    public boolean resultsTitlePrefixEnabled = true;
    @OptionTag(value="submit-immediately")
    public boolean submitImmediately = false;
    @OptionTag(value="page-size")
    public int pageSize = 500;
    @OptionTag(value="page-size-updated-timestamp")
    public long pageSizeUpdatedTimestamp = 0L;
    @OptionTag(value="limit-page-size")
    public boolean limitPageSize = true;
    @Deprecated
    @OptionTag(value="auto-transpose")
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public boolean autoTranspose = false;
    @OptionTag(value="auto-transpose-mode")
    public AutoTransposeMode autoTransposeMode = AutoTransposeMode.NEVER;
    @OptionTag(value="boolean-mode")
    public BooleanMode booleanMode = BooleanMode.TEXT;
    @OptionTag(value="default-ordering")
    public RowSortOrder.Type defaultTableOrdering = RowSortOrder.Type.UNSORTED;
    @Deprecated
    @OptionTag(value="reuse-result-tab")
    public boolean reuseResultTab = true;
    @OptionTag(value="always-review-parameters")
    public boolean alwaysReviewParameters = true;
    @Deprecated
    @OptionTag(value="execute-inside-option")
    public int executeInsideOption = 1;
    @Deprecated
    @OptionTag(value="execute-outside-option")
    public int executeOutsideOption = 1;
    @Deprecated
    @OptionTag(value="execute-selection-option")
    public int executeSelectionOption = 2;
    @OptionTag(value="split-statements-mode")
    public SplitScriptMode splitScriptMode = SplitScriptMode.COMBINED;
    @OptionTag(value="load-slow-documentation")
    public boolean loadSlowDocumentation = true;
    @OptionTag(value="preview-rows")
    public int previewRows = 10;
    @OptionTag(value="filters-history-size")
    public int filtersHistorySize = 10;
    @OptionTag(value="prefetch-size")
    public int prefetchSize = 100;
    @OptionTag(value="lob-length")
    public int bytesLimitPerValue = 204800;
    @OptionTag(value="error-in-editor")
    public boolean showErrorInEditor = true;
    @OptionTag(value="warn-unsafe-query")
    public boolean warnAboutUnsafeQuery = true;
    @OptionTag(value="auto-introspect-on-creation")
    public boolean trackNamespaces = true;
    @OptionTag(value="ddl-editor-confirm-loss")
    public boolean ddlConfirmLoss = true;
    @OptionTag(value="always-qualify-names")
    public boolean alwaysQualifyNames = false;
    @OptionTag(value="shorten-tab-names")
    public boolean shortenTabNames = true;
    @OptionTag(value="skip-refactoring-preview")
    public boolean skipRefactoringPreview = false;
    @OptionTag(value="notebook-mode")
    public boolean notebookMode = false;
    @OptionTag(value="show-output-in-tab")
    public boolean showOutputInTab = false;
    @OptionTag(value="context-tempate-target")
    public ContextTemplateTarget contextTemplateTarget = ContextTemplateTarget.APPEND_TO_EXISTING_CONSOLE;
    @OptionTag(value="show-services-mode")
    public ShowServicesMode showServicesMode = ShowServicesMode.ALL;
    @OptionTag(value="add-to-sort-via-alt-click")
    public boolean addToSortViaAltClick = true;
    @XCollection(propertyElementName="exec-options", elementName="exec-option", elementTypes={ExecOption.class})
    public List<ExecOption> execOptions = ContainerUtil.newArrayList((Iterable)JBIterable.of((Object)"").repeat(3).map(o -> new ExecOption()));
    @Property(surroundWithTag=false)
    public UserPatterns userPatterns = new UserPatterns();
    @XCollection(propertyElementName="csv-formats", elementName="format", elementTypes={PersistentCsvFormat.class})
    public List<PersistentCsvFormat> csvFormats = new ArrayList<PersistentCsvFormat>();
    @Transient
    public final TokenPatternCache patternCache = new TokenPatternCache(this);

    public long getModificationCount() {
        return this.myModificationCount.get();
    }

    private static CsvFormat xsvFormat(@NotNull String name, @NonNls @NotNull String id, @NotNull String valueSeparator) {
        if (name == null) {
            DatabaseSettings.$$$reportNull$$$0(0);
        }
        if (id == null) {
            DatabaseSettings.$$$reportNull$$$0(1);
        }
        if (valueSeparator == null) {
            DatabaseSettings.$$$reportNull$$$0(2);
        }
        ImmutableList quotes = ContainerUtil.immutableList((Object[])new CsvRecordFormat.Quotes[]{new CsvRecordFormat.Quotes("\"", "\"", "\"\"", "\"\""), new CsvRecordFormat.Quotes("'", "'", "''", "''")});
        CsvRecordFormat.QuotationPolicy quotationPolicy = CsvRecordFormat.QuotationPolicy.AS_NEEDED;
        CsvRecordFormat dataFormat = new CsvRecordFormat("", "", "", (List<CsvRecordFormat.Quotes>)quotes, quotationPolicy, valueSeparator, "\n", false);
        return new CsvFormat(name, dataFormat, null, id, false);
    }

    @NotNull
    public static ExecOption getDefaultExecOption() {
        ExecOption execOption = DatabaseSettings.getSettings().execOptions.get(0);
        if (execOption == null) {
            DatabaseSettings.$$$reportNull$$$0(3);
        }
        return execOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseSettings getSettings() {
        DatabaseSettings settings = (DatabaseSettings)ApplicationManager.getApplication().getService(DatabaseSettings.class);
        if (settings != null && settings.version == 0) {
            DatabaseSettings databaseSettings = settings;
            synchronized (databaseSettings) {
                settings.ensureDefaultsSet();
            }
        }
        return settings;
    }

    public static void fireSettingsChanged() {
        DatabaseSettings instance = DatabaseSettings.getSettings();
        instance.myModificationCount.incrementAndGet();
        instance.patternCache.clear();
        ((Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).settingsChanged();
    }

    public static DatabaseSettings create() {
        DatabaseSettings settings = new DatabaseSettings();
        settings.ensureDefaultsSet();
        return settings;
    }

    private DatabaseSettings() {
    }

    @TestOnly
    public void initTestDefaults() {
        LinkedHashSet<UserPatterns.ParameterPattern> predef = new LinkedHashSet<UserPatterns.ParameterPattern>(UserPatterns.getPredefined());
        ContainerUtil.addAll(predef, (Object[])new ExtraParametersProvider().getPatterns());
        this.getUserPatterns().patterns = new ArrayList<UserPatterns.ParameterPattern>(predef);
        this.getUserPatterns().processStrings = false;
        this.patternCache.clear();
        this.splitScriptMode = SplitScriptMode.ON_STATEMENTS;
        this.contextTemplateTarget = ContextTemplateTarget.APPEND_TO_EXISTING_CONSOLE;
    }

    @NotNull
    public DatabaseSettings getState() {
        ExecOption o = this.execOptions.get(0);
        this.reuseResultTab = !o.newTab;
        this.executeInsideOption = o.execInside;
        this.executeOutsideOption = o.execOutside;
        this.executeSelectionOption = o.execSelection;
        DatabaseSettings databaseSettings = this;
        if (databaseSettings == null) {
            DatabaseSettings.$$$reportNull$$$0(4);
        }
        return databaseSettings;
    }

    @TestOnly
    public DatabaseSettings copy() {
        return (DatabaseSettings)XmlSerializer.deserialize((Element)XmlSerializer.serialize((Object)this), DatabaseSettings.class);
    }

    public void loadState(@NotNull DatabaseSettings state) {
        if (state == null) {
            DatabaseSettings.$$$reportNull$$$0(5);
        }
        List<ExecOption> execOptionsPrev = this.execOptions;
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        if (this.execOptions.size() != 3) {
            JBIterable required = JBIterable.from(this.execOptions).append(execOptionsPrev).take(3);
            this.execOptions = ContainerUtil.newArrayList((Iterable)required);
        }
        ExecOption o = this.execOptions.get(0);
        o.newTab = !this.reuseResultTab;
        o.execInside = this.executeInsideOption;
        o.execOutside = this.executeOutsideOption;
        o.execSelection = this.executeSelectionOption;
        this.ensureDefaultsSet();
    }

    public boolean isSubmitImmediately() {
        return this.submitImmediately;
    }

    public boolean isAddToSortViaAltClick() {
        return this.addToSortViaAltClick;
    }

    public void setAddToSortViaAltClick(boolean value2) {
        this.addToSortViaAltClick = value2;
    }

    public void setSubmitImmediately(boolean submitImmediately) {
        this.submitImmediately = submitImmediately;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getPageSizeUpdatedTimestamp() {
        return this.pageSizeUpdatedTimestamp;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.pageSizeUpdatedTimestamp = System.currentTimeMillis();
    }

    public boolean isLimitPageSize() {
        return this.limitPageSize;
    }

    public void setLimitPageSize(boolean limitPageSize) {
        this.limitPageSize = limitPageSize;
        this.pageSizeUpdatedTimestamp = System.currentTimeMillis();
    }

    public void setAutoTransposeMode(@NotNull AutoTransposeMode autoTransposeMode) {
        if (autoTransposeMode == null) {
            DatabaseSettings.$$$reportNull$$$0(6);
        }
        this.autoTransposeMode = autoTransposeMode;
    }

    @NotNull
    public AutoTransposeMode getAutoTransposeMode() {
        AutoTransposeMode autoTransposeMode = this.autoTransposeMode;
        if (autoTransposeMode == null) {
            DatabaseSettings.$$$reportNull$$$0(7);
        }
        return autoTransposeMode;
    }

    public BooleanMode getBooleanMode() {
        return this.booleanMode;
    }

    public void setBooleanMode(@NotNull BooleanMode mode) {
        if (mode == null) {
            DatabaseSettings.$$$reportNull$$$0(8);
        }
        this.booleanMode = mode;
    }

    public RowSortOrder.Type getDefaultTableOrdering() {
        return this.defaultTableOrdering;
    }

    public void setDefaultTableOrdering(@NotNull RowSortOrder.Type ordering) {
        if (ordering == null) {
            DatabaseSettings.$$$reportNull$$$0(9);
        }
        this.defaultTableOrdering = ordering;
    }

    public int getPreviewRows() {
        return this.previewRows;
    }

    public void setPreviewRows(int rows) {
        this.previewRows = rows;
    }

    public int getFiltersHistorySize() {
        return this.filtersHistorySize;
    }

    public void setFiltersHistorySize(int filtersHistorySize) {
        this.filtersHistorySize = filtersHistorySize;
    }

    public int getPrefetchSize() {
        return Math.min(1000, this.prefetchSize);
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public int getBytesLimitPerValue() {
        return this.bytesLimitPerValue;
    }

    public void setBytesLimitPerValue(int lobLength) {
        this.bytesLimitPerValue = lobLength;
    }

    public boolean isShowErrorInEditor() {
        return this.showErrorInEditor;
    }

    public void setShowErrorInEditor(boolean show2) {
        this.showErrorInEditor = show2;
    }

    public UserPatterns getUserPatterns() {
        return this.userPatterns;
    }

    @NotNull
    public List<CsvFormat> getCsvFormats() {
        List<CsvFormat> formats = DatabaseSettings.getImmutableFormats(this.csvFormats);
        List<CsvFormat> list = formats.isEmpty() ? DatabaseSettings.getDefaultFormats() : formats;
        if (list == null) {
            DatabaseSettings.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static List<CsvFormat> getDefaultFormats() {
        List<CsvFormat> list = Arrays.asList((CsvFormat)CSV_FORMAT.getValue(), (CsvFormat)TSV_FORMAT.getValue(), (CsvFormat)PIPE_SEPARATED_FORMAT.getValue());
        if (list == null) {
            DatabaseSettings.$$$reportNull$$$0(11);
        }
        return list;
    }

    public void setCsvFormats(@NotNull List<CsvFormat> formats) {
        if (formats == null) {
            DatabaseSettings.$$$reportNull$$$0(12);
        }
        this.csvFormats = ContainerUtil.map(formats, PersistentCsvFormat::new);
    }

    private void ensureDefaultsSet() {
        this.userPatterns.migrate(this.version);
        if (DatabaseSettings.getImmutableFormats(this.csvFormats).isEmpty()) {
            this.setCsvFormats(DatabaseSettings.getDefaultFormats());
        } else {
            if (this.version < 2) {
                int idx = 0;
                for (PersistentCsvFormat format : this.csvFormats) {
                    if (ContainerUtil.exists(DatabaseSettings.getDefaultFormats(), f -> StringUtil.equals((CharSequence)format.id, (CharSequence)f.id))) continue;
                    CsvFormat similar = (CsvFormat)ContainerUtil.find(DatabaseSettings.getDefaultFormats(), f -> DatabaseSettings.formatsSimilar(f, format));
                    if (similar == null || ContainerUtil.exists(this.csvFormats, f -> StringUtil.equals((CharSequence)f.id, (CharSequence)similar.id))) {
                        format.id = String.valueOf(idx++);
                        continue;
                    }
                    format.id = similar.id;
                }
            }
            if (this.version < 5) {
                this.addNewFormat((CsvFormat)PIPE_SEPARATED_FORMAT.getValue(), (CsvFormat)TSV_FORMAT.getValue());
            }
            if (this.version < 6) {
                this.renameFormat(DatabaseBundle.message("csv.format.csv.default.old.name", new Object[0]), DatabaseBundle.message("csv.format.csv.default.name", new Object[0]));
                this.renameFormat(DatabaseBundle.message("csv.format.tsv.default.old.name", new Object[0]), DatabaseBundle.message("csv.format.tsv.default.name", new Object[0]));
            }
        }
        if (this.version < 4) {
            boolean bl = this.limitPageSize = this.pageSize > 0;
            if (!this.limitPageSize) {
                this.pageSize = 500;
            }
        }
        if (this.version < 7) {
            this.autoTransposeMode = this.autoTranspose ? AutoTransposeMode.ALWAYS : AutoTransposeMode.NEVER;
            this.autoTranspose = false;
        }
        this.version = 7;
    }

    private void renameFormat(@NotNull String oldName, @NotNull String newName) {
        if (oldName == null) {
            DatabaseSettings.$$$reportNull$$$0(13);
        }
        if (newName == null) {
            DatabaseSettings.$$$reportNull$$$0(14);
        }
        for (PersistentCsvFormat format : this.csvFormats) {
            if (!oldName.equals(format.name)) continue;
            format.name = newName;
        }
    }

    private void addNewFormat(@NotNull CsvFormat newFormat, @NotNull CsvFormat addAfterThis) {
        if (newFormat == null) {
            DatabaseSettings.$$$reportNull$$$0(15);
        }
        if (addAfterThis == null) {
            DatabaseSettings.$$$reportNull$$$0(16);
        }
        if (ContainerUtil.exists(this.csvFormats, f -> DatabaseSettings.formatsSimilar(newFormat, f))) {
            return;
        }
        int tsvIndex = ContainerUtil.indexOf(this.csvFormats, f -> f.id.equals(addAfterThis.id));
        this.csvFormats.add(tsvIndex + 1, new PersistentCsvFormat(newFormat));
    }

    private static boolean formatsSimilar(@NotNull CsvFormat format, @NotNull PersistentCsvFormat f) {
        if (format == null) {
            DatabaseSettings.$$$reportNull$$$0(17);
        }
        if (f == null) {
            DatabaseSettings.$$$reportNull$$$0(18);
        }
        if (StringUtil.equals((CharSequence)f.name, (CharSequence)format.name)) {
            return true;
        }
        CsvFormat immutable = f.immutable();
        return DatabaseSettings.formatsSimilar(format, immutable);
    }

    public static boolean formatsSimilar(@NotNull CsvFormat format, @Nullable CsvFormat other) {
        if (format == null) {
            DatabaseSettings.$$$reportNull$$$0(19);
        }
        return other != null && other.rowNumbers == format.rowNumbers && Comparing.equal((Object)other.headerRecord, (Object)format.headerRecord) && Comparing.equal((Object)other.dataRecord, (Object)format.dataRecord);
    }

    @NotNull
    private static List<CsvFormat> getImmutableFormats(@NotNull List<PersistentCsvFormat> persistentFormats) {
        if (persistentFormats == null) {
            DatabaseSettings.$$$reportNull$$$0(20);
        }
        List list = ContainerUtil.mapNotNull(persistentFormats, format -> format == null ? null : format.immutable());
        if (list == null) {
            DatabaseSettings.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueSeparator";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/settings/DatabaseSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoTransposeMode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formats";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFormat";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addAfterThis";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentFormats";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/settings/DatabaseSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExecOption";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoTransposeMode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCsvFormats";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFormats";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmutableFormats";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "xsvFormat";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 21: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setAutoTransposeMode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setBooleanMode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultTableOrdering";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setCsvFormats";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "renameFormat";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addNewFormat";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "formatsSimilar";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getImmutableFormats";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ShowServicesMode {
        ALL,
        QUERYOUTPUT_ERRORS_RESULTSETS,
        ERRORS_RESULTSETS,
        RESULTSETS,
        NEVER;

    }

    public static enum ContextTemplateTarget {
        OPEN_IN_NEW_CONSOLE,
        APPEND_TO_EXISTING_CONSOLE;

    }

    public static enum SplitScriptMode {
        COMBINED,
        ON_STATEMENTS,
        BY_SEPARATOR;

    }

    public static enum AutoTransposeMode {
        NEVER,
        ONE_ROW,
        ALWAYS;

    }

    public static enum BooleanMode {
        TEXT,
        CHECKBOX;

        public static Key<BooleanMode> BOOLEAN_MODE_KEY;

        @NotNull
        public static BooleanMode getBooleanMode(@NotNull UserDataHolder holder) {
            BooleanMode mode;
            if (holder == null) {
                BooleanMode.$$$reportNull$$$0(0);
            }
            if ((mode = (BooleanMode)((Object)holder.getUserData(BOOLEAN_MODE_KEY))) != null) {
                BooleanMode booleanMode = mode;
                if (booleanMode == null) {
                    BooleanMode.$$$reportNull$$$0(1);
                }
                return booleanMode;
            }
            mode = DatabaseSettings.getSettings().getBooleanMode();
            holder.putUserData(BOOLEAN_MODE_KEY, (Object)mode);
            BooleanMode booleanMode = mode;
            if (booleanMode == null) {
                BooleanMode.$$$reportNull$$$0(2);
            }
            return booleanMode;
        }

        static {
            BOOLEAN_MODE_KEY = new Key("BOOLEAN_MODE_KEY");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/settings/DatabaseSettings$BooleanMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/settings/DatabaseSettings$BooleanMode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBooleanMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getBooleanMode";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @Tag(value="exec-option")
    public static class ExecOption {
        @Attribute(value="new-tab")
        public boolean newTab;
        @Attribute(value="exec-inside")
        public int execInside = 1;
        @Attribute(value="exec-outside")
        public int execOutside = 1;
        @Attribute(value="exec-selection")
        public int execSelection = 2;

        @NotNull
        public ExecOption copyFrom(@NotNull ExecOption o) {
            if (o == null) {
                ExecOption.$$$reportNull$$$0(0);
            }
            this.newTab = o.newTab;
            this.execInside = o.execInside;
            this.execOutside = o.execOutside;
            this.execSelection = o.execSelection;
            ExecOption execOption = this;
            if (execOption == null) {
                ExecOption.$$$reportNull$$$0(1);
            }
            return execOption;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecOption option = (ExecOption)o;
            if (this.newTab != option.newTab) {
                return false;
            }
            if (this.execInside != option.execInside) {
                return false;
            }
            if (this.execOutside != option.execOutside) {
                return false;
            }
            return this.execSelection == option.execSelection;
        }

        public int hashCode() {
            int result2 = this.newTab ? 1 : 0;
            result2 = 31 * result2 + this.execInside;
            result2 = 31 * result2 + this.execOutside;
            result2 = 31 * result2 + this.execSelection;
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/settings/DatabaseSettings$ExecOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/settings/DatabaseSettings$ExecOption";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyFrom";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "copyFrom";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Listener {
        public void settingsChanged();
    }
}

