/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.types;

import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasTypeUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\r\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\t\u0010\u0015\u001a\u00020\u0007H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\r\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/types/DasBuiltinTypeWithLength;", "Lcom/intellij/database/types/DasBuiltinType;", "name", "", "kind", "Lcom/intellij/database/types/DasBuiltinType$Kind;", "length", "", "(Ljava/lang/String;Lcom/intellij/database/types/DasBuiltinType$Kind;I)V", "getLength", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "", "getKind", "getName", "hashCode", "render", "toDataType", "Lcom/intellij/database/model/DataType;", "Lorg/jetbrains/annotations/NotNull;", "toString", "intellij.database.core.impl"})
public final class DasBuiltinTypeWithLength
implements DasBuiltinType {
    private final String name;
    private final DasBuiltinType.Kind kind;
    private final int length;

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DasBuiltinType.Kind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public String render() {
        String string = DasTypeUtilsKt.renderSize(this.length);
        if (string == null) {
            return this.name;
        }
        String lengthStr = string;
        return this.name + '(' + lengthStr + ')';
    }

    @Override
    @NotNull
    public DataType toDataType() {
        DataType dataType = DataTypeFactory.of(null, this.name, this.length, 0, null, null, false, false);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"DataTypeFactory.of(\n    \u2026l, null, false, false\n  )");
        return dataType;
    }

    public final int getLength() {
        return this.length;
    }

    public DasBuiltinTypeWithLength(@NotNull String name, @NotNull DasBuiltinType.Kind kind, int length) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        this.name = name;
        this.kind = kind;
        this.length = length;
    }

    public /* synthetic */ DasBuiltinTypeWithLength(String string, DasBuiltinType.Kind kind, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = -1;
        }
        this(string, kind, n);
    }

    private final String component1() {
        return this.name;
    }

    private final DasBuiltinType.Kind component2() {
        return this.kind;
    }

    public final int component3() {
        return this.length;
    }

    @NotNull
    public final DasBuiltinTypeWithLength copy(@NotNull String name, @NotNull DasBuiltinType.Kind kind, int length) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        return new DasBuiltinTypeWithLength(name, kind, length);
    }

    public static /* synthetic */ DasBuiltinTypeWithLength copy$default(DasBuiltinTypeWithLength dasBuiltinTypeWithLength, String string, DasBuiltinType.Kind kind, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = dasBuiltinTypeWithLength.name;
        }
        if ((n2 & 2) != 0) {
            kind = dasBuiltinTypeWithLength.kind;
        }
        if ((n2 & 4) != 0) {
            n = dasBuiltinTypeWithLength.length;
        }
        return dasBuiltinTypeWithLength.copy(string, kind, n);
    }

    @NotNull
    public String toString() {
        return "DasBuiltinTypeWithLength(name=" + this.name + ", kind=" + (Object)((Object)this.kind) + ", length=" + this.length + ")";
    }

    public int hashCode() {
        String string = this.name;
        DasBuiltinType.Kind kind = this.kind;
        return ((string != null ? string.hashCode() : 0) * 31 + (kind != null ? ((Object)((Object)kind)).hashCode() : 0)) * 31 + Integer.hashCode(this.length);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DasBuiltinTypeWithLength)) break block3;
                DasBuiltinTypeWithLength dasBuiltinTypeWithLength = (DasBuiltinTypeWithLength)object;
                if (!Intrinsics.areEqual((Object)this.name, (Object)dasBuiltinTypeWithLength.name) || !Intrinsics.areEqual((Object)((Object)this.kind), (Object)((Object)dasBuiltinTypeWithLength.kind)) || this.length != dasBuiltinTypeWithLength.length) break block3;
            }
            return true;
        }
        return false;
    }
}

