/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.types;

import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasTypeUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\r\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/types/DasBuiltinTypeWithPrecision;", "Lcom/intellij/database/types/DasBuiltinType;", "name", "", "precision", "", "scale", "(Ljava/lang/String;II)V", "getPrecision", "()I", "getScale", "component1", "component2", "component3", "copy", "equals", "", "other", "", "getKind", "Lcom/intellij/database/types/DasBuiltinType$Kind;", "getName", "hashCode", "render", "toDataType", "Lcom/intellij/database/model/DataType;", "Lorg/jetbrains/annotations/NotNull;", "toString", "intellij.database.core.impl"})
public final class DasBuiltinTypeWithPrecision
implements DasBuiltinType {
    private final String name;
    private final int precision;
    private final int scale;

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DasBuiltinType.Kind getKind() {
        return DasBuiltinType.Kind.NUMBER;
    }

    @Override
    @NotNull
    public String render() {
        String string = DasTypeUtilsKt.renderSize(this.precision);
        if (string == null) {
            return this.name;
        }
        String precisionStr = string;
        String scaleStr = DasTypeUtilsKt.renderScale(this.scale);
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        $this$buildString.append(this.name);
        $this$buildString.append("(");
        $this$buildString.append(precisionStr);
        if (scaleStr != null) {
            $this$buildString.append(", ").append(scaleStr);
        }
        $this$buildString.append(")");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @Override
    @NotNull
    public DataType toDataType() {
        DataType dataType = DataTypeFactory.of(null, this.name, this.precision, this.scale, null, null, false, false);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"DataTypeFactory.of(\n    \u2026l, null, false, false\n  )");
        return dataType;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final int getScale() {
        return this.scale;
    }

    public DasBuiltinTypeWithPrecision(@NotNull String name, int precision, int scale) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.precision = precision;
        this.scale = scale;
    }

    public /* synthetic */ DasBuiltinTypeWithPrecision(String string, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(string, n, n2);
    }

    private final String component1() {
        return this.name;
    }

    public final int component2() {
        return this.precision;
    }

    public final int component3() {
        return this.scale;
    }

    @NotNull
    public final DasBuiltinTypeWithPrecision copy(@NotNull String name, int precision, int scale) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new DasBuiltinTypeWithPrecision(name, precision, scale);
    }

    public static /* synthetic */ DasBuiltinTypeWithPrecision copy$default(DasBuiltinTypeWithPrecision dasBuiltinTypeWithPrecision, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = dasBuiltinTypeWithPrecision.name;
        }
        if ((n3 & 2) != 0) {
            n = dasBuiltinTypeWithPrecision.precision;
        }
        if ((n3 & 4) != 0) {
            n2 = dasBuiltinTypeWithPrecision.scale;
        }
        return dasBuiltinTypeWithPrecision.copy(string, n, n2);
    }

    @NotNull
    public String toString() {
        return "DasBuiltinTypeWithPrecision(name=" + this.name + ", precision=" + this.precision + ", scale=" + this.scale + ")";
    }

    public int hashCode() {
        String string = this.name;
        return ((string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.precision)) * 31 + Integer.hashCode(this.scale);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DasBuiltinTypeWithPrecision)) break block3;
                DasBuiltinTypeWithPrecision dasBuiltinTypeWithPrecision = (DasBuiltinTypeWithPrecision)object;
                if (!Intrinsics.areEqual((Object)this.name, (Object)dasBuiltinTypeWithPrecision.name) || this.precision != dasBuiltinTypeWithPrecision.precision || this.scale != dasBuiltinTypeWithPrecision.scale) break block3;
            }
            return true;
        }
        return false;
    }
}

