/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.script.MongoJSLanguage;
import com.intellij.database.util.Case;
import com.intellij.database.util.ColoredDdlBuilder;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDropStatement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlSynonymDefinition;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbSqlUtil
extends DbSqlUtilCore {
    private DbSqlUtil() {
    }

    @NotNull
    public static Condition<VirtualFile> SQL_FILE_FILTER(@Nullable Project project) {
        if (project == null) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                DbSqlUtil.$$$reportNull$$$0(0);
            }
            return condition;
        }
        Condition condition = file -> {
            ObjectKind kind;
            if (file.isDirectory() || !file.isValid()) {
                return false;
            }
            ObjectKind objectKind = !(file instanceof DatabaseElementVirtualFileImpl) ? null : (kind = ((DatabaseElementVirtualFileImpl)((Object)file)).isBusy() ? ObjectKind.NONE : ((DatabaseElementVirtualFileImpl)((Object)file)).getObjectKind());
            if (kind == ObjectKind.NONE || kind == ObjectKind.DATABASE || kind == ObjectKind.SCHEMA) {
                return false;
            }
            return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SqlFileType.INSTANCE) || LanguageUtil.getLanguageFileType((Language)LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file)) == SqlFileType.INSTANCE;
        };
        if (condition == null) {
            DbSqlUtil.$$$reportNull$$$0(1);
        }
        return condition;
    }

    @NotNull
    public static String sql2Html(@NotNull Project project, @NotNull Language language, @NotNull CharSequence sequence) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(2);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(3);
        }
        if (sequence == null) {
            DbSqlUtil.$$$reportNull$$$0(4);
        }
        ColoredDdlBuilder colored = new ColoredDdlBuilder();
        DatabaseDialectEx dialect = language instanceof SqlLanguageDialect ? (DatabaseDialectEx)((SqlLanguageDialect)language).getDatabaseDialect() : DatabaseDialects.getGenericDialect();
        colored.withDialect(dialect);
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, null);
        Lexer lexer = highlighter.getHighlightingLexer();
        lexer.start(sequence);
        while (lexer.getTokenType() != null) {
            TextAttributesKey[] keys;
            boolean pushed = false;
            IElementType type = lexer.getTokenType();
            if (type != null && (keys = highlighter.getTokenHighlights(type)).length > 0) {
                pushed = true;
                colored.pushStyle(keys[0]);
            }
            colored.plain(StringUtil.escapeXmlEntities((String)lexer.getTokenText()));
            lexer.advance();
            if (!pushed) continue;
            colored.popStyle();
        }
        String string = colored.getStatement();
        if (string == null) {
            DbSqlUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static DasTable detectTable(@NotNull Project project, @NotNull Language language, @Nullable DbDataSource dataSource2, @Nullable SearchPath searchPath, @Nullable String queryText2, @Nullable SqlTableType resultType, @NotNull List<? extends DataConsumer.Column> columns) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(6);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(7);
        }
        if (columns == null) {
            DbSqlUtil.$$$reportNull$$$0(8);
        }
        DataConsumer.Column tableColumn = null;
        if (!columns.isEmpty()) {
            for (DataConsumer.Column column2 : columns) {
                if (StringUtil.isNotEmpty((String)column2.table) && (tableColumn == null || Objects.equals(column2.catalog, tableColumn.catalog) && Objects.equals(column2.schema, tableColumn.schema) && Objects.equals(column2.table, tableColumn.table))) {
                    tableColumn = column2;
                    continue;
                }
                tableColumn = null;
                break;
            }
        }
        DasNamed table = null;
        if (queryText2 != null) {
            SqlTableType sqlTableType = resultType != null ? resultType : DbSqlUtil.parseQueryTableType(project, language, dataSource2, searchPath, queryText2, null);
            PsiElement element2 = sqlTableType == null ? null : sqlTableType.getTypeElement();
            DasNamed dasNamed = table = element2 instanceof DasTable ? (DasTable)element2 : null;
            if (table == null && language instanceof SqlLanguageDialect && element2 instanceof SqlReferenceExpression) {
                SqlReferenceExpression ref = (SqlReferenceExpression)element2;
                String name = ref.getReferencePart(ObjectKind.TABLE);
                String refSchema = ref.getReferencePart(ObjectKind.SCHEMA);
                String refCatalog = ref.getReferencePart(ObjectKind.DATABASE);
                String schema = refSchema.isEmpty() && tableColumn != null && tableColumn.schema != null ? tableColumn.schema : refSchema;
                String catalog = refCatalog.isEmpty() && tableColumn != null && tableColumn.catalog != null ? tableColumn.catalog : refCatalog;
                table = DbImplUtil.getModelHelper(Dbms.UNKNOWN).sqlCreateFakeTable(catalog, schema, name);
            }
        }
        if (tableColumn != null && table != null) {
            String catalog;
            Dbms dbms = DbSqlUtil.getDbms(language);
            boolean checkTableName = dbms != Dbms.GREENPLUM || table.getKind() != ObjectKind.VIEW;
            boolean metadataMayReturnDifferentCase = dbms.in(Dbms.MYSQL_LIKE);
            boolean dbIsSchema = dbms.isMysql() || dbms == Dbms.CLICKHOUSE;
            String schema = dbIsSchema ? DasUtil.NO_NAME : DasUtil.getSchema((DasObject)table);
            String string = catalog = dbIsSchema ? DasUtil.getSchema((DasObject)table) : DasUtil.getCatalog((DasObject)table);
            if (checkTableName && !DbSqlUtil.matches(tableColumn.table, table.getName(), metadataMayReturnDifferentCase) || !DbSqlUtil.matches(tableColumn.schema, schema, metadataMayReturnDifferentCase) || !catalog.isEmpty() && !DbSqlUtil.matches(tableColumn.catalog, catalog, metadataMayReturnDifferentCase)) {
                table = null;
            }
        }
        return table;
    }

    private static boolean matches(@Nullable String jdbcName, @Nullable String modelName, boolean metadataMayReturnDifferentCase) {
        return StringUtil.isEmpty((String)jdbcName) || StringUtilRt.equal((CharSequence)modelName, (CharSequence)jdbcName, (!metadataMayReturnDifferentCase ? 1 : 0) != 0);
    }

    @NotNull
    public static List<DataConsumer.Column> createColumnsFromType(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @Nullable String catalog, @Nullable String schema, @NotNull String tableName) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(9);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(10);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(11);
        }
        if (tableName == null) {
            DbSqlUtil.$$$reportNull$$$0(12);
        }
        ArrayList<DataConsumer.Column> columns = new ArrayList<DataConsumer.Column>(type.getColumnCount());
        List<String> columnNames = DbSqlUtil.getUnambiguousColumnNames(project, dialect, type, null);
        int count = type.getColumnCount();
        for (int i2 = 0; i2 < count; ++i2) {
            String name = columnNames.get(i2);
            String typeName = type.getColumnType(i2).getDisplayName();
            columns.add(new DataConsumer.Column(i2, name, 1111, typeName, null, 0, 0, catalog, schema, tableName));
        }
        ArrayList<DataConsumer.Column> arrayList = columns;
        if (arrayList == null) {
            DbSqlUtil.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(14);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(15);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(16);
        }
        List<String> columnNames = DbSqlUtil.getColumnNames(type);
        Set<String> duplicates = DbSqlUtil.getDuplicateNames(columnNames);
        DbSqlUtil.makeUnambiguousColumnNames(project, dialect, type, columnNames, duplicates, forceQualify);
        List<String> list = columnNames;
        if (list == null) {
            DbSqlUtil.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public static List<String> getUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType partType, @NotNull SqlTableType fullType, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(18);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(19);
        }
        if (partType == null) {
            DbSqlUtil.$$$reportNull$$$0(20);
        }
        if (fullType == null) {
            DbSqlUtil.$$$reportNull$$$0(21);
        }
        List<String> partColumnNames = DbSqlUtil.getColumnNames(partType);
        List<String> fullColumnNames = DbSqlUtil.getColumnNames(fullType);
        Set<String> duplicates = DbSqlUtil.getDuplicateNames(fullColumnNames);
        DbSqlUtil.makeUnambiguousColumnNames(project, dialect, partType, partColumnNames, duplicates, forceQualify);
        List<String> list = partColumnNames;
        if (list == null) {
            DbSqlUtil.$$$reportNull$$$0(22);
        }
        return list;
    }

    private static void makeUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @NotNull List<String> columnNames, @NotNull Set<String> duplicates, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(23);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(24);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(25);
        }
        if (columnNames == null) {
            DbSqlUtil.$$$reportNull$$$0(26);
        }
        if (duplicates == null) {
            DbSqlUtil.$$$reportNull$$$0(27);
        }
        DdlBuilder builder = new DdlBuilder(new StringBuilder()).configureBuilder(project, DbSqlUtil.getSqlDialect(dialect)).withDialect(dialect);
        for (int i2 = 0; i2 < columnNames.size(); ++i2) {
            String name = columnNames.get(i2);
            String typeAlias = type.getColumnTypeAlias(i2);
            if (typeAlias != null && (duplicates.contains(name) || forceQualify != null && ((Boolean)forceQualify.fun((Object)type, (Object)i2)).booleanValue())) {
                builder.suppressQuoteIdentifiers(!type.isColumnTypeAliasQuoted(i2));
                builder.columnRef(typeAlias).symbol(".");
            }
            builder.suppressQuoteIdentifiers(!type.isColumnQuoted(i2));
            builder.columnRef(name);
            columnNames.set(i2, builder.getStatement());
            builder.clear();
        }
    }

    private static List<String> getColumnNames(SqlTableType type) {
        ArrayList<String> columnNames = new ArrayList<String>(type.getColumnCount());
        for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
            columnNames.add(StringUtil.notNullize((String)type.getColumnName(i2)));
        }
        return columnNames;
    }

    private static Set<String> getDuplicateNames(List<String> names) {
        THashSet duplicates = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        THashSet distinctNames = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (String name : names) {
            if (distinctNames.add(name)) continue;
            duplicates.add(name);
        }
        return duplicates;
    }

    @NotNull
    public static List<PsiElement> resolveToColumnList(@NotNull SqlReferenceExpression ref) {
        String text2;
        if (ref == null) {
            DbSqlUtil.$$$reportNull$$$0(28);
        }
        if (!"*".equals(text2 = StringUtil.notNullize((String)ref.getText())) && !text2.endsWith(".*")) {
            PsiElement resolve = ref.getReference().resolve();
            List<Object> list = resolve == null ? Collections.emptyList() : Collections.singletonList(resolve);
            if (list == null) {
                DbSqlUtil.$$$reportNull$$$0(29);
            }
            return list;
        }
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)ref.getSqlType(), SqlTableType.class);
        if (type == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                DbSqlUtil.$$$reportNull$$$0(30);
            }
            return list;
        }
        ArrayList<PsiElement> res2 = new ArrayList<PsiElement>(type.getColumnCount());
        for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
            res2.add(type.getColumnElement(i2));
        }
        ArrayList<PsiElement> arrayList = res2;
        if (arrayList == null) {
            DbSqlUtil.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @Nullable
    public static SqlTableType parseQueryTableType(@NotNull Project project, @NotNull Language language, @Nullable DbDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull String queryText2, @Nullable Language hostLanguage) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(32);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(33);
        }
        if (queryText2 == null) {
            DbSqlUtil.$$$reportNull$$$0(34);
        }
        if (!(language instanceof SqlLanguageDialect)) {
            return null;
        }
        SqlResultSetExpression sql = DbSqlUtil.parseSqlQuery(project, (SqlLanguageDialect)language, queryText2, hostLanguage);
        if (sql == null) {
            return null;
        }
        sql.getContainingFile().putUserData(DatabaseDataKeysCore.DATA_SOURCE_KEY, (Object)dataSource2);
        sql.getContainingFile().putUserData(DatabaseDataKeysCore.SEARCH_PATH_KEY, (Object)searchPath);
        return (SqlTableType)ObjectUtils.tryCast((Object)sql.getSqlType(), SqlTableType.class);
    }

    @Nullable
    public static SqlTableType parseQueryTableType(@NotNull JdbcConsoleBase console, @NotNull Language language, @NotNull String queryText2) {
        if (console == null) {
            DbSqlUtil.$$$reportNull$$$0(35);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(36);
        }
        if (queryText2 == null) {
            DbSqlUtil.$$$reportNull$$$0(37);
        }
        return DbSqlUtil.parseQueryTableType(console.getProject(), language, DbSqlUtil.getDbDataSource(console.getProject(), console.getDataSource()), console.getSearchPath(), queryText2, null);
    }

    public static boolean isResultEditable(@Nullable DataRequest request, SqlTableType tableType, DasTable detectedTable) {
        DasTable table;
        if (!(request instanceof DataRequest.QueryRequest)) {
            return false;
        }
        if (!(request instanceof ConsoleDataRequest)) {
            return true;
        }
        if (tableType == null) {
            return false;
        }
        PsiElement element2 = tableType.getTypeElement();
        DasTable dasTable = element2 instanceof DasTable ? (DasTable)element2 : (table = element2 instanceof SqlReferenceExpression ? detectedTable : null);
        if (table == null || DasUtil.getColumns(table).isEmpty()) {
            return false;
        }
        return DbImplUtilCore.isDataTable(table.getKind());
    }

    @Nullable
    public static IntrospectionScopeUpdater getScopeUpdater(@NotNull SyntaxTraverser<PsiElement> s2, @Nullable ObjectPath ns, @NotNull DasModel model) {
        if (s2 == null) {
            DbSqlUtil.$$$reportNull$$$0(38);
        }
        if (model == null) {
            DbSqlUtil.$$$reportNull$$$0(39);
        }
        IntrospectionScopeUpdater res2 = null;
        ObjectPath db = ns != null ? DbSqlUtil.getCurrentDatabase(ns) : DbSqlUtil.getCurrentDatabase(model);
        for (SqlStatement statement : s2.filter(SqlStatement.class)) {
            SqlDropStatement dropStatement;
            SqlReferenceExpression expression;
            ObjectPath objectName;
            ObjectKind kind;
            if (statement instanceof SqlAlterStatement) {
                for (SqlSynonymDefinition synonymDefinition : SyntaxTraverser.psiApi().children((Object)statement).filter(SqlSynonymDefinition.class)) {
                    kind = synonymDefinition.getKind();
                    if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) continue;
                    SqlNameElement newName = synonymDefinition.getNameElement();
                    SqlReferenceExpression oldName = synonymDefinition.getTargetReference();
                    if (newName == null || oldName == null) continue;
                    if (res2 == null) {
                        res2 = new IntrospectionScopeUpdater();
                    }
                    ObjectPath parent2 = kind == ObjectKind.SCHEMA ? db : null;
                    ObjectPath oldObjectName = ObjectPath.create(oldName.getName(), kind, oldName.isQuotedIdentifier(), null, parent2);
                    ObjectPath newObjectName = ObjectPath.create(newName.getName(), kind, newName.isQuotedIdentifier(), null, parent2);
                    res2.toRemove(oldObjectName);
                    res2.toAdd(newObjectName);
                }
                continue;
            }
            if (statement instanceof SqlCreateStatement) {
                SqlNameElement element2;
                SqlCreateStatement createStatement = (SqlCreateStatement)statement;
                ObjectKind kind2 = createStatement.getKind();
                if (kind2 != ObjectKind.DATABASE && kind2 != ObjectKind.SCHEMA || (element2 = createStatement.getNameElement()) == null) continue;
                if (res2 == null) {
                    res2 = new IntrospectionScopeUpdater();
                }
                objectName = ObjectPath.create(element2.getName(), kind2, element2.isQuotedIdentifier(), null, kind2 == ObjectKind.SCHEMA ? db : null);
                res2.toAdd(objectName);
                continue;
            }
            if (!(statement instanceof SqlDropStatement) || (expression = (dropStatement = (SqlDropStatement)statement).getTargetExpression()) == null || (kind = expression.getReferenceElementType().getTargetKind()) != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) continue;
            if (res2 == null) {
                res2 = new IntrospectionScopeUpdater();
            }
            objectName = ObjectPath.create(expression.getName(), kind, expression.isQuotedIdentifier(), null, kind == ObjectKind.SCHEMA ? db : null);
            res2.toRemove(objectName);
        }
        return res2;
    }

    @Nullable
    public static ObjectPath getCurrentDatabase(@NotNull DasModel model) {
        DasNamespace cur2;
        if (model == null) {
            DbSqlUtil.$$$reportNull$$$0(40);
        }
        if ((cur2 = model.getCurrentRootNamespace()) == null) {
            Iterator it2 = model.getModelRoots().filter(DasNamespace.class).iterator();
            if (!it2.hasNext()) {
                return null;
            }
            cur2 = (DasNamespace)it2.next();
            if (it2.hasNext()) {
                return null;
            }
        }
        return cur2.getKind() == ObjectKind.DATABASE ? ObjectPaths.of(cur2) : null;
    }

    @Nullable
    private static ObjectPath getCurrentDatabase(@NotNull ObjectPath ns) {
        if (ns == null) {
            DbSqlUtil.$$$reportNull$$$0(41);
        }
        return ns.findParent(ObjectKind.DATABASE, false);
    }

    public static boolean isSqlElement(@NotNull DbElement element2) {
        DbDataSource dataSource2;
        if (element2 == null) {
            DbSqlUtil.$$$reportNull$$$0(42);
        }
        return element2 != (dataSource2 = element2.getDataSource()) && dataSource2.getDelegate() instanceof SqlDataSource;
    }

    @Nullable
    public static DasObject getSqlSourceElement(@Nullable DbElement element2) {
        DasObject dasObject;
        DasObject dasObject2 = dasObject = element2 == null ? null : (DasObject)ObjectUtils.tryCast((Object)element2.getDelegate(), DasObject.class);
        if (dasObject == null) {
            return null;
        }
        return DbSqlUtil.getSqlSourceElement(element2.getDataSource(), dasObject);
    }

    @Nullable
    public static DasObject getSqlSourceElement(@Nullable DbDataSource dataSource2, @Nullable DasObject dasObject) {
        if (dataSource2 == null || dasObject == null) {
            return null;
        }
        SqlDataSource source = (SqlDataSource)ObjectUtils.tryCast((Object)dataSource2.getDelegate(), SqlDataSource.class);
        return source == null ? null : source.fromModel(dasObject);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull DatabaseDialect dialect) {
        SqlLanguageDialect res2;
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(43);
        }
        SqlLanguageDialect sqlLanguageDialect = (res2 = DbSqlUtil.findSqlDialect(dialect)) == null ? SqlDialects.getGenericDialect() : res2;
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(44);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static Language getLanguage(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtil.$$$reportNull$$$0(45);
        }
        MongoJSLanguage mongoJSLanguage = dbms == Dbms.MONGO ? MongoJSLanguage.INSTANCE : DbSqlUtil.getSqlDialect(dbms);
        if (mongoJSLanguage == null) {
            DbSqlUtil.$$$reportNull$$$0(46);
        }
        return mongoJSLanguage;
    }

    @NotNull
    public static Language getLanguage(@Nullable DbDataSource dataSource2) {
        Language language = dataSource2 == null ? null : dataSource2.getQueryLanguage();
        Object object = language == null ? SqlDialects.getGenericDialect() : language;
        if (object == null) {
            DbSqlUtil.$$$reportNull$$$0(47);
        }
        return object;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DatabaseDriver driver) {
        SqlLanguageDialect dialect = DbSqlUtil.findSqlDialect(driver);
        SqlLanguageDialect sqlLanguageDialect = dialect == null ? SqlDialects.getGenericDialect() : dialect;
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(48);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@Nullable DatabaseDriver driver) {
        if (driver == null) {
            return null;
        }
        String dialectId = driver.getSqlDialect();
        SqlLanguageDialect result2 = StringUtil.isEmpty((String)dialectId) ? null : SqlDialects.findDialectById(dialectId);
        return result2 != null ? result2 : DbSqlUtil.getSqlDialect(DbImplUtilCore.getDbms(driver));
    }

    @Deprecated
    public static boolean areKeywordsLowerCase(@Nullable Project project) {
        SqlCodeStyleSettings codeStyleSettings = SqlCodeStyles.getGeneralSqlSettings((Project)project);
        Case keywordCaseMode = codeStyleSettings.getKeywordCase();
        return keywordCaseMode == Case.LOWER || keywordCaseMode == Case.MIXED;
    }

    public static boolean areKeywordsLowerCase(@Nullable Project project, @NotNull Language dialect) {
        SqlCodeStyleSettings codeStyleSettings;
        Case keywordCaseMode;
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(49);
        }
        return (keywordCaseMode = (codeStyleSettings = SqlCodeStyles.getSqlSettings((Project)project, (Language)dialect)).getKeywordCase()) == Case.LOWER || keywordCaseMode == Case.MIXED;
    }

    public static boolean isSqlFile(@NotNull PsiFile file) {
        if (file == null) {
            DbSqlUtil.$$$reportNull$$$0(50);
        }
        return file instanceof SqlFile || file.getFileType() == SqlFileType.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 49: 
            case 50: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 49: 
            case 50: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbSqlUtil";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 14: 
            case 18: 
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 10: 
            case 15: 
            case 19: 
            case 24: 
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 11: 
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "SQL_FILE_FILTER";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbSqlUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sql2Html";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumnsFromType";
                break;
            }
            case 17: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnambiguousColumnNames";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToColumnList";
                break;
            }
            case 44: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sql2Html";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "detectTable";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createColumnsFromType";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getUnambiguousColumnNames";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "makeUnambiguousColumnNames";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveToColumnList";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "parseQueryTableType";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getScopeUpdater";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentDatabase";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isSqlElement";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "areKeywordsLowerCase";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isSqlFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 49: 
            case 50: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

