/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.editor.DatabaseEditorHelperCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.DatabaseVirtualFileSystem;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.search.ProjectAwareVirtualFile;
import com.intellij.psi.util.PsiAwareObject;
import com.intellij.sql.SqlFileType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.containers.JBIterable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider=ElementPresentation.class)
public class DatabaseElementVirtualFileImpl
extends VirtualFile
implements ProjectAwareVirtualFile,
VirtualFilePathWrapper,
PsiAwareObject {
    public static final int DATASOURCE_NAME_LENGTH = 36;
    @Nullable
    private final ObjectPath myPath;
    private boolean myWritable;
    private final boolean mySource;
    private final String myDataSourceId;
    private Pair<Reference<DbElement>, Long> myCachedPsi;
    private volatile boolean myBusy;
    private volatile String myContent;
    private volatile int myObjectHash;
    private volatile int myInitialContentHash;

    protected DatabaseElementVirtualFileImpl(@NotNull String dataSourceId, @Nullable ObjectPath path, boolean source) {
        if (dataSourceId == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(0);
        }
        this.myWritable = true;
        this.myDataSourceId = dataSourceId;
        this.myPath = path != null && path.kind == ObjectKind.ROOT ? null : path;
        this.mySource = source;
    }

    public String getDataSourceId() {
        return this.myDataSourceId;
    }

    @Nullable
    public ObjectPath getObjectPath() {
        return this.myPath;
    }

    public DbDataSource findDataSource(@NotNull Project project) {
        if (project == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(1);
        }
        return DbPsiFacade.getInstance(project).findDataSource(this.myDataSourceId);
    }

    public boolean isSource() {
        return this.mySource;
    }

    @NotNull
    public String getPath() {
        String string = DatabaseVirtualFileSystem.getPath(this.getDataSourceId(), this.myPath, this.mySource);
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static String getUrl(String dataSourceId, ObjectPath path, boolean source) {
        return "das://" + DatabaseVirtualFileSystem.getPath(dataSourceId, path, source);
    }

    @NotNull
    public String getName() {
        Object object = this.mySource ? this.getNameWithoutExtension() + ".sql" : this.getNameWithoutExtension();
        if (object == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(3);
        }
        return object;
    }

    @NotNull
    public String getNameWithoutExtension() {
        String string = DbSrcUtilsCore.escapeChars(this.myPath == null ? this.getDataSourceId() : this.myPath.name);
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isInProject(@NotNull Project project) {
        if (project == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(5);
        }
        return this.findDataSource(project) != null;
    }

    @NotNull
    public ObjectKind getObjectKind() {
        ObjectKind objectKind = this.myPath == null ? ObjectKind.ROOT : this.myPath.kind;
        if (objectKind == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(6);
        }
        return objectKind;
    }

    @Nullable
    public DbElement findElement(@NotNull Project project) {
        if (project == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(7);
        }
        return this.findElementInner(this.findDataSource(project));
    }

    @Nullable
    DbDataSource findDataSourceInAnyProject() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DbDataSource result2 = this.findDataSource(project);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    private DbElement findElementInner(@Nullable DbDataSource dataSource2) {
        DbElement cached;
        if (dataSource2 == null) {
            return null;
        }
        if (this.myPath == null) {
            return dataSource2;
        }
        Project project = dataSource2.getProject();
        long timestamp = DbPsiFacade.getInstance(project).getModificationCount();
        Pair<Reference<DbElement>, Long> cachedPsi = this.myCachedPsi;
        DbElement dbElement = cached = cachedPsi != null && (Long)cachedPsi.second == timestamp ? (DbElement)((Reference)cachedPsi.first).get() : null;
        if (cached != null && cached.getProject() == project) {
            return cached;
        }
        DbElement found = dataSource2.findElement(this.myPath);
        this.myCachedPsi = found != null ? Pair.create(new WeakReference<DbElement>(found), (Object)timestamp) : null;
        return found;
    }

    @NotNull
    public FileType getFileType() {
        if (this.mySource) {
            SqlFileType sqlFileType = SqlFileType.INSTANCE;
            if (sqlFileType == null) {
                DatabaseElementVirtualFileImpl.$$$reportNull$$$0(8);
            }
            return sqlFileType;
        }
        if (this.myPath != null && DbImplUtilCore.isDataTable(this.myPath.kind)) {
            FileType fileType = super.getFileType();
            if (fileType == null) {
                DatabaseElementVirtualFileImpl.$$$reportNull$$$0(9);
            }
            return fileType;
        }
        if (DatabaseEditorHelperCore.isDefinitionAvailable(this.findElementInner(this.findDataSourceInAnyProject()))) {
            SqlFileType sqlFileType = SqlFileType.INSTANCE;
            if (sqlFileType == null) {
                DatabaseElementVirtualFileImpl.$$$reportNull$$$0(10);
            }
            return sqlFileType;
        }
        FileType fileType = super.getFileType();
        if (fileType == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(11);
        }
        return fileType;
    }

    @NotNull
    public DatabaseVirtualFileSystem getFileSystem() {
        DatabaseVirtualFileSystem databaseVirtualFileSystem = DatabaseVirtualFileSystem.getDatabaseFileSystem();
        if (databaseVirtualFileSystem == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(12);
        }
        return databaseVirtualFileSystem;
    }

    public boolean isWritable() {
        return this.myWritable;
    }

    public void setWritable(boolean writable) {
        boolean prev = this.myWritable;
        DbDataSource dataSource2 = !writable ? null : this.findDataSourceInAnyProject();
        boolean bl = this.myWritable = dataSource2 != null && dataSource2.isWritable();
        if (prev != this.myWritable) {
            BulkFileListener publisher = (BulkFileListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
            List<VFilePropertyChangeEvent> events = Collections.singletonList(new VFilePropertyChangeEvent((Object)this, (VirtualFile)this, "writable", (Object)prev, (Object)this.myWritable, false));
            publisher.before(events);
            publisher.after(events);
        }
    }

    public final void setWritableInner(boolean writable) {
        this.myWritable = writable;
    }

    public boolean isDirectory() {
        return false;
    }

    public VirtualFile getParent() {
        if (this.myPath == null) {
            return null;
        }
        return DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(DatabaseVirtualFileSystem.getPath(this.getDataSourceId(), this.myPath.parent, this.mySource));
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @NotNull
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.myContent == null ? ArrayUtilRt.EMPTY_BYTE_ARRAY : this.myContent.getBytes(this.getCharset()));
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        if (!this.getFileType().isBinary()) {
            return new ByteArrayOutputStream(){

                @Override
                public void close() {
                    DatabaseElementVirtualFileImpl.this.myContent = new String(this.buf, 0, this.count, DatabaseElementVirtualFileImpl.this.getCharset());
                    FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{DatabaseElementVirtualFileImpl.this});
                }
            };
        }
        throw new IOException("Unsupported operation");
    }

    public void setContent(@NotNull String content, int objectHash) {
        if (content == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(13);
        }
        this.myContent = content;
        this.myObjectHash = objectHash;
        this.myInitialContentHash = content.hashCode();
    }

    public String getContent() {
        return this.myContent;
    }

    public boolean isBusy() {
        return this.myBusy;
    }

    public void setBusy(boolean busy) {
        this.myBusy = busy;
    }

    public byte @NotNull [] contentsToByteArray() {
        byte[] byArray = this.myContent != null ? this.myContent.getBytes(this.getCharset()) : ArrayUtilRt.EMPTY_BYTE_ARRAY;
        if (byArray == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(14);
        }
        return byArray;
    }

    public long getModificationStamp() {
        return 0L;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getLength() {
        return this.myContent == null ? 0L : (long)this.myContent.length();
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public boolean isValid() {
        return DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(this.getPath()) != null;
    }

    private static boolean isLoadingDS(@NotNull DbDataSource dataSource2) {
        LocalDataSource localDataSource;
        if (dataSource2 == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(15);
        }
        return (localDataSource = DbImplUtilCore.getMaybeLocalDataSource(dataSource2)) != null && localDataSource.isLoading();
    }

    public boolean shouldBeValid() {
        if (!LoadingState.PROJECT_OPENED.isOccurred()) {
            return true;
        }
        DbDataSource dataSource2 = this.findDataSourceInAnyProject();
        if (dataSource2 == null || !dataSource2.isValid()) {
            return false;
        }
        if (DatabaseElementVirtualFileImpl.isLoadingDS(dataSource2)) {
            return true;
        }
        return this.findElementInner(dataSource2) != null;
    }

    private String validnessStatus() {
        DbDataSource dataSource2 = this.findDataSourceInAnyProject();
        if (dataSource2 == null) {
            return "DS not found";
        }
        if (!dataSource2.isValid()) {
            return "DS invalid";
        }
        if (DatabaseElementVirtualFileImpl.isLoadingDS(dataSource2)) {
            return "DS loading";
        }
        if (this.findElementInner(dataSource2) == null) {
            return "Element not found";
        }
        return "Valid";
    }

    public boolean isModifiedByUser() {
        return this.myContent != null && this.myContent.hashCode() != this.myInitialContentHash;
    }

    public int getObjectHash() {
        return this.myObjectHash;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(16);
        }
        return (T)(key == FileDocumentManagerBase.TRACK_NON_PHYSICAL ? Boolean.TRUE : super.getUserData(key));
    }

    @Nullable
    public static DatabaseElementVirtualFileImpl findFile(@Nullable DbElement element2, boolean source) {
        if (element2 == null || !element2.isValid()) {
            return null;
        }
        Project project = element2.getProject();
        String path = DatabaseElementVirtualFileImpl.getPath(element2, source);
        DatabaseElementVirtualFileImpl file = (DatabaseElementVirtualFileImpl)DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(path);
        if (ApplicationManager.getApplication().isUnitTestMode() && file != null && file.findElement(project) != element2) {
            throw new AssertionError((Object)path);
        }
        return file;
    }

    public static String getPath(@NotNull DasDataSource dataSource2, @NotNull DasObject object, boolean source) {
        if (dataSource2 == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(17);
        }
        if (object == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(18);
        }
        ObjectPath path = object == dataSource2 ? null : ObjectPaths.of(object, dataSource2.getModel());
        return DatabaseVirtualFileSystem.getPath(dataSource2.getUniqueId(), path, source);
    }

    private static String getPath(@NotNull DbElement element2, boolean source) {
        if (element2 == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(19);
        }
        return DatabaseElementVirtualFileImpl.getPath(element2.getDataSource(), element2, source);
    }

    @NotNull
    public String getPresentableName() {
        return this.getPresentableName(true);
    }

    @NotNull
    private String getPresentableName(boolean shorten) {
        return this.adjustPresentableName(this.getSimplePresentableName(shorten), shorten);
    }

    @NotNull
    public String getPresentablePath() {
        return this.getPresentablePath(true);
    }

    @NotNull
    private String getPresentablePath(boolean shorten) {
        return this.adjustPresentableName(this.getSimplePresentablePath(shorten), shorten);
    }

    @NotNull
    private String getSimplePresentablePath(boolean shorten) {
        if (this.myPath == null) {
            String string = DatabaseBundle.message("ObjectKind.server", new Object[0]);
            if (string == null) {
                DatabaseElementVirtualFileImpl.$$$reportNull$$$0(20);
            }
            return string;
        }
        String displayName = this.myPath.getDisplayName();
        int size = this.myPath.getSize();
        int maxLength = 36;
        String string = displayName.length() <= maxLength || !shorten ? displayName : this.myPath.reduce(new StringBuilder(), (sb, p2) -> (sb.length() > 0 && p2.name.length() > 0 ? sb.append(".") : sb).append(StringUtil.trimMiddle((String)p2.name, (int)(maxLength / size)))).toString();
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private String getSimplePresentableName(boolean shorten) {
        String string = this.myPath == null ? DatabaseBundle.message("ObjectKind.server", new Object[0]) : (shorten ? StringUtil.trimMiddle((String)this.myPath.name, (int)20) : this.myPath.name);
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private String adjustPresentableName(@NotNull String name, boolean shorten) {
        if (name == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(23);
        }
        DbDataSource dataSource2 = this.findDataSourceInAnyProject();
        String string = (String)(this.mySource ? name + " (DDL)" : name) + DatabaseElementVirtualFileImpl.getDataSourceText(dataSource2, this.getObjectKind(), shorten);
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static String getDataSourceText(@Nullable DbDataSource dataSource2, @Nullable ObjectKind kind, boolean shorten) {
        if (dataSource2 == null || kind == ObjectKind.ROOT) {
            return "";
        }
        String name = shorten ? StringUtil.trimMiddle((String)dataSource2.getName(), (int)36) : dataSource2.getName();
        String string = " [" + name + "]";
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(25);
        }
        return string;
    }

    public boolean enforcePresentableName() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DatabaseElementVirtualFileImpl file = (DatabaseElementVirtualFileImpl)((Object)o);
        if (this.mySource != file.mySource) {
            return false;
        }
        if (!Objects.equals(this.myPath, file.myPath)) {
            return false;
        }
        return this.getDataSourceId().equals(file.getDataSourceId());
    }

    public int hashCode() {
        int result2 = this.getDataSourceId().hashCode();
        result2 = 31 * result2 + Objects.hashCode(this.myPath);
        result2 = 31 * result2 + (this.mySource ? 1 : 0);
        return result2;
    }

    public String toString() {
        return "DB VirtualFile: " + this.getObjectKind() + ", " + this.getPresentableUrl() + " (" + this.validnessStatus() + ")";
    }

    @NlsContexts.TabTitle
    public static String getEditorTabTitleImpl(@NotNull Project project, @NotNull DatabaseElementVirtualFileImpl file, boolean dataSourceSuffix, boolean shorten) {
        if (project == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(26);
        }
        if (file == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(27);
        }
        return DatabaseElementVirtualFileImpl.getEditorTabTitleImpl(project, file, file.myPath, file.findDataSource(project), dataSourceSuffix, shorten);
    }

    @NlsSafe
    public static String getEditorTabTitleImpl(@NotNull Project project, @NotNull VirtualFile file, @Nullable ObjectPath path, @Nullable DbDataSource dataSource2, boolean dataSourceSuffix, boolean shorten) {
        boolean qualify;
        if (project == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(28);
        }
        if (file == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(29);
        }
        boolean bl = qualify = DatabaseSettings.getSettings().alwaysQualifyNames || JBIterable.of((Object[])FileEditorManager.getInstance((Project)project).getOpenFiles()).find(o -> !file.equals(o) && o.getName().equals(file.getName())) != null;
        if (file instanceof DatabaseElementVirtualFileImpl) {
            DatabaseElementVirtualFileImpl dbFile = (DatabaseElementVirtualFileImpl)file;
            return qualify ? (dataSourceSuffix ? dbFile.getPresentablePath(shorten) : dbFile.getSimplePresentablePath(shorten)) : (dataSourceSuffix ? dbFile.getPresentableName(shorten) : dbFile.getSimplePresentableName(shorten));
        }
        return (path == null ? "" : (qualify ? path.getDisplayName() : path.getName())) + (dataSourceSuffix ? DatabaseElementVirtualFileImpl.getDataSourceText(dataSource2, path == null ? ObjectKind.ROOT : path.kind, shorten) : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/vfs/DatabaseElementVirtualFileImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/vfs/DatabaseElementVirtualFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectKind";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimplePresentablePath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimplePresentableName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustPresentableName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findDataSource";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInProject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isLoadingDS";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "adjustPresentableName";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTabTitleImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ElementPresentation
    extends PresentationProvider<DatabaseElementVirtualFileImpl> {
        public Icon getIcon(DatabaseElementVirtualFileImpl file) {
            DbElement element2 = file.findElementInner(file.findDataSourceInAnyProject());
            return element2 == null ? null : element2.getIcon();
        }
    }
}

